/*
 * rsaDpa.h
 *
 *	rsaDpa functions are meant to counter side-channel attacks based on
 *	power consumption analysis (e.g. SPA, DPA).
 *
 *  The associated rsaDpa.c source file contains only one function
 *      int mp_exptmod_rsaDpa(mp_int * G, mp_int * X, mp_int * P, mp_int * Y)
 *
 *  mp_exptmod_rsaDpa can replace the integer.c mp_exptmod function
 *  (but it still uses the mp_exptmod function).
 *      mp_exptmod(G,X,P,Y)
 *    and								 calculate Y = G ^ X mod P
 *      mp_exptmod_rsaDpa(G,X,P,Y)
 *
 *  Instead of computing Y = G ^ X mod P, mp_exptmod_rsaDpa chooses randomly
 *  between 4 other equivalent operations.
 *	 (a)	Y = (G ^ (X + rnd * P) mod P ) * (1 / (G ^ (rnd * P)) mod P) mod P
 *   (b)	Y = (G + rnd * P) ^ X mod P
 *   (c)	Y = (G ^ X mod (rnd * P)) mod P
 *   (d)	Y = ((G ^ rnd) mod P) * ((G ^ (X – rnd)) mod P) mod P
 *
 *  Under the following conditions
 *		if (X + rnd * P < 2^2048	&&
 *			G ^ (rnd * P) is inversible)	then	(a)
 *      else if (G + rnd * P < 2^2048)		then	(b)
 *      else if (rnd * P < 2^2048)			then	(c)
 *      else if (X > rnd)					then	(d)
 *		else										rnd = rand()
 *
 * NOTE:
 *      (a) condition
 *      - if P is prime, G ^ (rnd * P) is inversible if it not divisible by P
 *      - if P = RSA key = p*q, there is a high probability of being inversible
 *      >>  G ^ (rnd * P) is actually most of the time inversible
 *
 *		mp_exptmod calls functions that need P != 0
 *		So it needs P != 0 and in (c) operation rnd != 0
 *			but if rnd == 0, (a) or (b) conditions should be true
 *			and (c) should never run.
 *
 *  Created on: Jun 15, 2016
 *      Author: Antoine CHEN
 *  Modified : On July 21,2016 by Rajani(ID TECH) to build with USE_FAST_MATH
 *             enabled for FREESCALE platforms and use wolfssl random number
 *             generation APIs.
 */

#ifndef RSADPA_H_
#define RSADPA_H_

/*******************************************************************************
 * Added by Rajnai(ID TECH) on July 21,2016
 ******************************************************************************/
#include <wolfssl/wolfcrypt/random.h>
/******************************************************************************/
#include <wolfssl/wolfcrypt/integer.h>
#include <wolfssl/wolfcrypt/error-crypt.h>
#include <wolfssl/wolfcrypt/logging.h> // for wolfSSL debug

int
mp_exptmod_rsaDpa(mp_int * G, mp_int * X, mp_int * P, mp_int * Y);

#endif /* RSADPA_H_ */
