/* rabbit.h
 *
 * Copyright (C) 2006-2017 wolfSSL Inc.
 *
 * This file is part of wolfSSL.
 *
 * wolfSSL is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * wolfSSL is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1335, USA
 */


#ifndef WOLF_CRYPT_RABBIT_H
# define WOLF_CRYPT_RABBIT_H

# include <wolfssl/wolfcrypt/types.h>

# ifndef NO_RABBIT

#  ifdef __cplusplus
extern "C" {
#  endif


enum {
    RABBIT_ENC_TYPE = 5 /* cipher unique type */
};


/* Rabbit Context */
typedef struct RabbitCtx {
    word32 x[8];
    word32 c[8];
    word32 carry;
} RabbitCtx;


/* Rabbit stream cipher */
typedef struct Rabbit {
    RabbitCtx masterCtx;
    RabbitCtx workCtx;
    #  ifdef XSTREAM_ALIGN
    void *    heap; /* heap hint, currently XMALLOC only used with aligning */
    #  endif
} Rabbit;


WOLFSSL_API int wc_RabbitProcess(Rabbit *, byte *, const byte *, word32);
WOLFSSL_API int
wc_RabbitSetKey(Rabbit *, const byte * key, const byte * iv);

WOLFSSL_LOCAL int
wc_Rabbit_SetHeap(Rabbit * ctx, void * heap);

#  ifdef __cplusplus
} /* extern "C" */
#  endif

# endif /* NO_RABBIT */
#endif  /* WOLF_CRYPT_RABBIT_H */
