#ifndef _NEOII_SDK_API_H_
#define _NEOII_SDK_API_H_

#include "neoii_api.h"


#define PAYMENT_APP_VERSION(major, minor, release, \
      bugfix) (((major) << 24) | ((minor) << 16) | ((release) << 8) || (bugfix))


#ifdef FLASH_16MB_OLD_LAYOUT
/*@brief payment SDK modules address - values not included in firmware release file*/
# define MEM_PAYMENT_SDK_BEGIN (0x04804000)
# define MEM_PAYMENT_SDK_END   (0x04B03FFF)
# define MEM_PAYMENT_SDK_SIZE  (0x00300000)

/*@brief payment application modules address - values not included in firmware release file*/
# define MEM_PAYMENT_APP_BEGIN (0x04B04000)
# define MEM_PAYMENT_APP_END   (0x04E03FFF)
# define MEM_PAYMENT_APP_SIZE  (0x00300000)
#else
# ifdef FLASH_16MB
/*@brief payment SDK modules address*/
#  define MEM_PAYMENT_SDK_BEGIN PAYMENT_SDK_16M_BEGIN
#  define MEM_PAYMENT_SDK_END   PAYMENT_SDK_16M_END
#  define MEM_PAYMENT_SDK_SIZE  ((PAYMENT_SDK_16M_END) -(PAYMENT_SDK_16M_BEGIN))

/*@brief payment application modules address*/
#  define MEM_PAYMENT_APP_BEGIN PAYMENT_APP_16M_BEGIN
#  define MEM_PAYMENT_APP_END   PAYMENT_APP_16M_END
#  define MEM_PAYMENT_APP_SIZE  ((PAYMENT_APP_16M_END) -(PAYMENT_APP_16M_BEGIN))
# else
#  ifdef FLASH_32MB
/*@brief payment SDK modules address*/
#   define MEM_PAYMENT_SDK_BEGIN PAYMENT_SDK_32M_BEGIN
#   define MEM_PAYMENT_SDK_END   PAYMENT_SDK_32M_END
#   define MEM_PAYMENT_SDK_SIZE  ((PAYMENT_SDK_32M_END) -(PAYMENT_SDK_32M_BEGIN))

/*@brief payment application modules address*/
#   define MEM_PAYMENT_APP_BEGIN PAYMENT_APP_32M_BEGIN
#   define MEM_PAYMENT_APP_END   PAYMENT_APP_32M_END
#   define MEM_PAYMENT_APP_SIZE  ((PAYMENT_APP_32M_END) -(PAYMENT_APP_32M_BEGIN))
#  else
#   error No Flash size defined
#  endif // ifdef FLASH_32MB
# endif // ifdef FLASH_16MB
#endif // ifdef FLASH_16MB_OLD_LAYOUT

#endif // ifndef _NEOII_SDK_API_H_
