#ifndef _NEOII_API_CRYPTO_H_
# define _NEOII_API_CRYPTO_H_

# include "wolfssl/openssl/bn.h"
# include "wolfssl/openssl/rsa.h"
# include "wolfssl/openssl/pem.h"
# include "wolfssl/openssl/asn1.h"

# if defined(__cplusplus)
extern "C" {
# endif /*_cplusplus. */

WOLFSSL_BIGNUM *
wolfSSL_BN_new(void);
void
wolfSSL_BN_free(WOLFSSL_BIGNUM * bn);
int
wolfSSL_BN_set_word(WOLFSSL_BIGNUM * bn, WOLFSSL_BN_ULONG w);
char *
wolfSSL_BN_bn2dec(const WOLFSSL_BIGNUM * bn);

WOLFSSL_BIO *
wolfSSL_BIO_new(WOLFSSL_BIO_METHOD * method);
int
wolfSSL_BIO_free(WOLFSSL_BIO * bio);
int
wolfSSL_BIO_free_all(WOLFSSL_BIO * bio);
int
wolfSSL_BIO_read(WOLFSSL_BIO * bio, void * buf, int len);
int
wolfSSL_BIO_pending(WOLFSSL_BIO * bio);
int
wolfSSL_BIO_get_mem_data(WOLFSSL_BIO * bio, void * p);
WOLFSSL_BIO *
wolfSSL_BIO_new_mem_buf(void * buf, int len);

int
wolfSSL_PEM_write_bio_RSAPublicKey(WOLFSSL_BIO * bio, WOLFSSL_RSA * rsa);
int
wolfSSL_PEM_write_bio_RSAPrivateKey(WOLFSSL_BIO * bio, RSA * rsa,
  const EVP_CIPHER * cipher,
  unsigned char * passwd, int len,
  pem_password_cb * cb, void * arg);
WOLFSSL_X509 *
wolfSSL_PEM_read_X509(FILE * fp, WOLFSSL_X509 ** x, pem_password_cb * cb, void * u);
WOLFSSL_X509 *
wolfSSL_PEM_read_bio_X509(WOLFSSL_BIO * bp, WOLFSSL_X509 ** x,
  pem_password_cb * cb, void * u);

void
wolfSSL_RSA_free(WOLFSSL_RSA * rsa);
WOLFSSL_RSA *
wolfSSL_RSA_new(void);
int
wolfSSL_RSA_generate_key_ex(WOLFSSL_RSA * rsa, int bits, WOLFSSL_BIGNUM * pbn, void * cb);

WOLFSSL_ASN1_INTEGER *
wolfSSL_X509_get_serialNumber(WOLFSSL_X509 * px);
int
wolfSSL_X509_NAME_get_index_by_NID(WOLFSSL_X509_NAME * name, int nid, int pos);
WOLFSSL_X509_NAME *
wolfSSL_X509_get_subject_name(WOLFSSL_X509 * cert);
WOLFSSL_X509_NAME_ENTRY *
wolfSSL_X509_NAME_get_entry(WOLFSSL_X509_NAME * name, int loc);
WOLFSSL_ASN1_STRING * wolfSSL_X509_NAME_ENTRY_get_data(WOLFSSL_X509_NAME_ENTRY * in);
int
wolfSSL_X509_print(WOLFSSL_BIO * bp, X509 * x);
void
wolfSSL_X509_free(WOLFSSL_X509 * x509);
void
wolfSSL_OPENSSL_free(void * p);

WOLFSSL_BIGNUM *
wolfSSL_ASN1_INTEGER_to_BN(const WOLFSSL_ASN1_INTEGER * ai, WOLFSSL_BIGNUM * bn);
char *
wolfSSL_ASN1_STRING_data(WOLFSSL_ASN1_STRING * asn);
int
wolfSSL_ASN1_STRING_length(WOLFSSL_ASN1_STRING * asn);

WOLFSSL_BIO_METHOD *
wolfSSL_BIO_s_mem(void);

# ifdef __cplusplus
}
# endif

#endif // ifndef _NEOII_API_CRYPTO_H_
