#ifndef __LIBIDT_DEVICE_STR_H___
#define __LIBIDT_DEVICE_STR_H___

#define IDTECH_SDK_FLASH_ADDR MEM_PAYMENT_SDK_BEGIN // Also change LD files for any start addr changes

#include "IDTDef.h"
// #include "neoii_payment_str.h"
// #include "libIDT_NEO2.h"

#define IN
#define OUT
#define IN_OUT


#ifndef NEOII_IAR
typedef unsigned char byte;
typedef byte BYTE;
#endif


/**
 * Define the send command callback function to monitor the sending command into the reader. <br/>
 * It should be registered using the registerLogCallBk,
 */
typedef void (* pSendDataLog)(BYTE *, int);

/**
 * Define the read response callback function to monitor the reading response from the reader. <br/>
 * It should be registered using the registerLogCallBk,
 */
typedef void (* pReadDataLog)(BYTE *, int);

/**
 * Define the MSR callback function to get the MSR card data <br/>
 * It should be registered using the msr_registerCallBk,
 */
typedef void (* pMSR_callBack)(int, IDTMSRData);

/**
 * Define the MSR callback function to get the pointer to the MSR card data <br/>
 * It should be registered using the msr_registerCallBk,
 */
typedef void (* pMSR_callBackp)(int, IDTMSRData *);

/**
 * Define the EMV callback function to get the transaction message/data/result. <br/>
 * It should be registered using the emv_registerCallBk,
 */
typedef void (* pEMV_callBack)(int, int, BYTE *, int, IDTTransactionData *, EMV_Callback *, int);

/**
 * Define the PINPad callback function to get the input PIN Pad data <br/>
 * It should be registered using the pin_registerCallBk,
 */
typedef void (* pPIN_callBack)(int, IDTPINData *);


/**
 * Define the Worldpay callback function to get the transaction
 * message/data/result. <br/>
 */
typedef void (* pWP_callBack)(char *, int, int);

/**
 * Define the camera callback function to get the image data <br/>
 * It should be registered using the device_registerCameraCallBk,
 */
typedef void (* pCMR_callBack)(int, IDTCMRData *);

/**
 * Define the card status and front switch callback function to get card and front switch status <br/>
 * It should be registered using the device_registerCardStatusFrontSwitchCallBk,
 */
typedef void (* pCSFS_callBack)(BYTE status);

/**
 * Define the firmware update callback function to get the status of firmware update <br/>
 * It should be registered using the device_registerFWCallBk,
 */
typedef void (* pFW_callBack)(int, int, int, int, int);


// SDK Library Function Pointers

typedef int (* p_config_getVersion)(char * configVersion);
typedef int (* p_config_setCmdTimeOutDuration)(int millisecond);
typedef int (* p_config_getSerialNumber)(char * sNumber);
typedef int (* p_config_getSerialNumber_Len)(char * sNumber, int * sNumberLen);
typedef int (* p_config_getModelNumber)(char * sNumber);
typedef int (* p_config_getModelNumber_Len)(char * sNumber, int * sNumberLen);


typedef int (* p_device_isConnected)();
typedef int (* p_device_getCurrentDeviceType)();
typedef int (* p_isNGA)();
typedef char * (* p_getDeviceType)(int deviceType);
typedef int (* p_DoIDGCMD_str)(BYTE command, BYTE subCommand, BYTE * data, int dataLength, BYTE * resp, int * respLen,
  int ignore);


typedef void (* p_ctls_registerCallBk)(pMSR_callBack pCTLSf);
typedef void (* p_ctls_registerCallBkp)(pMSR_callBackp pCTLSf);
typedef int (* p_processCTLSData)(BYTE * retData, int retDataLen, IDTMSRData * cardData);
typedef int (* p_ctls_startTransaction)(float amount, float amtOther, int type, const int _timeout, BYTE * tags,
  int tagsLen);
typedef int (* p_ctls_cancelTransaction)();
typedef int (* p_ctls_setApplicationData)(BYTE * tlv, int tlvLen);
typedef int (* p_ctls_retrieveApplicationData)(BYTE * AID, int AIDLen, BYTE * tlv, int * tlvLen);
typedef int (* p_ctls_retrieveAIDList)(BYTE * AIDList, int * AIDListLen);
typedef int (* p_ctls_removeApplicationData)(BYTE * AID, int AIDLen);
typedef int (* p_ctls_removeAllApplicationData)();
typedef int (* p_ctls_retrieveTerminalData)(BYTE * tlv, int * tlvLen);
typedef int (* p_ctls_setTerminalData)(BYTE * tlv, int tlvLen);
typedef int (* p_ctls_setCAPK)(BYTE * capk, int capkLen);
typedef int (* p_ctls_retrieveCAPK)(BYTE * capk, int capkLen, BYTE * key, int * keyLen);
typedef int (* p_ctls_retrieveCAPKRIDList)(BYTE * keys, int * keysLen);
typedef int (* p_ctls_retrieveCAPKRIDIndexes)(BYTE * RID, int RIDLen, BYTE * tlv, int * tlvLen);
typedef int (* p_ctls_retrieveCAPKList)(BYTE * keys, int * keysLen);
typedef int (* p_ctls_removeCAPK)(BYTE * capk, int capkLen);
typedef int (* p_ctls_removeAllCAPK)();
typedef int (* p_ctls_setConfigurationGroup)(BYTE * tlv, int tlvLen);
typedef int (* p_ctls_getConfigurationGroup)(int group, BYTE * tlv, int * tlvLen);
typedef int (* p_ctls_getAllConfigurationGroups)(BYTE * tlv, int * tlvLen);
typedef int (* p_ctls_removeConfigurationGroup)(int group);


typedef int (* p_emv_getEMVKernelVersion)(char * version);
typedef int (* p_emv_getEMVKernelVersion_Len)(char * version, int * versionLen);
typedef int (* p_emv_getEMVKernelCheckValue)(BYTE * checkValue, int * checkValueLen);
typedef int (* p_emv_getEMVConfigurationCheckValue)(BYTE * checkValue, int * checkValueLen);
typedef int (* p_emv_setApplicationData)(BYTE * name, int nameLen, BYTE * tlv, int tlvLen);
typedef int (* p_emv_removeApplicationData)(BYTE * AID, int AIDLen);
typedef int (* p_emv_removeAllApplicationData)();
typedef int (* p_emv_retrieveTerminalData)(BYTE * tlv, int * tlvLen);
typedef int (* p_emv_setTerminalData)(BYTE * tlv, int tlvLen);
typedef int (* p_emv_setTerminalMajorConfiguration)(int configuration);
typedef int (* p_emv_removeTerminalData)();
typedef int (* p_emv_retrieveAIDList)(BYTE * AIDList, int * AIDListLen);
typedef int (* p_emv_retrieveCAPK)(BYTE * capk, int capkLen, BYTE * key, int * keyLen);
typedef int (* p_emv_setCAPK)(BYTE * capk, int capkLen);
typedef int (* p_emv_removeCAPK)(BYTE * capk, int capkLen);
typedef int (* p_emv_removeAllCAPK)();
typedef int (* p_emv_retrieveCAPKList)(BYTE * keys, int * keysLen);
typedef int (* p_emv_retrieveCRL)(BYTE * list, int * lsLen);
typedef int (* p_emv_setCRL)(BYTE * list, int lsLen);
typedef int (* p_emv_removeCRL)(BYTE * list, int lsLen);
typedef int (* p_emv_removeAllCRL)();
typedef void (* p_emv_setTransactionParameters)(float amount, float amtOther, int type, int timeout, BYTE * tags,
  int tagsLen);
typedef int (* p_emv_startTransaction)(float amount, float amtOther, int exponent, int type, int timeout, BYTE * tags,
  int tagsLen, int forceOnline);
typedef int (* p_emv_authenticateTransaction)(BYTE * updatedTLV, int updatedTLVLen);
typedef int (* p_emv_authenticateTransactionWithTimeout)(int timeout, BYTE * updatedTLV, int updatedTLVLen);

typedef int (* p_emv_completeTransaction)(int commError, BYTE * authCode, int authCodeLen, BYTE * iad, int iadLen,
  BYTE * tlvScripts, int tlvScriptsLen, BYTE * tlv, int tlvLen);
typedef int (* p_emv_cancelTransaction)();
typedef int (* p_emv_retrieveTransactionResult)(BYTE * tags, int tagsLen, IDTTransactionData * cardData);
typedef int (* p_emv_callbackResponseLCD)(int type, byte selection);
typedef int (* p_emv_callbackResponseMSR)(BYTE * MSR, int MSRLen);
typedef int (* p_emv_retrieveApplicationData)(BYTE * AID, int AIDLen, BYTE * tlv, int * tlvLen);

typedef void (* p_emv_registerCallBk)(pEMV_callBack pEMVf);
typedef void (* p_emv_allowFallback)(int allow);
typedef void (* p_emv_setAutoAuthenticateTransaction)(int authenticate);
typedef void (* p_emv_setAutoCompleteTransaction)(int authenticate);
typedef void (* p_emv_getAutoAuthenticateTransaction)();
typedef void (* p_emv_getAutoCompleteTransaction)();


typedef void (* p_registerAdfLogCallBk)(pSendDataLog pFSend, pReadDataLog pFRead);
typedef void (* p_registerLogCallBk)(pSendDataLog pFSend, pReadDataLog pFRead);
typedef void (* p_enableLogging)(int value);
typedef int (* p_device_startTransaction)(float amount, float amtOther, int type, const int _timeout, BYTE * tags,
  int tagsLen);
typedef int (* p_device_cancelTransaction)();
typedef int (* p_device_setCancelTransactionMode)(int mode);
typedef int (* p_device_cancelTransactionSilent)(int enable);

typedef int (* p_device_getFirmwareVersion)(char * firmwareVersion);
typedef int (* p_device_getFirmwareVersion_Len)(char * firmwareVersion, int * firmwareVersionLen);

typedef int (* p_device_SendDataCommandNEO)(int cmd, int subCmd, BYTE * data, int dataLen, BYTE * response,
  int * respLen);
typedef int (* p_device_sendVivoCommandP2_ext)(BYTE cmd, BYTE subCmd, BYTE * data, int dataLen, BYTE * response,
  int * respLen, int timeout, int noResponse);
typedef int (* p_device_sendVivoCommandP3_ext)(BYTE cmd, BYTE subCmd, BYTE * data, int dataLen, BYTE * response,
  int * respLen, int timeout, int noResponse);
typedef int (* p_device_updateFirmware)(BYTE * firmwareData, int firmwareDataLen, char * firmwareName,
  int encryptionType, BYTE * keyBlob, int keyBlobLen);
typedef int (* p_device_passthroughOnICC)();
typedef int (* p_device_passthroughOffICC)();
typedef int (* p_device_enablePassThrough)(int enablePassThrough);
typedef int (* p_device_enableL100PassThrough)(int enableL100PassThrough);
typedef int (* p_device_getL100PassThroughMode)();
typedef int (* p_device_setBurstMode)(BYTE mode);
typedef int (* p_device_setPollMode)(BYTE mode);
typedef void (* p_startAutoPollThread)();
typedef int (* p_device_setMerchantRecord)(int index, int enabled, char * merchantID, char * merchantURL);
typedef int (* p_device_getMerchantRecord)(int index, BYTE * record);
typedef int (* p_device_getMerchantRecord_Len)(int index, BYTE * record, int * recordLen);
typedef int (* p_device_getTransactionResults)(IDTMSRData * cardData);
typedef int (* p_device_controlUserInterface)(BYTE * values);
typedef int (* p_device_controlIndicator)(int indicator, int enable);
typedef int (* p_device_pingDevice)();
typedef int (* p_device_setRTCDateTime)(BYTE * dateTime, int dateTimeLen);
typedef int (* p_device_getRTCDateTime)(BYTE * dateTime, int * dateTimeLen);
typedef void (* p_device_registerFWCallBk)(pFW_callBack pFWf);
typedef void (* p_device_registerCameraCallBk)(pCMR_callBack pCMRf);
typedef void (* p_device_registerCardStatusFrontSwitchCallBk)(pCSFS_callBack pCSFSf);


typedef int (* p_icc_powerOnICC)(BYTE * ATR, int * inLen);
typedef int (* p_icc_powerOffICC)();
typedef int (* p_icc_exchangeAPDU)(BYTE * c_APDU, int cLen, BYTE * reData, int * reLen);
typedef int (* p_icc_getICCReaderStatus)(BYTE * status);

typedef void (* p_msr_registerCallBk)(pMSR_callBack pMSRf);
typedef void (* p_msr_registerCallBkp)(pMSR_callBackp pMSRf);
typedef int (* p_msr_startMSRSwipe)(int _timeout);
typedef int (* p_msr_cancelMSRSwipe)();


typedef void (* p_loyalty_registerCallBk)(pEMV_callBack pLEMVf);

typedef int (* p_tlv_processIDTTLV)(BYTE * data, int startPos, int tlvLen, BYTE * unencTLV, int * unencLen,
  BYTE * encTLV, int * encLen, BYTE * maskTLV, int * maskLen);
typedef int (* p_tlv_sortTLV)(BYTE * data, int tlvLen, int recursive);
typedef int (* p_tlv_getTagValue)(BYTE * data, int tlvLen, BYTE * tag, int tagLen, BYTE * value, int * valueLen);
typedef int (* p_tlv_addTLV)(BYTE * data, int * tlvLen, BYTE * tlvAdd, int tlvAddLen, int overWrite);
typedef int (* p_tlv_removeTLV)(BYTE * data, int * tlvLen, BYTE * tag, int tagLen, int recursive);
typedef int (* p_tlv_countTLV)(BYTE * data, int tlvLen, int * numTags);
typedef int (* p_tlv_validateTLV)(BYTE * data, int tlvLen, int recursive);

typedef int (* p_iso8583_get1987Handler)(OUT DL_ISO8583_HANDLER * ISOHandler);
typedef int (* p_iso8583_get1993Handler)(OUT DL_ISO8583_HANDLER * ISOHandler);
typedef int (* p_iso8583_get2003Handler)(OUT DL_ISO8583_HANDLER * ISOHandler);
typedef int (* p_iso8583_getField)(IN DL_UINT16 dataField, IN DL_ISO8583_HANDLER * ISOHandler,
  OUT DL_ISO8583_FIELD_DEF * field);
typedef int (* p_iso8583_initializeMessage)(OUT DL_ISO8583_MSG * ISOMessage);
typedef int (* p_iso8583_getMessageField)(IN DL_UINT16 dataField, IN DL_ISO8583_MSG * ISOMessage,
  OUT DL_ISO8583_MSG_FIELD * messageField);
typedef int (* p_iso8583_setMessageField)(IN DL_UINT16 dataField, IN const DL_UINT8 * data,
  IN_OUT DL_ISO8583_MSG * ISOMessage);
typedef int (* p_iso8583_removeMessageField)(IN DL_UINT16 dataField, IN_OUT DL_ISO8583_MSG * ISOMessage);
typedef int (* p_iso8583_packMessage)(IN const DL_ISO8583_HANDLER * ISOHandler, IN const DL_ISO8583_MSG * ISOMessage,
  OUT DL_UINT8 * packedData, OUT DL_UINT16 * packedDataLength);
typedef int (* p_iso8583_unpackMessage)(IN const DL_ISO8583_HANDLER * ISOHandler, IN const DL_UINT8 * packedData,
  IN DL_UINT16 packedDataLength, IN_OUT DL_ISO8583_MSG * ISOMessage);
typedef int (* p_iso8583_freeMessage)(IN DL_ISO8583_MSG * ISOMessage);
typedef int (* p_iso8583_serializeToXML)(IN DL_ISO8583_HANDLER * ISOHandler, IN DL_ISO8583_MSG * ISOMessage,
  OUT BYTE * serializedMessage, OUT int * serializedMessageLength);
typedef int (* p_iso8583_deserializeFromXML)(IN BYTE * serializedMessage, IN int serializedMessageLength,
  OUT DL_ISO8583_HANDLER * ISOHandler, OUT DL_ISO8583_MSG * ISOMessage);
typedef int (* p_iso8583_displayMessage)(IN DL_ISO8583_HANDLER * ISOHandler, IN DL_ISO8583_MSG * ISOMessage);
typedef void (* p_device_getIDGStatusCodeString)(IN int returnCode, OUT char * despcrition);
typedef void (* p_device_getResponseCodeString)(IN int returnCode, OUT char * despcrition);
typedef int (* p_emv_setApplicationDataTLV)(IN BYTE * tlv, IN int tlvLen);
typedef int (* p_emv_retrieveCAPKRIDIndexes)(IN BYTE * RID, IN int RIDLen, OUT BYTE * tlv, IN_OUT int * tlvLen);
typedef int (* p_convertBytesToHexString)(IN const BYTE * hex_string, IN const int len, OUT char * dst,
  OUT int * dstLen);
typedef int (* p_convertHexStringToBytes)(IN const char * str, BYTE * bytes, int blen);

typedef struct _idtech_sdk_api_t_ {
    p_emv_startTransaction                   fp_emv_startTransaction;


    p_config_setCmdTimeOutDuration           fp_config_setCmdTimeOutDuration;
    p_config_getSerialNumber                 fp_config_getSerialNumber;
    p_config_getSerialNumber_Len             fp_config_getSerialNumber_Len;
    p_config_getModelNumber                  fp_config_getModelNumber;
    p_config_getModelNumber_Len              fp_config_getModelNumber_Len;


    p_ctls_registerCallBk                    fp_ctls_registerCallBk;
    p_ctls_registerCallBkp                   fp_ctls_registerCallBkp;
    p_processCTLSData                        fp_processCTLSData;
    p_ctls_startTransaction                  fp_ctls_startTransaction;
    p_ctls_cancelTransaction                 fp_ctls_cancelTransaction;
    p_ctls_setApplicationData                fp_ctls_setApplicationData;
    p_ctls_retrieveApplicationData           fp_ctls_retrieveApplicationData;
    p_ctls_retrieveAIDList                   fp_ctls_retrieveAIDList;
    p_ctls_removeApplicationData             fp_ctls_removeApplicationData;
    p_ctls_removeAllApplicationData          fp_ctls_removeAllApplicationData;
    p_ctls_retrieveTerminalData              fp_ctls_retrieveTerminalData;
    p_ctls_setTerminalData                   fp_ctls_setTerminalData;
    p_ctls_setCAPK                           fp_ctls_setCAPK;
    p_ctls_retrieveCAPK                      fp_ctls_retrieveCAPK;
    p_ctls_retrieveCAPKRIDList               fp_ctls_retrieveCAPKRIDList;
    p_ctls_retrieveCAPKRIDIndexes            fp_ctls_retrieveCAPKRIDIndexes;
    p_ctls_retrieveCAPKList                  fp_ctls_retrieveCAPKList;
    p_ctls_removeCAPK                        fp_ctls_removeCAPK;
    p_ctls_removeAllCAPK                     fp_ctls_removeAllCAPK;
    p_ctls_setConfigurationGroup             fp_ctls_setConfigurationGroup;
    p_ctls_getConfigurationGroup             fp_ctls_getConfigurationGroup;
    p_ctls_getAllConfigurationGroups         fp_ctls_getAllConfigurationGroups;
    p_ctls_removeConfigurationGroup          fp_ctls_removeConfigurationGroup;


    p_emv_registerCallBk                     fp_emv_registerCallBk;
    p_emv_getEMVKernelVersion                fp_emv_getEMVKernelVersion;
    p_emv_getEMVKernelVersion_Len            fp_emv_getEMVKernelVersion_Len;
    p_emv_getEMVKernelCheckValue             fp_emv_getEMVKernelCheckValue;
    p_emv_getEMVConfigurationCheckValue      fp_emv_getEMVConfigurationCheckValue;
    p_emv_setApplicationData                 fp_emv_setApplicationData;
    p_emv_removeApplicationData              fp_emv_removeApplicationData;
    p_emv_removeAllApplicationData           fp_emv_removeAllApplicationData;
    p_emv_retrieveTerminalData               fp_emv_retrieveTerminalData;
    p_emv_setTerminalData                    fp_emv_setTerminalData;
    p_emv_setTerminalMajorConfiguration      fp_emv_setTerminalMajorConfiguration;
    p_emv_removeTerminalData                 fp_emv_removeTerminalData;
    p_emv_retrieveAIDList                    fp_emv_retrieveAIDList;
    p_emv_retrieveCAPK                       fp_emv_retrieveCAPK;
    p_emv_setCAPK                            fp_emv_setCAPK;
    p_emv_removeCAPK                         fp_emv_removeCAPK;
    p_emv_removeAllCAPK                      fp_emv_removeAllCAPK;
    p_emv_retrieveCAPKList                   fp_emv_retrieveCAPKList;
    p_emv_retrieveCRL                        fp_emv_retrieveCRL;
    p_emv_setCRL                             fp_emv_setCRL;
    p_emv_removeCRL                          fp_emv_removeCRL;
    p_emv_removeAllCRL                       fp_emv_removeAllCRL;
    p_emv_allowFallback                      fp_emv_allowFallback;
    p_emv_setAutoAuthenticateTransaction     fp_emv_setAutoAuthenticateTransaction;
    p_emv_setAutoCompleteTransaction         fp_emv_setAutoCompleteTransaction;
    p_emv_getAutoAuthenticateTransaction     fp_emv_getAutoAuthenticateTransaction;
    p_emv_getAutoCompleteTransaction         fp_emv_getAutoCompleteTransaction;
    p_emv_setTransactionParameters           fp_emv_setTransactionParameters;
    p_emv_authenticateTransaction            fp_emv_authenticateTransaction;
    p_emv_authenticateTransactionWithTimeout fp_emv_authenticateTransactionWithTimeout;
    p_emv_completeTransaction                fp_emv_completeTransaction;
    p_emv_cancelTransaction                  fp_emv_cancelTransaction;
    p_emv_retrieveTransactionResult          fp_emv_retrieveTransactionResult;
    p_emv_callbackResponseLCD                fp_emv_callbackResponseLCD;
    p_emv_callbackResponseMSR                fp_emv_callbackResponseMSR;
    p_emv_retrieveApplicationData            fp_emv_retrieveApplicationData;

    p_registerAdfLogCallBk                   fp_registerAdfLogCallBk;
    p_registerLogCallBk                      fp_registerLogCallBk;
    p_enableLogging                          fp_enableLogging;
    p_device_startTransaction                fp_device_startTransaction;
    p_device_cancelTransaction               fp_device_cancelTransaction;
    p_device_setCancelTransactionMode        fp_device_setCancelTransactionMode;
    p_device_cancelTransactionSilent         fp_device_cancelTransactionSilent;


    p_device_getFirmwareVersion              fp_device_getFirmwareVersion;
    p_device_getFirmwareVersion_Len          fp_device_getFirmwareVersion_Len;

    p_device_SendDataCommandNEO              fp_device_SendDataCommandNEO;
    p_device_sendVivoCommandP2_ext           fp_device_sendVivoCommandP2_ext;
    p_device_sendVivoCommandP3_ext           fp_device_sendVivoCommandP3_ext;
    p_device_updateFirmware                  fp_device_updateFirmware;
    p_device_passthroughOnICC                fp_device_passthroughOnICC;
    p_device_passthroughOffICC               fp_device_passthroughOffICC;
    p_device_enablePassThrough               fp_device_enablePassThrough;
    p_device_setBurstMode                    fp_device_setBurstMode;
    p_device_setPollMode                     fp_device_setPollMode;
    p_startAutoPollThread                    fp_startAutoPollThread;
    p_device_setMerchantRecord               fp_device_setMerchantRecord;
    p_device_getMerchantRecord               fp_device_getMerchantRecord;
    p_device_getMerchantRecord_Len           fp_device_getMerchantRecord_Len;
    p_device_getTransactionResults           fp_device_getTransactionResults;
    p_device_controlUserInterface            fp_device_controlUserInterface;
    p_device_controlIndicator                fp_device_controlIndicator;
    p_device_pingDevice                      fp_device_pingDevice;
    p_device_setRTCDateTime                  fp_device_setRTCDateTime;
    p_device_getRTCDateTime                  fp_device_getRTCDateTime;


    p_icc_powerOnICC                         fp_icc_powerOnICC;
    p_icc_powerOffICC                        fp_icc_powerOffICC;
    p_icc_exchangeAPDU                       fp_icc_exchangeAPDU;
    p_icc_getICCReaderStatus                 fp_icc_getICCReaderStatus;


    p_msr_registerCallBk                     fp_msr_registerCallBk;
    p_msr_registerCallBkp                    fp_msr_registerCallBkp;
    p_msr_startMSRSwipe                      fp_msr_startMSRSwipe;
    p_msr_cancelMSRSwipe                     fp_msr_cancelMSRSwipe;


    p_device_isConnected                     fp_device_isConnected;
    p_device_getCurrentDeviceType            fp_device_getCurrentDeviceType;
    p_isNGA                                  fp_isNGA;
    p_getDeviceType                          fp_getDeviceType;
    p_DoIDGCMD_str                           fp_DoIDGCMD_str;

    p_tlv_processIDTTLV                      fp_tlv_processIDTTLV;
    p_tlv_sortTLV                            fp_tlv_sortTLV;
    p_tlv_getTagValue                        fp_tlv_getTagValue;
    p_tlv_addTLV                             fp_tlv_addTLV;
    p_tlv_removeTLV                          fp_tlv_removeTLV;
    p_tlv_countTLV                           fp_tlv_countTLV;
    p_tlv_validateTLV                        fp_tlv_validateTLV;

    p_iso8583_get1987Handler                 fp_iso8583_get1987Handler;
    p_iso8583_get1993Handler                 fp_iso8583_get1993Handler;
    p_iso8583_get2003Handler                 fp_iso8583_get2003Handler;
    p_iso8583_getField                       fp_iso8583_getField;
    p_iso8583_initializeMessage              fp_iso8583_initializeMessage;
    p_iso8583_getMessageField                fp_iso8583_getMessageField;
    p_iso8583_setMessageField                fp_iso8583_setMessageField;
    p_iso8583_removeMessageField             fp_iso8583_removeMessageField;
    p_iso8583_packMessage                    fp_iso8583_packMessage;
    p_iso8583_unpackMessage                  fp_iso8583_unpackMessage;
    p_iso8583_freeMessage                    fp_iso8583_freeMessage;
    p_iso8583_serializeToXML                 fp_iso8583_serializeToXML;
    p_iso8583_deserializeFromXML             fp_iso8583_deserializeFromXML;
    p_iso8583_displayMessage                 fp_iso8583_displayMessage;
    p_device_getIDGStatusCodeString          fp_device_getIDGStatusCodeString;
    p_device_getResponseCodeString           fp_device_getResponseCodeString;
    p_emv_setApplicationDataTLV              fp_emv_setApplicationDataTLV;
    p_emv_retrieveCAPKRIDIndexes             fp_emv_retrieveCAPKRIDIndexes;
    p_convertBytesToHexString                fp_convertBytesToHexString;
    p_convertHexStringToBytes                fp_convertHexStringToBytes;
} idtech_sdk_api_t;

/**
 * @brief Firmware Application info struct */
typedef struct _sdk_head_info_ {
    unsigned int header;         /* four char code header */
    unsigned int version;        /* version for app */
    unsigned int begin;          /* app start address */
    unsigned int size;           /* app size, needed for upgrade and sig check */
    void *       table;          /* app function table address */
    const char * app_identifier; /* optional app name string pointer */
    void *       param;          /* app entry function parameter */
    unsigned int priority;       /*app task priority, should be 20~24*/
    unsigned int stacksize;      /*app task statck*/
    unsigned int text_end;       /*app text end address*/
    unsigned int data_start;     /*app data start address*/
    unsigned int data_end;       /*app data end address*/
    unsigned int bss_start;      /*app bss start address*/
    unsigned int bss_end;        /*app bss end address*/
} sdk_head_info;


#endif // ifndef __LIBIDT_DEVICE_STR_H___
