# IDTech C++ SDK Library Changelog
All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](http://keepachangelog.com/)
and this project adheres to [Semantic Versioning](http://semver.org/).

## [1.0.35.028] - 2022-07-25
- Fixed the issue SDK-140, 
- Added the functions forwardTransaction() and setWorldPayFilePath(), also added storeTransaction, storeOnHostNetworkError, storagePassword, storageMemo to the structure WorldPayData to support store forward for WorldPay.
- Added the functions device_setNEOGen() and device_setNEOAltDevice(), and also added alt and gen to the structure IDTDeviceHandle to support generation and alternative device.
- Changed the functions device_init() and device_setCurrentDevice() and the file "NEO2_Device.xml" to support generation, alternative device, and more readers.
- Changed the functions ctls_getAllConfigurationGroups(), device_SendDataCommandNEO(), and device_readFileFromSD(), device_outputLog() to check the data size before calling memcpy().
- Changed the function threadProc_RKI() to support Vendi.
- Changed _FIRMWARE_BUF_LEN to 5500000 bytes.
- Changed the function device_setCurrentDevice() to set the generation and alternative device for NEO readers.
- Changed the function device_updateFirmwareWithZipFile() to dynamically allocate memory.

## [1.0.35.027] - 2022-07-25
- Fixed the issues CJAVAUSDK-333, CS-4414, NEO3-563, and CJAVAUSDK-329.
- Added the function config_setConfigByJsonFile() to set the configuration by a JSON file.
- Changed threadProc_Camera(), device_stopQRCodeScan(), and device_stopTakingPhoto() to fix the timeout issue.
- Changed the functions emv_removeApplicationData() and emv_removeCAPK() to check the parameters properly.
- Changed the function device_updateFirmware() to support K81 firmware update by the txt file, and RT1052 firmware update by the fm file.

## [1.0.35.026] - 2022-06-06
- Added the function device_updateFirmwareWithZipFile() and the structure Script to update the firmware with the zip file for the NEO 2 readers.
- Added the function cancelWorldPay() to cancel the WorldPay transaction.
- Updated the WorldPay function to output log while connecting to the WorldPay server.
- Updated the function device_updateFirmware() for updating RT1050 and device tree.
- Updated the function device_getIDGStatusCodeString() to include the error code 0x2B.
- Changed the function executeTransaction() to call ctls_startTransaction for contactless transactions, and msr_startMSRSwipe() for MSR transactions separately.

## [1.0.35.025] - 2022-06-01
- Fixed the issue CJAVAUSDK-329.
- Changed the hotplug functions to do more checks for the bootloader mode.
- Updated the WorldPay function for VP3300.

## [1.0.35.024] - 2022-05-10
- Fixed the issues SDK-31, CJAVAUSDK-315, CJAVAUSDK-318, and CJAVAUSDK-326.
- Changed Kiosk V to Kiosk V S and added Kiosk V.
- Changed TLV_ParseTags() to handle AID tags.
- Refactored the C++ SDK source files.
- Removed Java from the document.
- Changed the function threadProc_AutoPoll_Read() to fix a memory crash issue.
- Changed the comment for the function device_setCurrentDevice() to add a note in the document.
- Changed the function device_setCameraParameters() to check parameters properly.
- Changed the functions device_startTransaction() and device_cancelTransaction(), and added the function device_setTransactionExponent() for Augusta and MiniSmart II.
- Updated WorldPay for VP3300.

## [1.0.35.023] - 2022-03-16
- Fixed the issues CJAVAUSDK-314, CJAVAUSDK-315, and CJAVAUSDK-318.
- Added the definition of COREDUMP_LOG_FILENAME_SIZE.
- Removed Java from the C++ SDK.
- Changed the function device_outputLog() to append the log file.
- Changed the function device_setCurrentDevice() to return error when the PID of USB for the reader is not available.
- Changed the functions device_setCoreDumpLogFile() and device_outputLog() to do more check for the parameter filenameLen.

## [1.0.35.022] - 2022-02-24
- Fixed the issues CS-4118, TS-28155, and CJAVAUSDK-313.
- Added L80, Kiosk V, and VP7200 for USB.
- Added the functions device_outputLog(), device_setCoreDumpLogFile(), device_enableL80PassThrough(), and device_getL80PassThroughMode().
- Added the core dump data in the MSR callback.
- Changed unsigned char to BYTE.
- Return the card data for MSR and CTLS transactions when the status code is 0x0A.
- Refactored the C++ SDK source code to reduce the file sizes.
- Changed the function config_getSerialNumber_Len() to check the length before memcpy().
- Defined IDG_V2_CMD_IDX, IDG_V2_SUBCMD_IDX, IDG_V2_LEN_MSB_IDX, IDG_V2_LEN_LSB_IDX, IDG_V2_DATA_IDX, and SERIAL_NUMBER_LEN, and changed the source code accordingly.
- Fixed the Worldpay transaction crash issue for VP3300 after the transaction timeout.
- Changed the flags in the thread threadProc_AutoPoll_Read() to fix a device_close() stuck issue.
- Changed threadProc_AutoPoll_Read(), ReadIDGRS232(), and ReadIDGUsb() to handle core dump data properly.
- Extended the gap of 5ms to 15ms in ReadIDGRS232() to solve a firmware issue.

## [1.0.35.021] - 2021-12-01
- Fixed the issue CJAVAUSDK-304.
- Added the function device_getTamperStatus() for NEO 2 readers.
- Re-implemented the function device_readFileFromSD().
- Implemented the function device_getDRS() for NEO 2 readers.
- Changed the function felica_write() for checking blockDataLen.
- Changed the function lcd_setBacklight() to add the parameter isBacklightOn according to the new firmware design spec.

## [1.0.35.020] - 2021-10-22
- Changed IDT_device_hotplug_callback(), device_init(), parseEMVFormat1(), and ReadDataUsb() to support SREDKey 2 for Kroger.
- Updated threadProc_RKI() for VP3300.
- Changed the function device_readFileFromSD() for VP6800.  (The firmware is not ready yet.)

## [1.0.35.019] - 2021-10-08
- Fixed the issue CJAVAUSDK-303.
- Added the function device_readFileFromSD().
- Changed device_getCameraParameters() according to the firmware change.
- Changed emv_callbackResponseLCD() to not block the LCD menus.
- Changed device_startQRCodeScanWithDisplayWindowInfo() to switch the high and low bytes for x, y, width, and height.

## [1.0.35.018] - 2021-09-23
- Fixed Worldpay Object Enum Initilization Values.
- Added the 2 functions device_getCameraParameters() and device_setCameraParameters() for NEO 2 readers.

## [1.0.35.017] - 2021-09-16
- Fixed the issue TS-26483, CJAVAUSDK-302, and CS-4192.
- Added asyncLCDMessage[] and asyncLCDMessageLen in the structure IDTLCDItem to support async messages.
- Changed the function device_setAudioVolume() to handle the command data properly.
- Changed the function emv_startTransaction() for non-contact transactions for NEO 2 readers.
- Changed threadProc_Camera(), threadProc_RKI(), threadProc_Read_Device(), threadProc_Read_CTLS(), threadProc_Read_PIN(), and threadProc_Open_Com_Port() to return NULL instead of 0.
- Changed device_updateFirmware() to support RS232 firmware update file for NEO 1 readers and set the timeout to 3 seconds for NEO 1 readers by RS232.
- Changed the function threadProc_Read_EMV() to handle the status code 0x57.
- Changed ReadIDGRS232(), ReadIDGTcpIp(), and ReadIDGUsb() to support async LCD messages through LCD callback in contactless transactions for VP3300.
- Changed device_updateFirmware() to set the timeout of the command 0xC7-15 to 3 seconds if it's less than 3 seconds for Kiosk III/IV and VP3300 with RS232.

## [1.0.35.016] - 2021-08-12
- Added WorldPay class IDTech_wp.c.
- Added WorldPay structure.
- Added int executeTransaction(WorldPayData *data, pWP_callBack wpCallback, int requestOn.
- Updated demo app, device screen, for Augusta, VP3300, NEO2, MiniSmartII to include WorldPay transaction option Added additional methods to intercept emv/msr callback data for WorldPay class.

## [1.0.35.015] - 2021-07-23
- Fixed the issues CJAVAUSDK-297, CS-4026, CJAVAUSDK-298, CJAVAUSDK-299, and CJAVAUSDK-300.
- Added the functions device_stopAudio(), device_playAudio(), device_getAudioVolume(), and device_setAudioVolume() for NEO 2 readers.
- Changed ReadDataRS232() to return when start sending a command.
- Changed the C++ SDK to support LCD messages for contactless transactions for VP3300.
- Changed threadProc_RKI() to support VP3300 and Kiosk III.
- Changed device_init() to return RETURN_CODE_FAILED when there is an error.
- Changed libpos_init() to solve the hot plug issue for Windows.
- Changed ExitUsbLib() to unload libusb for Windows.
- Changed DoNGACmdUsb() to support IDG readers.
- Changed the function emv_cancelTransaction() to set s_stopThread to 0 again after the command 0x05-01 is sent.
- Changed ReadIDGRS232(), ReadIDGUSB(), and ReadIDGTcpIp() for handling async LCD messages for VP3300 to avoid stack overflow.

## [1.0.35.014] - 2021-06-18
- Fixed the issues CJAVAUSDK-294 and CS-4062.
- Changed threadProc_Read_CTLS(), threadProc_AutoPoll_Read(), ReadIDGRS232(), ReadIDGTcpIp(), ReadIDGUsb() to handle async LCD messages for VP3300.
- Added the MSR_callBack_type MSR_callBack_type_ASYNC_LCD_MESSAGE for async LCD messages for VP3300.
- Changed threadProc_RKI() to support 1-certificate for NEO 2 readers.
- Changed device_rebootDevice() to support NEO 2 readers.
- Changed threadProc_Read_MSR() to handle the LCD messages during an MSR transaction.
- Changed ReadNGARS232() to handle the NGA data properly.
- Changed ReadIDGUsb(), ReadIDGRS232(), and ReadIDGTcpIp() to handle the LCD messages, card seated, and front switch events from the firmware.
- Updated the comment of device_init() to generate the document.
- Changed the NEO 2 demo for testing RKI.
- Changed the function ReadNGARS232() to read the whole NGA card data for EMV transactions.
- Changed the Makefile for ARMv7 to generate the static SDK library file.
- Changed the function threadProc_AutoPoll_Read() to handle the card data for the Pip Reader.
- Changed device_setCurrentDevice(), rs232_device_init(), and tcpip_device_init() to check burst mode properly.

## [1.0.35.013] - 2021-04-01
- Fixed the issues CS-3846, CS-3934, TS-24682, CJAVAUSDK-275, CJAVAUSDK-290, and CJAVAUSDK-280.
- Fixed the auto poll thread issue for USB under Windows.
- Changed device_SendDataCommandNEO(), ctls_retrieveAIDList(), and ctls_getAllConfigurationGroups() to handle the status code 0x63.
- Changed threadProc_Read_Device() to handle the status code 0x63 when ICC card is inserted for VP3300.
- Changed device_listDirectory() to pass the correct command data.
- Changed emv_setTerminalData() to pass the Terminal Configuration byte for VP8800.
- Changed the SDK functions for Augusta and MiniSmart II to support ICC notification.
- Changed threadProc_AutoPoll_Read() to support VAS transaction for Pip Reader.
- Changed winCallback() to handle the hotplug events when an ICC card is inserted for VP3300 under Windows.
- Changed ReadIDGUsb() to handle the error -1 for the function hid_read_timeout().

## [1.0.35.012] - 2021-02-09
- Fixed the issues CS-3680 and SUIAS-24.
- Fixed the libusb crash issue for libpos_exit() under Windows.
- Added the status codes IDG_P2_STATUS_CODE_COMMAND_CANCEL_OPERATION and IDG_P2_STATUS_CODE_PRESS_KEY_CANCEL_OPERATION.
- Implemented the functions felica_getCode() and felica_cancelCodeEntry().
- Implemented the RKI function for NEO 2 readers.
- Set the date and time at connection and transactions for VP3300.
- Changed device_updateFirmware() to return error if not able to get the firmware version when updating RT1050 firmware for VP6800.
- Changed device_updateFirmware() to sleep 300ms instead of 150ms between each command for VP3300.
- Changed DoIDGCMD_str() to reset the buffer size when re-sending the command.
- Changed device_setCurrentDevice() to remove redundant device_getFirmwareVersion().
- Changed winCallback() to return the first hotplug callback under Windows.
- Changed emv_startTransaction () and threadProc_Read_EMV() to fix a cancel transaction issue for MiniSmart II.
- Changed ReadNGAUsb() to ignore non-NGA data.

## [1.0.35.011] - 2021-01-05
- Fixed the issues CS-3680, and CJAVAUSDK-276.
- Added the comment to the document for the functions lcd_addButton(), lcd_addEthernet(), lcd_addLED(), lcd_addText(), lcd_addImage(), lcd_addVideo(), lcd_addExtVideo(), and ctls_displayOnlineAuthResult().
- Changed winCallback() and device_init() to handle the hotplug events properly.
- Changing device_startRKI() to support RKI for NEO 2 readers.
- Changed pin_capturePin() to check the parameters "type", "minPIN" and "maxPIN".
- Changed ReadIDGRS232() to set the inital read size to 16 bytes.
- Changed rs232_device_init() to implement the retry for device_getFirmwareVersion().
- Changed loyalty_startTransaction() to support the value 0x03 for the parameter iccReadType.
- Changed device_getTransactionResults() to check the data length.
- Changed the functions lcd_addButton(), lcd_addEthernet(), lcd_addLED(), lcd_addText(), lcd_addImage(), lcd_addVideo(), and lcd_addExtVideo() to set the command timeout to 6 seconds.
- Changed OnDevChange() and IDT_device_hotplug_callback() to accept the PID for the NEO 2 readers in bootloader mode.
- Changed ReadIDGRS232() to output the log for LCD event.
- Changed the functions rs232_device_init(), threadProc_Open_Com_Port(), and device_close() to clear the buffer after opening and before closing the com port.
- Changed DoIDGCmdRS232(), WriteIDGRS232(), DoFWCmdNGARS232(), and DoNGACmdRS232() to clear the RS232 write buffer but not clear the RS232 read buffer before sending a command.
- Changed ReadDataRS232() to finish reading the RS232 buffer before sending a command.

## [1.0.35.010] - 2020-11-25
- Fixed the issues CS-3507, CJAVAUSDK-265, CJAVAUSDK-264, CS-3659, and CS-3614.
- Fixed the internal function checkExponent() and updated the .h file.
- Added the error code EMV_RESULT_CODE_TIMEOUT_FOR_WAITING_ICC_INSERT_OR_MSR_SWIPE_FALLBACK (0x3013).
- Added the function lcd_addExtVideo().
- Added the function lcd_linkUIWithTransactionMessageId() to link a Message Id with a customer Screen.
- Added the function set_open_com_port_timeout() and changed rs232_device_init() to support timeout for opening com port.
- Implemented motor firmware update for VP5300M.
- Changed DoIDGCmdRS232() to retry once for the Felica related commands.
- Changed processCTLSData() to handle some garbage data.
- Changed emv_startTransaction() and emv_activateTransaction() to return error when 0x63 is not received from the firmware.
- Changed DoIDGCmdRS232() to enable the retries for lcd_queryScreenbyName(), lcd_getAllObjects(), lcd_removeItem(), lcd_createScreen(), lcd_showScreen(), lcd_addImage(), lcd_addText(), lcd_addButton(), lcd_addVideo(), and lcd_queryObjectbyName().
- Changed LCD_callBack_type_BUTTON_EVENT to LCD_callBack_type_LCD_EVENT.
- Changed processSpectrumGUID() to add the length of the return data.
- Changed device_getFirmwareVersion_Len() to actually check the length of the return data.
- Changed DoIDGCmdRS232() to fix an exception for the retry of the Felica related commands.
- Changed device_startQRCodeScan() and added device_startQRCodeScanWithDisplayWindowInfo() to support the the window info.
- Changed the function TLV_getTags() for Windows to avoid an exception.
- Changed ctls_startTransaction(), device_setTransactionExponent(), device_startTransaction(), emv_startTransaction(), and emv_startTransactionExt() to support the exponent value from 0 to 9.
- Corrected the length of s_cmd in "IDTech_icc.c".

## [1.0.35.009] - 2020-09-22
- Fixed the issues CJAVAUSDK-254, CS-3390, CJAVAUSDK-256, FLTSYS-1, and TS-22304.
- Changed device_cancelTransaction() and emv_cancelTransaction() to return the error code Busy when the previous one is not done.
- Changed device_listDirectory() to return the error IDG_P2_STATUS_CODE_FAILED_NACK when the firmware doesn't return the correct response data.
- Changed CHARACTER_INTERVAL from 3 to 5.
- Changed device_startTransaction() to not send the command 0x61-17 when it's called by loyalty_startTransaction().
- Added the functions loyalty_registerCallBk(), loyalty_cancelTransactionSilent(), loyalty_startTransaction(), and loyalty_cancelTransaction() for VP6800.
- Changed ctls_retrieveCAPKList() to initialize the buffer length properly.
- Changed the functions DoIDGP1CMD_str(), DoIDGCMD_str(), DoIDGP3CMD_str() to not call the functions convertBytesToHexString() and convertHexStringToBytes().
- Changed the function DoDirectIDGCMD_str() to pass the correct third parameter to the function convertHexStringToBytes().
- Changed the function ctls_startTransaction() to handle the tag "DFEF37" properly.
- Changed ReadITPUsb() for SREDKey 2 KB mode.

## [1.0.35.008] - 2020-08-07
- Fixed the issues TS-21327, TS-21102 (for the response 0x61-FF), TS-20478, TS-21356, TS-21365, TS-21332, TS-20897, TS-21650, CJAVAUSDK-243, TS-20420, CS-3392, SWAC-89, CJAVAUSDK-216, CJAVAUSDK-246, CJAVAUSDK-249, CJAVAUSDK-250, and CJAVAUSDK-251.
- Fixed the functions device_deleteDirectory() and device_queryFile() for the error 0x05 (Incorrect Parameter).
- Updated the "NEO2_Devices.xml" for VP3350.
- Updated the comment of the functions in the header files.
- Added the error code EMV_RESULT_CODE_MSR_CARD_ERROR_FALLBACK.
- Added the _Len functions to fix the security issue.
- Added pin_capturePinExt() for NEO 2 readers to support new firmware.
- Added the return code for setAbsoluteLibraryPath() and device_setConfigPath().
- Added the length parameter for TLV_GetTag() and TLV_GetLength().
- Added a flag to exit the auto poll thread when device_close() is called without cancelling the thread.
- Implemented the CRC retries for DoIDGCMD_str().
- Changed the function device_updateFirmware() to support kernel update.
- Changed the functions grsiP2Command() and grsiP3Command() to check the length parameters.
- Changed the function device_updateFirmware() to have retries for device_getFirmwareVersion(), the command 0xC7-11, and the command 0xC7-41.
- Changed the function TLV_getTags() to check the parameter tagCount.
- Changed emv_retrieveApplicationData() for the new response data format from the firmware.
- Changed OnDevChange() to get the VID and PID of the plugged/unplugged USB device.
- Changed functions and added the corresponding _Len functrions to solve the IOActive security issue.
- Changed device_updateFirmware() to set the flag fwInitialized when the firmware update fails.
- Changed device_close() to wait for the termination of auto poll thread.
- Changed the functions emv_authenticateTransaction() and emv_completeTransaction() to ignore redundant LCD messages.
- Changed camera busy error code to 0xA5.
- Changed InitUsbLib() to get the new list of USB readers.
- Changed the Makefile to generate the static SDK library file for ARM v6.
- Changed pin_inputFromPrompt() to handle the parameters defaultResponse and defaultResponseLen properly.
- Changed the sleep time between RS232 read functions from 2ms to 3ms.
- Changed device_close() to not cancel the auto poll thread for RS232.  
- Changed the function device_listDirectory() to handle the status code 0x63 from the firmware.
- Changed the functions device_close(), IDT_device_hotplug_callback(), and device_setPollMode() to set a flag properly when the auto poll thread is killed for non-RS232 readers.
- Changed ctls_setCAPK() and emv_setCAPK() to handle the modulus length properly.
- Changed device_listDirectory() for the new firmware command (0x83-35 and 0x83-22) data format of NEO 2 readers, ands also changed the type of the parameter "directoryLen" to IN_OUT.
- Changed device_updateFirmware() to wait for 18 sedconds instead of 3 seconds when initial firmware update is done for NEO 2 readers.
- Changed threadProc_AutoPoll_Read() to read data for all NEO 2 readers.
- Changed pin_inputFromPrompt() to handle the parameter defaultResponseLen properly.
- Changed device_setCurrentDevice(), rs232_device_init(), and tcpip_device_init() to start the auto poll thread for all NEO 2 readers.
- Changed device_close() to set the log callbacks to NULL, and cancel the auto poll thread for RS232 and TcpIp.
- Changed ReadIDGRS232(), ReadIDGTcpIp(), and ReadIDGUsb() to handle the LCD button event.
- Changed enum EMV_RESULT_CODE in "IDTDef.h" for firmware change.
- Changed device_setPollMode() to not kill the auto poll thread for NEO 2 readers.
- Changed device_updateFirmware() to add the log when command retries fails for NEO 2 readers.
- Changed ReadIDGRS232(), ReadIDGTcpIp(), and ReadIDGUSB() to handle LCD button event.
- Changed the parameter directoryLen of device_listDirectory() to be IN_OUT.

## [1.0.35.007] - 2020-06-01
- Fixed the issues CJAVAUSDK-228, CJAVAUSDK-229, CJAVAUSDK-230, and TS-20123.
- Changed device_transferFile() to limit the file size to 64K for sending the file to flash, and no file size limitation (actually 2147483647 bytes for an integer) for sending the file to SD card.
- Changed pin_cancelPINEntry() and threadProc_Read_PIN() to handle Cancel PIN Entry properly.
- Changed DoIDGCmdRS232() and ReadIDGRS232() for Felica functions.

## [1.0.35.006] - 2020-05-08
- Fixed the issues TS-20123, TS-20152, TS-20725, and TS-20478.
- Added device_toSDCard() for NEO 2 devices.
- Changed device_deleteDirectory() to handle directory name "" for deleting the root directory.  Also updated the comment for device_deleteDirectory().
- Changed most of the IDG functions to check for the polling thread.
- Changed DoIDGCmdRS232() to sleep 2ms between write and read for all commands except firmware update.
- Changed ReadIDGRS232() to read in 64 bytes at a time and sleep for 5ms for each loop.
- Changed ReadDataRS232() to sleep 2ms for each loop.
- Changed ReadDataUsb() with the timeout of 5ms for read and sleep 2ms for each loop.
- Changed the comment of the function device_deleteDirectory().
- Changed the function device_deleteDirectory() to support NEO 2 devices.
- Changed IDTLog() to output milli-second.
- Changed device_listDirectory(), device_transferFile(), device_deleteFile(), and device_queryFile() to support SD card for NEO 2 devices.
- Changed device_updateFirmware() for checking the VP6800 RT1050 firmware version.
- Changed rs232_device_init() to retry opening the com port 3 times.
- Changed DoIDGCmdRS232() and ReadIDGRS232() to speed up Felica functions.
- Changed the SDK version to 1.0.35.006.

## [1.0.35.005] - 2020-04-22
- Fixed the issues CJAVAUSDK-210, CJAVAUSDK-213, CJAVAUSDK-214, CJAVAUSDK-215, and CJAVAUSDK-217.
- Added device_getThreadStackSize() and device_setThreadStackSize() for VP3300 COM.
- Changed the comment of the tag "DFEE1A" in the header files.
- Changed threadProc_Read_CTLS() to solve CTLS transaction timeout and CRC missing bytes issues.
- Changed threadProc_Read_Device(), threadProc_Read_MSR() to solve CRC missing bytes issue.
- Changed device_getFirmwareVersion() to return correct error code.
- Changed threadProc_Read_MSR() and msr_startMSRSwipe() to use the SDK timeout.
- Changed threadProc_Read_PIN() to cancel pin_capturePin() properly.
- Changed DoIDGCMD_str() to check the lenght of the IDG response data.
- Changed ReadNGAUsb(), ReadITPUsb(), ReadIDGUsb(), and ReadDataUsb() to return timeout error code from libusb.
- Changed threadProc_Read_EMV() to handle the timeout from libusb properly.
- Changed the comment of the function device_setThreadStackSize().
- Changed the SDK version to 1.0.35.005.

## [1.0.35.004] - 2020-03-31
- Fixed the issues CJAVAUSDK-204, CJAVAUSDK-206, TS-20446, TS-20478, TS-20660, TS-20723, and TS-20724.
- Added pin_cancelPINEntry() in "libIDT_Augusta.h" and "libIDT_NEO2.h".
- Added free() to prevent memory leak.
- Added the functions device_getThreadStackSize() and device_setThreadStackSize() to set the stack size of the pthread.
- Added the flag THREAD_MGMT to reduce the stack size.
- Added the log for reading data in the thread threadProc_AutoPoll_Read().
- Implemented the function config_setCmdTimeOutDuration().
- Changed device_setNEO2DevicesConfigs() to use the pre-defined value CONFIG_FILE_SIZE for file size.
- Changed device_init() to return RETURN_CODE_FAILED (for NGA readers) or IDG_P2_STATUS_CODE_FAILED_NACK (for IDG readers) when fails.
- Changed the return code of rs232_device_init() to IDG_P2_STATUS_CODE_FAILED_NACK or RETURN_CODE_FAILED when it fails.
- Changed threadProc_AutoPoll_Read() to handle EMV transaction data with command 0x02.
- Changed device_updateFirmware() to speed up the process.
- Changed ctls_registerCallBk(), ctls_registerCallBkp(), device_registerCameraCallBk(), device_registerCardStatusFrontSwitchCallBk(), device_registerRKICallBk(), device_registerFWCallBk(), emv_registerCallBk(), lcd_registerCallBk(), msr_registerCallBk(), msr_registerCallBkp(), pin_registerCallBk() to allow NULL pointer as the parameter.
- Changed emv_start_Transaction() and emv_activateTransaction() to remove device_getFirmwareVersion(), and check the device name in device_setCurrentDevice() instead.
- Changed device_close() to avoid lock up when an error detected.
- Changed rs232_device_init() to only return success after the handshake is completed with no error for NEO 2 readers.
- Implementing TCP/IP read and write functions.
- Changed the SDK version to 1.0.35.004.

## [1.0.35.003] - 2020-02-25
- Fixed CJAVAUSDK-198, CJAVAUSDK-196, NEOII-2412, CJAVAUSDK-180, CJAVAUSDK-124, SDKC-39, SDKC-41, SDKC-40, SDKC-38, CJAVAUSDK-194, CJAVAUSDK-190, CS-2901, and CJAVAUSDK-202.
- Added the error code 0x5039 "EMV_PIN_ENTRY_TIMEOUT".
- Added the functions emv_authenticateTransactionWithTimeout(), device_setCancelTransactionMode(), device_pollForToken(), device_cancelTransactionSilent(), and device_enableRFAntenna().
- Added the function device_registerCardStatusFrontSwitchCallBk() and the call back CSFS_callBack() for Card Status and Front Switch event for NEO 2 readers.
- Added the function device_cancelTransactionSilent(), device_startListenNotifications(), and device_stopListenNotifications().
- Added the timeout check for threadProc_Read_EMV().
- Added the device type for IDT_DEVICE_NEO2_TCPIP.
- Added the function device_getDeviceMemoryUsageInfo().
- Added the functions device_getSDKWaitTime() and device_setSDKWaitTime() to get and set the SDK timeout for transactions.
- Added the function tcpip_device_init().
- Added the status codes IDG_P2_STATUS_CODE_TAMPER_OCCURRED and IDG_P2_STATUS_CODE_CARD_NOT_REMOVE.
- Changed device_cancelTransaction(), ctls_cancelTransaction(), emv_cancelTransaction(), and msr_cancelMSRSwipe() to support the option not to display "CANCELLED" on the LCD screen.
- Changed device_updateFirmware() to send a command more times if it fails.
- Changed device_startTransaction() and emv_startTransaction() to pass the tag "DFEF37".
- Changed pin_inputFromPrompt() to correct the command data.
- Changed lcd_setBacklight() to support the new command data format.
- Changed the function device_setCancelTransactionMode() to return error code.
- Changed emv_authenticateTransaction() and emv_completeTransaction() to clear the buffer before sending the commands.
- Changed ctls_setCAPK() and emv_setCAPK() to handle the command data properly.
- Changed threadProc_AutoPoll_Read() and to handle the cancel button during a transaction for VP6800.
- Changed threadProc_AutoPoll_Read() to handle key pad event and EMV transaction response.
- Changed emv_startTransaction() to handle the tag "DFEF37" properly.
- Changed pin_inputFromPrompt() to support preClearText and postClearText to be 0.
- Changed device_close() to return error code.
- Set the command timeout to default before returning from threadProc_Read_Device(), threadProc_Read_EMV(), and threadProc_Read_CTLS().
- Changed the SDK version to 1.0.35.003.

## [1.0.35.002] - 2020-01-02
- Fixed MSR Thread Crash for NEOII ADF

## [1.0.35.001] - 2019-12-20
- Fixed SDKC-14, SDKC-32, SDKC-33, SDKC-34, SDKC-35, CS-2888, CJAVAUSDK-182, CJAVAUSDK-184, and CJAVAUSDK-185.
- Added ARMv8 build for Raspberry Pi 3.
- Added Pip Reader.
- Added the functions device_queryFile(), felica_SendCommand()
- Changed threadProc_Read_CTLS() and threadProc_Read_MSR() to handle error code for IDG readers.
- Changed emv_startTransaction() and emv_activateTransaction() to display system screen for VP6800.
- Changed processReceivedData() to reset the structure IDTTransactionData first.
- Enabled the function pin_inputFromPrompt() for VP6800.
- Changed device_setCurrentDevice() and rs232_device_init() to send the reset transaction command when device_passthroughOffICC() returns 0x0B after the NEO 2 reader is connected.
- Changed the SDK version to 1.0.35.001.

## [1.0.34.003] - 2019-12-04
- Fixed TS-18902, SDKC-30, CJAVAUSDK-177, CJAVAUSDK-176, CJAVAUSDK-174, SDKC-29, CJAVAUSDK-173, CJAVAUSDK-170, CJAVAUSDK-165, CJAVAUSDK-168, and CJAVAUSDK-167.
- Added firmware update function for VP6800.
- Changed the platform names of the SDK and demo folders.
- Changed DoIDGCmdRS232() and ReadIDGRS232() to have the option to ignore LCD messages.
- Changed ctls_displayOnlineAuthResult() and lcd_addItem() to have longer timeout.
- Changed msr_startMSRSwipe() to set the maximum timeout value to 30 seconds for Augusta (firmware limitation).
- Changed threadProc_Read_PIN() to read PIN data properly.
- Changed device_setCurrentDevice() for NEO 2 readers to check bootloader mode.
- Changed WriteUsb() to write at most 3 times if failed for Augusta and MiniSmart II.
- Changed device_getIDGStatusCodeString() to add the error code 0x60 for EMV transaction.
- Changed the SDK version to 1.0.34.003.
- Increased the firmware buffer size to 4000000 bytes to store the content of the firmware file.

## [1.0.34.002] - 2019-11-04
- Fixed NEOII mssleep.  Fixed NEOII msr timeout
- Fixed NEOII MSR swipe

## [1.0.34.001] - 2019-11-01
- Fixed TS-18343, CS-2639, CJAVAUSDK-160, CJAVAUSDK-154, CJAVAUSDK-153, CJAVAUSDK-117, CJAVAUSDK-161, CJAVAUSDK-143, CJAVAUSDK-135, CJAVAUSDK-136, CJAVAUSDK-126, CJAVAUSDK-127, CJAVAUSDK-162, SDKC-26.
- Added VP3300 RS232 interface and created a new device type IDT_DEVICE_VP3300_COM.
- Added firmware update for VP3300.
- Added lcd_addVideo() for VP6800.
- Set the default value of isDataVariant in IDTMSRData to -1.
- Changed ctls_removeAllApplicationData() to remove the redundant tag "9F06".
- Changed ctls_displayOnlineAuthResult() to support 3 status codes 0, 1, and 2.
- Changed device_listDirectory() to support NEO 2 devices.
- Changed threadProc_Camera() to handle cancel and timeout properly.
- Changed threadProc_Read_EMV() to ignore button events during EMV transactions.
- Changed emv_authenticateTransaction() and emv_completeTransaction() to clear the buffer before reading the response data for Augusta and MiniSmart II.
- Changed the SDK version to 1.0.34.001.

## [1.0.33.001] - 2019-10-18
- Updated NEOII Internal for new fw and neoapi file, changing NEO Sleep ADF-38 

## [1.0.33] - 2019-10-18
- Removed pthread_exit causing crash on x64 systems, TS-17810, SDK-C8.
- Updated NEOII Internal for new fw and neoapi file ADF-38 

## [1.0.32] - 2019-10-04
- Fixed CJAVAUSDK-140, TS-18027, CS-2251.
- Fixed some hotplug exception issues.
- Added the error code IDG_P2_STATUS_CODE_SDK_BUSY_CMR, the functions device_registerCameraCallBk(), device_startQRCodeScan(), device_stopQRCodeScan(), device_startTakingPhoto(), device_stopTakingPhoto(), and CMR_callBack() to support the camera feature for VP6800.
- Changed the SDK version to 1.0.32. 

## [1.0.31] - 2019-09-31
### Changed
- Fixed emv transaction for NEOII internal
- Changed the SDK version to 1.0.31.

## [1.0.30] - 2019-09-17
### Changed
- Added the support for SREDKey 2.
- Added the functions device_SendDataCommandITP() and device_setSystemLanguage().
- Changed the SDK version to 1.0.30.

## [1.0.29] - 2019-08-29
### Changed
- Fixed: restarting listener for button presses when USB reconnect (Linux)
- Fixed: restoring callback when USB reconnect (Windows)
- Fixed: crash when reconnecting while listener thread is active (Windows)
- Added Win64 build

## [1.0.28] - 2019-08-28
### Changed
- Added USB Hotswap Functionality for Windows Platform

## [1.0.27] - 2019-08-22
### Changed
- Resolved crash when disconnecting USB connection in the middle of a USB reading loop
- ctls_displayOnlineAuthResult to be allowed on all devices, not just VP8800
- updated NEOII libraries to now use new malloc definition

## [1.0.26] - 2019-08-20
### Changed
- Fixed USB hotswap.  Now will properly reconnect automatically upon USB device detection

## [1.0.25] - 2019-08-19
### Changed
- Fixed device_isConnected checking while on RS-232

## [1.0.24] - 2019-08-14
### Changed
- Added device_setTransactionExponent
- Added ctls_displayOnlineAuthResult to IDT_NEO2.h

## [1.0.23] - 2019-08-08
### Changed
- Properly terminate mutex thread when starting a new RS-232 connection.
- Supress error message printout when trying to close a RS-232 handle that has already been closed

## [1.0.22] - 2019-08-02
### Changed
- Updated libusb-1.0.so for ARM and libusb-1.0.dll for Windows.
- Changed the function emv_setTerminalMajorConfiguration() to support the configuration value from 1 to 23.
- Changed threadProc_Read_CTLS(), threadProc_Read_MSR(), threadProc_AutoPoll_Read(), ReadIDGRS232(), and ReadIDGUsb() to handle Cancel and Enter key press.
- Changed ctls_startTransaction() and emv_startTransaction() to check the tag 5F36 for exponent.
- Changed ctls_removeApplicationData() to add the tag 9F06 for the AID.
- Increased the stack size of the thread threadProc_Read_MSR().
- Changed threadComplete() to not pass any authCode.
- Changed threadProc_Read_PIN() to get the correct pinBlockData.
- Changed threadProc_Read_CTLS() to handle card insert.
- Changed the SDK version to 1.0.21.

### Added
- Added BYTE functionKey[4] to the structure IDTPINData.

## [1.0.21] - 2019-06-26
### Changed
- Removed crypto library.
- Changed getAidStringsCheckContact() to ignore disabled AID�����.
- Changed threadProc_Read_CTLS() and threadProc_Read_MSR() to handle CDCVM (�����e Phone����) event.
- Changed device_setSleepModeTime() to handle L100 passthrough mode for NEO 2 devices.
- Changed threadProc_AutoPoll_Read() to handle CDCVM (�����e Phone����) event, and the button events "Cancel" and "Enter" for VP6300.
- Changed the thread stack size to 8 MB.
- Changed threadProc_Read_PIN() to handle pin_capturePin() and PIN Request properly.
- Changed parseEnhancedMSRData() to set captureEncryptType in IDTMSRData for IDG devices.
- Changed ReadIDGRS232() and ReadIDGUsb() to handle cancel PIN entry.
- Changed ReadIDGUsb() to handle LCD and PIN messages.
- Changed the SDK version to 1.0.21.

### Added
- Added the functions felica_authentication(), felica_readWithMac(), felica_writeWithMac(), felica_read(), felica_write(), felica_poll(), and felica_requestService().
- Added ERR_INSTALLER_BASE in �����rorCommon.h����.
- Added one more parameter �����nore���� for DoIDGP1CMD_str() to ignore the response data not related to the command.
- Added IDG_P2_STATUS_CODE_CDCVM  and enum EMV_LCD_DISPLAY_MESSAGE_MODE.

## [1.0.20] - 2019-03-07
### Changed
- Changed emv_startTransaction() and emv_activateTransaction() to also return the status code 0x63.
- Changed processTLV() to increase the data size.
- Changed emv_startTransaction() and emv_activateTransaction() to handle the return code 0x23.
- Changed parseEnhancedMSRData() to increase the tagValue size.
- Changed threadProc_Read_MSR() and threadProc_Read_CTLS() to handle bad swipe.
- Changed the timeout value for the read functions in emv_clearBuffer().
- Changed threadAuthenticate() and threadComplete() to handle errors.
- Changed threadProc_Read_PIN() for pin_getFunctionKey().
- Changed DoIDGCMD_str() to support RKI commands.
- Changed the SDK version to 1.0.20.

### Added
- Added threadProc_RKI(), device_registerRKICallBk(), device_startRKI(), and RKI_callBack() to support RKI function for VP3300.
- Added error codes for RKI. Added ca-certificates.crt.

## [1.0.19] - 2019-02-05
### Changed
- Changed threadProc_Read_EMV(), emv_startTransaction() and emv_activateTransaction() to handle different modes of VP8800 LCD messages.
- Changed the SDK version to 1.0.19.

## [1.0.18] - 2019-02-01
### Changed
- Changed threadProc_Read_CTLS() and threadProc_Read_MSR() to ignore LCD messages.
- Implemented DoCMD_data_justRead() for VP8800.
- Changed threadProc_Read_EMV() and processReceivedData() to handle EMV transactions with LCD messages for VP8800.
- Changed LanguageInfo.c to add more LCD messages.
- Changed the SDK version to 1.0.18.

### Added
- Added EMV_LCD_DISPLAY_MODE_PAUSE for EMV_LCD_DISPLAY_MODE.
- Added LCD functions in libIDT_Device.h.
- Added pin_promptForNumericKey() in libIDT_NEO2.h

## [1.0.17] - 2018-12-31
### Changed
- Changed the flag isDataVariant for parsing MSR card data.
- Changed threadProc_AutoPoll_Read() to handle lcd button event for VP6800.
- Changed ctls_startTransaction() and ctls_activateTransaction() to fix the value of the tag DFEF37 to 0x02.
- Changed emv_activateTransaction() to ignore LCD messages when sending the command.
- Changed ReadIDGRS232() in threadProc_Read_EMV() to have the timeout of 100ms.
- Changed the SDK version to 1.0.17.

### Added
- Added LCD and PIN functions for VP6800.
- Added lcd_registerCallBk().

## [1.0.16] - 2018-11-02
### Changed
- Merged the SDK source code with the customer's (Mackaymeters).
- Changed the SDK version to 1.0.16.

### Added
- Added device_getTransactionResults() for  all the .java files in JNI_Bridge.
- Added rs232_device_init() to libIDT_KioskIII.h, libIDT_MiniSmartII.h, libIDT_NEO2.h, and libIDT_SpectrumPro.h.

## [1.0.15] - 2018-09-19
### Changed
- Changed device_getKeyStatus() for L100.
- Changed the SDK version to 1.0.15.

## [1.0.14] - 2018-09-17
### Changed
- Changed the comment of the function device_getKeyStatus() for NEO 2 devices to generate the correct document.
- Updated JNI_Bridge with missing functions.
- Changed the SDK version to 1.0.14.

## [1.0.13] - 2018-09-06
### Added
- Added emv_setTerminalMajorConfiguration().

### Changed
- Ignore LCD messages for commands of NEO 2 devices under L100 pass through mode.
- Changed ctls_activateTransaction() to check the interface tag DFEF37.
- Disabled the PIN functions for L100 pass through mode of NEO 2 devices.
- Updated LCD messages.
- Updated the tags to check auto poll and burst mode.
- Changed the SDK version to 1.0.13.

## [1.0.12] - 2018-08-29
### Added
- Added the function device_getL100PassThroughMode().

### Changed
- Changed L100 related functions to support L100 passthrough mode.
- Changed emv_activateTransaction() to use the command 0x60-10 instead of 0x02-40 for NEO2 devices.
- Changed LCD message tables for 4 languages.
- Changed DoCMD_data_justRead() to support L100 passthrough mode.
- Changed the SDK version to 1.0.12.
- Increased the array lcd_messages[] to 4096 bytes.

## [1.0.11] - 2018-08-08
### Added
- Added PIN functions to support L100.
- Added L100 demo.

### Changed
- Implementing the support for L100 passthrough mode (not finished yet).
- Changed threadProc_Read_CTLS() to not send the command 0x03-03 after EMV authenticate for VP8800.
- Changed ctls_startTransaction() and ctls_activateTransaction() to use the timeout value passed.
- Changed ctls_retrieveApplicationData() to not pass the tag DFEE4F for NEO 2 devices.
- Changed lcd_clearDisplay() to support L100.
- Changed parseEnhancedMSRData() for VP8800 with the new tags DFEF17 and DFEF18.
- Changed DoNGACmdUsb() to support L100 passthrough mode.
- Changed IDTPINData to support L100.

## [1.0.10] - 2018-07-27
### Added
- Added the tag DFEF37 for ctls_startTransaction() for NEO2 devices.

### Changed
- Changed processReceivedData() to parse the response data of EMV start/authenticate transaction for VP8800 correctly.
- Changed EMV_startTransaction() to set the correct tag value for the tag DFEF37 for VP3310.
- Changed threadProc_Read_MSR() to return error code for MSR transaction.
- Changed the device name checking string "FW Update" to "FW_UPDATE" in device_setCurrentDevice().
- Changed the version to 1.0.10.

## [1.0.9] - 2018-07-20
### Added
- Added the callback function for firmware update.
- Added the function device_registerFWCallBk().
- Added the function to write the log to a file instead of output to screen.
- Added NEO 2 FW Update in NEO2_Devices.xml.

### Changed
- Changed device_updateFirmware() for NEO 2 devices.
- Changed version to 1.0.9.

## [1.0.8] - 2018-07-16
### Changed
- Changed pin_getEncryptedOnlinePIN() to store correct KSN data.
- Changed SDK version to 1.0.8.

## [1.0.7] - 2018-07-05
### Added
- Added support for Kiosk IV by USB, and also added support for Kiosk IV and Kiosk III S by RS232.

### Changed
- Changed the DoIDGCMD_str() to set the data size to 0 when the return code is not IDG_P2_STATUS_CODE_DO_SUCCESS.
- Changed DoIDGCmdRS232() and ReadIDGRS232() to return the correct error code.
- Changed the SDK version to 1.0.7.
- Changed libIDT_KioskIII.h to replace msr_registerCallBk() and msr_registerCallBkp() with ctls_registerCallBk() and ctls_registerCallBkp().

### Removed
- Removed .$(VERSION) for LDFLAGS in the Makefiles.

## [1.0.6] - 2018-06-22
### Added
- Added device_enableExternalLCDMessages().
- Added device_setNEO2DevicesConfigs().

### Changed
- Increased ram size of NEO2 to 0x400000 bytes.
- Changed all the NEO2 functions to handle external LCD messages.
- Increased the MSR, CTLS, and EMV card data size to 4K.
- Changed EMV, CTLS, MSR, and device cancel transactions to wait for 150 ms.
- Changed device_setBurstMode() for NEO devices to use the new tag 0xDFEE7E for command data. 
- Changed lcd functions to support only VP8800.
- Changed processReceivedData() to parse CTLS data correctly.
- Changed config_getModelNumber() to support NEO2 devices.
- Changed the SDK version to 1.0.6.
- Changed device_init() to handle both xml file and xml data.

## [1.0.5] - 2018-06-13
### Changed
- Changed device_startTransaction() for EMV transaction for VP8800.
- Added device_configureButtons(), device_getButtonConfiguration(), device_disableBlueLED(), device_enableBlueLED(), device_lcdDisplayClear(), device_turnOffYellowLED(), device_turnOnYellowLED(), device_buzzerOnOff(), device_lcdDisplayLine1Message(), and device_lcdDisplayLine2Message().
- Added emv_getEMVKernelVersion(), emv_getEMVKernelCheckValue(), and emv_getEMVConfigurationCheckValue() in libIDT_NEO2.h.
- C++ SDK update makefiles to remove VP5300 demo folder
- Changed device_getKeyStatus() to support NEO devices.
- Changed threadProc_Read_EMV() for RS232 read timeout.
- Changed device_setCurrentDevice() to handle redundant LCD messages.
- Changed parserEMVCallback() to public.
- Added the function device_setConfigPath().
- Removed the MAJOR version from Makefile.
- Changed threadProc_Read_MSR() to return correct error code.

## [1.0.4] - 2018-06-06
### Changed
- Changed emv_activateTransaction to not require amount/type
- Changed ctls_activateTransaction to not require amount/type
- Changed device_activateTransaction to not require amount/type

## [1.0.3] - 2018-056-05
### Added
- Added emv_getEMVKernelVersion()
- Added emv_getEMVKernelCheckValue()
- Added emv_getEMVConfigurationCheckValue() in libIDT_NEO2.h.
- Added emv_retrieveTransactionResult() in libIDT_NEO2.h.
- Added emv_activateTransaction
- Added ctls_activateTransaction
- Added device_activateTransaction

### Changed
- C++ SDK update makefiles to remove VP5300 demo folder

## [1.0.2] - 2018-05-24
### Changed
- Changed the version to 1.0.2.
- Updated makefiles and NEO2 header
- Added NEO2_Devices.xml, update libIDT_NEO2.h
- Updated pipelines output file with branch name
- Moved version number to VERSION file
- comm library - add HEAD request for comm_httpRequest
- Added get CAPK for configMgr
- Modularized configMgr functions
- Added config meta and template functions for configmgr
- Added config aids for configmgr
- Added get terminal data and crl for configMgr
- Get NEO2 device name by the tag Product instead of Name.
- Added emv_setApplicationDataTLV()
- Added comm_setCAPath() and HEAD request for http request. Fixed the call back function HTTPRequestWriteCallback() for http async requests.
- Added emv_setApplicationDataTLV()
- Changed ctls_getAllConfigurationGroups() for NEO2 devices
- Changed device_startTransaction() to check timeout value for NEO2 devices

### Removed
- Removed AC100 makefiles
- Removed get version functions

## [1.0.1] - 2018-05-01
### Changed
- Changed the version to 1.0.1.
- Changed threadProc_Read_EMV() to handle MSR fallback data size larger than 512 bytes.

## [1.0.0] - 2018-04-27
### Changed
- Changed threadProc_Read_MSR() to handle more LCD messages.
- Changed threadProc_Read_EMV() to handle LCD messages and return correct error code for timeout.  Changed emv_cancelTransaction() to handle more LCD messages for VP5300.  Changed emv_retrieveTransactionResult() to get correct tlv data.
- Changed device_cancelTransaction() to call emv_cancelTransaction() for NEO2 devices.
- Changed threadProc_Read_CTLS() to handle LCD messages.
- Merge all original libraries into one shared library
- Proper Semantic Versioning
- Refactor makefiles for autobuilding

### Removed
- ADF Libraries from main SDK
- ADF Library header symbols

## [0.02.032.001] - 04/25/2018
- Changed emv_cancelTransaction() to handle LCD messages.
- Changed device_setPollMode() to handle LCD message.
- Changed the version to 0.02.032.001.
- Changed the comment for device_startTransaction().
- Changed processReceivedData() for VP8800 testing.
- Changed threadProc_Read_EMV() to handle the returned data for command 0x02-40 for NEO2 devices.  Changed emv_startTransaction() to handle the call from device_startTransaction() for NEO2 devices.
- Changed device_startTransaction() and device_getFirmwareVersion() for NEO2 devices.  Changed threadProc_AutoPoll_Read() to handle LCD messages for VP5300.

## [0.02.031.001] - 04/20/2018
- Changed ReadIDGUsb() to ignore LCD messages.
- Changed version to 0.02.031.001.  Added device_getDevicePid().
- Added more LCD message strings for each language.
- Changed threadProc_Read_MSR() to handle LCD messages.
- Changed threadProc_Read_EMV() to handle LCD messages.  Changed emv_startTransaction() to handle duplicate - tags.
- Changed device_controlUserInterface() to handle NULL parameter.
- Changed threadProc_Read_CTLS() to handle LCD messages.
- Added MSR_callBack_type_ERR_CODE in MSR_callBack_type.  Added errorCode in IDTMSRData.
- Checked NULL parameter for setAbsoluteLibraryPath().  Increased the buffer size of processTLV().
- Changed getAIDTags() to get the correct tag count.

## [0.02.030.001] - 04/11/2018
- Changed/Removed mssleep() functions to reduce read/write time.
- Removed device_selfCheck().  Changed emv_autoAuthenticate() to emv_setAutoAuthenticateTransaction().  Added emv_setAutoCompleteTransaction(), emv_getAutoAuthenticateTransaction(), and emv_getAutoCompleteTransaction().
- Reverted libIDT_LogMgr.h.
- Reverted libIDT_Log.h.
- Added #include <sqlite3.h> and #include <string.h>.
- Changed emv_autoAuthenticate() to emv_setAutoAuthenticateTransaction().  Added emv_setAutoCompleteTransaction(), emv_getAutoAuthenticateTransaction(), and emv_getAutoCompleteTransaction().
- Reverted log messages.  Changed parseNGAMSRFormat() for Augusta and MiniSmartII.
- Added emv_setAutoCompleteTransaction(), emv_getAutoAuthenticateTransaction(), and emv_getAutoCompleteTransaction().
- Added "CAPTURE_ENCODE_TYPE_Unknown" in CAPTURE_ENCODE_TYPES.  Added Java_IDTechSDK_IDTechSDKBridge_jemvsetAutoCompleteTransaction(), Java_IDTechSDK_IDTechSDKBridge_jemvgetAutoAuthenticateTransaction(), and Java_IDTechSDK_IDTechSDKBridge_jemvgetAutoCompleteTransaction().
- Added threadComplete() to handle auto EMV complete transaction.
- Changed the buffer to read MSR card data in threadProc_Read_MSR() to 2K.  Check the flag AutoPollOn for most of the functions.
- Reverted IDTech_logMgr.c.
- Fixed emv_setCRL() for NEO2 devices.  Check the flag AutoPollOn for most of the functions.  Added emv_setAutoCompleteTransaction(), emv_getAutoAuthenticateTransaction(), and emv_getAutoCompleteTransaction().
- Removed #include <sqlite3.h>.

## 04/10/2018
- Check the flag AutoPollOn in most of the functions..
- Added CAPTURE_ENCODE_TYPE_Unknown for CAPTURE_ENCODE_TYPE.  Reverted the enum LOG_LEVEL. Added mac and macKSN for IDTMSRData.
- Changed parseMSRData().
- Changed back to old log functions.
- Added .fp_emv_setAutoAuthenticate, .fp_emv_setAutoComplete, .fp_emv_getAutoAuthenticate, and .fp_emv_getAutoComplete in idtech_sdk_api_str.
- C++ SDK fix includes for devMgr and logMgr

## 03/23/2018
- C++ SDK config manager updates
- Implement remaining log manager functions.
- Update log_rawCommData() and log_raw() functions to accept raw binary data.
- Add ADF module function declarations for testing suite.
- Rename RAW_COMMUNICATION_DATA to DEBUG.
- Update IDT_LOG_MESSAGE() and rename RAW_COMMUNICATION_DATA to DEBUG.
- Update LOG_LEVEL enumeration and add logging modules response codes.
- Add logging manager pass-through functions.
- Removed VP5300 Pid.  Added isNEO2Pid().
- Changed get version functions to pass a string for storing the version.
- Changed device_init() to support NEO2 devices.
- Removed unsupported functions.
- Changed ws_getVersion() to return error for AC100.
- Changed msr_getVersion() to return error for AC100.  Changed VP5300 to NEO2.
- Changed lcd_getVersion() to return error for AC100.
- Changed icc_getVersion() to return error for AC100.
- Changed emv_getVersion() to return error for AC100.
- Changed device_getVersion() to return error for AC100.
- Changed ctls_getVersion() to return error for AC100.
- Changed config_getVersion() to return error for AC100.  Check NULL pointer for the functions.
- Added IDT_DEVICE_NEO2 to DEVICE_TYPE. Increased the size of value in IDTTag.  Added the variable name in IDTDeviceHandle.
- Changed get version functions to pass a string for storing the version.
- Reverted back to old log functions until new functions are done.
- Changed the version to 0l.02.030.001, and changed VP5300 to NEO2.

## 03/20/2018
- Added NEO2 devices.

## 03/19/2018
- Added AC100 Single File

## 03/08/2018
- Add device manager pass-through functions.
- Implement device manager API.
- Add device manager function declarations.
- Add RESOURCE_TYPE enum and add more response codes for the device manager module.
- Update device manager function documentation and add devMgr_removeCallerAndReleaseClaims().
- Copy devMgr headers to corresponding directories.
- Add log callback function declaration.

## 03/07/2018
- C++ SDK header updates for Security and ResMgr
- C++ SDK implement Resource Manager Library

## 03/05/2018
- C++ SDK security library bug fixes
- C++ SDK fix compile issues for Mac, Pisces, and Neo2

## 03/02/2018
- Updated MAC code to bypass mutex lock/unlock on libIDT_Device.c
- Fixed callback parameter for logging
- Excluded r_pthread.c from Windows makefile and Mac makefile

## 03/01/2018
- C++ SDK add Security Library
- NEO II Updates

## 02/26/2018
- Updated pthread functions for NEO II
- Added NEO II Methods
- Add preliminary device manager and resource manager function declarations.
- Add logging manager module function declarations and definitions (in progress).
- Add logging module function declarations.
- Reverse LOG_LEVEL enum and add module specific response enums.
- Add preliminary communication module function declarations.
- Add logging ����瘥秋�嚙賣�ss-through����瘥秋��嚙� functions.
- Remove deprecated logging functions.
- Add logging function declarations.
- Fix FTP download progress error and add preprocessor directives for handling certificates on Windows.
- Check for both VP8800 and NEO2 preprocessor directives.
- Copy log and logMgr header files accordingly when building for VP8800.
- Reverted back to 6318
- Updated emv_completeTransaction to not check for parameters if commError = 1.
- Checkpoint upload.  Converting files to also work with NEO II.  Reverting multiple libraries into a single IDTechSDK for NEO II.

## 02/15/2018
- Adding ARM-M Support.  Adding NEO 2 headers

## 02/13/2018
- Add httpComm_callBack, v4Comm_callBack function pointer declarations and comm_registerHTTPCallback(), comm_registerV4Callback() function declarations to device headers.
- Add pass-through functions for comm_registerHTTPCallback() and comm_registerV4Callback().
- Implement async option for comm_httpRequest().
- Add communication library result code (COMM_ASYNC_FAIL) for when creating a new thread fails.
- Removed EXPORT_SYMBOLS from comm_uploadFTP().
- Changed the version to 0.02.029.001.
- Changed threadProc_Read_MSR() to check DPAS AID and the tag 9F71 when the return code of msr transaction is 0x0A to return MSR_callBack_type_FALLBACK_TO_CONTACT.
- Changed emv_retrieveAIDList() to check the parameter AIDListLen passed in for VP3300.
- Changed threadProc_Read_CTLS() to check DPAS AID and the tag 9F71 when the return code of ctls transaction is 0x0A to return MSR_callBack_type_FALLBACK_TO_CONTACT.
- Added MSR_callBack_type_FALLBACK_TO_CONTACT to enum MSR_callBack_type.

## 02/08/2018
- Add comm_httpRequest() declaration to device headers.

## 02/07/2018
- Add certificate option for comm_httpRequest() for Windows platform.
- Changed the SDK version to 0.02.028.001.
- Changed emv_completeTransaction() to handle NULL iad.
- Add new communication library return codes.
- Update comm_httpRequest() return codes.

## 02/02/2018
- C++ SDK bug fix emv_removeAllApplicationData() for VP8800

## 01/30/2018
- Add comm_downloadFTP() and comm_uploadFTP() declarations to header files.
- Update comm_downloadFTP() and comm_uploadFTP() functions with new result codes and add CAINFO option for Windows.
- Add result codes for communication library.
- C++ SDK bug fix: add static to private functions

## 01/29/2018
- C++ SDK bug fix header files

## 01/26/2018
- Added ftpComm_callBack.
- Added FTP upload, FTP download, and http request.
- Implemented FTP upload and download.
- Added P2 status code.
- Remove unused function.

## 01/25/2018
- C++ SDK update headers with L2 library
- Copy communication header to demo output.
- Add comm_sendEmail() declaration to header files.
- Implement comm_sendEmail().

## 01/24/2018
- C++ SDK tlv comment updates and bug fixes
- Add communication library result code enum.
- Add compiler _WIN32 definition to satisfy test suite.
- Remove obsolete filter out statement.

## 01/10/2018
- Added IDTech_comm.c and IDTech_comm.h.
- Added comm_registerHTTPCallback(), comm_registerV4Callback(), and comm_downloadFTP().
- Removed unused variables.
- C++ SDK add Initial Security Library
- Changed IDT_LOG_MESSAGE().
- Added httpComm_callBack and v4Comm_callBack.
- Added httpComm_callBack s_pComm_f and v4Comm_callBack s_pv4Comm_f.
- Changed IDT_LOG_MESSAGE().

## 01/09/2018
- C++ SDK add L2 functions

## 01/08/2018
- Update include statements.
- C++ SDK update library headers
- Update iso8583_derserializeFromXML to return RETURN_CODE_DO_SUCCESS when successful.

## 01/05/2018
- Changed _idtech_crypto_api_t to solve compile errors.
- Changed _idtech_sdk_api_t_ to solve compile errors.
- Changed void tlv_processIDTTLV() to int tlv_processIDTTLV().
- #define EXPORT_SYMBOLS extern for non-Windows platforms.
- C++ SDK Crypto Library bug fix
- C++ SDK Compression library update makefiles
- Fix incorrect assignment of field definition.
- Remove const modifier from ISO8583 structures.
- C++ SDK add Compression library and support for Pisces

## 01/04/2018
- Fixed the extern issue.

## 01/03/2018
- Fixed tlv_sortTLV().
- Changed device_transferFile() to limit the file size to 461000 bytes.
- Changed the parameters of Java_IDTechSDK_IDTechSDKBridge_jpinpromptCreditDebit().
- Added crypto_getVersion() and tlv_validateTLV().  Changed tlv functions to return an error code.
- Changed a_tlv_processIDTTLV, a_tlv_sortTLV, and a_tlv_getTagValue to return an error code.
- Added device_enhancedPassthrough() and lcd_cancelSlideShow().  Changed the tlv functions to return error code.
- Added DoIDGP3CMD_str().  Changed parseEnhancedMSRData() to assign isCTLS to cardData.
- Changed pin_promptCreditDebit() for VP8800.
- Changed processReceivedData() for VP8800.
- Added an internal function msr_readMSRData().
- Modified lcd_startSlideShow().  Added lcd_cancelSlideShow(), lcd_createInputField(), and lcd_getInputFieldValue().
- Changed icc_getICCReaderStatus() for VP8800.
- Changed emv_startTransaction() and emv_completeTransaction() to handle PIN entry and signature for VP8800.  Changed emv_completeTransaction() to have the iadLen between 8 and 16 bytes.
- Changed threadProc_Read_Device() to handle PIN entry and signature for VP8800.  Added device_enhancedPassthrough().
- Added crypto_getLibraryVersion().
- Added RETURN_CODE_EMV_PIN and RETURN_CODE_EMV_SIGNATURE to RETURN_CODE.
- Changed tlv_sortTLV(), tlv_getTagValue(), tlv_removeTLV(), tlv_countTLV(), tlv_validateTLV(), and pin_promptCreditDebit(). Added device_enhancedPassthrough(), lcd_cancelSlideShow(), lcd_createInputField(), lcd_getInputFieldValue(), and crypto_getVersion().

## 12/26/2017
- C++ SDK update Crypto Library to include DES

## 12/21/2017
- C++ SDK bug fixes
- Add ISO8583 function declarations to device headers.
- Add iso8583_get1987Handler(), iso8583_get1993Handler(), iso8583_get2003Handler(), iso8583_getField(), iso8583_initializeMessage(), iso8583_getMessageField(), iso8583_setMessageField(), iso8583_removeMessageField(), iso8583_packMessage(), iso8583_unpackMessage(), iso8583_freeMessage(), iso8583_serializeToXML(), iso8583_deserializeFromXML(), and iso8583_displayMessage() functions.
- Add public ISO8583 structures.
- Add external ISO8583 library source files.
- Update Makefiles to ignore ISO8583 source files.

## 12/20/2017
- Update C++ Crypto Library to handle PEM, DER, PKCS7, and PKCS12 RSA Certificates

## 12/14/2017
- Update C++ Crypto Library with Cipher settings, RSA, and HMAC

## 12/11/2017
- Add NULL check to setMerchantRecord().

## 11/21/2017
- Added NEO2 flag for CONFIG, CRYPTO, and TLV.

## 11/17/2017
- Add support for NEOII to the crypto library (work in progress).
- Add support for NEOII to the configuration library (work in progress).
- Adding ARM-M Support
- Fixed a typo in the comment.
- Removed the ����瘥秋��蕭,����瘥秋�嚙賜嚙� of the last element of enum.

## 11/16/2017
- Adding ARM-M Support

## 11/13/2017
- Changed IDTEnableLogging() to IDT_EnableLogging(), and added the function IDT_DisableLogging().
- Added the flag logEnabled.

## 11/10/2017
- Changed the version to 0.02.027.001.
- Use new function IDT_LOG_MESSAGE() instead of DoPrintF(), libpos_log_byte_array(), and libpos_log() for logging.
- Added enum LOG_LEVEL, COMM_TYPE, and FORMAT_TYPE.
- Implemented IDT_LOG_MESSAGE() and modified IDTLog() for logging.

## 11/06/2017
- Update header files to include IDTDef.h
- Update header files to include TLV and Crypto functions

## 11/01/2017
- Free symbol after usage.
- Add raw communication data and function entry / exit logging functions.
- Add constants relevant to logging.
- Add raw communication data logging.
- Add imagehlp library to linker options.

## 10/27/2017
- Changed device_getRTCDateTime() to support more tags in response data.

## 10/26/2017
- Changed the SDK version to 0.02.026.001.
- Added DoIDGP1CMD_str().  Changed parseEMVFormat1() to support enhanced MSR data.
- Changed processReceivedData() to support enhanced MSR data.
- Removed printData(), resetMSRData(), and parseMSRData().
- Changed threadProc_Read_EMV(), emv_startTransaction(), emv_authenticateTransaction(), emv_completeTransaction(), and emv_cancelTransaction() to reset the timeout value.
- Added device_getRTCDateTime() and device_setRTCDateTime().  Changed parseMSRData() for new enhanced MSR data.
- Added grsiP1Command() and grsiP3Command().

## 10/24/2017
- Move tlv and crypto functions into their own shared library.

## 10/20/2017
- Changed tlvCompare().
- Changed IDTCryptoData.

## 10/19/2017
- Updated Makefiles to show warnings. Fixed some warnings.

## 10/17/2017
- Added IDTCryptoData, getIPEK(), getDerivedKey(), getDataKey(), getPINKey(), getMACKey(), encryptTDES(), and encryptAES(), decryptTDES(), decryptAES(), encryptPinTDES(), encryptPinAES(), decryptPinTDES(), decryptPinAES(), processDUKPT(). Fixed a bug with convertBytesToHexString(). Updated Makefiles for OpenSSL.

## 10/11/2017
- Removed EXPORT_SYMBOLS for lcd_getInputEvent().
- Changed the comments to fix some Doxygen issue.

## 10/10/2017
- Changed version to 0.02.025.001.
- Changed rs232_timeout to be extern.
- Changed the comment for the documentation.
- Changed the timeout for ReadIDGRS232().

## 10/09/2017
- Fixed compiler error for ARM.
- Changed ReadIDGRS232() to return IDG_P2_STATUS_CODE_TIMEOUT for timeout.
- Changed emv_setApplicationData().
- Changed processReceivedData() to support VP5300.
- Added VP5300 and changed the version to 0.02.024.001.

## 10/06/2017
- Added processIDTTLV(), sortTLV(), getTagValue(), addTLV(), removeTLV(), countTLV(), and convertTagArray().

## 09/19/2017
- Add soname option when generating library for Java for x86_64.

## 09/18/2017
- Add static linker flag for Windows_Java Makefile to bundle functions at compile time.

## 09/15/2017
- Changed ReadDataUsb() to support auto poll and burst mode on for Mac.  Changed InitUsbLib() and CloseUsb() to fix open and close USB issues for Mac.

## 09/14/2017
- Exported the function convertNumberToASCII().
- Changed ReadDataUsb() to use hidlib instead of usblib for VP3300.
- Added emv_setTransactionParameters().
- Changed the version to 0.02.023.001 and added EMV parameters.
- Added jemvsetTransactionParameters().
- Changed device_startTransaction() to support EMV transaction even when auto poll is on.  Changed threadProc_AutoPoll_Read(), device_setBurstMode(), and device_setPollMode() to support 3-interface transactions when auto poll is on for VP3300.  Changed device_getTransactionResults() to handle error codes 0x23, 0x30, and 0x31.
- Added CVN17 card data parsing in processCTLSData().

## 08/31/2017
- Fix assignment of checKValueLen in emv_getEMVKernelCheckValue function.
- Add convertNumberToASCII function
- Update _CMD_DATA_MAX_LEN to 4096
- Add lcd_displayText, lcd_displayParagraph, lcd_displayButton, lcd_createList, lcd_addItemToList, lcd_clearEventQueue, and lcd_getInputEvent functions.

## 08/30/2017
- Added Vendi and changed the version to 0.02.022.001.
- Changed all IDG devices to use hid library instead of libusb.
- Added device_startTransaction() and device_cancelTransaction().
- Changed device_close() to prevent the application from crashing.

## 08/08/2017
- Update Makefiles (for Java bridge) to export JARs into corresponding folders automatically.

## 08/07/2017
- Adding Pisces Support Files

## 08/01/2017
- Add JNI C functions:
- - device_startTransaction(), device_cancelTransaction(), device_controlUserInterface(), device_controlIndicator(), device_calibrateParameters(), device_getDriveFreeSpace(), device_listDirectory(), device_createDirectory(), device_deleteDirectory(), device_transferFile(), and device_deleteFile()
- - ctls_displayOnlineAuthResult()
- - emv_retrieveExceptionList(), emv_setException(), emv_removeException(), emv_removeAllExceptions(), emv_retrieveExceptionLogStatus(), emv_removeTransactionLog(), emv_retrieveTransactionLogStatus(), and emv_retrieveTransactionLog()
- - lcd_resetInitialState(), lcd_customDisplayMode(), lcd_setForeBackColor(), lcd_clearDisplay(), lcd_captureSignature(), lcd_startSlideShow(), lcd_setDisplayImage(), and lcd_setBackgroundImage()
- - pin_getEncryptedOnlinePIN(), pin_getPAN(), and pin_promptCreditDebit()
- Update Makefile for ARM_Java to link with libusb-1.0.

## 07/31/2017
- Changed the version to 0.02.021.001.
- Changed VP4880 to VP3300_USB, UniPayIII to VP3300_AJ, and VP3300 to VP3300_BT.
- Changed VP3300_AJ, VP3300_USB, and VP3300_BT to use libhid instead of libusb.
- Added device_setCurrentDevice().
- Changed the comment of device_setCurrentDevice().
- Moved the PID definition to poscom_usb.h.  Changed device types IDT_DEVICE_UNIPAY_III to IDT_DEVICE_VP3300_AJ, IDT_DEVICE_VP4880 to IDT_DEVICE_VP3300_USB, and IDT_DEVICE_VP3300 to IDT_DEVICE_VP3300_BT.
- Added the check for the flag isMSRBusy in functions.
- Added the function emv_clearBuffer().
- Changed threadProc_Read_Device() to support device_startTransaction().  Added more flags in device_cancelTransaction() to stop the thread threadProc_Read_Device().
- Changed VP4880 to VP3300_USB, UniPayIII to VP3300_AJ, and VP3300 to VP3300_BT.

## 07/27/2017
- Changed the value of IDG_P2_STATUS_CODE_CARD_INSERTED to 0xA3.

## 07/18/2017
- Release SDK version 0.02.020.001.
- Changed TLV_ParseTags() back to not ignore the last 5 bytes.
- Added IDG_P2_STATUS_CODE_ICC_CARD_INSERTED.
- Modified threadProc_Read_Device() to support device_startTransaction() for VP3300, VP4880, and UniPay III.

## 07/14/2017
- Add new EMV functions for the VP8800.
- Fix issue with incorrect storage of device handles when using HIDAPI.

## 07/13/2017
- Removed TLV_getTags() from libIDT_Device_shared.h.
- Added TLV_getTags() to libIDT_Device.h.
- Added device_sendVivoCommandP2_ext() and device_sendVivoCommandP3_ext().
- Added grsiP3Command().

## 07/12/2017
- Added IDTech_lcd.c and IDTech_ws.c.
- Added the int parameter deviceType to CloseUsb().
- Changed OpenUsb() and CloseUsb() to support VP8800.
- Added lcd_resetInitialState(), lcd_customDisplayMode(), lcd_setForeBackColor(), lcd_clearDisplay(), lcd_captureSignature(), lcd_startSlideShow(), lcd_setDisplayImage(), pin_getEncryptedOnlinePIN(), pin_getPAN(), pin_promptCreditDebit(), ws_requestCSR(), ws_loadSSLCert(), ws_revokeSSLCert(), ws_deleteSSLCert(), ws_getCertChainType(), and ws_updateRootCertificate().
- Changed the second parameter of pPIN_callBack() from IDTPINData to IDTPINData *.
- Added parsePINBlockData().
- Added lcd_resetInitialState(), lcd_customDisplayMode(), lcd_setForeBackColor(), lcd_clearDisplay(), lcd_captureSignature(), lcd_startSlideShow(), lcd_setDisplayImage(), lcd_setBackgroundImage(), pin_getEncryptedOnlinePIN(), pin_getPAN(), pin_promptCreditDebit(), ws_requestCSR(), ws_loadSSLCert(), ws_revokeSSLCert(), ws_deleteSSLCert(), ws_getCertChainType(), ws_updateRootCertificate(), and parsePINBlockData().
- Increased the buffer size of the return data for DoIDGCMD_str() from 1K to 4K.  Changed device_init() and device_close() to fix the crash issue when connecting VP8800 and other devices by USB.
- Added WS source file for VP8800.
- Added pin_getEncryptedOnlinePIN(), pin_getPAN(), pin_promptCreditDebit(), and parsePINBlockData().  Changed parsePINData().
- Changed processReceivedData() to fix the issue of no data for MSR fall back during EMV transaction for VP4880.
- Added the LCD source file.
- Added one more check in device_listDirectory().
- Changed ctls_setCAPK(), ctls_retrieveCAPKRIDList(), ctls_retrieveCAPKRIDIndexes(), ctls_removeCAPK(), ctls_removeAllCAPK(), and ctls_getConfigurationGroup() to support VP8800.
- Changed the structure IDTPINData and added the structure RequestCSR to support VP8800.
- Added LCD, PIN, and WS functions.

## 07/07/2017
- Add emv_removeTransactionLog, emv_retrieveTransactionLogStatus, and emv_retrieveTransactionLog functions for the VP8800.

## 07/06/2017
- Add emv_setException, emv_removeException, emv_removeAllExceptions, and emv_retrieveExceptionLogStatus functions for the VP8800.
- Update emv_retrieveCRL, emv_removeCRL, emv_setCRL, emv_removeAllCRL, and emv_retrieveCRLStatus functions for the VP8800.

## 07/05/2017
- Add emv_retrieveCRLStatus and emv_retrieveExceptionList functions for the VP8800.
- Update ctls_getConfigurationGroup and ctls_removeConfigurationGroup functions for the VP8800.
- Add ctls_resetConfigurationGroup function for the VP8800.
- Update emv_retrieveCAPK, emv_setCAPK, emv_removeCAPK, emv_removeAllCAPK, and emv_retrieveCAPKList functions for the VP8800.
- Update linker flag for ARM to point to libusb.
- Added ctls_displayOnlineAuthResult().
- Changed device_getDriveFreeSpace() to fix a compile error.
- Changed ctls_retrieveApplicationData() and ctls_retrieveCAPK(), and added ctls_displayOnlineAuthResult() to support VP8800.
- Added isPINBusy and isMSRBusy;

## 07/03/2017
- Update emv_setApplicationData, ctls_getConfigurationGroup, ctls_removeConfigurationGroup, emv_retrieveCAPK, and emv_removeCAPK functions for the VP8800.
- Add ctls_resetConfigurationGroup function for the VP8800.
- Update USB communication to use HIDAPI for the VP8800.
- Update EMV AID functions for the VP8800.
- Changed the comment of ReadIDGRS232().
- Added device_getDriveFreeSpace(), device_listDirectory(), device_createDirectory(), device_deleteDirectory(), device_transferFile(), device_deleteFile(), device_controlIndicator(), device_calibrateParameters(), and msr_flushTrackData().  Removed device_setBurstMode() and device_setPollMode().
- Changed convertBytesToHexString(), DoNGACMD_str(), DoITPCMD_str(), DoIDGCMD_str(), DoDirectIDGCMD_str(), and DoCMD_data_justSend() to increase the command size to 4K.  Changed device_getIDGStatusCodeString() to support error code 0x98 and 0x99.
- Added msr_flushTrackData().
- Changed emv_retrieveAIDList() to support VP8800.
- Changed the return code of device_startTransaction() and device_cancelTransaction().  Changed device_SendDataCommand() to increase the command sizde to 4K.
- Added the error code IDG_P2_STATUS_CODE_NO_DRIVE_SPACE.
- Added the function getAidStringsCheckContact().
- Changed grsiP2Command(0 to increase the command size to 4K.  Added the function getAidStringsCheckContact().

## 06/30/2017
- Add HIDAPI source for Windows and Linux.
- Update USB communication to use HIDAPI for the VP8800.
- Update timeout value when starting an EMV transaction.
- Update emv_retrieveApplicationData and emv_removeApplicationData functions for the VP8800.
- Add error handling for error 0x36 (No Advice or Reversal Required (Declined)).

## 06/29/2017
- Changed WriteUsb() for VP8800.
- Added device_startTransaction() and device_cancelTransaction().
- Added VP8800 for parseEnhancedMSRData().
- Changed processReceivedData() for VP8800.
- Changed emv_startTransaction(), emv_authenticateTransaction(), and emv_completeTransaction() for VP8800.
- Added threadProc_Read_Device(), device_startTransaction(), and device_cancelTransaction().
- Removed the duplicated processTLV().  Changed threadProc_Read_CTLS() and ctls_startTransaction() for VP8800.

## 06/26/2017
- Changed BTPAY_MINI and PISCES to VP3300 and VP8800.
- Changed Pisces to VP8800.
- Changed BTPayMini to VP3300.
- Changed The comment of emv_setTerminalData().

## 06/21/2017
- Added Pisces and changed the version to 0.02.020.001.
- Implemented ReadIDGRS232().
- Added Pisces in emv_retrieveTerminalData().
- Added Pisces in DEVICE_TYPE.
- Added Pisces in getCurrentDeviceName().
- Changed the CRC order in grsiP2Command().

## 06/16/2017
- Added BTPayMini in getCurrentDeviceName().
- Add BTPay Mini support to Java bridge.

## 06/15/2017
- Changed _FIRMWARE_BUF_LEN from 1500000 to 1700000.

## 06/14/2017
- Changed the version to 0.02.019.001.

## 06/09/2017
- Update modifiers for shared variables and resolve issue with emv_canceled variable error for Mac OS.
- Added device_getTransactionResults().
- Changed device_setBurstMode() to only support mode 0 and mode 1.
- Changed SHARED_SYMBOLS to extern.
- Added test code for IDG devices.
- Added EXPORT_SYMBOLS to shared variables.
- Added a check to prevent processReceivedData() from crash.
- Added the flag isEMVCancelCmd to solve emv_cancelTransaction() block issue under Windows.
- Changed device_SendDataCommand() to solve emv_cancelTransaction() block issue under Windows.
- Changed EXPORT_SYMBOLS and SHARED_SYMBOLS.

## 06/06/2017
- Changed the version to 0.02.019.
- Removed EXPORT_SYMBOLS for variables.  Increased the buffer by 64 bytes for DoNGACMD_str() and DoCMD_str_back_OKdata().  Reset BurstModeOn and AutoPollOn in device_setCurrentDevice().  Modified rs232_device_init() to test Spectrum Pro by RS232.
- Increased c_APDU length form 500 bytes to 512 bytes.
- Added IDT_DEVICE_SPECTRUM_PRO_COM for emv_retrieveTerminalID().  Increased 64 buytes buffer for emv_retrieveCRL().  Fixed the timout value for emv_startTransaction() and emv_authenticateTransaction().  Turn LED light off in emv_cancelTransaction().
- Changed SHARED_SYMBOLS to be the same as EXPORT_SYMBOLS.
- Added EXPORT_SYMBOLS to setAbsoluteLibraryPath().  Changed getLibraryPath(), getFunction(), and startAutoPollThread() to fix pointer issues.

## 05/25/2017
- Check for prefix forward slash in absolute library path.
- Update SDK to produce separate libraries

## 05/23/2017
- Initialized the variables to 0.
- Added length check for byte array parameters.
- Added _CMD_DATA_MAX_LEN.
- Changed ReadNGAUsb() and ReadIDGUsb() to check the data size limit.
- Removed device_getDRS().
- Increased the data size of DoNGACMD_str(), DoCMD_str_noback(), and device_setCurrentDevice().
- Changed the comment of device_getDRS().  Removed msr_clearMSRData().
- Added more parameter check for msr_captureMode().
- Added more parameter check for icc_enable() and icc_exchangeAPDU().
- Increased the data size of emv_setTerminalID().  Changed the timeout requirement for emv_startTransaction().
- Added more parameter check for device_controlLED(), device_controlLED_ICC(), and device_controlBeep().
- Added more parameter check for config_setLEDController(), config_setBeeperController(), and config_setEncryptionControl().

## 04/21/2017
- Changed the version to 0.02.018.
- Added the internal functions GetReadTimeoutInterval() and ResetReadTimeoutInterval().
- Changed the comment for ctls_setTerminalData().
- Changed the comments for device_verifyBackdoorKey() and ctls_retrieveTerminalData().
- Added the flag PassThroughModeOn.  Changed DoCMD_str_noback() and DoCMD_str_back_OKdata() to return error code.  Changed device_setCurrentDevice() to check burst mode and auto poll.
- Changed pin_getPIN() to return error when the parameters are invalid.
- Changed threadProc_Read_MSR() to fix the card swipe issue for Spectrum Pro.
- Added the function startAutoPollThread().
- Reset the timout after ctls transaction.  Changed ctls_startTransaction() to return error when passthrough mode is on.  Removed redundant devices for ctls functions.
- Changed the return value of getAIDTags() to handle different errors.

## 04/12/2017
- Added device_verifyBackdoorKey() to libIDT_UniPayI_V.h, and removed device_verifyBackdoorKey() from libIDT_MiniSmartII.h.
- Changed device_verifyBackdoorKey() to support only Augusta TTK for now.

## 04/11/2017
- Changed SDK version to 0.02.017.
- Changed processReceivedData() and processEMVData() to handle the result code EMV_RESULT_CODE_SWIPE_NON_ICC for EMV transaction.

## 04/10/2017
- Changed the SDK version to 0.02.016.

## Removed typedef bool. Made all instances int.
- Removed "false". Made all instances 0.
- Removed "true". Made all instances 1.

## 04/06/2017
- Changed the SDK version to 0.02.015.
- Changed the comments of ctls_startTransaction() and msr_startMSRSwipe().
- Added the error code RETURN_CODE_ERR_CMD_NOT_ALLOWED.
- Changed msr_startMSRSwipe() to return error if auto poll is on.
- Changed emv_startTransaction() to attach the additional tags to the command and check the tags length.  Also changed emv_authenticateTransaction() and emv_completeTransaction() to check the tags length.
- Changed ctls_startTransaction() to return error when auto poll is on (fixed the issue KIOSKSDK-159).
- Changed bool to unsigned char, and removed True and False.

## 04/05/2017
- Changed SDK version to 0.02.014.
- Added the conditional compile flag __MACH__ to be compatible with Mac.
- Switched EMOCOMP and SDKCOMP for some Makefiles.
- Added SetReadTimeoutInterval() for RS232 devices.
- Added device_isAttached() and device_getMerchantRecord() in .h files.

## 04/04/2017
- Implemented functions for RS232 devices.  (Currently only support Spectrum Pro.)
- Added IDG_P2_STATUS_CODE for IDG devices, also added support for BTPay Mini.
- Fixed issues KIOSKSDK-137, KIOSKSDK-138, KIOSKSDK-143, KIOSKSDK-146, KIOSKSDK-147, KIOSKSDK-148, KIOSKSDK-144, KIOSKSDK-151, KIOSKSDK-152, KIOSKSDK-154, KIOSKSDK-150, KIOSKSDK-155, KIOSKSDK-156, KIOSKSDK-158, KIOSKSDK-157, KIOSKSDK-161, KIOSKSDK-162, KIOSKSDK-160, KIOSKSDK-153, and SSPLS-48.

## 03/21/2017
- Fixed emv_completeTransaction() for IDG devices.
- 0.02.013
- Updated Makefiles.
- Changed the comments of emv_startTransaction() and ctls_startTransaction().
- Changed the comment of the first parameter (commError) for emv_completeTransaction().
- Changed emv_completeTransaction() to fix Issue SSPLS-46.  Modified emv_callbackResponseLCD() to support LCD menus for UniPay III.
- Changed the value of the first parameter (commError) for emv_completeTransaction() from 1 to 0 in the demo.

## 03/20/2017
- Changed SDK version to 0.02.012.
- Commented out device_startRKI() to fix Issue SSPLS-47.
- Added mssleep(100) between write and read for DoNGACmdUsb() to fix Issue SSPLS-42.
- Changed emv_completeTransaction() to fix Issue SSPL-46.
- Changed pin_cancelPINEntry(); to r = pin_cancelPINEntry(); in Spectrum Pro demo.
- Added mssleep(100) in controlLED() to fix Issue AGSTSDK-47.

## 03/16/2017
- Changed emv_startTransaction() to check more parameters.  (Fixed Issue SSPLS-43.)
- Added msr_getKeyTypeForICCDUKPT(), msr_getKeyFormatForICCDUKPT(), msr_setKeyFormatForICCDUKPT(), and msr_setKeyTypeForICCDUKPT() to fix issue AGSTSDK-44.
- Removed MSR functions from MiniSmart II.
- Changed icc_setKeyFormatForICCDUKPT() to support TransArmor for Augusta (Issue AGSTSDK-45).
- Added msr_captureMode() to the libIDT_Augusta.h and libIDT_Device.h (Issue AGSTSDK-46).
- Change SDK version to 0.02.011
- Update OpenUSB() to correctly store handle from hidapi library
- Update hid_write() and hid_read_timeout() invocations to pass in the correct hidapi handle
- Update threadProc_Read_EMV() to handle read invocation return value accordingly for Mac platform
- Update emv_authenticateTransaction() and emv_completeTransaction() to add delay for Mac platform
- Update addTLVEntriesToHashMapObj() to cast tagNameArray accessors to unsigned char because of integer promotion
- Update getjByteArrayFromBYTEArray() and getStringFromCharArray() to add data length bound checking
- Add default case to all switch statements in IDTechSDK_IDTechSDKBridge.c

## 03/15/2017
- Changed SDK version to 0.02.010
- Changed DoIDGCmdUsb(), DoCMD_str_back_OKdata(), and device_setCurrentDevice() to fix Issue SSPLS-44.
- Changed emv_startTransaction() to limit tagLen to < 500 bytes (Fixed Issue SSPLS-43).
- Changed the error message for get Configuration Group in Kiosk III Demo.
- Removed old options 16. Set Swipe TDES., 17. Set Swipe AES., and 18. Get Swipe Encryption to fix Issue AGSTSDK-43.

## 03/14/2017
- Changed version to 0.02.009
- Changed DoCMD_data_back_OKdata() to fix the issues AGSTSDK-40 and AGSTSDK-41.
- Changed emv_startTransaction() to check the parameters (to fix the issue SSPLS-43).

## 03/13/2017
- 0.02.008
- Updated Makefiles to include the version number
- Changed IDT_device_hotplug_callback() to remove the log. KIOSKSDK-133

## 0.02.007
- Removed RS-232 for Mac
- Added RS232 library.
- Fixed log issue. KIOSKSDK-133
- Added RS232 devices.
- Changed charmsr_encTrack1Len to msr_encTrack1Len.
- Modified processReceivedData() to fix the issue of data parsing for MSR fallback of EMV transaction.
- Added ctls_removeConfigurationGroup(). KIOSKSDK-135.
- Add Spectrum Pro JNI bridge methods

## 3/8/2017
- 0.02.006
- Added MiniSmart II
- Moved the auto poll thread to IDTech_device.c.  Added some RS232 functions which are still under implementation.
- Modified device_setBurstMode() and device_setPollMode() to create a thread for auto poll (to lower CPU usage).  Also moved threadProc_AutoPoll_Read() to this file.

## 3/7/2017
- Update JNI bridge CAPTURE_ENCRYPT_TYPE switch

## 3/6/2017
- Add Kiosk III JNI bridge methods

## 3/2/2017
- Add Augusta JNI bridge methods

## 3/1/2017
- Added MiniSmart II.

## 2/28/2017
- Added MiniSmart II and defined PID����庖���.
- Fixed emv_startTransaction() for IDG devices.
- Added UniPay 1.5 TTK

## 2/23/2017
- DVT SDK 0.2.005

## 2/22/2017
- Changed isAIDTag().
- Changed bool to int for WIN32.
- Changed _UNIX_PLATFORM_ to __linux.
- 0.02.005.  Updated Shared Exports
- Fixed return data for ctls_retrieveTerminalData().
- 0.02.005.  Update IDG USB
- 0.02.005.  Updated Windows USB Routines.  Fixed startup loop failure
- 0.02.005.  Updated Mac USB Routines
- 0.02.005.  Updated Makefiles.  Updated External References.  Removed DUKPT/MAC routines
- Mac Functions
- New Makefiles

## 2/20/2017
- Fixed emv_retrieveTransactionResult() to parse tlv data for Augusta.

## 2/19/2017
- Mac Updates

## 2/17/2017
- Mac HID Updates

## 2/17/2017
- Changed SDK version to 0.02.004.
- Added parameter check for msr_startMSRSwipe().
- Added parameter check for emv functions, and also fixed the block issue for emv transaction.
- Added parameter check for device_controlLED().
- Added parameter check for ctls_startTransaction().

## 2/14/2017
- Changed parseEMVFormat1() for Augusta.
- Changed threadProc_Read_MSR() for Augusta.

## 2/13/2017
- Fixed compiling warnings for Eclipse under Windows and added fflush()����庖���.
- Added a MSR callback function with a IDTMSRData pointer.
- Added UniPay III.
- Added UniPay I_V.
- Added an NGA MSR parse function.
- Added void (*pMSR_callBackp)(int, IDTMSRData *).

## 2/2/2017
- Changed functions for contactless devices to have mssleep(150) before sending the command.  Also changed the error code for IDG Protocol 2 devices.

## 1/27/2017
- Merged to local copy which supports VP4880 and firmware update for Augusta and Kiosk III.
- Added MSR Transaction flags.

## 1/24/2017
- added LoadLibrary for Windowws

## 1/18/2017
- Mac Support

## 1/17/2017
- minGW Eclipse Update

## 1/5/2017
- Changed device_SendDataCommand().
- Added convertDoubleToBytes().
- Added IDG functions.
- Changed Start CTLS Swipe command to 0x0240.
- Added VP4880.

## 12/21/2016
- Eclipse Windows Build
- Modified libpos_open_device() to be working for Windows and Linux.
- Removed prototype of parseMSRData().

## 12/20/2016
- Added the flag to with between Windows and Linux.

## 12/16/2016
- Added support for Augusta S and Augusta S TTK.

## 12/15/2016
- Add Eclipse Project
- Restore Makefile
- Implemented config_getSerialNumber() for Augusta.
- Modified the comments.
- KioskIII, Augusta, SpectrumPro Support
- Modified the comment for ctls_cancelTransaction().

## 12/13/2016
- SDK: Remove the unnecessary log

## 12/12/2016
- Added read and write functions for Augusta KB for testing.
- Added ITP functions for Augusta KB for testing.
- Changed msr_switchUSBInterfaceMode().
- Changed the switch in get firmware version and controlLED_ICC for Augusta KB.

## 11/30/2016
- Fixed a bug for processReceivedData().
- Added timeout for threadProc_Read_EMV(), and LED control for Augusta EMV transaction.

## 11/28/2016
- Modified processReceivedData() for Augusta.
- Implemented EMV functions for Augusta.

## 11/23/2016
- SDK: Augusta SRED: 1. Add the MAC function for setWhiteList. 2. fixed the crash issue when do the MAC function 3. add the error when get MAC KSN failed.
- Modified threadProc_Read_EMV() to support Augusta.
- SDK: Augusta SRED: add the MAC supported for setWhiteList

## 11/22/2016
- Fixed emv_retrieveTerminalID().
- SDK: Augusta: EMV: added the CAPK and CRL functions, and fixed the return ACK code

## 11/21/2016
- 1. using DoCMD_str_noback instead of DoNGACMD_str
- 2. fixed the setterminaldata and emv_removeTerminalData and emv_setApplicationData
- 3. remove the unnecessary comments
- Implemented AID and Terminal functions for EMV.

## 11/18/2016
- Implemented part of EMV functions.

## 11/17/2016
- Changed threadProc_Read_MSR() to parse the MSR data for Augusta.
- SDK: ICC: Added the APIs same with windows SDK for Augusta.
- SDK: Device: rollback the changing of Chihlung
- SDK: MSR: fixed the read buffer mode for Augusta.

## 11/16/2016
- Implementing msr_getMSRData().
- Implemented ICC functions.
- Added the place holder for device_getKeyStatus().
- SDK: Augusta: MSR: Added the MSR APIs for Augusta as follows detailed:
- msr_captureMode
- msr_disable
- msr_getClearPANID
- msr_getExpirationMask
- msr_getFunctionStatus
- msr_getSetting
- msr_getSwipeEncryption
- msr_getSwipeForcedEncryptionOption
- msr_getSwipeMaskOption
- msr_RetrieveWhiteList
- msr_setClearPANID
- msr_setExpirationMask
- msr_setSetting
- msr_setSwipeEncryption
- msr_setSwipeForcedEncryptionOption
- msr_setSwipeMaskOption
- msr_setWhiteList
- msr_switchUSBInterfaceMode

## SDK: Remove unnecessary val

## 11/15/2016
- SDK: Augusta(S/TTK): add the API into the device module.
- SDK: Augusta: Add the config function

## 11/14/2016
- SDK: To support Augusta / Augusta S

## 11/9/2016
- SDK: removed the unnecessary log, especial for Card data output print log;
- Changed the unnecessary log

## 11/8/2016
- 1. removed the device_getDeviceTypeIndex and device_disconnected which looks seems the API, actually they all internal function.
- 2. added the hotplug_usb_connected and hotplug_usb_disconnected

## changed device_init() to fix hot plug issue.
- HOT-PLUG Debug

## 11/7/2016
- fixed the crash issue after reboot device
- remove unnecessary function in icc model.
- Removed printf("s_husb [%X]\n", s_husb);
- Added cardData->encryptedTagCount = 0;, cardData->maskedTagCount = 0; and cardData->unencryptedTagCount = 0; to resetMSRData.

## 11/3/2016
- Added ReadDataUsb() to read ctls data.
- Modified threadProc_AutoPoll_Read() to handle ctls data.
- Added mssleep(150) for each Kiosk III command.
- Added processCTLSData() to parse the ctls data.
- Added ctlsApplicationand isCTLS.
- Added getApplicationType().

## 11/2/2016
- removed printf().
- Implemented threadAutoPoll and the checking for Auto Poll mode for Kiosk III.
- Implemented the checking for Auto Poll mode for Kiosk III.
- Modify the SDK Version and Add the changing history
- fixed the SDK issue to build succeeded

## 11/1/2016
- fixed the API ctls_getAllConfigurationGroups to add the parameters
- add the device_getIDGStatusCodeString for the device with NEO/IDG protocol
- Double check the API description and add the API in the head file
- Added printAIDs().
- Changed retrieveAIDTags() and added printAIDs().
- Fix the device_XXX and ctls_XXX API command set

## 10/31/2016
- Changed retrieveAIDTags().
- Changed TLV_GetTag().
- Changed resData to resLen.
- Changed the command for ctls_retrieveApplicationData().
- Added retrieveAIDTags().
- Fixed the ctls_setApplication

## 10/28/2016
- Added getHashSha256().
- Implemented missing functions.
- API Adjustment:
- 1. ICC: changing the API such as icc_passthroughon / off to device_XXX
- 2. ctls: changing the emv_XXX to ctls_XXX for set/get AID and CAPK
- 3. Device: add some device_XXX API according windows SDK

## 10/27/2016
- Remove the lock and check startCTLSTransaction and cancelCTLSTransaction to enable cancel transaction.
- Remove the lock to enable cancel transaction.
- Added support for Kiosk III S.
- Added cancelCTLSTransaction, and startCTLSTransaction to check CTLS transaction status.
- Added MSR_callBack_type_TERMINATED.
- HOT-PLUG: add the hot-plug feature supported.
- Detailed:
- 1. first open current connected(attached device), and then register the usb hot-plug callback.
- (Limitation: if we don't open current device, the hot-plug cannot detect what has been connected device so that skipped these connected devices)
- 2. when received the hot-plug message, SDK will change the device status with connected/disconnected.
- 3. when received the device plugged in message, SDK will open the new coming device.

## 10/26/2016
- Modified read functions.
- Added DoIDGCmdUsb() and modified read and write functions.
- Implemented ctls parse functions.
- Comment out getEncryptedTrackDataLength() and getCardType().
- Changed ReadUsb() to ReadNGAUsb().
- Changed DoCmdUsb() to DoNGACmdUsb().

## 10/26/2016
- Implemented ctls_startTransaction() and the callback function.
- Added IDTTag.

## 10/25/2016
- add the API: bool device_isAttached(int deviceType)

## 10/24/2016
- rollback, skip add the hot-plug

## 10/21/2016
- add the hot-plug

## 10/20/2016
- Modified device_close() and device_isConnected().
- Added support for more devices.
- Added ctls functions.
- Fixed grsiP2Command().

## 1/19/2016
- Modified device_SendDataCommand().
- Modified device_init().
- Changed IDT_DEVICE_AUGUSTA to IDT_DEVICE_AUGUSTA_HID.
- Updated device_SendDataCommand().
- Modified device_getFirmwareVersion() and device_SendDataCommand().
