#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "demo_common.h"

IDT_COMMON_PROCESS COMMON;
extern IDT_PROCESS idtech_process;
extern IDT_DEMO_LIB_DISPLAY_MENU idtech_display_menu_from_lib;

void
_Vendi_display_msr_menu();

void
_Vendi_process_msr() {
    int choice;
    BYTE resData[_DATA_BUF_LEN];
    int resLen;
    int r;

    do {
        _Vendi_display_msr_menu();
        choice = COMMON.inputSelection();
        switch (choice) {
            case 1:
                printf(">>1. Start MSR\n");
                fflush(stdout);
                r = msr_startMSRSwipe(30);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Start MSR Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("MSR Start MSR Swipe Succeeded\n");
                    printf("Please Swipe Card...\n");
                }
                fflush(stdout);
                break;
            case 2:
                printf(">>2. Cancel MSR\n");
                fflush(stdout);
                r = msr_cancelMSRSwipe();
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Cancel MSR Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("MSR Cancel MSR Swipe Succeeded\n");
                }
                fflush(stdout);
                break;
            //		case 3:
            //			printf(">>3. Clear Card Data\n");
            //			r = msr_clearMSRData();
            //			if ( r != RETURN_CODE_DO_SUCCESS ) {
            //				printf("  Do msr_clearMSRData(), failed!\n");
            //			}
            //			else{
            //				printf("MSR Clear MSR Data Succeeded\n");
            //			}
            //		break;
            //
            //		case 4:
            //			printf(">>4. Get Card Data\n");
            //			resLen = _DATA_BUF_LEN;
            //			memset(resData, 0, resLen);
            //			r = msr_getMSRData(resData, &resLen);
            //			if ( r != RETURN_CODE_DO_SUCCESS ) {
            //				printf("  Do msr_getMSRData(), failed!\n");
            //			}
            //			else{
            //				printf("Get MSR Data: Succeeded\n");
            //				IDTMSRData msrData1;
            //				resetMSRData(&msrData1);
            //				parseMSRData(resData, resLen, &msrData1);
            //				COMMON.printMSRData(&msrData1);
            //			}
            //		break;
            case 0:
                if (isMSRBusy) {
                    printf("MSR Busy\n");
                    choice = -1;
                } else {
                    printf(">>0. Back To Main Menu\n");
                }
                fflush(stdout);
                break;
        }
    } while (choice != 0);
    if (choice == 0) {
//        idtech_process.pProcess_function_list();
        return;
    }
} /* _Vendi_process_msr */

void
_Vendi_display_msr_menu() {
    idtech_display_menu_from_lib.pDisplay_Menu_current = _Vendi_display_msr_menu;
    printf("\t\t************* MSR Options [Vendi]***************\n");
    printf("\t\t0. Back To Main Menu\n");
    printf("\t\t1. Start MSR\n");
    printf("\t\t2. Cancel MSR\n");
    // printf("\t\t3. Clear Card Data\n");
    // printf("\t\t4. Get Card Data\n");
    printf("\t\t************************************************\n");
    fflush(stdout);
}
