#include <stdio.h>
#include <string.h>
#include "demo_common.h"

extern IDT_COMMON_PROCESS COMMON;
extern IDT_PROCESS idtech_process;
extern IDT_DEMO_LIB_DISPLAY_MENU idtech_display_menu_from_lib;

void
_Vendi_display_device_menu();

void
_Vendi_process_device() {
    int choice;
    int r = 0;
    char str1[256] = { 0 };
    int len        = 512;

    memset(str1, 0, 256);
    do {
        _Vendi_display_device_menu();
        choice = COMMON.inputSelection();
        switch (choice) {
            case 1: {
                printf(">>1. Get Firmware Version\n");
                fflush(stdout);
                r = device_getFirmwareVersion(str1);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Get Firmware Version Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    char str2[200] = { 0 };
                    sprintf(str2, "Firmware version: %s\n", str1);
                    printf(str2);
                }
                fflush(stdout);
            }
            break;
            case 2: {
                printf(">>2. Send Command: 0x29, 0x00\n");
                fflush(stdout);
                BYTE rbbyte[512] = { 0 };
                memset(rbbyte, 0, 512);
                len = 512;
                r = device_SendDataCommandNEO(0x29, 0x00, NULL, 0, rbbyte, &len);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Do device_SendDataCommand(), failed! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                        strErr);
                } else {
                    char str3[1024] = { 0 };
                    memset(str3, 0, 1024);
                    COMMON.convertBytesIntoHexStr(rbbyte, len, 0, str3);
                    printf("response code : %s\n", str3);
                }
                fflush(stdout);
            }
            break;
            case 3: {
                printf(">>3. Get Serial Number\n");
                fflush(stdout);
                r = config_getSerialNumber(str1);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Get Serial Number Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    char str2[200] = { 0 };
                    sprintf(str2, "Serial Number: %s\n", str1);
                    printf(str2);
                }
                fflush(stdout);
            }
            break;
            case 4: {
                printf(">>4. Ping Device\n");
                fflush(stdout);
                r = device_pingDevice();
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Ping Device Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Ping Device Succeeded\n");
                }
                fflush(stdout);
            }
            break;
            case 5:
                printf(">>5. Interface Control\n");
                fflush(stdout);
                BYTE values[4] = { 0xFF, 0x04, 0xFF, 0x01 };
                r = device_controlUserInterface(values);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Interface Control Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Interface Control Succeeded\n");
                }
                fflush(stdout);
                break;
            case 6:
                printf(">>6. Pass Through On\n");
                fflush(stdout);
                r = device_enablePassThrough(1);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Pass Through On Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Pass Through On Succeeded\n");
                }
                fflush(stdout);
                break;
            case 7:
                printf(">>7. Pass Through Off\n");
                fflush(stdout);
                r = device_enablePassThrough(0);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Pass Through Off Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Pass Through Off Succeeded\n");
                }
                fflush(stdout);
                break;
            case 8:
                printf(">>8. Set Burst On\n");
                fflush(stdout);
                r = device_setBurstMode(1);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Set Burst On Failed! ErrorCode:0x%02x, Info: %s ----- \n",
                        r, strErr);
                } else {
                    printf("Set Burst On Succeeded\n");
                }
                fflush(stdout);
                break;
            case 9:
                printf(">>9. Set Burst Off\n");
                fflush(stdout);
                r = device_setBurstMode(0);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Set Burst Off Failed! ErrorCode:0x%02x, Info: %s ----- \n",
                        r, strErr);
                } else {
                    printf("Set Burst Off Succeeded\n");
                }
                fflush(stdout);
                break;

            case 10:
                printf(">>10. Set Auto Poll On\n");
                fflush(stdout);
                r = device_setPollMode(0);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Set Auto Poll On Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Set Auto Poll On Succeeded\n");
                }
                fflush(stdout);
                break;
            case 11:
                printf(">>11. Poll On Demand\n");
                fflush(stdout);
                r = device_setPollMode(1);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Poll On Demand Failed! ErrorCode:0x%02x, Info: %s ----- \n",
                        r, strErr);
                } else {
                    printf("Set Poll On Demand Succeeded\n");
                }
                fflush(stdout);
                break;
            case 12:
                printf(">>12. Set Merchant Record\n");
                fflush(stdout);
                r = device_setMerchantRecord(1, 1, "pass.com.firstdata.money2020", null);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Set Merchant Record Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Set Merchant Record Succeeded\n");
                }
                fflush(stdout);
                break;
            case 13:
                printf(">>13. Get Merchant Record\n");
                fflush(stdout);
                BYTE record[0x63];
                memset(record, 0, 0x63);
                r = device_getMerchantRecord(1, record);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Get Merchant Record Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Get Merchant Record Succeeded\n");
                    int i;
                    printf("Record:\n");
                    for (i = 0; i < 0x63; i++) {
                        printf("%02X", record[i]);
                    }
                    printf("\n");
                }
                fflush(stdout);
                break;
            case 0:
                printf(">>0.Back To Main Menu\n");
                fflush(stdout);
                break;
        }
    } while (choice != 0);
    if (choice == 0) {
//        idtech_process.pProcess_function_list();
        return;
    }
} /* _Vendi_process_device */

void
_Vendi_display_device_menu() {
    idtech_display_menu_from_lib.pDisplay_Menu_current = _Vendi_display_device_menu;
    printf("\t\t************ Device Options [Vendi]*************\n");
    printf("\t\t0.  Back To Main Menu\n");
    printf("\t\t1.  Get Firmware Version\n");
    printf("\t\t2.  Send Data Command\n");
    printf("\t\t3.  Get Serial Number\n");
    printf("\t\t4.  Ping Device\n");
    printf("\t\t5.  Interface Control\n");
    printf("\t\t6.  Enable Passthrough\n");
    printf("\t\t7.  Disable Passthrough\n");
    printf("\t\t8.  Burst Mode ON\n");
    printf("\t\t9.  Burst Mode OFF\n");
    printf("\t\t10. Auto Poll\n");
    printf("\t\t11. Poll On Demand\n");
    printf("\t\t12. Set Merchant Record\n");
    printf("\t\t13. Get Merchant Record\n");
    printf("\t\t************************************************\n");
    fflush(stdout);
}
