/*
 * demo_common.c
 *
 *  Created on: Aug 10, 2017
 *      Author: idt
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "demo_common.h"
#include "IDTDef.h"

#define _BUF_LEN 4096
char Data[_CMD_BUF_LEN * 2] = { 0 };

int
convertHStrIntoHex(const char * srcStr, unsigned char * hexData, int * datalen)
{
    if (NULL == srcStr) {
        return RETURN_CODE_ERR_INVALID_PARAMETER;
    }
    if (NULL == hexData) {
        return RETURN_CODE_ERR_INVALID_PARAMETER;
    }
    char src[_BUF_LEN * 2];
    memset(src, 0, _BUF_LEN * 2);
    int lenT = strlen(srcStr);

    int k = 0;
    int i = 0;
    for (i = 0; i < lenT; i++) {
        if ((' ' == srcStr[i]) || (',' == srcStr[i]) || ('\n' == srcStr[i]) || ('\r' == srcStr[i])) {
            continue;
        }
        src[k++] = srcStr[i];
        // printf("(%c)",srcStr[i]);
    }
    src[k] = 0;
    // printf("\n");

    int realLen = k;
    if (0 != (k % 2)) {
        return RETURN_CODE_ERR_INVALID_PARAMETER;
    }
    int len = realLen / 2;
    if (len > *datalen) {
        return RETURN_CODE_ERR_INVALID_PARAMETER;
    }
    *datalen = len;

    // printf("--%d--",len);
    char * asc_string = (char *) malloc(len * 2 + 1);
    strcpy(asc_string, src);
    char c = 0x00;
    for (i = 0; i < len * 2; i++) {
        c = asc_string[i];
        if ((c >= 0x30) && (c <= 0x39))
            asc_string[i] -= 0x30;
        else if ((c >= 0x41) && (c <= 0x46))
            asc_string[i] -= 0x37;
        else
            asc_string[i] -= 0x57;
    }
    int m = 0;
    for (m = 0; m < len; m++) {
        hexData[m] = 16 * asc_string[2 * m] + asc_string[2 * m + 1];
        // printf("%02X ",hex_string[m]);
    }
    // printf("\n");
    free(asc_string);
    return RETURN_CODE_DO_SUCCESS;
} /* convertHStrIntoHex */

int
convertBytesIntoHexStr(unsigned char * hexData, int datalen, int withChar_LineFeed, char * str)
{
    int i   = 0;
    int end = 0;

    for (i = 0; i < datalen; i++) {
        sprintf(str, "%s%02X ", str, hexData[i]);
        end += 3;

        if (1 == withChar_LineFeed) {
            if (0 == ((i + 1) % 16)) {
                sprintf(str, "%s\n", str);
                end += 1;
            }
        }
    }
    str[end] = 0;
    return RETURN_CODE_DO_SUCCESS;
}

void
getTLVString(unsigned char * data, int len, char * TLVs)
{
    int m             = 0;
    int pos           = 0;
    int length        = 0;
    int lengthCounter = 0;

    BYTE tempTLVs[_CMD_BUF_LEN * 2] = { 0 };

    strcpy(TLVs, "");

    for (m = 0; m < len; m++) {
        if (pos == 0) {
            if ((data[m] & 0x1F) == 0x1f) {
                if ((data[m + 1] & 0x80) == 0x80 && (data[m] != 0xFF || !isAIDTag(data[m + 1]))) {
                    sprintf(tempTLVs, "%02X%02X%02X: ", data[m], data[m + 1], data[m + 2]);

                    strcat(TLVs, tempTLVs);
                    memset(tempTLVs, 0, _CMD_BUF_LEN);

                    pos = pos + 3;
                } else   {
                    sprintf(tempTLVs, "%02X%02X:   ", data[m], data[m + 1]);

                    strcat(TLVs, tempTLVs);
                    memset(tempTLVs, 0, _CMD_BUF_LEN);

                    pos = pos + 2;
                }
            } else   {
                sprintf(tempTLVs, "%02X:     ", data[m]);

                strcat(TLVs, tempTLVs);
                memset(tempTLVs, 0, _CMD_BUF_LEN);

                pos = pos + 1;
            }

            if ((data[m + pos] & 0x80) != 0x80) {
                length = data[m + pos];
                // printf(" <1len:%d> ",length);
                if (length > 0) {
                    pos = pos + 1;
                }
                // printf(" <1len1:%d> ",pos);
                m = m + pos;
                // printf(" <1len2:%d> ",m);
            } else if (data[m + pos] == 0x81)     {
                length = data[m + pos + 1];
                // printf(" <2len:%d> ",length);
                pos = pos + 2;
                m   = m + pos;
            } else   {
                length = ((data[m + pos + 1] * 0x100) + data[m + pos + 2]);
                // printf(" <3len:%d> ",length);
                pos = pos + 3;
                m   = m + pos;
            }
        }
        if (length == 0) {
            // printf(" <4len:%d> ",length);
            pos = 0;
            lengthCounter = 0;
            strcat(TLVs, "\n");
        } else   {
            sprintf(tempTLVs, "%02X", data[m]);

            strcat(TLVs, tempTLVs);
            memset(tempTLVs, 0, _CMD_BUF_LEN);

            lengthCounter++;
            // printf(" <5len:%d> ",lengthCounter);
            if (lengthCounter == length) {
                // printf(" <6len:%d> ",length);
                pos = 0;
                lengthCounter = 0;
                strcat(TLVs, "\n");
            }
        }
    }
    strcat(TLVs, "\n");
} /* getTLVString */

char *
trim(char * str)
{
    char * end;

    // Trim leading spaces
    while (isspace((unsigned char) *str)) str++;

    // Trim trailing spaces
    end = str + strlen(str) - 1;
    while (end > str && isspace((unsigned char) *end)) end--;

    // New null terminator position
    *(end + 1) = 0;

    return str;
}

char *
getData(BYTE * resData, int resLen, int isASCII)
{
    memset(Data, 0, _CMD_BUF_LEN * 2);

    if (resLen <= 0) {
        return Data;
    } else {
        int i;
        for (i = 0; i < resLen; i++) {
            if (isASCII)
                sprintf(Data, "%s%c", Data, resData[i]);
            else
                sprintf(Data, "%s%02X ", Data, resData[i]);
        }
        strcat(Data, "\n");
    }

    return Data;
}
