#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "demo_common.h"

IDT_COMMON_PROCESS COMMON;
extern IDT_PROCESS idtech_process;
extern IDT_DEMO_LIB_DISPLAY_MENU idtech_display_menu_from_lib;

void
_VP8800_display_ws_menu();

void
_VP8800_process_ws() {
    int choice;
    BYTE status;
    int r = 0;
    BYTE ATR[_DATA_BUF_LEN];
    int ATRLen;
    BYTE resData[_DATA_BUF_LEN];
    int resLen;

    do {
        _VP8800_display_ws_menu();
        choice = COMMON.inputSelection();
        switch (choice) {
            case 1: {
                printf(">>1. Request CSR\n");
                fflush(stdout);
                RequestCSR csr;
                memset(&csr, 0, sizeof(RequestCSR));
                r = ws_requestCSR(&csr);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Request CSR Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Request CSR Succeeded\n");
                    printf("CSR Encrypting Keys: %s\n", csr.encKeysName);
                    printf("%s\n\n", csr.encKeysCSR);
                    printf("CSR Validating/Signing Keys: %s\n", csr.encSigningName);
                    printf("%s\n\n", csr.encSigningCSR);
                    printf("CSR Validating/Signing 3rd Party Apps: %s\n", csr.encAppsName);
                    printf("%s\n\n", csr.encAppsCSR);
                }
                fflush(stdout);
            }
            break;
            case 2:
                printf(">>2. Load Certificate\n");
                fflush(stdout);
                r = ws_loadSSLCert("1.00", 4, "1.00", 4);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Load Certificate Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Load Certificate Mode Succeeded\n");
                }
                fflush(stdout);
                break;
            case 3:
                printf(">>3. Revoke Certificate\n");
                fflush(stdout);
                r = ws_revokeSSLCert("123", 3);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Revoke Certificate Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Revoke Certificate Succeeded\n");
                }
                fflush(stdout);
                break;
            case 4: {
                printf(">>4. Delete Certificate\n");
                fflush(stdout);
                r = ws_deleteSSLCert("123", 3);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf("  Delete Certificate failed! ErrorCode:0x%02x ,Info: %s ----- \n", r, strErr);
                } else {
                    printf("Delete Certificate Succeeded\n");
                }
                fflush(stdout);
            }
            break;
            case 5: {
                printf(">>5. Get Cert Chain Status\n");
                fflush(stdout);
                int type;
                r = ws_getCertChainType(&type);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Get Cert Chain Status failed!! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                        strErr);
                    fflush(stdout);
                    break;
                } else {
                    printf("Get Cert Chain Status Succeeded\n");
                    if (type == 1) {
                        printf("Cert Chain Type: Production\n");
                    } else {
                        printf("Cert Chain Type: Test\n");
                    }
                }
                fflush(stdout);
            }
            break;
            case 6: {
                printf(">>6. Update Roor Cert\n");
                fflush(stdout);
                r = ws_updateRootCertificate("1.00", 4, "1.00", 4, "1.00", 4);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Update Roor Cert failed!! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                        strErr);
                    fflush(stdout);
                    break;
                } else {
                    printf("Update Roor Cert Succeeded\n");
                }
                fflush(stdout);
            }
            break;
            case 0:
                printf(">>0.Back To Main Menu\n");
                fflush(stdout);
                break;
        }
    } while (choice != 0);
    // #ifdef WIN32
    if (choice == 0) {
//        idtech_process.pProcess_function_list();
        return;
    }
    // #endif
} /* _VP8800_process_ws */

void
_VP8800_display_ws_menu() {
    idtech_display_menu_from_lib.pDisplay_Menu_current = _VP8800_display_ws_menu;
    printf("\t\t*********** WS Options [VP8800]************\n");
    printf("\t\t0.  Back To Main Menu\n");
    printf("\t\t1.  Request CSR\n");
    printf("\t\t2.  Load Certificate\n");
    printf("\t\t3.  Revoke Certificate\n");
    printf("\t\t4.  Delete Certificate\n");
    printf("\t\t5.  Get Cert Chain Status\n");
    printf("\t\t6.  Update Roor Cert\n");
    printf("\t\t************************************************\n");
    fflush(stdout);
}
