#include <stdio.h>
#include <string.h>
#include "demo_common.h"

IDT_COMMON_PROCESS COMMON;
EXPORT_SYMBOLS IDT_PROCESS idtech_process;
EXPORT_SYMBOLS IDT_DEMO_LIB_DISPLAY_MENU idtech_display_menu_from_lib;

void
_VP8800_display_pin_menu();

void
_VP8800_process_pin() {
    int choice;
    int r = 0;
    char str1[256] = { 0 };

    memset(str1, 0, 256);
    BYTE retData[4];
    int retDataLen = 4;
    pin_registerCallBk(COMMON.PIN_callBack);
    do {
        _VP8800_display_pin_menu();
        choice = COMMON.inputSelection();
        switch (choice) {
            case 1:
                printf(">>1. Get Encrypted PIN\n");
                fflush(stdout);
                r = pin_getEncryptedOnlinePIN(0, 20);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Get Encrypted PIN failed!! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                        strErr);
                    fflush(stdout);
                    break;
                } else {
                    printf("Get Encrypted PIN Succeeded\n");
                    //				printf("PIN Block: ");
                    //				int i;
                    //				for (i=0;i<16;i++)
                    //					printf("%c", );
                }
                fflush(stdout);
                break;
            case 2:
                printf(">>2. Get PAN\n");
                fflush(stdout);
                r = pin_getPAN(1, 120);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getResponseCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Get PAN Failed! ErrorCode: 0x%02x, Info: %s ----- \n",
                        r,
                        strErr);
                } else {
                    printf("Get PAN Succeeded\n");
                }
                fflush(stdout);
                break;
            case 3:
                printf(">>3. Prompt Debit/Credit\n");
                fflush(stdout);
                r = pin_promptCreditDebit("$", 1, "1.00", 4, 20, retData, &retDataLen);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getResponseCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Prompt Debit/Credit Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Prompt Debit/Credit Succeeded\n");
                }
                fflush(stdout);
                break;
            case 0:
                if (isPINBusy) {
                    printf("PIN Busy\n");
                    choice = -1;
                } else {
                    printf(">>0. Back To Main Menu\n");
                }
                fflush(stdout);
                break;
        }
    } while (choice != 0);
    // #ifdef WIN32
    if (choice == 0) {
//        idtech_process.pProcess_function_list();
        return;
    }
    // #endif
} /* _VP8800_process_pin */

void
_VP8800_display_pin_menu() {
    idtech_display_menu_from_lib.pDisplay_Menu_current = _VP8800_display_pin_menu;
    printf("\t\t********* Pin Options [VP8800]**********\n");
    printf("\t\t0. Back To Main Menu\n");
    printf("\t\t1. Get Encrypted PIN\n");
    printf("\t\t2. Get PAN\n");
    printf("\t\t3. Prompt Debit/Credit\n");
    printf("\t\t************************************************\n");
    fflush(stdout);
}
