#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "demo_common.h"

IDT_COMMON_PROCESS COMMON;
extern IDT_PROCESS idtech_process;
extern IDT_DEMO_LIB_DISPLAY_MENU idtech_display_menu_from_lib;

void
_VP8800_display_lcd_menu();

void
_VP8800_process_lcd() {
    int choice;
    BYTE status;
    int r = 0;
    BYTE ATR[_DATA_BUF_LEN];
    int ATRLen;
    BYTE resData[_DATA_BUF_LEN];
    int resLen;

    do {
        _VP8800_display_lcd_menu();
        choice = COMMON.inputSelection();
        switch (choice) {
            case 1:
                printf(">>1. Reset Initial State\n");
                fflush(stdout);
                r = lcd_resetInitialState();
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Reset Initial State Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Reset Initial State Succeeded\n");
                }
                fflush(stdout);
                break;
            case 2:
                printf(">>2. Start Custom Display Mode\n");
                fflush(stdout);
                r = lcd_customDisplayMode(1);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Start Custom Display Mode Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Start Custom Display Mode Succeeded\n");
                }
                fflush(stdout);
                break;
            case 3:
                printf(">>3. Stop Custom Display Mode\n");
                fflush(stdout);
                r = lcd_customDisplayMode(0);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Stop Custom Display Mode Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Stop Custom Display Mode Succeeded\n");
                }
                fflush(stdout);
                break;
            case 4: {
                printf(">>4. Set Colors\n");
                fflush(stdout);
                BYTE foreRGB[] = { 0xFF, 0xFF, 0xFF };
                BYTE backRGB[] = { 0x00, 0x00, 0x00 };
                r = lcd_setForeBackColor(foreRGB, 3, backRGB, 3);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf("  Set Colors failed! ErrorCode:0x%02x ,Info: %s ----- \n", r, strErr);
                } else {
                    printf("Set Colors Succeeded\n");
                }
                fflush(stdout);
            }
            break;
            case 5: {
                printf(">>5. Clear Display\n");
                fflush(stdout);
                r = lcd_clearDisplay();
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Clear Display failed!! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                        strErr);
                    fflush(stdout);
                    break;
                } else {
                    printf("Clear Display Succeeded\n");
                }
                fflush(stdout);
            }
            break;
            case 6: {
                printf(">>6. Capture Signature\n");
                fflush(stdout);
                r = lcd_captureSignature(60);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Capture Signature failed!! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                        strErr);
                    fflush(stdout);
                    break;
                } else {
                    printf("Capture Signature Succeeded\n");
                }
                fflush(stdout);
            }
            break;
            case 7: {
                printf(">>7. Start Slideshow\n");
                fflush(stdout);
                printf("Please enter the folder which contains the images to display:\n");
                fflush(stdout);
                char folderName[50];
                fgets(folderName, 50, stdin);
                if (folderName[0] == '\n' || folderName[0] == '\r') {
                    break;
                }
                int i;
                for (i = 0; i < 49; i++) {
                    if (folderName[i] == '\n' || folderName[i] == '\r') {
                        if (folderName[i - 1] == '/') {
                            folderName[i] = '\0';
                        } else {
                            folderName[i]     = '/';
                            folderName[i + 1] = '\0';
                        }
                        break;
                    }
                }
                lcd_customDisplayMode(0);
                lcd_customDisplayMode(1);
                r = lcd_startSlideShow(folderName, strlen(folderName), 0, 0, 2, 1, 0, 1, 3, 0, 1);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Start Slideshow failed!! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                        strErr);
                    fflush(stdout);
                    break;
                } else {
                    printf("Start Slideshow Succeeded\n");
                }
                fflush(stdout);
            }
            break;
            case 8: {
                printf(">>8. Start Default Slideshow\n");
                fflush(stdout);

                char directory[_DATA_BUF_LEN];
                int directoryLen = _DATA_BUF_LEN;
                r = device_listDirectory(NULL, 0, 1, 0, directory, &directoryLen);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- List Directory Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                    fflush(stdout);
                    break;
                }

                if (NULL == strstr(directory, "DefaultSlideShow/")) {
                    // create folder
                    device_createDirectory("DefaultSlideShow", 16);
                    // transfer files
                    int i;
                    int failed = 0;
                    for (i = 1; i <= 8; i++) {
                        char out_filename[50];
                        sprintf(out_filename, "DefaultSlideShow/img%d.png", i);
                        char in_filename[50];
                        sprintf(in_filename, "../Resources/%3d.png", i);
                        BYTE fileData[166000];
                        int fileDataLen;
                        FILE * fp;
                        if (NULL == (fp = fopen(in_filename, "rb"))) {
                            printf("Could not open file %s\n", in_filename);
                            fflush(stdout);
                            failed = 1;
                            break;
                        }
                        fseek(fp, 0, SEEK_END);
                        fileDataLen = ftell(fp);
                        if (fileDataLen > 166000) {
                            printf("Not enough buffer\n");
                            fflush(stdout);
                            failed = 1;
                            break;
                        }

                        fseek(fp, 0, SEEK_SET);
                        fread(fileData, fileDataLen, 1, fp);
                        fclose(fp);

                        r = device_transferFile(out_filename, strlen(out_filename), fileData, fileDataLen);
                        if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                            char strErr[200] = { 0 };
                            memset(strErr, 0, 200);
                            device_getIDGStatusCodeString(r, strErr);
                            printf(
                                ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Transfer File Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                                strErr);
                            fflush(stdout);
                            failed = 1;
                            break;
                        }
                    }
                    if (failed == 1) {
                        break;
                    }
                } else {
                    int i;
                    int failed = 0;
                    for (i = 1; i <= 8; i++) {
                        char out_filename[50];
                        sprintf(out_filename, "DefaultSlideShow/img%d.png", i);
                        char in_filename[50];
                        sprintf(in_filename, "../Resources/%3d.png", i);
                        if (NULL == strstr(directory, out_filename)) {
                            //						device_createDirectory("DefaultBackground");
                            // Read in the file
                            BYTE fileData[166000];
                            int fileDataLen;
                            FILE * fp;
                            if (NULL == (fp = fopen(in_filename, "rb"))) {
                                printf("Could not open file %s\n", in_filename);
                                fflush(stdout);
                                failed = 1;
                                break;
                            }

                            fseek(fp, 0, SEEK_END);
                            fileDataLen = ftell(fp);
                            if (fileDataLen > 35000) {
                                printf("Not enough buffer\n");
                                fflush(stdout);
                                failed = 1;
                                break;
                            }
                            fseek(fp, 0, SEEK_SET);
                            fread(fileData, fileDataLen, 1, fp);
                            fclose(fp);
                            r = device_transferFile(out_filename, strlen(out_filename), fileData, fileDataLen);
                            if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                                char strErr[200] = { 0 };
                                memset(strErr, 0, 200);
                                device_getIDGStatusCodeString(r, strErr);
                                printf(
                                    ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Transfer File Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                                    strErr);
                                fflush(stdout);
                                failed = 1;
                                break;
                            }
                        }
                    }
                    if (failed == 1) {
                        break;
                    }
                }
                lcd_customDisplayMode(0);
                lcd_customDisplayMode(1);
                r = lcd_startSlideShow("DefaultSlideShow", strlen("DefaultSlideShow"), 0, 0, 2, 1, 0, 1, 3, 0, 1);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Start Default Slideshow failed!! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                        strErr);
                    fflush(stdout);
                    break;
                } else {
                    printf("Start Default Slideshow Succeeded\n");
                }
                fflush(stdout);
            }
            break;
            case 9: {
                printf(">>9. Display Image\n");
                fflush(stdout);
                printf("Please enter the image name to display:\n");
                fflush(stdout);
                char imageName[50];
                fgets(imageName, 50, stdin);
                if (imageName[0] == '\n' || imageName[0] == '\r') {
                    break;
                }
                int i;
                for (i = 0; i < 50; i++) {
                    if (imageName[i] == '\n' || imageName[i] == '\r') {
                        imageName[i] = '\0';
                        break;
                    }
                }
                r = lcd_customDisplayMode(0);
                r = lcd_customDisplayMode(1);
                r = lcd_setDisplayImage(imageName, strlen(imageName), 0, 0, 2, 0, 1);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Display Image failed!! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                        strErr);
                    fflush(stdout);
                    break;
                } else {
                    printf("Display Image Succeeded\n");
                }
                fflush(stdout);
            }
            break;
            case 10: {
                printf(">>10. Set Background\n");
                fflush(stdout);
                printf("Please enter the image name to display as background:\n");
                fflush(stdout);
                char imageName[50];
                fgets(imageName, 50, stdin);
                if (imageName[0] == '\n' || imageName[0] == '\r') {
                    break;
                }
                int i;
                for (i = 0; i < 50; i++) {
                    if (imageName[i] == '\n' || imageName[i] == '\r') {
                        imageName[i] = '\0';
                        break;
                    }
                }
                r = lcd_customDisplayMode(0);
                r = lcd_customDisplayMode(1);
                r = lcd_setBackgroundImage(imageName, strlen(imageName), 1);
                lcd_customDisplayMode(0);
                lcd_resetInitialState();
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Set Background failed!! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                        strErr);
                    fflush(stdout);
                    break;
                } else {
                    printf("Set Background Succeeded\n");
                }
                fflush(stdout);
            }
            break;
            case 11: {
                printf(">>11. Remove Background\n");
                fflush(stdout);
                r = lcd_customDisplayMode(0);
                r = lcd_customDisplayMode(1);
                r = lcd_setBackgroundImage(NULL, 0, 0);
                lcd_customDisplayMode(0);
                lcd_resetInitialState();
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Remove Background failed!! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                        strErr);
                    fflush(stdout);
                    break;
                } else {
                    lcd_clearDisplay();
                    printf("Remove Background Succeeded\n");
                }
                fflush(stdout);
            }
            break;
            case 12: {
                printf(">>12. Set Default Background\n");
                fflush(stdout);
                char directory[_DATA_BUF_LEN];
                int directoryLen = _DATA_BUF_LEN;
                r = device_listDirectory(NULL, 0, 1, 0, directory, &directoryLen);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- List Directory Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                    fflush(stdout);
                    break;
                }
                if (NULL == strstr(directory, "DefaultBackground/default.png")) {
                    device_createDirectory("DefaultBackground", 17);
                    // Read in the file
                    BYTE fileData[35000];
                    int fileDataLen;
                    FILE * fp;
                    if (NULL == (fp = fopen("../Resources/default.png", "rb"))) {
                        printf("Could not open file ../Resources/default.png\n");
                        fflush(stdout);
                        break;
                    }

                    fseek(fp, 0, SEEK_END);
                    fileDataLen = ftell(fp);
                    if (fileDataLen > 35000) {
                        printf("Not enough buffer\n");
                        fflush(stdout);
                        break;
                    }

                    fseek(fp, 0, SEEK_SET);
                    fread(fileData, fileDataLen, 1, fp);
                    fclose(fp);

                    r = device_transferFile("DefaultBackground/default.png", strlen(
                            "DefaultBackground/default.png"), fileData, fileDataLen);
                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getIDGStatusCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Transfer File Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                            strErr);
                        fflush(stdout);
                        break;
                    }
                }
                lcd_customDisplayMode(0);
                lcd_customDisplayMode(1);
                r = lcd_setBackgroundImage("DefaultBackground/default.png", strlen("DefaultBackground/default.png"), 1);
                lcd_customDisplayMode(0);
                lcd_resetInitialState();
                //			device_calibrateParameters(0x02);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Set Default Background failed!! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                        strErr);
                    fflush(stdout);
                    break;
                } else {
                    printf("Set Default Background Succeeded\n");
                }
                fflush(stdout);
            }
            break;
            case 0:
                printf(">>0.Back To Main Menu\n");
                fflush(stdout);
                break;
        }
    } while (choice != 0);
    // #ifdef WIN32
    if (choice == 0) {
//        idtech_process.pProcess_function_list();
        return;
    }
    // #endif
} /* _VP8800_process_lcd */

void
_VP8800_display_lcd_menu() {
    idtech_display_menu_from_lib.pDisplay_Menu_current = _VP8800_display_lcd_menu;
    printf("\t\t********** LCD Options [VP8800]************\n");
    printf("\t\t0.  Back To Main Menu\n");
    printf("\t\t1.  Reset Initial State\n");
    printf("\t\t2.  Start Custom Display Mode\n");
    printf("\t\t3.  Stop Custom Display Mode\n");
    printf("\t\t4.  Set Colors\n");
    printf("\t\t5.  Clear Display\n");
    printf("\t\t6.  Capture Signature\n");
    printf("\t\t7.  Start Slideshow\n");
    printf("\t\t8.  Start Default Slideshow\n");
    printf("\t\t9.  Display Image\n");
    printf("\t\t10. Set Background\n");
    printf("\t\t11. Remove Background\n");
    printf("\t\t12. Set Default Background\n");
    printf("\t\t************************************************\n");
    fflush(stdout);
}
