#include <stdio.h>
#include <string.h>
#include "demo_common.h"

extern IDT_COMMON_PROCESS COMMON;
extern IDT_PROCESS idtech_process;
extern IDT_DEMO_LIB_DISPLAY_MENU idtech_display_menu_from_lib;

void
_VP8800_display_device_menu();

#if defined(WIN32) || defined(__MACH__)
EXPORT_SYMBOLS int isDeviceTransaction = 0;
#else
SHARED_SYMBOLS int isDeviceTransaction;
#endif

void
_VP8800_process_device() {
    int choice;
    int r = 0;
    char str1[256] = { 0 };
    int len        = 512;

    memset(str1, 0, 256);
    int i;
    char directory_name[50];
    char file_name[50];
    emv_setAutoAuthenticateTransaction(1);
    emv_setAutoCompleteTransaction(1);

    do {
        _VP8800_display_device_menu();
        choice = COMMON.inputSelection();
        switch (choice) {
            case 1:
                printf(">>1. Start Transaction\n");
                fflush(stdout);
                r = device_startTransaction(1.00, 0.00, 0, 30, NULL, 0);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS && r != 0x23) {
                    printf("  Do device_startTransaction(), failed! Error Code: %04X\n", r);
                } else {
                    printf("Start Transaction Succeeded\n");
                    printf("Please Use Card...\n");
                    isDeviceTransaction = 1;
                }
                fflush(stdout);
                break;
            case 2:
                printf(">>2. Cancel Transaction\n");
                fflush(stdout);
                r = device_cancelTransaction();
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    printf("  Do device_cancelTransaction(), failed!\n");
                } else {
                    printf("Cancel Transaction successfully\n");
                }
                fflush(stdout);
                break;
            case 3: {
                printf(">>3. Get Firmware Version\n");
                fflush(stdout);
                r = device_getFirmwareVersion(str1);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Get Firmware Version Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    char str2[200] = { 0 };
                    sprintf(str2, "Firmware version: %s\n", str1);
                    printf(str2);
                }
                fflush(stdout);
            }
            break;
            case 4: {
                printf(">>4. Send Command: 0x29, 0x00\n");
                fflush(stdout);
                BYTE rbbyte[512] = { 0 };
                memset(rbbyte, 0, 512);
                len = 512;
                r = device_SendDataCommandNEO(0x29, 0x00, NULL, 0, rbbyte, &len);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Do device_SendDataCommand(), failed! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                        strErr);
                } else {
                    char str3[1024] = { 0 };
                    memset(str3, 0, 1024);
                    COMMON.convertBytesIntoHexStr(rbbyte, len, 0, str3);
                    printf("response code : %s\n", str3);
                }
                fflush(stdout);
            }
            break;
            case 5: {
                printf(">>5. Get Serial Number\n");
                fflush(stdout);
                r = config_getSerialNumber(str1);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Get Serial Number Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    char str2[200] = { 0 };
                    sprintf(str2, "Serial Number: %s\n", str1);
                    printf(str2);
                }
                fflush(stdout);
            }
            break;
            case 6: {
                printf(">>6. Ping Device\n");
                fflush(stdout);
                r = device_pingDevice();
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Ping Device Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Ping Device Succeeded\n");
                }
                fflush(stdout);
            }
            break;
            case 7: {
                printf(">>7. Interface Control (4 short beeps)\n");
                fflush(stdout);
                BYTE values[4] = { 0xFF, 0x04, 0x00, 0x00 };
                r = device_controlUserInterface(values);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Interface Control Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Interface Control Succeeded\n");
                }
                fflush(stdout);
            }
            break;
            case 8: {
                printf(">>8. Interface Control (All LED On)\n");
                fflush(stdout);
                BYTE values[4] = { 0xFF, 0x00, 0xFF, 0x01 };
                r = device_controlUserInterface(values);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Interface Control Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Interface Control Succeeded\n");
                }
                fflush(stdout);
            }
            break;
            case 9: {
                printf(">>9. Interface Control (All LED Off)\n");
                fflush(stdout);
                BYTE values[4] = { 0xFF, 0x00, 0xFF, 0x00 };
                r = device_controlUserInterface(values);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Interface Control Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Interface Control Succeeded\n");
                }
                fflush(stdout);
            }
            break;
            case 10: {
                printf(">>10. Indicator Control (Blue MSR LED On)\n");
                fflush(stdout);
                r = device_controlIndicator(1, 1);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Indicator Control Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Indicator Control Succeeded\n");
                }
                fflush(stdout);
            }
            break;
            case 11: {
                printf(">>11. Indicator Control(Blue MSR LED Off)\n");
                fflush(stdout);
                r = device_controlIndicator(1, 0);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Indicator Control Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Indicator Control Succeeded\n");
                }
                fflush(stdout);
            }
            break;
            case 12:
                printf(">>12. Pass Through On\n");
                fflush(stdout);
                r = device_enablePassThrough(1);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Pass Through On Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Pass Through On Succeeded\n");
                }
                fflush(stdout);
                break;
            case 13:
                printf(">>13. Pass Through Off\n");
                fflush(stdout);
                r = device_enablePassThrough(0);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Pass Through Off Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Pass Through Off Succeeded\n");
                }
                fflush(stdout);
                break;
            case 14:
                printf(">>14. Calibration\n");
                fflush(stdout);
                r = device_calibrateParameters(2);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Calibration Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Calibration Succeeded\n");
                }
                fflush(stdout);
                break;
            case 15:
                printf(">>15. Get Drive Free Space\n");
                fflush(stdout);
                int free, used;
                r = device_getDriveFreeSpace(&free, &used);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Get Drive Free Space Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Get Drive Free Space Succeeded\n");
                    printf("Free Drive Space: %d\nUsed Drive Space: %d\n", free, used);
                }
                fflush(stdout);
                break;
            case 16:
                printf(">>16. List Directory\n");
                fflush(stdout);
                char ssDirectory[_CMD_BUF_LEN];
                int ssDirectoryLen = _CMD_BUF_LEN;
                memset(ssDirectory, 0, _CMD_BUF_LEN);
                r = device_listDirectory(NULL, 0, 1, 0, ssDirectory, &ssDirectoryLen);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- List Directory Failed! ErrorCode:0x%02x, Info: %s ----- \n",
                        r, strErr);
                } else {
                    printf("List Directory Succeeded\n");
                    int i;
                    for (i = 0; i < ssDirectoryLen; i++) {
                        if (ssDirectory[i] == ',') {
                            printf("\n");
                        } else {
                            printf("%c", ssDirectory[i]);
                        }
                    }
                    printf("\n");
                }
                fflush(stdout);
                break;
            case 17:
                printf(">>17. Create Directory\n");

                printf("Please enter the directory name:\n");
                fflush(stdout);
                fgets(directory_name, 50, stdin);
                for (i = 0; i < 50; i++) {
                    if (directory_name[i] == '\n' || directory_name[i] == '\r') {
                        directory_name[i] = '\0';
                        break;
                    }
                }

                r = device_createDirectory(directory_name, strlen(directory_name));
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Create Directory Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Create Directory Succeeded\n");
                }
                fflush(stdout);
                break;
            case 18:
                printf(">>18. Delete Directory\n");

                printf("Please enter the directory name:\n");
                fflush(stdout);
                fgets(directory_name, 50, stdin);
                for (i = 0; i < 50; i++) {
                    if (directory_name[i] == '\n' || directory_name[i] == '\r') {
                        directory_name[i] = '\0';
                        break;
                    }
                }

                r = device_deleteDirectory(directory_name, strlen(directory_name));
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Delete Directory Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Delete Directory Succeeded\n");
                }
                fflush(stdout);
                break;
            case 19: {
                printf(">>19. Transfer File\n");

                printf("Please enter the source file name:\n");
                fflush(stdout);
                char in_file_name[50];
                fgets(in_file_name, 50, stdin);
                for (i = 0; i < 50; i++) {
                    if (in_file_name[i] == '\n' || in_file_name[i] == '\r') {
                        in_file_name[i] = '\0';
                        break;
                    }
                }

                printf("Please enter the destination file name:\n");
                fflush(stdout);
                fgets(file_name, 50, stdin);
                for (i = 0; i < 50; i++) {
                    if (file_name[i] == '\n' || file_name[i] == '\r') {
                        file_name[i] = '\0';
                        break;
                    }
                }

                // Read in the file
                BYTE fileData[50000];
                int fileDataLen;

                FILE * fp;
                if (NULL == (fp = fopen(in_file_name, "rb"))) {
                    printf("Could not open file %s\n", in_file_name);
                    fflush(stdout);
                    break;
                }

                fseek(fp, 0, SEEK_END);
                fileDataLen = ftell(fp);
                if (fileDataLen > 50000) {
                    printf("Not enough buffer\n");
                    fflush(stdout);
                    break;
                }

                fseek(fp, 0, SEEK_SET);
                fread(fileData, fileDataLen, 1, fp);
                fclose(fp);

                r = device_transferFile(file_name, strlen(file_name), fileData, fileDataLen);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Transfer File Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Transfer File Succeeded\n");
                }
                fflush(stdout);
            }
            break;
            case 20:
                printf(">>20. Delete File\n");

                printf("Please enter the file name:\n");
                fflush(stdout);
                fgets(file_name, 50, stdin);

                for (i = 0; i < 50; i++) {
                    if (file_name[i] == '\n' || file_name[i] == '\r') {
                        file_name[i] = '\0';
                        break;
                    }
                }

                r = device_deleteFile(file_name, strlen(file_name));
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Delete File Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Delete File Succeeded\n");
                }
                fflush(stdout);
                break;
            case 0:
                printf(">>0.Back To Main Menu\n");
                fflush(stdout);
                isDeviceTransaction = 0;
                break;
        }
    } while (choice != 0);
    // #ifdef WIN32
    if (choice == 0) {
//        idtech_process.pProcess_function_list();
        return;
    }
    // #endif
} /* _VP8800_process_device */

void
_VP8800_display_device_menu() {
    idtech_display_menu_from_lib.pDisplay_Menu_current = _VP8800_display_device_menu;
    printf("\t\t********** Device Options [VP8800]***********\n");
    printf("\t\t0.  Back To Main Menu\n");
    printf("\t\t1.  Start Transaction\n");
    printf("\t\t2.  Cancel Transaction\n");
    printf("\t\t3.  Get Firmware Version\n");
    printf("\t\t4.  Send Data Command\n");
    printf("\t\t5.  Get Serial Number\n");
    printf("\t\t6.  Ping Device\n");
    printf("\t\t7.  Interface Control (4 short beeps)\n");
    printf("\t\t8.  Interface Control (All LED On)\n");
    printf("\t\t9.  Interface Control (All LED Off)\n");
    printf("\t\t10. Indicator Control (Blue MSR LED On)\n");
    printf("\t\t11. Indicator Control (Blue MSR LED Off)\n");
    printf("\t\t12. Enable Passthrough\n");
    printf("\t\t13. Disable Passthrough\n");
    printf("\t\t14. Calibration\n");
    printf("\t\t15. Get Drive Free Space\n");
    printf("\t\t16. List Directory\n");
    printf("\t\t17. Create Directory\n");
    printf("\t\t18. Delete Directory\n");
    printf("\t\t19. Transfer File\n");
    printf("\t\t20. Delete File\n");
    printf("\t\t************************************************\n");
    fflush(stdout);
}
