#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "demo_common.h"

// IDT_COMMON_PROCESS  COMMON;
// extern IDT_PROCESS idtech_process;
// extern IDT_DEMO_LIB_DISPLAY_MENU idtech_display_menu_from_lib;

extern IDT_COMMON_PROCESS COMMON;
extern IDT_PROCESS idtech_process;
extern IDT_DEMO_LIB_DISPLAY_MENU idtech_display_menu_from_lib;

void
_VP3300_display_msr_menu();

void
_VP3300_process_msr() {
    int choice;
    BYTE resData[_DATA_BUF_LEN];
    int resLen;
    int r;

    do {
        _VP3300_display_msr_menu();
        choice = COMMON.inputSelection();
        switch (choice) {
            case 1:
                printf(">>1. Start MSR\n");
                fflush(stdout);
                //			msr_registerCallBk(COMMON.MSR_callBack);
                r = msr_startMSRSwipe(30);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Start MSR Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("MSR Start MSR Swipe Succeeded\n");
                    printf("Please Swipe Card...\n");
                }
                fflush(stdout);
                break;
            case 2:
                printf(">>2. Cancel MSR\n");
                fflush(stdout);
                r = msr_cancelMSRSwipe();
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Cancel MSR Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("MSR Cancel MSR Swipe Succeeded\n");
                }
                fflush(stdout);
                break;
            case 3:
                printf(">>3. Validate TLV\n");
                BYTE tlv11[1024] = { 0 };
                int tlvLen11     = 1024;
                //			char *str2 = "9F01065649534130305F5701005F2A0208409F090200965F3601029F1B0400003A98DF25039F3704DF28039F0802DFEE150101DF13050000000000DF14050000000000DF15050000000000DF180100DF170400002710DF190100";
                //			char *str2 = "DFEE134142363031313030303939313731313837345E4E4554574F524B2F444953434F564552202020202020202020205E3137303132303131303030313535353638383539DFEE1425363031313030303939313731313837343D31373031323031313030303135353536383835398407A00000032410109F0607A00000032410109F3501229F3704599083689F3901919A031711309F2103144639564142363031313030303939313731313837345E4E4554574F524B2F444953434F564552202020202020202020205E313730313230313130303031303030363838303057136011000991711874D17012011000100068800F9C0100FFEE0108DF300100DF520100DFEF4C06002700000000DFEF4D273B363031313030303939313731313837343D31373031323031313030303130303036383830303FDFEE260111";
                //			char *str2 = "DFEE134142363031313030303939313731313837345E4E4554574F524B2F444953434F564552202020202020202020205E3137303132303131303030313535353638383539DFEE1425363031313030303939313731313837343D31373031323031313030303135353536383835398407A00000032410109F0607A00000032410109F3501229F3704599083689F3901919A031711309F2103144639564142363031313030303939313731313837345E4E4554574F524B2F444953434F564552202020202020202020205E313730313230313130303031303030363838303057136011000991711874D17012011000100068800F9C0100FFEE0108DF520100DF300100DFEF4C06002700000000DFEF4D273B363031313030303939313731313837343D31373031323031313030303130303036383830303FDFEE260111";
                char * str2 =
                  "9a031712029c01005f2a0208405f2d02656e9f02060000000001009f03060000000000009f0607a00000000410109f090200029f1a0208409f1e0830303030303030309f21030821089f33030000e89f34030000009f3501229f360200029f37041905a1869f3901919f530100df81290830f0f00030f0ff00ff81063bdf812a18303030303030303030303030303030303030303030303030df812b070000000000000fdf8115060000000000ff9f6e0708400000303900ff81056c50104445424954204d4153544552434152448407a00000000410109f6d020001563442353230343234323735303237303031305e202f5e313930373230313030303032313730313931393030303030303030303030399f6b135204242750270010d19072010000283019199fffee012fdf300100df3118303030303030303030303030303030303030303030303030df320d30303030303030303030303030dfee260151";

                //			char *str2 = "DFEE134142363031313030303939313731313837345E4E4554574F524B2F444953434F564552202020202020202020205E3137303132303131303030313535353638383539DFEE1425363031313030303939313731313837343D31373031323031313030303135353536383835398407A00000032410109F0607A00000032410109F3501229F3704599083689F3901919A031711309F2103144639564142363031313030303939313731313837345E4E4554574F524B2F444953434F564552202020202020202020205E313730313230313130303031303030363838303057136011000991711874D17012011000100068800F9C0100FFEE0104DF300100DFEF4C06002700000000DFEF4D273B363031313030303939313731313837343D31373031323031313030303130303036383830303FDFEE260111";

                //			char *str2 = "BF370D9F01065649534130305F570100BF2A099F090200965F360102BF1B12BF190FDF170400002710DF13050000000000";
                COMMON.convertHStrIntoHex(str2, tlv11, &tlvLen11);
                //			BYTE tag[] = {0xDF, 0x13};
                //			BYTE tag[] = {0xDF, 0x52};
                //			r = tlv_sortTLV(tlv11, tlvLen11, 1);
                //			r = tlv_removeTLV(tlv11, &tlvLen11, tag, 2, 1);
                // r = tlv_validateTLV(tlv11, tlvLen11, 1);
                // if ( r != RETURN_CODE_DO_SUCCESS ) {
                //  printf("  Do tlv_validateTLV(), failed!\n");
                // }
                // else{
                //  printf("Validate TLV Succeeded\n");
                //  int i;
                //  for (i=0;i<tlvLen11;i++)
                //      printf("%02X", tlv11[i]);
                //  printf("\n");
                // }
                break;
            //		case 3:
            //			printf(">>3. Clear Card Data\n");
            //			r = msr_clearMSRData();
            //			if ( r != RETURN_CODE_DO_SUCCESS ) {
            //				printf("  Do msr_clearMSRData(), failed!\n");
            //			}
            //			else{
            //				printf("MSR Clear MSR Data Succeeded\n");
            //			}
            //		break;
            //
            //		case 4:
            //			printf(">>4. Get Card Data\n");
            //			resLen = _DATA_BUF_LEN;
            //			memset(resData, 0, resLen);
            //			r = msr_getMSRData(resData, &resLen);
            //			if ( r != RETURN_CODE_DO_SUCCESS ) {
            //				printf("  Do msr_getMSRData(), failed!\n");
            //			}
            //			else{
            //				printf("Get MSR Data: Succeeded\n");
            //				IDTMSRData msrData1;
            //				resetMSRData(&msrData1);
            //				parseMSRData(resData, resLen, &msrData1);
            //				COMMON.printMSRData(&msrData1);
            //			}
            //		break;
            case 0:
                if (isMSRBusy) {
                    printf("MSR Busy\n");
                    choice = -1;
                } else {
                    printf(">>0. Back To Main Menu\n");
                }
                fflush(stdout);
                break;
        }
    } while (choice != 0);
    // #ifdef WIN32
    if (choice == 0) {
//        idtech_process.pProcess_function_list();
        return;
    }
    // #endif
} /* _VP3300_process_msr */

void
_VP3300_display_msr_menu() {
    idtech_display_menu_from_lib.pDisplay_Menu_current = _VP3300_display_msr_menu;

    if (device_getCurrentDeviceType() == IDT_DEVICE_VP3300_AJ) {
        printf("\t\t********** MSR Options [VP3300 AJ]************\n");
    } else if (device_getCurrentDeviceType() == IDT_DEVICE_VP3300_USB) {
        printf("\t\t********** MSR Options [VP3300 USB]***********\n");
    } else if (device_getCurrentDeviceType() == IDT_DEVICE_VP3300_BT) {
        printf("\t\t********** MSR Options [VP3300 BT]************\n");
    } else if (device_getCurrentDeviceType() == IDT_DEVICE_VP3300_COM) {
        printf("\t\t********** MSR Options [VP3300 COM]***********\n");
    }
    printf("\t\t0. Back To Main Menu\n");
    printf("\t\t1. Start MSR\n");
    printf("\t\t2. Cancel MSR\n");
    printf("\t\t3. Validate TLV\n");
    //	printf("\t\t3. Clear Card Data\n");
    // printf("\t\t4. Get Card Data\n");
    printf("\t\t************************************************\n");
    fflush(stdout);
}
