/**
 *  \mainpage libpos API Reference
 *
 *  \section objects POS objects
 *
 */


#ifndef __LIBDEMO_SPECTRUM_PRO_C___
#define __LIBDEMO_SPECTRUM_PRO_C___
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <memory.h>


#include "libDemo_SpectrumPro.h"
#ifndef WIN32
# include <dlfcn.h>
#endif

// SpectrumPro process
extern void
_SpectrumPro_process_function_list();
extern void
_SpectrumPro_process_device();
extern void
_SpectrumPro_process_config();
extern void
_SpectrumPro_process_msr();
extern void
_SpectrumPro_process_icc();
extern void
_SpectrumPro_process_emv();
extern void
_SpectrumPro_process_pin();
extern void
_SpectrumPro_display_device_menu();
extern void
_SpectrumPro_display_pin_menu();
extern void
_SpectrumPro_display_emv_menu();
extern void
_SpectrumPro_display_msr_menu();


IDT_COMMON_PROCESS COMMON;
IDT_PROCESS idtech_process;
IDT_DEMO_LIB_DISPLAY_MENU idtech_display_menu_from_lib;

void
IDT_PROCESS_clean() {
    idtech_process.pProcess_function_list = NULL;
    idtech_process.pProcess_device        = NULL;
    idtech_process.pProcess_config        = NULL;
    idtech_process.pProcess_msr = NULL;
    idtech_process.pProcess_icc = NULL;
    idtech_process.pProcess_emv = NULL;
    idtech_process.pProcess_pin = NULL;
}

void
libDemo_getMenuFn(IDT_DEMO_LIB_DISPLAY_MENU * _idtech_display_menu_from_lib) {
    *_idtech_display_menu_from_lib = idtech_display_menu_from_lib;
}

void
libDemo_init(IDT_COMMON_PROCESS _demo_Common_Process, IDT_DEMO_LIB_DISPLAY_MENU * _idtech_display_menu_from_lib) {
    COMMON = _demo_Common_Process;
    // intialize the process function
    IDT_PROCESS_clean();
    idtech_process.pProcess_function_list = _SpectrumPro_process_function_list;
    idtech_process.pProcess_device        = _SpectrumPro_process_device;
    idtech_process.pProcess_config        = _SpectrumPro_process_config;
    idtech_process.pProcess_msr = _SpectrumPro_process_msr;
    idtech_process.pProcess_icc = _SpectrumPro_process_icc;
    idtech_process.pProcess_emv = _SpectrumPro_process_emv;
    idtech_process.pProcess_pin = _SpectrumPro_process_pin;

    // intialize the display menu callback
    idtech_display_menu_from_lib = *_idtech_display_menu_from_lib;
    idtech_display_menu_from_lib.pDisplay_Menu_device = _SpectrumPro_display_device_menu;
    idtech_display_menu_from_lib.pDisplay_Menu_pin    = _SpectrumPro_display_pin_menu;
    idtech_display_menu_from_lib.pDisplay_Menu_emv    = _SpectrumPro_display_emv_menu;
    idtech_display_menu_from_lib.pDisplay_Menu_msr    = _SpectrumPro_display_msr_menu;

    *_idtech_display_menu_from_lib = idtech_display_menu_from_lib;
    // into the function menu selection
    idtech_process.pProcess_function_list();
}

#endif /* ifndef __LIBDEMO_SPECTRUM_PRO_C___ */
