#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "demo_common.h"

IDT_COMMON_PROCESS COMMON;
extern IDT_PROCESS idtech_process;
extern IDT_DEMO_LIB_DISPLAY_MENU idtech_display_menu_from_lib;

void
_SpectrumPro_display_icc_menu();

void
_SpectrumPro_process_icc() {
    int choice;
    BYTE status;
    int r;
    BYTE ATR[_DATA_BUF_LEN];
    int ATRLen;
    BYTE resData[_DATA_BUF_LEN];
    int resLen;

    do {
        _SpectrumPro_display_icc_menu();
        choice = COMMON.inputSelection();
        switch (choice) {
            case 1:
                printf(">>1. Power On ICC\n");
                fflush(stdout);
                ATRLen = _DATA_BUF_LEN;
                memset(ATR, 0, ATRLen);
                r = icc_powerOnICC(ATR, &ATRLen);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getResponseCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Power On ICC Failed! ErrorCode: 0x%02x, Info: %s ----- \n",
                        r, strErr);
                } else {
                    printf("ICC Power On Succeeded\nATR: ");
                    int i;
                    for (i = 0; i < ATRLen; i++) {
                        printf("%02X ", ATR[i]);
                    }
                    printf("\n");
                }
                fflush(stdout);
                break;
            case 2:
                printf(">>2. Power Off ICC\n");
                fflush(stdout);
                r = icc_powerOffICC();
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getResponseCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Power Off ICC Failed! ErrorCode: 0x%02x, Info: %s ----- \n",
                        r, strErr);
                } else {
                    printf("ICC Power Off Succeeded\n");
                }
                fflush(stdout);
                break;

            case 3:
                printf(">>3. Get ICC Reader Status\n");
                fflush(stdout);
                r = icc_getICCReaderStatus(&status);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getResponseCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Get ICC Reader Status Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    BYTE bit0      = (byte) (status & 0x01);
                    BYTE bit1      = (byte) ((status & 0x02) >> 1);
                    char str2[200] = { 0 };
                    sprintf(str2, "Reader Status: %02X\n%s %s\n", status,
                      (bit0 == 1 ? "[ICC Powered] " : "[ICC Power Not Ready] "),
                      (bit1 == 1 ? "[Card Seated]" : "[Card Not Seated] "));
                    //				sprintf(str2, "ICC Reader Status : %s %s \n", (bit0 == 1 ? "[ICC Powered] " : "[ICC Power Not Ready] "), (bit1 == 1 ? "[Card Seated]" : "[Card Not Seated] "));
                    printf(str2);
                }
                fflush(stdout);
                break;
            case 0:
                printf(">>0.Back To Main Menu\n");
                fflush(stdout);
                break;
        }
    } while (choice != 0);
    // #ifdef WIN32
    if (choice == 0) {
//        idtech_process.pProcess_function_list();
        return;
    }
    // #endif
} /* _SpectrumPro_process_icc */

void
_SpectrumPro_display_icc_menu() {
    idtech_display_menu_from_lib.pDisplay_Menu_current = _SpectrumPro_display_icc_menu;
    printf("\t\t********** ICC Options [SpectrumPro]************\n");
    printf("\t\t0. Back To Main Menu\n");
    printf("\t\t1. Power On ICC\n");
    printf("\t\t2. Power Off ICC\n");
    printf("\t\t3. Get ICC Reader Status\n");
    printf("\t\t************************************************\n");
    fflush(stdout);
}
