#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "demo_common.h"

IDT_COMMON_PROCESS COMMON;
EXPORT_SYMBOLS IDT_PROCESS idtech_process;
EXPORT_SYMBOLS IDT_DEMO_LIB_DISPLAY_MENU idtech_display_menu_from_lib;

void
_SREDKey2_display_msr_menu();

void
_SREDKey2_process_msr() {
    int choice;
    BYTE resData[_DATA_BUF_LEN];
    int resLen;
    int r;

    //	msr_registerCallBk(COMMON.MSR_callBack);
    //	msr_registerCallBkp(COMMON.MSR_callBackp);
    do {
        _SREDKey2_display_msr_menu();
        choice = COMMON.inputSelection();
        switch (choice) {
            case 1:
                printf(">>1. Set Expiration Mask ON\n");
                fflush(stdout);
                r = msr_setExpirationMask(1);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    printf("  Do msr_setExpirationMask(1) failed!\n");
                } else {
                    printf("Set Expiration Mask ON Succeeded\n");
                }
                fflush(stdout);
                break;
            case 2:
                printf(">>2. Set Expiration Mask OFF\n");
                fflush(stdout);
                r = msr_setExpirationMask(0);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    printf("  Do msr_setExpirationMask(0), failed!\n");
                } else {
                    printf("Set Expiration Mask OFF Succeeded\n");
                }
                fflush(stdout);
                break;
            case 3:
                printf(">>3. Get Expiration Mask Status\n");
                fflush(stdout);
                BYTE response = 0x00;
                r = msr_getExpirationMask(&response);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    printf("  Do msr_getExpirationMask(), failed!\n");
                } else {
                    printf("Get Expiration Mask Status Succeeded\n");
                    printf("Expiration Masking: %s\r\n", ((response == 0x30) ? "Masked" : "Unmasked"));
                }
                fflush(stdout);
                break;
            case 4:
                printf(">>4. Set PAN Clear Digits\n");
                fflush(stdout);
                r = msr_setClearPANID(0x04);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    printf("  Do msr_setClearPANID(), failed!\n");
                } else {
                    printf("Set PAN Clear Digits Succeeded\n");
                }
                fflush(stdout);
                break;
            case 5: {
                printf(">>5. Get PAN Clear Digits\n");
                fflush(stdout);
                BYTE response = 0x00;
                r = msr_getClearPANID(&response);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    printf("  Do msr_getClearPANID(), failed!\n");
                } else {
                    printf("Get Clear PAN Digits Succeeded\n");
                    printf("Get Clear PAN Digits Response: 0x%02X\r\n", response);
                }
                fflush(stdout);
            }
            break;
            case 6:
                printf(">>6. Set Swipe Force Enc. ON\n");
                fflush(stdout);
                r = msr_setSwipeForcedEncryptionOption(1, 1, 1, 1);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    printf("  Do msr_setSwipeForcedEncryptionOption(1), failed!\n");
                } else {
                    printf("Set Swipe Force Enc. ON Succeeded\n");
                }
                fflush(stdout);
                break;
            case 7:
                printf(">>7. Set Swipe Force Enc. OFF\n");
                fflush(stdout);
                r = msr_setSwipeForcedEncryptionOption(0, 0, 0, 0);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    printf("  Do msr_setSwipeForcedEncryptionOption(0), failed!\n");
                } else {
                    printf("Set Swipe Force Enc. OFF Succeeded\n");
                }
                fflush(stdout);
                break;
            case 8: {
                printf(">>8. Get Swipe Force Enc.\n");
                fflush(stdout);
                BYTE format = 0x00;
                r = msr_getSwipeForcedEncryptionOption(&format);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    printf("  Do msr_getSwipeForcedEncryptionOption(), failed!\n");
                } else {
                    printf("Get Swipe Force Enc. Succeeded\n");
                    if ((format & 0x01) == 0x01) {
                        printf("\tTrack 1 Swipe Force Encryption: ON\r\n");
                    } else {
                        printf("\tTrack 1 Swipe Force Encryption: OFF\r\n");
                    }
                    if ((format & 0x02) == 0x02) {
                        printf("\tTrack 2 Swipe Force Encryption: ON\r\n");
                    } else {
                        printf("\tTrack 2 Swipe Force Encryption: OFF\r\n");
                    }
                    if ((format & 0x04) == 0x04) {
                        printf("\tTrack 3 Swipe Force Encryption: ON\r\n");
                    } else {
                        printf("\tTrack 3 Swipe Force Encryption: OFF\r\n");
                    }
                    if ((format & 0x08) == 0x08) {
                        printf("\tTrack 3 Option 0 Swipe Force Encryption: ON\r\n");
                    } else {
                        printf("\tTrack 3 Option 0 Swipe Force Encryption: OFF\r\n");
                    }
                }
                fflush(stdout);
            }
            break;
            case 9:
                printf(">>9. Set Swipe Mask ON.\n");
                fflush(stdout);
                r = msr_setSwipeMaskOption(1, 1, 1);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    printf("  Do msr_setSwipeMaskOption(1), failed!\n");
                } else {
                    printf("Set Swipe Mask ON Succeeded\n");
                }
                fflush(stdout);
                break;
            case 10:
                printf(">>10. Set Swipe Mask OFF\n");
                fflush(stdout);
                r = msr_setSwipeMaskOption(0, 0, 0);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    printf("  Do msr_setSwipeMaskOption(0), failed!\n");
                } else {
                    printf("Set Swipe Mask OFF Succeeded\n");
                }
                fflush(stdout);
                break;
            case 11: {
                printf(">>11. Get Swipe Mask\n");
                fflush(stdout);
                BYTE format = 0x00;
                r = msr_getSwipeMaskOption(&format);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    printf("  Do msr_getSwipeMaskOption(), failed!\n");
                } else {
                    printf("Get Swipe Mask Status Succeeded\n");
                    if ((format & 0x01) == 0x01) {
                        printf("\tTrack 1 Mask Option: ON\r\n");
                    } else {
                        printf("\tTrack 1 Mask Option: OFF\r\n");
                    }
                    if ((format & 0x02) == 0x02) {
                        printf("\tTrack 2 Mask Option: ON\r\n");
                    } else {
                        printf("\tTrack 2 Mask Option: OFF\r\n");
                    }
                    if ((format & 0x04) == 0x04) {
                        printf("\tTrack 3 Mask Option: ON\r\n");
                    } else {
                        printf("\tTrack 3 Mask Option: OFF\r\n");
                    }
                }
                fflush(stdout);
            }
            break;
            case 12:
                printf(">>12. Disable MSR\n");
                fflush(stdout);
                r = msr_disable();
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getResponseCodeString(r, strErr);
                    printf("  Do msr_disable(), failed! ErrorCode:0x%02x ,Info: %s ----- \n", r, strErr);
                } else {
                    printf("Disable MSR Succeeded\n");
                }
                fflush(stdout);
                break;
            case 13: {
                printf(">>13. Get MSR Function Status\n");
                fflush(stdout);
                int enabled;
                int isBufferMode;
                int withNotification;
                r = msr_getFunctionStatus(&enabled, &isBufferMode, &withNotification);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    printf("  Do icc_getFunctionStatus(), failed!\n");
                } else {
                    printf("Get MSR Function Status Succeeded\n");
                    if (enabled) {
                        printf("\tMSR Reader:[%s] [%s] [%s]\n", (enabled == 1 ? "Enabled" : "Disabled"),
                          (isBufferMode == 1 ? "Buffer Mode" : "Auto Mode"),
                          (withNotification == 1 ? "with Notification" : "without Notification"));
                    } else {
                        printf("\tMSR Reader Disabled.\n");
                    }
                }
                fflush(stdout);
            }
            break;
            case 0:
                if (isMSRBusy) {
                    printf("MSR Busy\n");
                    choice = -1;
                } else {
                    printf(">>0. Back To Main Menu\n");
                }
                fflush(stdout);
                break;
        }
    } while (choice != 0);
    if (choice == 0) {
//        idtech_process.pProcess_function_list();
        return;
    }
} /* _SREDKey2_process_msr */

void
_SREDKey2_display_msr_menu() {
    idtech_display_menu_from_lib.pDisplay_Menu_current = _SREDKey2_display_msr_menu;
    printf("\t\t********** MSR Options [SREDKey2]************\n");
    printf("\t\t0.  Back To Main Menu\n");
    printf("\t\t1.  Set Expiration Mask ON\n");
    printf("\t\t2.  Set Expiration Mask OFF\n");
    printf("\t\t3.  Get Expiration Mask Status\n");
    printf("\t\t4.  Set PAN Clear Digits\n");
    printf("\t\t5.  Get PAN Clear Digits\n");
    printf("\t\t6.  Set Swipe Force Enc. ON\n");
    printf("\t\t7.  Set Swipe Force Enc. OFF\n");
    printf("\t\t8.  Get Swipe Force Enc.\n");
    printf("\t\t9.  Set Swipe Mask ON.\n");
    printf("\t\t10. Set Swipe Mask OFF.\n");
    printf("\t\t11. Get Swipe Mask.\n");
    printf("\t\t12. Disable MSR.\n");
    printf("\t\t13. Get MSR Function Status.\n");
    printf("\t\t************************************************\n");
    fflush(stdout);
}
