/*
 * Copyright (C) ID TECH.
 *
 * Author: Eric
 *
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "demo_common.h"

extern IDT_COMMON_PROCESS COMMON;
extern IDT_PROCESS idtech_process;
extern IDT_DEMO_LIB_DISPLAY_MENU idtech_display_menu_from_lib;

void
display_SREDKey2_function_menu();

void
_SREDKey2_process_function_list() {
    int choice = 0;

    // Get The Device Type
    // int deviceType = 1;

    //	emv_registerCallBk(COMMON.EMV_callBack);
    //	emv_allowFallback(1);
    //	ctls_registerCallBk(COMMON.MSR_callBack);
    ctls_registerCallBkp(COMMON.MSR_callBackp);
    //	pin_registerCallBk(COMMON.PIN_callBack);
    registerLogCallBk(COMMON.SendDataLog,
      COMMON.ReadDataLog);

    //	lcd_registerCallBk(COMMON.LCD_callBack);
    //	device_registerFWCallBk(COMMON.FW_callBack);

    do {
        display_SREDKey2_function_menu();
        choice = COMMON.inputSelection();
        switch (choice) {
        case 1:
            if (idtech_process.pProcess_device) {
                idtech_process.pProcess_device();
            }
            break;
        case 2:
            if (idtech_process.pProcess_config) {
                idtech_process.pProcess_config();
            }
            break;
        case 3:
            if (idtech_process.pProcess_msr) {
                idtech_process.pProcess_msr();
            }
            break;
        case 0:
            printf(">>0. Back To Device Selection Menu\n");
            fflush(stdout);
            break;
        }
    } while (choice != 0);
    if (choice == 0) {
        //      idtech_display_menu_from_lib.pDisplay_Menu_current = COMMON.main_display_device_list;
        COMMON.main_process_device_select();
    }
} /* _SREDKey2_process_function_list */

void
display_SREDKey2_function_menu() {
    idtech_display_menu_from_lib.pDisplay_Menu_current = display_SREDKey2_function_menu;
    printf("\t\t*********** Universal SDK: [SREDKey2] ************\n");
    printf("\t\t0. Back To Device Selection Menu\n");
    printf("\t\t1. Device\n");
    printf("\t\t2. Config\n");
    printf("\t\t3. MSR\n");
    printf("\t\t************************************************\n");
    fflush(stdout);
}
