#include <stdio.h>
#include <string.h>
#include "demo_common.h"

extern IDT_COMMON_PROCESS COMMON;
extern IDT_PROCESS idtech_process;
extern IDT_DEMO_LIB_DISPLAY_MENU idtech_display_menu_from_lib;

void
_SREDKey2_display_device_menu();
// extern void getDUKPT(int type);

#if defined(WIN32) || defined(__MACH__)
EXPORT_SYMBOLS int isDeviceTransaction = 0;
#else
SHARED_SYMBOLS int isDeviceTransaction;
#endif

void
_SREDKey2_process_device() {
    int choice;
    int r = 0;
    char str1[256] = { 0 };
    int len        = 512;

    memset(str1, 0, 256);
    emv_setAutoAuthenticateTransaction(1);
    emv_setAutoCompleteTransaction(1);
    do {
        _SREDKey2_display_device_menu();
        choice = COMMON.inputSelection();

        switch (choice) {
            case 1: {
                printf(">>1. Get Firmware Version\n");
                fflush(stdout);
                r = device_getFirmwareVersion(str1);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Get Firmware Version Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Firmware version: %s\n", str1);
                }
                fflush(stdout);
            }
            break;
            case 2: {
                printf(">>2. Send IDG Command: 0x29, 0x00\n");
                fflush(stdout);
                BYTE rbbyte[512] = { 0 };
                memset(rbbyte, 0, 512);
                len = 512;
                r   = device_SendDataCommandNEO(0x29, 0x00, NULL, 0, rbbyte, &len);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Do device_SendDataCommand(), failed! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                        strErr);
                } else {
                    char str3[1024] = { 0 };
                    memset(str3, 0, 1024);
                    COMMON.convertBytesIntoHexStr(rbbyte, len, 0, str3);
                    printf("response code : %s\n", str3);
                }
                fflush(stdout);
            }
            break;
            case 3:
                printf(">>3. Get Key Status\n");
                fflush(stdout);
                {
                    int newFormat    = 1;
                    BYTE status[100] = { 0 };
                    int statusLen    = 100;
                    int rt = device_getKeyStatus(&newFormat, status, &statusLen);
                    if (rt == RETURN_CODE_DO_SUCCESS && statusLen > 0) {
                        printf("Get Key Status succeeded:\r\n");
                        int i;
                        for (i = 0; i < statusLen; i++) {
                            printf("0x%02X ", status[i]);
                            printf("\n");
                        }
                    } else {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getResponseCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n	----- Do device_getKeyStatus(), failed! ErrorCode:0x%02x ,Info: %s ----- \n",
                            r, strErr);
                    }
                    fflush(stdout);
                }
                break;
            case 4: {
                printf(">>4. Send NGA Command 784631\n");
                fflush(stdout);
                BYTE bbyte[5] = { 0x00 };
                int cmdlen;
                BYTE cmdData[_DATA_BUF_LEN] = { 0x00 };
                int cmdDataLen;
                bbyte[0] = 0x78;
                bbyte[1] = 0x46;
                bbyte[2] = 0x31;
                cmdlen   = 3;
                BYTE rbbyte[512] = { 0 };
                memset(rbbyte, 0, 512);
                len = 512;

                r = device_SendDataCommand(bbyte, cmdlen, NULL, 0, rbbyte, &len);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getResponseCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Do device_SendDataCommand(), failed! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                        strErr);
                } else {
                    char str3[1024] = { 0 };
                    memset(str3, 0, 1024);
                    COMMON.convertBytesIntoHexStr(rbbyte, len, 0, str3);
                    printf("response code : %s\n", str3);
                }
                fflush(stdout);
            }
            break;
            case 5: {
                printf(">>5. Send ITP Command 531A\n");
                fflush(stdout);
                BYTE bbyte[2]   = { 0x00 };
                int cmdlen      = 2;
                BYTE cmdData[1] = { 0x31 };
                int cmdDataLen  = 1;
                bbyte[0] = 0x53;
                bbyte[1] = 0x1A;
                BYTE rbbyte[512] = { 0 };
                memset(rbbyte, 0, 512);
                len = 512;

                r = device_SendDataCommandITP(bbyte, cmdlen, cmdData, cmdDataLen, rbbyte, &len);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    printf(">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Do device_SendDataCommand(), failed!\n");
                } else {
                    char str3[1024] = { 0 };
                    memset(str3, 0, 1024);
                    COMMON.convertBytesIntoHexStr(rbbyte, len, 0, str3);
                    printf("response code : %s\n", str3);
                }
                fflush(stdout);
            }
            break;
            case 6: {
                printf(">>6. Reboot Device\n");
                fflush(stdout);
                r = device_rebootDevice();
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getResponseCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Do device_rebootDevice(), failed! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Reboot Device Success!\n");
                }
                fflush(stdout);
            }
            break;
            case 7:
                printf(">>7. Set System Language\n");
                fflush(stdout);
                r = device_setSystemLanguage("EN");
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Set System Language Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Set System Language Succeeded\n");
                }
                fflush(stdout);
                break;
            case 8:
                if (device_getCurrentDeviceType() == IDT_DEVICE_SREDKEY2_HID) {
                    printf(">>8. Change to KB mode\n");
                    fflush(stdout);
                    BYTE bbyte[2]  = { 0x00 };
                    int cmdlen     = 2;
                    BYTE cmdData[] = { 0x38 };
                    int cmdDataLen = 1;
                    bbyte[0] = 0x53;
                    bbyte[1] = 0x23;
                    BYTE rbbyte[512] = { 0 };
                    memset(rbbyte, 0, 512);
                    len = 512;
                    r   = device_SendDataCommandITP(bbyte, cmdlen, cmdData, cmdDataLen, rbbyte, &len);
                    if (r != RETURN_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        printf(">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Change to KB mode failed!\n");
                    } else {
                        printf("Change to KB mode succeeded\n");
                    }
                    fflush(stdout);
                } else {
                    printf(">>8. Change to HID mode\n");
                    fflush(stdout);
                    BYTE bbyte[2]  = { 0x00 };
                    int cmdlen     = 2;
                    BYTE cmdData[] = { 0x30 };
                    int cmdDataLen = 1;
                    bbyte[0] = 0x53;
                    bbyte[1] = 0x23;
                    BYTE rbbyte[512] = { 0 };
                    memset(rbbyte, 0, 512);
                    len = 512;

                    r = device_SendDataCommandITP(bbyte, cmdlen, cmdData, cmdDataLen, rbbyte, &len);
                    if (r != RETURN_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        printf(">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Change to KB mode failed!\n");
                    } else {
                        printf("Change to KB mode succeeded\n");
                    }
                    fflush(stdout);
                }
                break;
            case 0:
                printf(">>0.Back To Main Menu\n");
                fflush(stdout);
                break;
        }
    } while (choice != 0);
    if (choice == 0) {
//        idtech_process.pProcess_function_list();
        return;
    }
} /* _SREDKey2_process_device */

void
_SREDKey2_display_device_menu() {
    idtech_display_menu_from_lib.pDisplay_Menu_current = _SREDKey2_display_device_menu;

    printf("\t\t********** Device Options [SREDKey2]***********\n");
    printf("\t\t0.  Back To Main Menu\n");
    printf("\t\t1.  Get Firmware Version\n");
    printf("\t\t2.  Send IDG Command: 0x29, 0x00\n");
    printf("\t\t3.  Get Key Status\n");
    printf("\t\t4.  Send NGA Command 784631\n");
    printf("\t\t5.  Send ITP Command 531A\n");
    printf("\t\t6.  Reboot Device\n");
    printf("\t\t7.  Set System Language\n");
    if (device_getCurrentDeviceType() == IDT_DEVICE_SREDKEY2_HID) {
        printf("\t\t8.  Change to KB mode\n");
    } else {
        printf("\t\t8.  Change to HID mode\n");
    }
    printf("\t\t************************************************\n");
    fflush(stdout);
}
