#include <stdio.h>
#include <string.h>
#include "demo_common.h"

IDT_COMMON_PROCESS COMMON;
extern IDT_PROCESS idtech_process;
extern IDT_DEMO_LIB_DISPLAY_MENU idtech_display_menu_from_lib;

void
_SREDKey2_display_config_menu();

void
_SREDKey2_process_config() {
    int choice;
    int r = 0;
    char str1[256] = { 0 };

    memset(str1, 0, 256);
    do {
        _SREDKey2_display_config_menu();
        choice = COMMON.inputSelection();
        switch (choice) {
            case 1:
                printf(">>1. Get Model Number\n");
                fflush(stdout);
                r = config_getModelNumber(str1);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getResponseCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Get Model Number Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    char str2[200] = { 0 };
                    sprintf(str2, "Model Number: %s\n", str1);
                    printf(str2);
                }
                fflush(stdout);
                break;
            case 2: {
                printf(">>2. Get Serial Number\n");
                fflush(stdout);
                r = config_getSerialNumber(str1);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Get Serial Number Failed!\n");
                } else {
                    char str2[200] = { 0 };
                    sprintf(str2, "Serial Number: %s\n", str1);
                    printf(str2);
                }
                fflush(stdout);
            }
            break;
            case 0:
                printf(">>0. Back To Main Menu\n");
                fflush(stdout);
                break;
        }
    } while (choice != 0);
    if (choice == 0) {
//        idtech_process.pProcess_function_list();
        return;
    }
} /* _SREDKey2_process_config */

void
_SREDKey2_display_config_menu() {
    idtech_display_menu_from_lib.pDisplay_Menu_current = _SREDKey2_display_config_menu;
    printf("\t\t********* Config Options [SREDKey2]**********\n");
    printf("\t\t0.  Back To Main Menu\n");
    printf("\t\t1.  Get Model Number\n");
    printf("\t\t2.  Get Serial Number\n");
    printf("\t\t************************************************\n");
    fflush(stdout);
}
