#include <stdio.h>
#include <string.h>
#include "demo_common.h"

extern IDT_DEMO_LIB_DISPLAY_MENU idtech_display_menu_from_lib;
int pinFinished = 0;
void
printPINData(IDTPINData * pinData);
char *
getKeyPressed(BYTE * keyCode);

void
PIN_callBack(int type, IDTPINData * pinData) {
    printf("\nPIN Callback\n");
    switch (type) {
        case PIN_callBack_type_ERR:
            printf("Callback PIN Error\n");
            break;
        case PIN_callBack_type_Cancelled:
            printf("Callback PIN Cancelled\n");
            break;
        case PIN_callBack_type_RETURN_CODE:
            printPINData(pinData);
            break;
        case PIN_callBack_type_TIMEOUT:
            printf("PIN Callback Timeout\n");
            break;
        case PIN_callBack_type_ERR_CODE:
            printf("Error Code: %04X\n", pinData->errorCode);
            break;
        case PIN_callBack_type_KEY_INPUT:
            if (pinData->functionKeyCode[0] != 0) {
                printf("Key Pressed: ");
                if (pinData->functionKeyCode[1] != 0) {
                    printf("%c%c", pinData->functionKeyCode[0], pinData->functionKeyCode[1]);
                } else {
                    printf("%c", pinData->functionKeyCode[0]);
                }
            } else {
                if (pinData->functionKey[0] != 0) {
                    printf("%s", getKeyPressed(pinData->functionKey));
                    fflush(stdout);
                } else {
                    if (pinData->keyStringLen == 0) {
                        printf("Key Pressed\n");
                        pinFinished = 1;
                        return;
                    } else {
                        printf("Keys Entered: %s\n", pinData->keyString);
                    }
                }
            }
            printf("\n");
            break;
        default:
            break;
    }
    fflush(stdout);
    pinFinished = 1;
    #ifndef WIN32
    if (idtech_display_menu_from_lib.pDisplay_Menu_current) {
        idtech_display_menu_from_lib.pDisplay_Menu_current();
        printf("Please Input your Selection. (0 - exit current menu)\n");
    }
    #endif
} /* PIN_callBack */

void
printPINData(IDTPINData * pinData) {
    if (device_getCurrentDeviceType() == IDT_DEVICE_VP8800) {
        printf("Man. Captured Initial Vector: ");
        printData(pinData->InitVector, pinData->InitVectorLen, 0);
        printf("Man. Captured KSN: ");
        printData(pinData->KSN, pinData->KSNLen, 0);
        printf("Man. Captured Encrypted PAN: ");
        printData(pinData->PAN, pinData->PANLen, 0);
        printf("Man. Captured Encrypted Expiry: ");
        printData(pinData->ExpiryDate, pinData->ExpiryDateLen, 0);
        printf("Man. Captured Encrypted CSC: ");
        printData(pinData->CSC, pinData->CSCLen, 0);
        printf("PAN First Digits: ");
        printData(pinData->FirstPANDigits, pinData->FirstPANDigitsLen, 1);
        printf("PAN Last Digits: ");
        printData(pinData->LastPANDigits, pinData->LastPANDigitsLen, 1);
        printf("Man. Captured MAC: ");
        printData(pinData->MACValue, pinData->MACValueLen, 0);
        printf("Man. Captured MAC KSN: ");
        printData(pinData->MACKSN, pinData->MACKSNLen, 0);

        if (pinData->MACStatus & 0x02 == 0x02) {
            printf("Encryption Type: TDES\n");
        } else {
            printf("Encryption Type: AES\n");
        }
    } else if (device_getCurrentDeviceType() == IDT_DEVICE_L100 ||
        device_getCurrentDeviceType() == IDT_DEVICE_L80 ||
        device_getL100PassThroughMode() == 1) {
        printf("Encrypted PIN Data: ");
        printData(pinData->PIN, pinData->PINLen, 0);
    } else {
        printf("KSN: ");
        printData(pinData->KSN, pinData->KSNLen, 0);
        printf("PIN Block Data: ");
        printData(pinData->pinBlockData, pinData->pinBlockLen, 0);
    }
} /* printPINData */

char *
getKeyPressed(BYTE * keyCode) {
    if (keyCode == NULL) {
        return "";
    }
    BYTE keys[][4] = {
        { 0x02, 0x02, 0x5B, 0x2F }, // Cancel
        { 0x02, 0x03, 0x4B, 0x0E }  // Enter
    };
    int i;
    for (i = 0; i < 2; i++) {
        if (!memcmp(keyCode, keys[i], 4)) {
            break;
        }
    }
    switch (i) {
        case 0:
            return "Cancel Key Pressed";

        case 1:
            return "Enter Key Pressed";

        default:
            return "";
    }
}

void
set_pin_Finished(int auto_Finished) {
    pinFinished = auto_Finished;
}

int
get_pin_Finished() {
    return pinFinished;
}
