#include <stdio.h>
#include <string.h>
#include "demo_common.h"
#include "LanguageInfo.h"

#if defined(WIN32) || defined(__MACH__)
EXPORT_SYMBOLS int ctls_language = 0;
#else
SHARED_SYMBOLS int ctls_language;
#endif

//extern IDT_DEMO_LIB_DISPLAY_MENU idtech_display_menu_from_lib;

void
printLCDItem(IDTLCDItem * lcdItem);
void
printAsyncLCDMessage(IDTLCDItem * lcdItem);

void
LCD_callBack(int type, IDTLCDItem * lcdItem) {
    printf("\nLCD Callback\n");
    switch (type) {
        case LCD_callBack_type_LCD_EVENT:
            printLCDItem(lcdItem);
            break;
        case LCD_callBack_type_ASYNC_LCD_MESSAGE:
            printAsyncLCDMessage(lcdItem);
            break;
        default:
            break;
    }
    fflush(stdout);
} /* LCD_callBack */

void
printLCDItem(IDTLCDItem * lcdItem) {
    printf("Screen Name: %s\n", lcdItem->screenName);
    printf("Screen ID: %d\n", lcdItem->screenID);
    printf("Object Name: %s\n", lcdItem->objectName);
    printf("Object ID: %d\n", lcdItem->objectID);
    int compID = (lcdItem->objectID >> 8) & 0xFF;
    if (compID > 0 && compID < 4) {
        printf("Long Pressed: %d\n", lcdItem->longPressed);
    }
}

void
printAsyncLCDMessage(IDTLCDItem * lcdItem) {
    //	printf("cardData Len: %d\ncardData:\n",cardData->cardDataLen);
    //	printData(cardData->cardData, cardData->cardDataLen, 0);

    char * text[2] = { 0 };
    int lines      = 0;

    retrieveCTLSMessage(lcdItem->asyncLCDMessage[3], ctls_language, lcdItem->asyncLCDMessage[6], text, &lines);

    int i;
    printf("[");
    for (i = 0; i < lines; i++) {
        if (i == lines - 1) {
            printf("%s]\n", text[i]);
        } else {
            printf("%s\n", text[i]);
        }
    }
}
