/*
 * Terminal_KBInputControl.c
 *
 *  Created on: Jul 12, 2016
 *      Author: Eric
 */
#include <time.h>
#include "Terminal_KBInputControl.h"
#include <stdio.h>
#ifdef WIN32
# include <conio.h>
#else
# include <termios.h>
#endif
#include <unistd.h>
#include <fcntl.h>

int mode   = 0;
int * prev = NULL;

#ifndef WIN32
int
kbhit(void) {
    struct termios oldt, newt;
    int ch;
    int oldf;

    tcgetattr(STDIN_FILENO, &oldt);
    newt          = oldt;
    newt.c_lflag &= ~(ICANON | ECHO);
    tcsetattr(STDIN_FILENO, TCSANOW, &newt);
    oldf = fcntl(STDIN_FILENO, F_GETFL, 0);
    fcntl(STDIN_FILENO, F_SETFL, oldf | O_NONBLOCK);
    ch = getchar();
    tcsetattr(STDIN_FILENO, TCSANOW, &oldt);
    fcntl(STDIN_FILENO, F_SETFL, oldf);
    if (mode == 0) {
        if (ch != EOF) {
            ungetc(ch, stdin);
            # ifdef __linux
            printf("%c", (char) ch);
            # endif
            return 1;
        }
        return 0;
    } else {
        if (ch != EOF) {
            if (ch == 0x0A || ch == 0x0D) {
                if (*prev == 0x0A || *prev == 0x0D || *prev == 0) {
                    *prev = ch;
                    return 0;
                } else {
                    *prev = ch;
                    ungetc(ch, stdin);
                    # ifdef __linux
                    printf("%c", (char) ch);
                    # endif
                    return 1;
                }
            } else {
                *prev = ch;
                ungetc(ch, stdin);
                # ifdef __linux
                printf("%c", (char) ch);
                # endif
                return 1;
            }
        }
        *prev = ch;
        return 0;
    }
} /* kbhit */

int
kbhit(void);
#endif /* ifndef WIN32 */
int
waitInputfor(int waitingSeconds) {
    clock_t t0, dt;

    //	int flag;

    t0 = clock();
    //	flag = 1;
    printf("Please input your selection:\n");
    fflush(stdout);
    mode = 0;
    prev = NULL;
    //	while( !kbhit() ) {
    while (!kbhit()) {
        dt = clock() - t0;
        if (dt >= waitingSeconds * CLOCKS_PER_SEC) {
            //			 flag =0;
            printf("Timeout, (%d S) !\n", waitingSeconds);
            printf("Default to first selection\n");
            fflush(stdout);
            return 1;
        }
    }
    //	scanf("%d",&x); printf("Selected item: %d\n",x);
    //	return x;

    char buffer[50];
    char * str = fgets(buffer, sizeof(buffer), stdin);
    if (str != NULL) {
        //		printf("%s\n", str);
        //		if (str[0] == 'c' || str[0] == 'C')
        //			return -1;
        char * end;
        long num = strtol(str, &end, 10);
        if (str != end) {
            return (int) num;
        }
    } else   {
        return 1;
    }

    return 1;
} /* waitInputfor */

int
waitInputforPIN(EMV_Callback * emvCallbackInfo, char * strPIN) {
    clock_t t0, dt;

    //	int flag;

    t0 = clock();
    //	flag = 1;
    //	printf("Please input your selection:\n");
    fflush(stdout);
    int iPrev = 0;
    mode = 1;
    prev = &iPrev;
    //	while( !kbhit_nonempty(&prev) ) {
    while (!kbhit() ) {
        dt = clock() - t0;
        if (dt >= emvCallbackInfo->pin_entryStartTimeout * CLOCKS_PER_SEC) {
            //			 flag =0;
            printf("Timeout, (%d S) !\n", emvCallbackInfo->pin_entryStartTimeout);
            //			 printf("Default to first selection\n");
            fflush(stdout);
            return 1;
        }
    }
    //	scanf("%d",&x); printf("Selected item: %d\n",x);
    //	return x;

    char buffer[50];
    char * str = fgets(buffer, sizeof(buffer), stdin);
    if (str != NULL) {
        int i;
        for (i = 0; i < 50; i++) {
            if (str[i] == '\r' || str[i] == '\n') {
                str[i] = '\0';
                break;
            }
        }
        strcpy(strPIN, str);
        return 0;
        //		char *end;
        //		long num = strtol(str, &end, 10);
        //		if (str != end)
        //			return;
    } else {
        return 1;
    }

    //	return;
} /* waitInputforPIN */
