/*
 * LanguageInfo.h
 *
 *  Created on: Jul 11, 2016
 *      Author: Eric
 */

#ifndef LANGUAGEINFO_H_
#define LANGUAGEINFO_H_
#include "IDTDef.h"


enum DeviceTerminalInfo {
    // const message ID
    MSC_ID_PROCESS_WAIT         = 0x11,
    MSC_ID_WELCOME              = 0x23,
    MSC_ID_AMOUNT               = 0x01,
    MSC_ID_AMOUNT_OTHER         = 0x24,
    MSC_ID_CANCELLED            = 0x21,
    MSC_ID_CANCEL_OR_ENTER      = 0x05,
    MSC_ID_ENTER_AMOUNT         = 0x08,
    MSC_ID_ENTER_AMOUNT_OTHER   = 0x25,
    MSC_ID_ENTER_PIN            = 0x09,
    MSC_ID_SWIPE_OR_INSERT      = 0x0B,
    MSC_ID_TIME_OUT             = 0x19,
    MSC_ID_TERMINATE            = 0x17,
    MSC_ID_USE_CHIP_READER      = 0x0E,
    MSC_ID_APPROVED             = 0x03,
    MSC_ID_TRY_AGAIN            = 0x14,
    MSC_ID_CAPK_HASH_VALUE_FAIL = 0x26,
};


void
setLanguage(char * language);
char *
getDisplayMessageByID(int id);
char *
getLanguageCode(char * sLanguage);
char *
getDisplayMessage(char * language, int id);
void
retrieveCTLSMessage(BYTE scheme, int language, BYTE id, char * text[], int * lines);
#endif /* LANGUAGEINFO_H_ */
