/*
 * Copyright (C) ID TECH.
 *
 * Author: Eric
 *
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "demo_common.h"
#ifndef WIN32
# include <dlfcn.h>
#endif
#include "libIDT_Device.h"
#include <pthread.h>

#include <stdlib.h>

#ifdef WIN32
/* See http://stackoverflow.com/questions/12765743/getaddrinfo-on-win32 */
# ifndef _WIN32_WINNT
#  define _WIN32_WINNT 0x0501 /* Windows XP. */
# endif
# include <winsock2.h>
//  #include <Ws2tcpip.h>
#else
# ifndef NEO2
/* Assume that any non-Windows platform uses POSIX-style sockets instead. */
#  include <sys/socket.h>
#  include <netinet/in.h>
#  include <sys/types.h>
#  include <arpa/inet.h>
#  include <netdb.h>  /* Needed for getaddrinfo() and freeaddrinfo() */
#  include <unistd.h> /* Needed for close() */
#  include <sys/ioctl.h>
# endif
#endif /* ifdef WIN32 */

void
display_main_menu();
void
display_main_menuVP();
void
process_interface_select();
void
process_interface_selectVP();

extern int
inputSelection();
#ifndef WIN32
//extern int level;
#endif

SHARED_SYMBOLS int connectionMode;

// SHARED_SYMBOLS int client_sockfd;
// SHARED_SYMBOLS int server_sockfd;
// SHARED_SYMBOLS int server_io_sockfd;

int
main(int argc, char * argv[]) {
    int r = 0;
    int i = 0;
    char logLevel[100];

    memset(logLevel, 0, 100);
    char outputType[100];
    memset(outputType, 0, 100);
    char * version = SDK_Version();

//    int level = 0;

    if (argc > 1) {
        byte loglvl[1];
        loglvl[0] = 0x00;
        byte outType[1];
        outType[0] = 0x00;
        sprintf(logLevel, "%s", argv[1]);
        convertHexStringToBytes(logLevel, loglvl, 1);
//        level = atoi(logLevel);
        int type = 0;
        if (argc > 2) {
            sprintf(outputType, "%s", argv[2]);
            convertHexStringToBytes(outputType, outType, 1);
            type = atoi(outputType);
        }
        //		enableLogging(level);
        IDT_EnableLogging(loglvl[0], type);
    }
    printf("SDK version: %s\n", version);

    printf("Thread Stack Size %d\n", device_getThreadStackSize());

    //	IDT_EnableLogging(0x10, 0);

    // open main menu to select usb or rs232
    #ifdef PISCES
    process_interface_selectVP();
    return 0;

    #else
    process_interface_select();
    return 0;

    #endif
} /* main */

void
process_interface_select() {
    int choice;

    // Get The Device Type
    int deviceType = IDT_DEVICE_UNKNOWN;

    //	int loopOkay = 0;
    do {
        display_main_menu();

        choice = inputSelection();

        if (choice == 0) {
            //			if (isUSB)
            //				process_exit();
            printf("Application Exit.\n");
            fflush(stdout);
            return;
        } else if (choice == 1)   { // usb
            usb_init();
            connectionMode = 1;
            //			break;
        } else if (choice == 2)   { // rs232
            rs232_init();
            connectionMode = 2;
            //			break;
        }
        //		else if (choice == 3)  //tcpip
        //		{
        //			tcpip_init();
        //			connectionMode = 3;
        ////			break;
        //		}
        //		else if (choice == 4)
        //		{
        //			char libraryPath[512] = {0};
        //
        //			libraryPathSelection(libraryPath);
        //
        //			if (strlen(libraryPath) > 1) {
        //				setAbsoluteLibraryPath(libraryPath);
        //				printf(">>  Library path set.\n\n");
        //			} else
        //				printf(">>  Library path not set.\n\n");
        //		}

        //		if(1==loopOkay)break;
    } while (choice != 0);
    //	if(loopOkay==1)
    //	{
    //		init_demo_lib(deviceType);
    //	}
} /* process_interface_select */

void
process_interface_selectVP() {
    int choice;

    // Get The Device Type
    int deviceType = IDT_DEVICE_UNKNOWN;

    //	int loopOkay = 0;
    do {
        display_main_menu();

        choice = inputSelection();

        if (choice == 0) {
            return;
        } else if (choice == 1)   { // usb
            usb_init();
            connectionMode = 1;
        }
        //		else if (choice == 2)
        //		{
        //			char libraryPath[512] = {0};
        //
        //			libraryPathSelection(libraryPath);
        //
        //			if (strlen(libraryPath) > 1) {
        //				setAbsoluteLibraryPath(libraryPath);
        //				printf(">>  Library path set.\n\n");
        //			} else
        //				printf(">>  Library path not set.\n\n");
        //		}
    } while (choice != 0);
}

void
display_main_menu() {
    #ifdef PISCES
    display_main_menuVP();
    return;

    #endif
    printf("\t\t************************************************\n");
    printf("\t\t*********** IDT Universal SDK ******************\n");
    printf("\t\t******* Interface Select Options ***************\n");
    printf("\t\t0.  Exit\n");
    printf("\t\t1.  USB\n");
    printf("\t\t2.  RS232\n");
    //	printf("\t\t3.  TCPIP\n");
    //	printf("\t\t4.  Set Library Path\n");
    printf("\t\t************************************************\n");
    //	idtech_display_menu_from_lib.pDisplay_Menu_current = display_main_menu;
    fflush(stdout);
}

void
display_main_menuVP() {
    printf("\t\t*****************************************\n");
    printf("\t\t********* IDTech VP8800 Library *********\n");
    printf("\t\t**************** Options ****************\n");
    printf("\t\t0.  Exit\n");
    printf("\t\t1.  Initialize VP8800 Communication\n");
    //	printf("\t\t2.  Set Library Path\n");
    printf("\t\t************************************************\n");
    //	idtech_display_menu_from_lib.pDisplay_Menu_current = display_main_menu;
    fflush(stdout);
}

// void process_exit()
// {
//	device_close();
//
////	printf("Application Exit.\n");
////	fflush(stdout);
// }
