/**
 *  \mainpage libpos API Reference
 *
 *  \section objects POS objects
 *
 */


#ifndef __LIBDEMO_PIP_READER_C___
#define __LIBDEMO_PIP_READER_C___

#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <memory.h>
#include "libDemo_PipReader.h"
#ifndef WIN32
# include <dlfcn.h>
#endif

// PipReader process
extern void
_PipReader_process_function_list();
extern void
_PipReader_process_device();
extern void
_PipReader_process_ctls();

extern void
_PipReader_display_ctls_menu();
extern void
_PipReader_display_device_menu();

IDT_COMMON_PROCESS COMMON;
IDT_PROCESS idtech_process;
IDT_DEMO_LIB_DISPLAY_MENU idtech_display_menu_from_lib;

void
IDT_PROCESS_clean() {
    idtech_process.pProcess_function_list = NULL;
    idtech_process.pProcess_device        = NULL;
    idtech_process.pProcess_config        = NULL;
    idtech_process.pProcess_msr = NULL;
    idtech_process.pProcess_icc = NULL;
    idtech_process.pProcess_emv = NULL;
    idtech_process.pProcess_pin = NULL;
}

void
libDemo_getMenuFn(IDT_DEMO_LIB_DISPLAY_MENU * _idtech_display_menu_from_lib) {
    *_idtech_display_menu_from_lib = idtech_display_menu_from_lib;
}

void
libDemo_init(IDT_COMMON_PROCESS _demo_Common_Process, IDT_DEMO_LIB_DISPLAY_MENU * _idtech_display_menu_from_lib) {
    COMMON = _demo_Common_Process;
    // intialize the process function
    IDT_PROCESS_clean();
    idtech_process.pProcess_function_list = _PipReader_process_function_list;
    idtech_process.pProcess_device        = _PipReader_process_device;
    idtech_process.pProcess_ctls = _PipReader_process_ctls;

    // intialize the display menu callback
    //	idtech_display_menu_from_lib.pDisplay_Menu_ctls = _PipReader_display_device_menu;//_PipReader_display_ctls_menu;
    idtech_display_menu_from_lib = *_idtech_display_menu_from_lib;

    idtech_display_menu_from_lib.pDisplay_Menu_ctls   = _PipReader_display_ctls_menu;
    idtech_display_menu_from_lib.pDisplay_Menu_device = _PipReader_display_device_menu;
    *_idtech_display_menu_from_lib = idtech_display_menu_from_lib;
    // into the function menu selection
    idtech_process.pProcess_function_list();
}

#endif /* ifndef __LIBDEMO_PIP_READER_C___ */
