#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "demo_common.h"

EXPORT_SYMBOLS IDT_COMMON_PROCESS COMMON;
EXPORT_SYMBOLS IDT_PROCESS idtech_process;

EXPORT_SYMBOLS IDT_DEMO_LIB_DISPLAY_MENU idtech_display_menu_from_lib;

void
_PipReader_display_ctls_menu();

void
_PipReader_process_ctls() {
    int choice;
    BYTE resData[_DATA_BUF_LEN];
    int resLen;
    int r;

    //	BYTE TAGS[] ={0x9F, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9C, 0x01, 0x00, 0x9F, 0x03, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    //	BYTE TAGS[] ={0x9F, 0x02, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    //	int tagsLen = 21;

    do {
        _PipReader_display_ctls_menu();
        //		printf("Please Input your Selection:\n");
        //		scanf("%d",&choice);
        choice = COMMON.inputSelection();
        switch (choice) {
            case 1: {
                printf(">>1. Start Mifare/VAS/SmartTap Transaction\n");
                fflush(stdout);
                BYTE tlv1[200];
                int tlvLen1 = 200;
                char * str1 =
                  "ffee0e08dfed3a0401030709FFEE080ADFEF1A010aDFED280100FFEE06189F220201009F2604000000029F2B050100000000DF010101";
                COMMON.convertHStrIntoHex(str1, tlv1, &tlvLen1);
                r = ctls_startTransaction(1.00, 0.00, 0, 30, tlv1, tlvLen1); // default
                //			r = ctls_activateTransaction(30, tlv1, tlvLen1);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS && r != 0x23) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Do ctls_activateTransaction(), failed!! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                        strErr);
                    fflush(stdout);
                } else {
                    printf("Activate Mifare/VAS/SmartTap Transaction Succeeded\n");
                    printf("Please Tap Card...\n");
                }
                fflush(stdout);
            }
            break;
            case 2:
                printf(">>2. Cancel CTLS\n");
                fflush(stdout);
                r = ctls_cancelTransaction();
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Cancel CTLS Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("CTLS Cancel CTLS command sent successfully\n");
                }
                fflush(stdout);
                break;
            case 3: {
                printf(">>3. Get Terminal Data\n");
                fflush(stdout);
                BYTE data[_DATA_BUF_LEN];
                int dataLen = _DATA_BUF_LEN;
                r = ctls_retrieveTerminalData(data, &dataLen);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Retrieve Terminal Data failed!! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                        strErr);
                    fflush(stdout);
                    break;
                }
                printf(">>Retrieve Terminal Data:\n");
                COMMON.printBytes(data, dataLen);
                COMMON.printTLV(data, dataLen);
            }
            break;
            case 4: {
                printf(">>4. Set Terminal Data\n");
                fflush(stdout);
                BYTE tlv16[_DATA_BUF_LEN * 2];
                int tlvlen16 = _DATA_BUF_LEN * 2;
                //				BYTE tlv16[2000];
                //				int tlvlen16 =2000;
                //				char * terminalstr ="ffe40100df7c0100df7d0100df7503003000df6a01019f5801039f5903dc80009f5a01009f5e02e0009f5f060000000080009f5d06000000005000df2a06000000005000df2b0132df2c010adf630100df640100df650100df660100fff003020000fff30207fffff90103fffa020000df5101809f0106000000000000df680100df7f0100df2601019c01005f2a0208405f3601029f090200029f1a0208409f1b04000017709f33030008e89f3501229f400560000030009f660480004000fff106000000010000fff403000601fff506000000008000fff80100fffb0100fffc0101fffd05f850acf800fffe05f850aca000ffff0500000000009f15020000df28030008e8df29030068e89f6d0200019f7c140000000000000000000000000000000000000000fff20830303030303030309f4e1e0000000000000000000000000000000000000000000000000000000000009f5301009f03060000000000009f02060000000000019f1c0800000000000000009f160f000000000000000000000000000000ffee1d0404042a0cffee1e01019f410400000000df891b0101fff701009a031608129f21030339139700";

                //				char * terminalstr ="ffe40100df7c0100df7503003000df6a01019f5801039f5903dc80009f5a01009f5e02e0009f5f060000000080009f5d06000000005000df2a06000000005000df2b0132df2c010adf630100df640100df650100df660100fff003020000fff30207fffff90103fffa020000df5101809f0106000000000000df680100df7f0100df2601019c01005f2a0208409f090200029f1a0208409f1b04000017709f660480004000fff106000000010000fff403000601fff506000000008000fff80100fffb0100fffc0101fffd05f850acf800fffe05f850aca000ffff050000000000df28030008e8df29030068e89f6d0200019f7c1400000000000000000000000000000000000000009f5301009f03060000000000009f0206000000000001ffee1d0504042a0c319f410400000000dfef360400000000dfef4b031200009700df7d0100fff2085465726d696e616c9f4e2231303732312057616c6b65722053742e20437970726573732c204341202c5553412edf1008656e667265737a68df110100df270100dfee150101dfee160100dfee170107dfee180180dfee1e08d0dc20d0c41e1400dfee1f0180dfee1b083030303135313030dfee20013cdfee21010adfee2203323c3c9f33030008e89f3501229f400560000030009f150200009f1c0800000000000000009f160f0000000000000000000000000000005f360102fff70100ffee1e0102df891b01019a030101259f2103165337";

                //				char * terminalstr ="FFE40100DF7C0100DF7D0100DF7503003000DF6A01019F5801039F5903DC80009F5A01009F5E02E0009F5F060000000080009F5D06000000005000DF2A06000000005000DF2B0132DF2C010ADF630100DF640100DF650100DF660100FFF003020000FFF30207FFFFF90103FFFA0200009F0106000000000000DF680100DF7F0100DF2601019C01005F2A0208405F3601029F090200029F1A0208409F1B04000017709F33030008E89F3501229F400560000030009F660480004000FFF106000000010000FFF403000601FFF506000000008000FFF80100FFFB0100FFFC0101FFFD05F850ACF800FFFE05F850ACA000FFFF0500000000009F15020000DF28030008E8DF29030068E89F6D0200019F7C140000000000000000000000000000000000000000FFF20830303030303030309F4E1E0000000000000000000000000000000000000000000000000000000000009F5301009F03060000000000009F02060000000000019F1C0800000000000000009F160F000000000000000000000000000000FFEE1D0404042A0CFFEE1E0101DF5102C000FFF701009F410400000007DF891B01009A030101019F2103000000";

                char * terminalstr =
                  "5F368201ff5F3601029F3501219F33036028C89F4005F000F0A0019F1E085465726D696E616C9F150212349F160F3030303030303030303030303030309F1C0838373635343332319F4E2231303732312057616C6B65722053742E20437970726573732C204341202C5553412EDF260101DF1008656E667265737A68DF110100DF270100D5F3601029F3501219F33036028C89F4005F000F0A0019F1E085465726D696E616C9F150212349F160F3030303030303030303030303030309F1C0838373635343332319F4E2231303732312057616C6B65722053742E20437970726573732C204341202C5553412EDF260101DF1008656E667265737A68DF110100DF270100D5F3601029F3501219F33036028C89F4005F000F0A0019F1E085465726D696E616C9F150212349F160F3030303030303030303030303030309F1C0838373635343332319F4E2231303732312057616C6B65722053742E20437970726573732C204341202C5553412EDF260101DF1008656E667265737A68DF110100DF270100D5F3601029F3501219F33036028C89F4005F000F0A0019F1E085465726D696E616C9F150212349F160F3030303030303030303030303030309F1C0838373635343332319F4E2231303732312057616C6B65722053742E20437970726573732C204341202C5553412EDF260101DF1008656E667265737A68DF110100DF270100D22";

                //				char * terminalstr ="FFE40100DF7C0100DF7503003000DF6A01019F5801039F5903DC80009F5A01009F5E02E0009F5F060000000080009F5D06000000005000DF2A06000000005000DF2B0132DF2C010ADF630100DF640100DF650100DF660100FFF003020000FFF30207FFFFF90103FFFA020000DF5101809F0106000000000000DF680100DF7F0100DF2601019C01005F2A0208409F090200029F1A0208409F1B04000017709F660480004000FFF106000000010000FFF403000601FFF506000000008000FFF80100FFFB0100FFFC0101FFFD05F850ACF800FFFE05F850ACA000FFFF050000000000DF28030008E8DF29030068E89F6D0200019F7C1400000000000000000000000000000000000000009F5301009F03060000000000009F0206000000000001FFEE1D0504042A0C319F410400000000DFEF360400000000DFEF4B031200009700DF7D0100FFF2085465726D696E616C9F4E2231303732312057616C6B65722053742E20437970726573732C204341202C5553412EDF1008656E667265737A68DF110100DF270100DFEE150101DFEE160100DFEE170107DFEE180180DFEE1E08D0DC20D0C41E1400DFEE1F0180DFEE1B083030303135313030DFEE20013CDFEE21010ADFEE2203323C3C9F33030008E89F3501229F400560000030009F150200009F1C0800000000000000009F160F0000000000000000000000000000005F360102FFF70100FFEE1E0102DF891B01019A030101259F2103165337";

                //				char * terminalstr ="5F3601029F1A0208409F3501219F33036028C89F4005F000F0A0019F1E085465726D696E616C9F150212349F160F3030303030303030303030303030309F1C0838373635343332319F4E2231303732312057616C6B65722053742E20437970726573732C204341202C5553412EDF260101DF1008656E667265737A68DF110100DF270100DFEE150101DFEE160100DFEE170107DFEE180180DFEE1E08D0DC20D0C41E1400DFEE1F0180DFEE1B083030303135313030DFEE20013CDFEE21010ADFEE2203323C3C";
                //				char * terminalstr ="5F368201ff5F3601029F3501219F33036028C89F4005F000F0A0019F1E085465726D696E616C9F150212349F160F3030303030303030303030303030309F1C0838373635343332319F4E2231303732312057616C6B65722053742E20437970726573732C204341202C5553412EDF260101DF1008656E667265737A68DF110100DF270100D5F3601029F3501219F33036028C89F4005F000F0A0019F1E085465726D696E616C9F150212349F160F3030303030303030303030303030309F1C0838373635343332319F4E2231303732312057616C6B65722053742E20437970726573732C204341202C5553412EDF260101DF1008656E667265737A68DF110100DF270100D5F3601029F3501219F33036028C89F4005F000F0A0019F1E085465726D696E616C9F150212349F160F3030303030303030303030303030309F1C0838373635343332319F4E2231303732312057616C6B65722053742E20437970726573732C204341202C5553412EDF260101DF1008656E667265737A68DF110100DF270100D5F3601029F3501219F33036028C89F4005F000F0A0019F1E085465726D696E616C9F150212349F160F3030303030303030303030303030309F1C0838373635343332319F4E2231303732312057616C6B65722053742E20437970726573732C204341202C5553412EDF260101DF1008656E667265737A68DF110100DF270100D22";
                //				COMMON.convertHStrIntoHex(,tlv16,&tlvlterminalstren16);
                COMMON.convertHStrIntoHex(terminalstr, tlv16, &tlvlen16);
                r = ctls_setTerminalData(tlv16, tlvlen16);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n	----- save Terminal Data failed!! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                        strErr);
                    fflush(stdout);
                    break;
                } else {
                    printf(">>save Terminal Data success\n");
                    fflush(stdout);
                }
            }
            break;

            case 5: {
                printf(">>5. Get Config Group\n");
                fflush(stdout);

                BYTE tlv[_DATA_BUF_LEN * 2];
                int tlvLen = _DATA_BUF_LEN * 2;
                int group  = 0;
                r = ctls_getConfigurationGroup(group, tlv, &tlvLen);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n	----- Retrieve Config Group failed!! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                        strErr);
                    fflush(stdout);
                    break;
                }

                IDTTag tags[500];
                int tagCount = 500;
                printf(">>Get Config Group %d Succeeded:\n", group);

                TLV_getTags(tlv, tlvLen, tags, &tagCount);
                if (tagCount > 0) {
                    printf("Tags Count: %d\n", tagCount);
                    int i;
                    for (i = 0; i < tagCount; i++) {
                        int j;
                        for (j = 0; j < tags[i].tagLen; j++) {
                            printf("%02X", tags[i].Tag[j]);
                        }
                        printf(": ");
                        for (j = 0; j < tags[i].valueLen; j++) {
                            printf("%02X", tags[i].value[j]);
                        }
                        printf("\n");
                    }
                }
                printf("\n");
                fflush(stdout);
            }
            break;
            case 6: {
                printf(">>6. Set AppleVAS/SmartTap/Mifare Parameters\n");
                fflush(stdout);
                BYTE tlv6[128] = { 0 };
                int tlvlen6    = 128;
                char * ConfigurationGroup =
                  "FFE40100ffee0e08dfed3a0401030709FFEE080ADFEF1A010aDFED280100FFEE06189F220201009F2604000000029F2B050100000000DF010103";
                COMMON.convertHStrIntoHex(ConfigurationGroup, tlv6, &tlvlen6);
                r = ctls_setConfigurationGroup(tlv6, tlvlen6);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n	----- Set AppleVAS/SmartTap/Mifare Parameters failed!! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                        strErr);
                    fflush(stdout);
                    break;
                } else {
                    printf(">>Set AppleVAS/SmartTap/Mifare Parameters success\n");
                    fflush(stdout);
                }
            }
            break;

            case 7: {
                printf(">>7. Show ApplePay VAS Tags \n");
                printf("\tSend the following tags with startTranasction to utilize ApplePay VAS\r\n\r\n");

                printf("\tApplePay VAS OR ApplePay\r\n");
                printf("\tFFEE06189F220201009F2604000000009F2B050100000000DF010101\r\n\r\n");
                printf("\tApplePay VAS AND ApplePay\r\n");
                printf("\tFFEE06189F220201009F2604000000019F2B050100000000DF010101\r\n\r\n");
                printf("\tApplePay VAS ONLY\r\n");
                printf("\tFFEE06189F220201009F2604000000029F2B050100000000DF010101\r\n\r\n");
                printf("\tApplePay ONLY\r\n");
                printf("\tFFEE06189F220201009F2604000000039F2B050100000000DF010101\r\n\r\n");
                fflush(stdout);
            }
            break;

            case 0:
                if (isMSRBusy) {
                    printf("CTLS Busy\n");
                    choice = -1;
                } else {
                    printf(">>0. Back To Main Menu\n");
                }
                fflush(stdout);
                break;
        }
    } while (choice != 0);
    // #ifdef WIN32
    if (choice == 0) {
//        idtech_process.pProcess_function_list();
        return;
    }
    // #endif
} /* _PipReader_process_ctls */

void
_PipReader_display_ctls_menu() {
    idtech_display_menu_from_lib.pDisplay_Menu_current = _PipReader_display_ctls_menu;
    printf("\t\t********** CTLS Options [Pip Reader] **********\n");
    printf("\t\t0.  Back To Main Menu\n");
    printf("\t\t1.  Start Mifare/VAS/SmartTap Trans\n");
    printf("\t\t2.  Cancel CTLS Trans\n");
    printf("\t\t3.  Get Terminal Data\n");
    printf("\t\t4.  Set Terminal Data\n");
    printf("\t\t5.  Get Config Group\n");
    printf("\t\t6.  Set AppleVAS/SmartTap/Mifare Parameters\n");
    printf("\t\t7.  Show ApplePay VAS Tags\n");
    printf("\t\t************************************************\n");
    fflush(stdout);
}
