/**
 *  \mainpage libpos API Reference
 *
 *  \section objects POS objects
 *
 */


#ifndef __LIBDEMO_NEO2_C___
#define __LIBDEMO_NEO2_C___

#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <memory.h>
#include "libDemo_NEO2.h"
// #include "demo_common.h"
#ifndef WIN32
# include <dlfcn.h>
#endif
// NEO2 process
extern void
_NEO2_process_function_list();
extern void
_NEO2_process_device();
extern void
_NEO2_process_ctls();
extern void
_NEO2_process_msr();
extern void
_NEO2_process_icc();
extern void
_NEO2_process_emv();
extern void
_NEO2_process_pin();
extern void
_NEO2_process_lcd();

extern void
_NEO2_display_ctls_menu();
extern void
_NEO2_display_device_menu();
extern void
_NEO2_display_msr_menu();
extern void
_NEO2_display_icc_menu();
extern void
_NEO2_display_emv_menu();
extern void
_NEO2_display_pin_menu();
extern void
_NEO2_display_lcd_menu();

IDT_COMMON_PROCESS COMMON;
IDT_PROCESS idtech_process;
IDT_DEMO_LIB_DISPLAY_MENU idtech_display_menu_from_lib;

void
IDT_PROCESS_clean() {
    idtech_process.pProcess_function_list = NULL;
    idtech_process.pProcess_device        = NULL;
    idtech_process.pProcess_config        = NULL;
    idtech_process.pProcess_msr = NULL;
    idtech_process.pProcess_icc = NULL;
    idtech_process.pProcess_emv = NULL;
    idtech_process.pProcess_pin = NULL;
    idtech_process.pProcess_lcd = NULL;
}

void
libDemo_getMenuFn(IDT_DEMO_LIB_DISPLAY_MENU * _idtech_display_menu_from_lib) {
    *_idtech_display_menu_from_lib = idtech_display_menu_from_lib;
}

void
libDemo_init(IDT_COMMON_PROCESS _demo_Common_Process, IDT_DEMO_LIB_DISPLAY_MENU * _idtech_display_menu_from_lib) {
    COMMON = _demo_Common_Process;
    // intialize the process function
    IDT_PROCESS_clean();
    idtech_process.pProcess_function_list = _NEO2_process_function_list;
    idtech_process.pProcess_device        = _NEO2_process_device;
    idtech_process.pProcess_ctls = _NEO2_process_ctls;
    idtech_process.pProcess_msr  = _NEO2_process_msr;
    idtech_process.pProcess_icc  = _NEO2_process_icc;
    idtech_process.pProcess_emv  = _NEO2_process_emv;
    idtech_process.pProcess_pin  = _NEO2_process_pin;
    idtech_process.pProcess_lcd  = _NEO2_process_lcd;

    // intialize the display menu callback
    //	idtech_display_menu_from_lib.pDisplay_Menu_ctls = _NEO2_display_device_menu;//_NEO2_display_ctls_menu;
    idtech_display_menu_from_lib = *_idtech_display_menu_from_lib;

    idtech_display_menu_from_lib.pDisplay_Menu_ctls   = _NEO2_display_ctls_menu;
    idtech_display_menu_from_lib.pDisplay_Menu_device = _NEO2_display_device_menu;
    idtech_display_menu_from_lib.pDisplay_Menu_msr    = _NEO2_display_msr_menu;
    idtech_display_menu_from_lib.pDisplay_Menu_icc    = _NEO2_display_icc_menu;
    idtech_display_menu_from_lib.pDisplay_Menu_emv    = _NEO2_display_emv_menu;
    idtech_display_menu_from_lib.pDisplay_Menu_pin    = _NEO2_display_pin_menu;
    idtech_display_menu_from_lib.pDisplay_Menu_lcd    = _NEO2_display_lcd_menu;
    *_idtech_display_menu_from_lib = idtech_display_menu_from_lib;
    // into the function menu selection
    idtech_process.pProcess_function_list();
}

#endif /* ifndef __LIBDEMO_NEO2_C___ */
