#include <stdio.h>
#include <string.h>
#include "demo_common.h"

IDT_COMMON_PROCESS COMMON;
EXPORT_SYMBOLS IDT_PROCESS idtech_process;
EXPORT_SYMBOLS IDT_DEMO_LIB_DISPLAY_MENU idtech_display_menu_from_lib;

void
_NEO2_display_pin_menu();
void
_NEO2_process_pin() {
    int choice;
    int r = 0;

    //	char str1[256] = {0};
    //	memset(str1, 0 ,256);
    //	pin_registerCallBk(COMMON.PIN_callBack);
    do {
        _NEO2_display_pin_menu();
        choice = COMMON.inputSelection();
        switch (choice) {
            case 1:
                printf(">>1. Get Encrypted PIN\n");
                fflush(stdout);
                COMMON.set_pin_Finished(0);
                r = pin_capturePin(0, 0x11, "4111111111111111", 16, 4, 12, "ENTER PIN", 9); // default
                //			r = pin_capturePin(30, 0x11, "4111111111111111", 16, 4, 12, "ENTER PIN", 9);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Get Encrypted PIN Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                    fflush(stdout);
                    break;
                } else {
                    printf("Get Encrypted PIN Succeeded\n");
                    printf("Please Enter PIN on PIN Pad...\n");
                }
                fflush(stdout);
                //			while(COMMON.get_pin_Finished()==0) mssleep(500);  //enable this line to show the menu after the callback function is done.
                break;
            case 2: {
                printf(">>2. Prompt Key Input\n");
                fflush(stdout);

                int signaturelen = 256;
                BYTE signature[256];
                char * signatureStr =
                  "b6d80e9d7d5686c7010215e0bacf95dc7f1f5a38d806ac9fb81bfb2368fe2f8a036a4f5ac85e81c5d0313b6e5472cfed9b6e8fa02b95e2427693e0d0d271e9a3b1134f3f4c363e906e45f03a52937c59375ecb17b75565da9298639bf501efbe884618af13a10da8eadb73cdb74406d15c224fbc8e685b1a1c672664f1a8e089ad2ce67c69e84b5b6b5b94774105e871ef1e2a153591b19fbd9b3e5c9d45a44740339b09e250fd362030a726dd9a41784ed108e5b96c1b91164439890c7f2616293c97308f0eb7e43b2ce2ac8e09febc1a5b81a9568722b19a3b703249734298244bc5b47d32750956e56727e45a8bfa9c17ca7803245f8c8ee361864fb9e89e";

                COMMON.convertHStrIntoHex(signatureStr, signature, &signaturelen);

                r = pin_promptForNumericKeyWithSwipe(30, 0x12, 1, 16, "Please Swipe Or", 15, "Key Employee ID", 15,
                    signature, 256);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Prompt Key Entry Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Prompt Key Input Succeeded\n");
                    printf("Please Enter Key on Key Pad...\n");
                }
                fflush(stdout);
            }
            break;
            //		case 3:
            //		{
            //			printf(">>3. Prompt Amount Entry\n");
            //			fflush(stdout);
            //
            //			int signaturelen = 256;
            //			BYTE signature[256];
            //			char *signatureStr = "7d23bc58d7d9555d33ebf4cd8e7a19f867de213a82bc44dc94ac77b58b10e97a240f37480035bf7b08986c46f023e584f674dc60a2fe5ff6b0ee630cb4891c81d10a33edc5dc5cf3c7a409726fa96aeddfe63c4be87464a28bbf48a90fc5497ce7b0629d2717ccbb44c9c8a46b736e483d015679b060d7b1dea38e5966b50ab07100e736a12cb392acf32427b9607cc3d46ebc35464a6d27b7d7864a4d80fb93350c5b3b793e912aaca9f5dbbec8a8d571ea10654f94d6d19d0f4a54dd1da6ae71195785d495c67aabd3bc05a45c83da547fd74c46bbc4011b1c8af8b44c4bb185108465a08a31ab8ac69d47b09ca147dd1427651497f6b19cfa9bdb41e99ec0";
            //			COMMON.convertHStrIntoHex(signatureStr,signature,&signaturelen);
            //			r = pin_promptForAmount(30, 1, 12, "DEMO: Enter Amt.", 16, signature, 256);
            //			if ( r != RETURN_CODE_DO_SUCCESS ) {
            //				char strErr[200] = {0};
            //				memset(strErr, 0, 200);
            //				device_getResponseCodeString(r, strErr);
            //				printf(">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Prompt Amount Entry Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r, strErr);
            //			}
            //			else{
            //				printf("Prompt Amount Entry Succeeded\n");
            //				printf("Please Enter Amount on Key Pad...\n");
            //			}
            //			fflush(stdout);
            //		}
            //		break;
            //		case 3:
            //			printf(">>3. Get Function Key\n");
            //			fflush(stdout);
            //			r = pin_getFunctionKey(20);
            //			if ( r != RETURN_CODE_DO_SUCCESS ) {
            //				char strErr[200] = {0};
            //				memset(strErr, 0, 200);
            //				device_getResponseCodeString(r, strErr);
            //				printf(">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Get Function Key Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r, strErr);
            //			}
            //			else{
            //				printf("Get Function Key Succeeded\n");
            //				printf("Please Press the Function Key on Key Pad...\n");
            //			}
            //			fflush(stdout);
            //		break;
            case 3:
                printf(">>3. Cancel PIN Entry\n");
                fflush(stdout);
                r = pin_cancelPINEntry();
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Cancel PIN Entry Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("PIN Cancel PIN Succeeded\n");
                }
                fflush(stdout);
                break;
            case 4:
                printf(">>4. Send Beep\n");
                fflush(stdout);
                r = pin_sendBeep(0, 0);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Send Beep Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Send Beep Succeeded\n");
                }
                fflush(stdout);
                break;
            case 5:
                printf(">>5. Get PAN\n");
                fflush(stdout);
                r = pin_getPanEntry(0, 0, 0, 0, 0, 15, 1);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Get PAN Failed! ErrorCode: 0x%02x, Info: %s ----- \n",
                        r,
                        strErr);
                } else {
                    //				printf("Get PAN Succeeded\n");
                    printf("Please Enter PAN on Key Pad...\n");
                }
                fflush(stdout);
                break;
            case 6: {
                printf(">>6. Prompt Numeric Key Input\n");
                fflush(stdout);

                int signaturelen = 256;
                BYTE signature[256];
                char * signatureStr =
                  "67E889DC42150BD5E57BF221AAEB68707440FA1612AC78D64E5F04DB081E6ADE1C67B65DA52E0F1B51B464057AE8B2274980A57C4858C51BE371569BDD2F6D5B7FDB34FA2FE577E5E5CDB3CB74F3C5D70F3C12EA7AF7A78C6CD7A5D8861B325958E35F3C8F90D013F854A000A90FD83FABA0F227ACB14783DE8C71CDF5DAD120F17B2771B51BAEE989DC444613A5F9FB88A255CA8ADE69DBF1EF78DC51A3044687B07ABE15CB07154AFFADBCC178CF995A6DBD3D1AD07ED93EAFF7B23F95C582857344D8520CD1FEEA2B73A8CC8141D0CE78B643767014D26559C55D8AC45A110C3A6BAB8E817E16A4FF52325E9D3E69B6E686A7C188DBB673E3B3CC2AD91D3E";

                COMMON.convertHStrIntoHex(signatureStr, signature, &signaturelen);
                r = pin_promptForNumericKey(30, 1, 1, 16, "Enter Num. Key", 14, signature, 256);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Prompt Numeric Key Input Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Prompt Numeric Key Input Succeeded\n");
                    printf("Please Enter Numeric Key on Key Pad...\n");
                }
                fflush(stdout);
            }
            break;
            case 7: {
                printf(">>7. Input From Prompt\n");
                fflush(stdout);
                char * defaultResponse = "";

                r = pin_inputFromPrompt(0, 4, 4, 1, 15, "EN", 1, "", 0, 60);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Input From Prompt Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Input From Prompt Succeeded\n");
                    printf("Please Enter Numeric Key on Key Pad...\n");
                }
                fflush(stdout);
            }
            break;
            case 0:
                if (isPINBusy) {
                    printf("PIN Busy\n");
                    choice = -1;
                } else {
                    printf(">>0. Back To Main Menu\n");
                }
                fflush(stdout);
                break;
        }
    } while (choice != 0);
    // #ifdef WIN32
    if (choice == 0) {
//        idtech_process.pProcess_function_list();
        return;
    }
    // #endif
} /* _NEO2_process_pin */

void
_NEO2_display_pin_menu() {
    idtech_display_menu_from_lib.pDisplay_Menu_current = _NEO2_display_pin_menu;
    printf("\t\t************ Config Options [NEO]***************\n");
    printf("\t\t0. Back To Main Menu\n");
    printf("\t\t1. Get Encrypted PIN\n");
    printf("\t\t2. Prompt Key Input\n");
    //	printf("\t\t3. Prompt Amount Entry\n");
    //	printf("\t\t3. Get Function Key\n");
    printf("\t\t3. Cancel PIN Entry\n");
    printf("\t\t4. Send Beep\n");
    printf("\t\t5. Get PAN\n");
    printf("\t\t6. Prompt Numeric Key Input\n");
    printf("\t\t7. Input From Prompt\n");
    printf("\t\t************************************************\n");
    fflush(stdout);
}
