#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "demo_common.h"

IDT_COMMON_PROCESS COMMON;
extern IDT_PROCESS idtech_process;
extern IDT_DEMO_LIB_DISPLAY_MENU idtech_display_menu_from_lib;

void
_NEO2_display_msr_menu();

void
_NEO2_process_msr() {
    int choice;
    BYTE resData[_DATA_BUF_LEN];
    int resLen;
    int r;

    //	char str1[256] = {0};
    //	memset( str1, 0 ,256);
    //	pin_registerCallBk(COMMON.PIN_callBack);
    do {
        _NEO2_display_msr_menu();
        choice = COMMON.inputSelection();
        if (device_getL100PassThroughMode() == 1) {
            switch (choice) {
                case 1:
                    printf(">>1. Get Encrypted PIN\n");
                    fflush(stdout);
                    r = pin_getEncryptedPIN(1, "4111111111111111", 16, "ENTER PIN", 9, 30);
                    if (r != RETURN_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getResponseCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Get Encrypted PIN Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                            strErr);
                    } else {
                        printf("Get Encrypted PIN Succeeded\n");
                        printf("Please Enter PIN on PIN Pad...\n");
                    }
                    fflush(stdout);
                    break;
                case 2:
                    printf(">>2. Prompt Key Entry\n");
                    fflush(stdout);
                    r = pin_promptForKeyInput(1, 0, 0, 1, 12, 20);
                    if (r != RETURN_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getResponseCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Prompt Key Entry Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                            strErr);
                    } else {
                        printf("Prompt Key Entry Succeeded\n");
                        printf("Please Enter Key on Key Pad...\n");
                    }
                    fflush(stdout);
                    break;
                case 3:
                    printf(">>3. Prompt Amount Entry\n");
                    fflush(stdout);
                    r = pin_promptForAmountInput(1, 0, 1, 12, 20);
                    if (r != RETURN_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getResponseCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Prompt Amount Entry Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                            strErr);
                    } else {
                        printf("Prompt Amount Entry Succeeded\n");
                        printf("Please Enter Amount on Key Pad...\n");
                    }
                    fflush(stdout);
                    break;
                case 4:
                    printf(">>4. Get Function Key\n");
                    fflush(stdout);
                    r = pin_getFunctionKey(20);
                    if (r != RETURN_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getResponseCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Get Function Key Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                            strErr);
                    } else {
                        printf("Get Function Key Succeeded\n");
                        printf("Please Press the Function Key on Key Pad...\n");
                    }
                    fflush(stdout);
                    break;
                case 5:
                    printf(">>5. Cancel PIN Entry\n");
                    fflush(stdout);
                    pin_cancelPINEntry();
                    if (r != RETURN_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getResponseCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Cancel PIN Entry Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                            strErr);
                    } else {
                        printf("PIN Cancel PIN Succeeded\n");
                    }
                    fflush(stdout);
                    break;
                case 6:
                    printf(">>6. Send Beep\n");
                    fflush(stdout);
                    r = pin_sendBeep(2000, 200);
                    if (r != RETURN_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getResponseCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Send Beep Failed! ErrorCode: 0x%02x, Info: %s ----- \n",
                            r, strErr);
                    } else {
                        printf("Send Beep Succeeded\n");
                    }
                    fflush(stdout);
                    break;
                case 7:
                    printf(">>7. Set Key Values On\n");
                    fflush(stdout);
                    r = pin_setKeyValues(1);
                    if (r != RETURN_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getResponseCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Set Key Values On Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                            strErr);
                    } else {
                        printf("Set Key Values On Succeeded\n");
                    }
                    fflush(stdout);
                    break;
                case 8:
                    printf(">>8. Set Key Values Off\n");
                    fflush(stdout);
                    r = pin_setKeyValues(0);
                    if (r != RETURN_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getResponseCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Set Key Values Off Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                            strErr);
                    } else {
                        printf("Set Key Values Off Succeeded\n");
                    }
                    fflush(stdout);
                    break;
                case 0:
                    if (isPINBusy) {
                        printf("PIN Busy\n");
                        choice = -1;
                    } else {
                        printf(">>0. Back To Main Menu\n");
                    }
                    fflush(stdout);
                    break;
            }
        } else {
            switch (choice) {
                case 1:
                    printf(">>1. Start MSR\n");
                    fflush(stdout);
                    //			msr_registerCallBk(COMMON.MSR_callBack);
                    r = msr_startMSRSwipe(30);
                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getIDGStatusCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Start MSR Failed! ErrorCode:0x%02x, Info: %s ----- \n",
                            r, strErr);
                    } else {
                        printf("MSR Start MSR Swipe Succeeded\n");
                        printf("Please Swipe Card...\n");
                    }
                    fflush(stdout);
                    break;
                case 2:
                    printf(">>2. Cancel MSR\n");
                    fflush(stdout);
                    r = msr_cancelMSRSwipe();
                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getIDGStatusCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Cancel MSR Failed! ErrorCode:0x%02x, Info: %s ----- \n",
                            r, strErr);
                    } else {
                        printf("MSR Cancel MSR Swipe Succeeded\n");
                    }
                    fflush(stdout);
                    break;
                //		case 3:
                //			printf(">>3. Clear Card Data\n");
                //			r = msr_clearMSRData();
                //			if ( r != RETURN_CODE_DO_SUCCESS ) {
                //				printf("  Do msr_clearMSRData(), failed!\n");
                //			}
                //			else{
                //				printf("MSR Clear MSR Data Succeeded\n");
                //			}
                //		break;
                //
                //		case 4:
                //			printf(">>4. Get Card Data\n");
                //			resLen = _DATA_BUF_LEN;
                //			memset(resData, 0, resLen);
                //			r = msr_getMSRData(resData, &resLen);
                //			if ( r != RETURN_CODE_DO_SUCCESS ) {
                //				printf("  Do msr_getMSRData(), failed!\n");
                //			}
                //			else{
                //				printf("Get MSR Data: Succeeded\n");
                //				IDTMSRData msrData1;
                //				resetMSRData(&msrData1);
                //				parseMSRData(resData, resLen, &msrData1);
                //				COMMON.printMSRData(&msrData1);
                //			}
                //		break;
                case 0:
                    if (isMSRBusy) {
                        printf("MSR Busy\n");
                        choice = -1;
                    } else {
                        printf(">>0. Back To Main Menu\n");
                    }
                    fflush(stdout);
                    break;
            }
        }
    } while (choice != 0);
    // #ifdef WIN32
    if (choice == 0) {
//        idtech_process.pProcess_function_list();
        return;
    }
    // #endif
} /* _NEO2_process_msr */

void
_NEO2_display_msr_menu() {
    idtech_display_menu_from_lib.pDisplay_Menu_current = _NEO2_display_msr_menu;
    if (device_getL100PassThroughMode() == 1) {
        printf("\t\t************ Config Options [L100]**************\n");
        printf("\t\t0. Back To Main Menu\n");
        printf("\t\t1. Get Encrypted PIN\n");
        printf("\t\t2. Prompt Key Entry\n");
        printf("\t\t3. Prompt Amount Entry\n");
        printf("\t\t4. Get Function Key\n");
        printf("\t\t5. Cancel PIN Entry\n");
        printf("\t\t6. Send Beep\n");
        printf("\t\t7. Set Key Values On\n");
        printf("\t\t8. Set Key Values Off\n");
        printf("\t\t************************************************\n");
    } else {
        printf("\t\t********** MSR Options [NEO]********************\n");
        printf("\t\t0. Back To Main Menu\n");
        printf("\t\t1. Start MSR\n");
        printf("\t\t2. Cancel MSR\n");
        // printf("\t\t3. Clear Card Data\n");
        // printf("\t\t4. Get Card Data\n");
        printf("\t\t************************************************\n");
    }
    fflush(stdout);
}
