#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "demo_common.h"

IDT_COMMON_PROCESS COMMON;
extern IDT_PROCESS idtech_process;
extern IDT_DEMO_LIB_DISPLAY_MENU idtech_display_menu_from_lib;

void
_NEO2_display_lcd_menu();


void
_NEO2_process_lcd() {
    int choice;
    int status;
    int r = 0;

    do {
        _NEO2_display_lcd_menu();
        choice = COMMON.inputSelection();
        switch (choice) {
            case 1:
                printf(">>1. Clear Display\n");
                fflush(stdout);
                r = lcd_clearDisplay(0xFF);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Clear Display Failed! ErrorCode: 0x%02x, Info: %s ----- \n",
                        r, strErr);
                } else {
                    printf("Clear Display Succeeded\n");
                }
                fflush(stdout);
                break;
            case 2:
                printf(">>2. Display Message\n");
                fflush(stdout);
                r = lcd_displayMessage(1, "SmartPIN NEO2 Ready", 19);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Display Message Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Display Message Succeeded\n");
                }
                fflush(stdout);
                break;
            case 3: {
                printf(">>3. Create Screen\n");
                fflush(stdout);
                int ScreenID;
                r = lcd_createScreen("Screen1", 7, &ScreenID);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Create Screen Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Create Screen Succeeded\n");
                    printf("ScreenID: %d\n", ScreenID);
                }
                fflush(stdout);
            }
            break;
            case 4:
                printf(">>4. Destroy Screen\n");
                fflush(stdout);
                r = lcd_destroyScreen("Screen1", 7);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Destroy Screen Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Destroy Screen Succeeded\n");
                }
                fflush(stdout);
                break;
            case 5: {
                printf(">>5. Get Active Screen\n");
                fflush(stdout);
                char screenName[100];
                int screenNameLen = 100;
                memset(screenName, 0, screenNameLen);
                r = lcd_getActiveScreen(screenName, &screenNameLen);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Get Active Screen Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Get Active Screen Succeeded\n");
                    printf("Screen Name: %s\n", screenName);
                }
                fflush(stdout);
            }
            break;
            case 6:
                printf(">>6. Show Screen");
                fflush(stdout);
                r = lcd_showScreen("Screen1", 7);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Show Screen Failed! ErrorCode: 0x%02x, Info: %s ----- \n",
                        r, strErr);
                } else {
                    printf("Show Screen Succeeded\n");
                }
                fflush(stdout);
                break;
            case 7: {
                printf(">>7. Get Button Event\n");
                fflush(stdout);
                int screenID;
                int objectID;
                char screenName[100];
                int screenNameLen = 100;
                char objectName[100];
                int objectNameLen = 100;
                int isLongPress   = 0;

                r = lcd_getButtonEvent(&screenID, &objectID, screenName, &screenNameLen, objectName, &objectNameLen,
                    &isLongPress);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Get Button Event Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Get Button Event Succeeded\n");
                    if (objectNameLen == 0) {
                        printf("No Button Event was found\n");
                    } else {
                        printf("screenName: %s\n", screenName);
                        printf("objectName: %s\n", objectName);
                        printf("screenID: %d\n", screenID);
                        printf("objectID: %d\n", objectID);
                        printf("isLongPress: %d\n", isLongPress);
                    }
                }
                fflush(stdout);
            }
            break;
            case 8: {
                printf(">>8. Add Button\n");
                fflush(stdout);
                IDTLCDItem returnItem;
                memset(&returnItem, 0, sizeof(IDTLCDItem));
                r = lcd_addButton("Screen1", 7, "Button1", 7, 2, 0, 10, 30, "Button1", 7, &returnItem);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Add Button Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Add Button Succeeded\n");
                    printf("screenID: %d\n", returnItem.screenID);
                    printf("objectID: %d\n", returnItem.objectID);
                    printf("topLeftX: %d\n", returnItem.topLeftX);
                    printf("topLeftY: %d\n", returnItem.topLeftY);
                    printf("bottomRightX: %d\n", returnItem.bottomRightX);
                    printf("bottomRightY: %d\n", returnItem.bottomRightY);
                }
                fflush(stdout);
            }
            break;
            case 9: {
                printf(">>9. Add Ethernet\n");
                fflush(stdout);
                IDTLCDItem returnItem;
                memset(&returnItem, 0, sizeof(IDTLCDItem));
                r = lcd_addEthernet("Screen1", 7, "Ethernet1", 9, 0, 10, 100, &returnItem);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Add Ethernet Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Add Ethernet Succeeded\n");
                    printf("screenID: %d\n", returnItem.screenID);
                    printf("objectID: %d\n", returnItem.objectID);
                    printf("topLeftX: %d\n", returnItem.topLeftX);
                    printf("topLeftY: %d\n", returnItem.topLeftY);
                    printf("bottomRightX: %d\n", returnItem.bottomRightX);
                    printf("bottomRightY: %d\n", returnItem.bottomRightY);
                }
                fflush(stdout);
            }
            break;
            case 10: {
                printf(">>10. Add LED\n");
                fflush(stdout);
                BYTE LED[4] = { 0x00, 0x01, 0x02, 0x03 };
                IDTLCDItem returnItem;
                memset(&returnItem, 0, sizeof(IDTLCDItem));
                r = lcd_addLED("Screen1", 7, "LED1", 4, 0, 10, 150, &returnItem, LED, 4);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Add LED Failed! ErrorCode: 0x%02x, Info: %s ----- \n",
                        r, strErr);
                } else {
                    printf("Add LED Succeeded\n");
                    printf("screenID: %d\n", returnItem.screenID);
                    printf("objectID: %d\n", returnItem.objectID);
                    printf("topLeftX: %d\n", returnItem.topLeftX);
                    printf("topLeftY: %d\n", returnItem.topLeftY);
                    printf("bottomRightX: %d\n", returnItem.bottomRightX);
                    printf("bottomRightY: %d\n", returnItem.bottomRightY);
                }
                fflush(stdout);
            }
            break;
            case 11: {
                printf(">>11. Add Text\n");
                fflush(stdout);
                BYTE color[4] = { 0xFF, 0x00, 0x00, 0x00 };
                IDTLCDItem returnItem;
                memset(&returnItem, 0, sizeof(IDTLCDItem));
                r = lcd_addText("Screen1", 7, "Text1", 5, 0, 10, 200, 100, 30, 0, color, 4, "Text1", 5, &returnItem);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Add Text Failed! ErrorCode: 0x%02x, Info: %s ----- \n",
                        r, strErr);
                } else {
                    printf("Add Text Succeeded\n");
                    printf("screenID: %d\n", returnItem.screenID);
                    printf("objectID: %d\n", returnItem.objectID);
                    printf("topLeftX: %d\n", returnItem.topLeftX);
                    printf("topLeftY: %d\n", returnItem.topLeftY);
                    printf("bottomRightX: %d\n", returnItem.bottomRightX);
                    printf("bottomRightY: %d\n", returnItem.bottomRightY);
                }
                fflush(stdout);
            }
            break;
            case 12: {
                printf(">>12. Add Image\n");
                printf("Please enter the image file name:\n");
                fflush(stdout);
                char file_name[128];
                fgets(file_name, 128, stdin);
                int i;
                for (i = 0; i < 128; i++) {
                    if (file_name[i] == '\n' || file_name[i] == '\r') {
                        file_name[i] = '\0';
                        break;
                    }
                }
                IDTLCDItem returnItem;
                memset(&returnItem, 0, sizeof(IDTLCDItem));
                r =
                  lcd_addImage("Screen1", 7, "Image1", 6, 0, 10, 250, file_name, (int) strlen(file_name), &returnItem);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Add Image Failed! ErrorCode:0x%02x, Info: %s ----- \n",
                        r, strErr);
                } else {
                    printf("Add Image Succeeded\n");
                }
                fflush(stdout);
            }
            break;
            case 13: {
                printf(">>13. Add Video\n");
                printf("Please enter the video file name:\n");
                fflush(stdout);
                char file_name[128];
                fgets(file_name, 128, stdin);
                int i;
                for (i = 0; i < 128; i++) {
                    if (file_name[i] == '\n' || file_name[i] == '\r') {
                        file_name[i] = '\0';
                        break;
                    }
                }
                IDTLCDItem returnItem;
                memset(&returnItem, 0, sizeof(IDTLCDItem));
                r =
                  lcd_addVideo("Screen1", 7, "Video1", 6, 2, 10, 250, file_name, (int) strlen(file_name), &returnItem);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Add Video Failed! ErrorCode:0x%02x, Info: %s ----- \n",
                        r, strErr);
                } else {
                    printf("Add Video Succeeded\n");
                }
                fflush(stdout);
            }
            break;
            case 14: {
                printf(">>14. Clone Screen\n");
                fflush(stdout);
                int cloneID;
                r = lcd_cloneScreen("Screen1", 7, "Screen2", 7, &cloneID);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Clone Screen Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Clone Screen Succeeded\n");
                    printf("cloneID: %d\n", cloneID);
                }
                fflush(stdout);
            }
            break;
            case 15: {
                printf(">>15. Update Label\n");
                fflush(stdout);
                r = lcd_updateLabel("Screen1", 7, "Text1", 5, "Text2", 5);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Update Label Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Update Label Succeeded\n");
                }
                fflush(stdout);
            }
            break;
            case 16: {
                printf(">>16. Update Color\n");
                fflush(stdout);
                BYTE color[4] = { 0xFF, 0x00, 0x00, 0x00 };
                r = lcd_updateColor("Screen1", 7, "Text1", 5, color, 4);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Update Color Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Update Color Succeeded\n");
                }
                fflush(stdout);
            }
            break;
            case 17: {
                printf(">>17. Update Position\n");
                fflush(stdout);
                r = lcd_updatePosition("Screen1", 7, "Text1", 5, 0, 10, 150);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Update Position Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Update Position Succeeded\n");
                }
                fflush(stdout);
            }
            break;
            case 18: {
                printf(">>18. Remove Object\n");
                printf("Please enter the object name to remove:\n");
                fflush(stdout);
                char object_name[128];
                fgets(object_name, 128, stdin);
                int i;
                for (i = 0; i < 128; i++) {
                    if (object_name[i] == '\n' || object_name[i] == '\r') {
                        object_name[i] = '\0';
                        break;
                    }
                }
                r = lcd_removeItem("Screen1", 7, object_name, (int) strlen(object_name));
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Remove Object Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Remove Object Succeeded\n");
                }
                fflush(stdout);
            }
            break;
            case 19: {
                printf(">>19. Store Screen Info\n");
                fflush(stdout);
                r = lcd_storeScreenInfo();
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Store Screen Info Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Store Screen Info Succeeded\n");
                }
                fflush(stdout);
            }
            break;
            case 20: {
                printf(">>20. Load Screen Info\n");
                fflush(stdout);
                r = lcd_loadScreenInfo();
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Load Screen Info Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Load Screen Info Succeeded\n");
                }
                fflush(stdout);
            }
            break;
            case 21: {
                printf(">>21. Clear Screen Info\n");
                fflush(stdout);
                r = lcd_clearScreenInfo();
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Clear Screen Info Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Clear Screen Info Succeeded\n");
                }
                fflush(stdout);
            }
            break;
            case 22: {
                printf(">>22. Get All Screens\n");
                fflush(stdout);
                int screenNumbers = 20;
                IDTScreenInfo screenInfo[screenNumbers];
                memset(screenInfo, 0, sizeof(IDTScreenInfo) * screenNumbers);
                r = lcd_getAllScreens(&screenNumbers, screenInfo);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Get All Screens Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Get All Screens Succeeded\n");
                    printf("screenNumbers %d\n", screenNumbers);
                    int i;
                    for (i = 0; i < screenNumbers; i++) {
                        printf("ScreenID: %d Screen Name: %s\n", screenInfo[i].screenID, screenInfo[i].screenName);
                    }
                }
                fflush(stdout);
            }
            break;
            case 23: {
                printf(">>23. Get All Objects on Screen\n");
                fflush(stdout);
                int objectNumbers = 20;
                IDTObjectInfo objectInfo[objectNumbers];
                memset(objectInfo, 0, sizeof(IDTObjectInfo) * objectNumbers);
                r = lcd_getAllObjects("Screen1", 7, &objectNumbers, objectInfo);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Get All Objects on Screen Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Get All Objects on Screen Succeeded\n");
                    printf("objectNumbers %d\n", objectNumbers);
                    int i;
                    for (i = 0; i < objectNumbers; i++) {
                        printf("ObjectID: %d Object Name: %s\n", objectInfo[i].objectID, objectInfo[i].objectName);
                    }
                }
                fflush(stdout);
            }
            break;
            case 24: {
                printf(">>24. Query Screen by Name\n");
                fflush(stdout);
                int result = 0;
                r = lcd_queryScreenbyName("Screen1", 7, &result);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Query Screen by Name Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Query Screen by Name Succeeded\n");
                    if (result == 1) {
                        printf("The screen exist\n");
                    } else {
                        printf("The screen does not exist\n");
                    }
                }
                fflush(stdout);
            }
            break;
            case 25: {
                printf(">>25. Query Object by Name\n");
                fflush(stdout);
                int objectNumbers = 20;
                IDTScreenInfo screenInfo[objectNumbers];
                memset(screenInfo, 0, sizeof(IDTScreenInfo) * objectNumbers);
                r = lcd_queryObjectbyName("Text1", 5, &objectNumbers, screenInfo);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Query Object by Name Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Query Object by Name Succeeded\n");
                    printf("objectNumbers %d\n", objectNumbers);
                    int i;
                    for (i = 0; i < objectNumbers; i++) {
                        printf("Screen Name: %s\n", screenInfo[i].screenName);
                    }
                }
                fflush(stdout);
            }
            break;
            case 26: {
                printf(">>26. Query Screen by ID\n");
                fflush(stdout);
                int screenNameLen    = 100;
                char screenName[100] = { 0 };
                int result = 0;
                r = lcd_queryScreenbyID(0, &result, screenName, &screenNameLen);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Query Screen by ID Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Query Screen by ID Succeeded\n");
                    if (result == 1) {
                        printf("The screen exist\n");
                        printf("Screen Name %s\n", screenName);
                    } else {
                        printf("The screen does not exist\n");
                    }
                }
                fflush(stdout);
            }
            break;
            case 27: {
                printf(">>27. Query Object by ID\n");
                fflush(stdout);
                int objectNumbers = 20;
                IDTScreenInfo screenInfo[20];
                memset(screenInfo, 0, sizeof(IDTScreenInfo) * objectNumbers);
                r = lcd_queryObjectbyID(0, &objectNumbers, screenInfo);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Query Object by ID Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Query Object by ID Succeeded\n");
                    printf("objectNumbers %d\n", objectNumbers);
                    int i;
                    for (i = 0; i < objectNumbers; i++) {
                        printf("Screen Name: %s\n", screenInfo[i].screenName);
                    }
                }
                fflush(stdout);
            }
            break;
            case 28: {
                printf(">>28. Set Backlight\n");
                fflush(stdout);
                r = lcd_setBacklight(1, 60);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Set Backlight Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Set Backlight Succeeded\n");
                }
                fflush(stdout);
            }
            break;
            case 0:
                printf(">>0.Back To Main Menu\n");
                fflush(stdout);
                break;
        }
    } while (choice != 0);
    // #ifdef WIN32
    if (choice == 0) {
//        idtech_process.pProcess_function_list();
        return;
    }
    // #endif
} /* _NEO2_process_lcd */

void
_NEO2_display_lcd_menu() {
    idtech_display_menu_from_lib.pDisplay_Menu_current = _NEO2_display_lcd_menu;
    printf("\t\t************* LCD Options [NEO]*****************\n");
    printf("\t\t0.  Back To Main Menu\n");
    printf("\t\t1.  Clear Display\n");
    printf("\t\t2.  Display Message\n");
    printf("\t\t3.  Create Screen\n");
    printf("\t\t4.  Destroy Screen\n");
    printf("\t\t5.  Get Active Screen\n");
    printf("\t\t6.  Show Screen\n");
    printf("\t\t7.  Get Button Event\n");
    printf("\t\t8.  Add Button\n");
    printf("\t\t9.  Add Ethernet\n");
    printf("\t\t10. Add LED\n");
    printf("\t\t11. Add Text\n");
    printf("\t\t12. Add Image\n");
    printf("\t\t13. Add Video\n");
    printf("\t\t14. Clone Screen\n");
    printf("\t\t15. Update Label\n");
    printf("\t\t16. Update Color\n");
    printf("\t\t17. Update Position\n");
    printf("\t\t18. Remove Object\n");
    printf("\t\t19. Store Screen Info\n");
    printf("\t\t20. Load Screen Info\n");
    printf("\t\t21. Clear Screen Info\n");
    printf("\t\t22. Get All Screens\n");
    printf("\t\t23. Get All Objects on Screen\n");
    printf("\t\t24. Query Screen by Name\n");
    printf("\t\t25. Query Object by Name\n");
    printf("\t\t26. Query Screen by ID\n");
    printf("\t\t27. Query Object by ID\n");
    printf("\t\t28. Set Backlight\n");
    printf("\t\t************************************************\n");
    fflush(stdout);
} /* _NEO2_display_lcd_menu */
