#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "demo_common.h"

IDT_COMMON_PROCESS COMMON;
extern IDT_PROCESS idtech_process;
extern IDT_DEMO_LIB_DISPLAY_MENU idtech_display_menu_from_lib;

void
_NEO2_display_icc_menu();

void
_NEO2_process_icc() {
    int choice;
    BYTE status;
    int r = 0;
    BYTE ATR[_DATA_BUF_LEN];
    int ATRLen;
    BYTE resData[_DATA_BUF_LEN];
    int resLen;

    do {
        _NEO2_display_icc_menu();
        choice = COMMON.inputSelection();
        if (device_getL100PassThroughMode() == 1) {
            switch (choice) {
                case 1:
                    printf(">>1. Clear Display\n");
                    fflush(stdout);
                    r = lcd_clearDisplay(0xFF);
                    if (r != RETURN_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getResponseCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Clear Display Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                            strErr);
                    } else {
                        printf("Clear Display Succeeded\n");
                        //				char str2[200] = {0};
                        //				sprintf(str2, "Model Number: %s\n", str1);
                        //				printf (str2);
                    }
                    fflush(stdout);
                    break;
                case 2:
                    printf(">>2. Clear Line #1\n");
                    fflush(stdout);
                    r = lcd_clearDisplay(0);
                    if (r != RETURN_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getResponseCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Clear Line #1 Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                            strErr);
                    } else {
                        printf("Clear Line #1 Succeeded\n");
                    }
                    fflush(stdout);
                    break;
                case 3:
                    printf(">>3. Save Prompt\n");
                    fflush(stdout);
                    r = lcd_savePrompt(2, "********", 8);
                    if (r != RETURN_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getResponseCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Save Prompt Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                            strErr);
                    } else {
                        printf("Save Prompt Succeeded\n");
                    }
                    fflush(stdout);
                    break;
                case 4:
                    printf(">>4. Display Prompt\n");
                    fflush(stdout);
                    r = lcd_displayPrompt(1, 1);
                    if (r != RETURN_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getResponseCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Display Prompt Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                            strErr);
                    } else {
                        printf("Display Prompt Succeeded\n");
                    }
                    fflush(stdout);
                    break;
                case 5:
                    printf(">>5. Display Message\n");
                    fflush(stdout);
                    r = lcd_displayMessage(1, "SmartPIN L100 Ready", 19);
                    if (r != RETURN_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getResponseCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Display Message Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                            strErr);
                    } else {
                        printf("Display Message Succeeded\n");
                    }
                    fflush(stdout);
                    break;
                case 6:
                    printf(">>6. Enable Backlight\n");
                    fflush(stdout);
                    r = lcd_enableBacklight(1);
                    if (r != RETURN_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getResponseCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Enable Backlight Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                            strErr);
                    } else {
                        printf("Enable Backlight Succeeded\n");
                    }
                    fflush(stdout);
                    break;
                case 7:
                    printf(">>7. Disable Backlight\n");
                    fflush(stdout);
                    r = lcd_enableBacklight(0);
                    if (r != RETURN_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getResponseCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Disable Backlight Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                            strErr);
                    } else {
                        printf("Disable Backlight Succeeded\n");
                    }
                    fflush(stdout);
                    break;
                case 8:
                    printf(">>8. Get Backlight Status\n");
                    fflush(stdout);
                    r = lcd_getBacklightStatus(&status);
                    if (r != RETURN_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getResponseCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Get Backlight Status Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                            strErr);
                    } else {
                        printf("Get Backlight Status Succeeded\n");
                        if (status == 1) {
                            printf("Backlight is On\n");
                        } else {
                            printf("Backlight is Off\n");
                        }
                    }
                    fflush(stdout);
                    break;
                case 0:
                    printf(">>0.Back To Main Menu\n");
                    fflush(stdout);
                    break;
            }
        } else {
            switch (choice) {
                case 1:
                    printf(">>1. Pass Through On\n");
                    fflush(stdout);
                    r = device_enablePassThrough(1);
                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getIDGStatusCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Pass Through On Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                            strErr);
                    } else {
                        printf("Pass Through On Succeeded\n");
                    }
                    fflush(stdout);
                    break;
                case 2:
                    printf(">>2. Pass Through Off\n");
                    fflush(stdout);
                    r = device_enablePassThrough(0);
                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getIDGStatusCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Pass Through Off Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                            strErr);
                    } else {
                        printf("Pass Through Off Succeeded\n");
                    }
                    fflush(stdout);
                    break;
                case 3:
                    printf(">>3. Power On ICC\n");
                    fflush(stdout);
                    ATRLen = _DATA_BUF_LEN;
                    memset(ATR, 0, ATRLen);
                    r = icc_powerOnICC(ATR, &ATRLen);
                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getIDGStatusCodeString(r, strErr);
                        printf("  Do icc_powerOnICC failed! ErrorCode:0x%02x ,Info: %s ----- \n", r, strErr);
                    } else {
                        printf("ICC Power On Succeeded\nATR: ");
                        int i;
                        for (i = 0; i < ATRLen; i++) {
                            printf("%02X ", ATR[i]);
                        }
                        printf("\n");
                    }
                    fflush(stdout);
                    break;
                case 4:
                    printf(">>4. Power Off ICC\n");
                    fflush(stdout);
                    r = icc_powerOffICC();
                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getIDGStatusCodeString(r, strErr);
                        printf("  Do icc_powerOffICC failed! ErrorCode:0x%02x ,Info: %s ----- \n", r, strErr);
                    } else {
                        printf("ICC Power Off Succeeded\n");
                    }
                    fflush(stdout);
                    break;
                case 5: {
                    printf(">>5. Send APDU\n");
                    fflush(stdout);
                    // input
                    char * strAPDU = "00a404000e315041592e5359532e444446303100";
                    BYTE byteAPDU[800];
                    int byteAPDULen = 800;
                    COMMON.convertHStrIntoHex(strAPDU, byteAPDU, &byteAPDULen);
                    // output
                    BYTE data[200];
                    int dataLen = 200;
                    r = icc_exchangeAPDU(byteAPDU, byteAPDULen, data, &dataLen);
                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getIDGStatusCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- icc_exchangeAPDU failed!! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                            strErr);
                        fflush(stdout);
                        break;
                    }
                    char str1[1024] = { 0 };
                    COMMON.convertBytesIntoHexStr(data, dataLen, 1, str1);
                    printf(">>Get APDU Data: %s.\n", str1);
                    fflush(stdout);
                }
                break;
                case 0:
                    printf(">>0.Back To Main Menu\n");
                    fflush(stdout);
                    break;
            }
        }
    } while (choice != 0);
    // #ifdef WIN32
    if (choice == 0) {
//        idtech_process.pProcess_function_list();
        return;
    }
    // #endif
} /* _NEO2_process_icc */

void
_NEO2_display_icc_menu() {
    idtech_display_menu_from_lib.pDisplay_Menu_current = _NEO2_display_icc_menu;
    if (device_getL100PassThroughMode() == 1) {
        printf("\t\t************* LCD Options [L100]****************\n");
        printf("\t\t0.  Back To Main Menu\n");
        printf("\t\t1.  Clear Display\n");
        printf("\t\t2.  Clear Line #1\n");
        printf("\t\t3.  Save Prompt\n");
        printf("\t\t4.  Display Prompt\n");
        printf("\t\t5.  Display Message\n");
        printf("\t\t6.  Enable Backlight\n");
        printf("\t\t7.  Disable Backlight\n");
        printf("\t\t8.  Get Backlight Status\n");
        printf("\t\t************************************************\n");
    } else {
        printf("\t\t********** ICC Options [NEO]********************\n");
        printf("\t\t0.  Back To Main Menu\n");
        printf("\t\t1.  Enable Passthrough\n");
        printf("\t\t2.  Disable Passthrough\n");
        printf("\t\t3.  Power On ICC\n");
        printf("\t\t4.  Power Off ICC\n");
        printf("\t\t5.  Send APDU\n");
        printf("\t\t************************************************\n");
    }
    fflush(stdout);
}
