#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "demo_common.h"

EXPORT_SYMBOLS IDT_COMMON_PROCESS COMMON;
EXPORT_SYMBOLS IDT_PROCESS idtech_process;

EXPORT_SYMBOLS IDT_DEMO_LIB_DISPLAY_MENU idtech_display_menu_from_lib;

void
_NEO2_display_ctls_menu();
// EXPORT_SYMBOLS void MSR_callBack(int type, IDTMSRData cardData1);
// EXPORT_SYMBOLS void MSR_callBackp(int type, IDTMSRData *cardData1);

void
_NEO2_process_ctls() {
    int choice;
    BYTE resData[_DATA_BUF_LEN];
    int resLen;
    int r;
    char str1[256] = { 0 };

    memset(str1, 0, 256);
    do {
        _NEO2_display_ctls_menu();
        //		printf("Please Input your Selection:\n");
        //		scanf("%d",&choice);
        choice = COMMON.inputSelection();

        if (device_getL100PassThroughMode() == 1) {
            switch (choice) {
                case 1:
                    printf(">>1. Get Model Number\n");
                    fflush(stdout);
                    r = config_getModelNumber(str1);
                    if (r != RETURN_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getResponseCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Get Model Number Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                            strErr);
                    } else {
                        char str2[200] = { 0 };
                        sprintf(str2, "Model Number: %s\n", str1);
                        printf(str2);
                    }
                    fflush(stdout);
                    break;
                case 2: {
                    printf(">>2. Get Serial Number\n");
                    fflush(stdout);
                    r = config_getSerialNumber(str1);
                    if (r != RETURN_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getResponseCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Get Serial Number Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                            strErr);
                    } else {
                        char str2[200] = { 0 };
                        sprintf(str2, "Serial Number: %s\n", str1);
                        printf(str2);
                    }
                    fflush(stdout);
                }
                break;
                case 0:
                    printf(">>0. Back To Main Menu\n");
                    fflush(stdout);
                    break;
            }
        } else {
            switch (choice) {
                case 1:
                    printf(">>1. Start CTLS\n");
                    fflush(stdout);
                    r = ctls_startTransaction(1.00, 0.00, 0, 30, NULL, 0); // default
                    //				BYTE data[] = {0xff, 0xee, 0x08, 0x0a, 0xdf, 0xef, 0x1a, 0x01, 0x0a, 0xdf, 0xed, 0x28, 0x01, 0x00, 0xff, 0xee, 0x0e, 0x00};
                    //				r = ctls_startTransaction(1.00, 0.00, 0, 30, data, 18);
                    //				r = ctls_activateTransaction(30, NULL, 0);
                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS && r != IDG_P2_STATUS_CODE_REQUEST_ONLINE_AUTHORIZATION) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getIDGStatusCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Start CTLS Failed! ErrorCode:0x%02x, Info: %s ----- \n",
                            r, strErr);
                    } else {
                        printf("CTLS Start Transaction Succeeded\n");
                        printf("Please Tap Card...\n");
                    }
                    fflush(stdout);
                    break;
                case 2:
                    printf(">>2. Cancel CTLS\n");
                    fflush(stdout);
                    r = ctls_cancelTransaction();
                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getIDGStatusCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Cancel CTLS Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                            strErr);
                    } else {
                        printf("CTLS Cancel CTLS command sent successfully\n");
                    }
                    fflush(stdout);
                    break;
                case 3:
                    printf(">>3.  Retrieve AID	A0 00 00 01 52 30 10\n");
                    fflush(stdout);
                    {
                        int AIDlen8;
                        int tlvlen8;
                        tlvlen8 = 500;
                        //				BYTE AID[7] ={0xa0,0x00,0x00,0x00,0x04,0x10,0x10};
                        BYTE AID[7] = { 0xa0, 0x00, 0x00, 0x01, 0x52, 0x30, 0x10 };
                        AIDlen8 = 7;
                        BYTE tlv[500] = { 0 };
                        memset(tlv, 0, 500);
                        r = ctls_retrieveApplicationData(AID, AIDlen8, tlv, &tlvlen8);
                        if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                            char strErr[200] = { 0 };
                            memset(strErr, 0, 200);
                            device_getIDGStatusCodeString(r, strErr);
                            printf(
                                ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n	 ----- Retrieve AID  a0 00 00 00 04 10 10 failed!! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                                strErr);
                            fflush(stdout);
                            break;
                        }
                        printf(">>AID data:\n");
                        COMMON.printBytes(tlv, tlvlen8);
                        COMMON.printTLV(tlv, tlvlen8);
                    }
                    break;
                case 4: {
                    //				printf(">>4.  Remove all AID\n");
                    //				fflush(stdout);
                    //
                    //				r = ctls_removeAllApplicationData();
                    //				if ( r != IDG_P2_STATUS_CODE_DO_SUCCESS ) {
                    //					  char strErr[200] = {0};
                    //					  memset(strErr,0,200);
                    //					  device_getIDGStatusCodeString(r, strErr);
                    //					  printf(">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- remove AID  a0 00 00 00 04 10 10 failed!! ErrorCode:0x%02x ,Info: %s ----- \n",r,strErr);
                    //					  fflush(stdout);
                    //					  break ;
                    //				}
                    //				printf(">>remove all AID success\n" );
                    //				fflush(stdout);


                    printf(">>4.  Remove AID A0 00 00 01 52 30 10\n");
                    fflush(stdout);
                    //			BYTE AID[10] ={0x9f,0x06,0x07,0xa0,0x00,0x00,0x00,0x04,0x10,0x10};
                    BYTE AID[7] = { 0xa0, 0x00, 0x00, 0x01, 0x52, 0x30, 0x10 };
                    int AIDlen  = 7;
                    r = ctls_removeApplicationData(AID, AIDlen);
                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getIDGStatusCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- remove AID  A0 00 00 01 52 30 10 failed!! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                            strErr);
                        fflush(stdout);
                        break;
                    }
                    printf(">>remove AID  A0 00 00 01 52 30 10 success\n");
                    fflush(stdout);
                }
                break;
                case 5: {
                    printf(">>5. List AID\n");
                    fflush(stdout);
                    BYTE data[_DATA_BUF_LEN*2];
                    int dataLen = _DATA_BUF_LEN*2;
                    r = ctls_retrieveAIDList(data, &dataLen);
                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getIDGStatusCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- retrieveAIDList failed!! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                            strErr);
                        fflush(stdout);
                        break;
                    }
                    printf(">>retrieve AIDList:\n");
                    int len = 0;
                    while (len < dataLen) {
                        printf("%s\n", &(data[len]));
                        len += strlen(&(data[len])) + 1;
                    }
                    fflush(stdout);
                }
                break;
                case 6: {
                    printf(">>6. Save AID A0 00 00 01 52 30 10  \n");
                    fflush(stdout);
                    BYTE tlv11[200];
                    int tlvLen11 = 200;
                    //				char *str2 = "ffe401029f0607a0000000051010ffe10101ffe50110ffe30114ffe20106";
                    //				char *str2 = "DFEE2D01829F0607A0000001523010DFEE4B0101DFEE2E0110";
                    char * str2 = "DFEE2D01809F0607A0000000041010DFEE4B0101DFEE2E0110";

                    COMMON.convertHStrIntoHex(str2, tlv11, &tlvLen11);
                    r = ctls_setApplicationData(tlv11, tlvLen11);
                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getIDGStatusCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n	----- Save AID a0 00 00 00 04 10 10 failed!! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                            strErr);
                        fflush(stdout);
                        break;
                    }
                    printf(">>Save AID a0 00 00 00 04 10 10 success.\n");
                    fflush(stdout);
                }
                break;
                case 7: {
                    printf(">>7. Get Terminal Data\n");
                    fflush(stdout);
                    BYTE data[_DATA_BUF_LEN];
                    int dataLen = _DATA_BUF_LEN;
                    r = ctls_retrieveTerminalData(data, &dataLen);

                    //				BYTE data[_DATA_BUF_LEN*4];
                    //				int dataLen = _DATA_BUF_LEN*4;
                    //				r = ctls_getAllConfigurationGroups(data, &dataLen);

                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getIDGStatusCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Retrieve Terminal Data failed!! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                            strErr);
                        fflush(stdout);
                        break;
                    }
                    printf(">>Retrieve Terminal Data:\n");
                    COMMON.printBytes(data, dataLen);
                    COMMON.printTLV(data, dataLen);
                }
                break;
                case 8: {
                    printf(">>8. Set Terminal Data\n");
                    fflush(stdout);
                    BYTE tlv16[1024];
                    int tlvlen16 = 1024;
                    //				char * terminalstr ="ffe40100df7c0100df7d0100df7503003000df6a01019f5801039f5903dc80009f5a01009f5e02e0009f5f060000000080009f5d06000000005000df2a06000000005000df2b0132df2c010adf630100df640100df650100df660100fff003020000fff30207fffff90103fffa020000df5101809f0106000000000000df680100df7f0100df2601019c01005f2a0208405f3601029f090200029f1a0208409f1b04000017709f33030008e89f3501229f400560000030009f660480004000fff106000000010000fff403000601fff506000000008000fff80100fffb0100fffc0101fffd05f850acf800fffe05f850aca000ffff0500000000009f15020000df28030008e8df29030068e89f6d0200019f7c140000000000000000000000000000000000000000fff20830303030303030309f4e1e0000000000000000000000000000000000000000000000000000000000009f5301009f03060000000000009f02060000000000019f1c0800000000000000009f160f000000000000000000000000000000ffee1d0404042a0cffee1e01019f410400000000df891b0101fff701009a031608129f21030339139700";
                    char * terminalstr =
                      "5F3601029F1A0208409F3501219F33036028C89F4005F000F0A0019F1E085465726D696E616C9F150212349F160F3030303030303030303030303030309F1C0838373635343332319F4E2231303732312057616C6B65722053742E20437970726573732C204341202C5553412EDF260101DF1008656E667265737A68DF110100DF270100DFEE150101DFEE160100DFEE170107DFEE180180DFEE1E08D0DC20D0C41E1400DFEE1F0180DFEE1B083030303135313030DFEE20013CDFEE21010ADFEE2203323C3C";
                    COMMON.convertHStrIntoHex(terminalstr, tlv16, &tlvlen16);
                    r = ctls_setTerminalData(tlv16, tlvlen16);
                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getIDGStatusCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n	----- save Terminal Data failed!! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                            strErr);
                        fflush(stdout);
                        break;
                    } else {
                        printf(">>save Terminal Data success\n");
                    }
                    fflush(stdout);
                }
                break;

                case 9: {
                    printf(">>9. Get Config Group\n");
                    fflush(stdout);
                    BYTE tlv[_DATA_BUF_LEN * 3];
                    int tlvLen = _DATA_BUF_LEN * 3;
                    int group  = 0x02;
                    r = ctls_getConfigurationGroup(group, tlv, &tlvLen);
                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getIDGStatusCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n	----- Get Config Group failed!! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                            strErr);
                        fflush(stdout);
                        break;
                    }
                    IDTTag tags[250];
                    int tagCount = 250;
                    printf(">>Get Config Group %d Succeeded:\n", group);
                    COMMON.printBytes(tlv, tlvLen);

                    TLV_getTags(tlv, tlvLen, tags, &tagCount);
                    if (tagCount > 0) {
                        printf("Tags Count: %d\n", tagCount);
                        int i;
                        for (i = 0; i < tagCount; i++) {
                            int j;
                            for (j = 0; j < tags[i].tagLen; j++) {
                                printf("%02X", tags[i].Tag[j]);
                            }
                            printf(": ");
                            for (j = 0; j < tags[i].valueLen; j++) {
                                printf("%02X", tags[i].value[j]);
                            }
                            printf("\n");
                        }
                    }
                    printf("\n");
                    fflush(stdout);
                }

                break;
                case 10: {
                    printf(">>10. Set Config Group\n");
                    fflush(stdout);
                    BYTE tlv16[1024];
                    int tlvlen16 = 1024;
                    char * ConfigurationGroup =
                      "DFEE2D01809C0100DF8121050000000000DF8122050000000000DF81200500000000009F1A0208405F2A0208409F09020100DF812406000000030000DF812306000000015000DF8126060000000020009F1B0400003A98DFEE35030107039F3303E0E8089F6604B600C000DFEE7401039F350122";
                    COMMON.convertHStrIntoHex(ConfigurationGroup, tlv16, &tlvlen16);
                    r = ctls_setConfigurationGroup(tlv16, tlvlen16);
                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getIDGStatusCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n	----- Set Config Group failed!! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                            strErr);
                        fflush(stdout);
                        break;
                    } else {
                        printf(">>Set Config Group success\n");
                        fflush(stdout);
                    }
                }

                break;

                case 11: {
                    printf(">>11. Retrieve CAPK A0 00 00 99 99 E1 \n");
                    fflush(stdout);
                    BYTE data[500];
                    int dataLen = 500;
                    char * str2 = "A0 00 00 99 99 E1";
                    BYTE pdt1[500];
                    int pdt1Len = 500;
                    COMMON.convertHStrIntoHex(str2, pdt1, &pdt1Len);
                    r = ctls_retrieveCAPK(pdt1, pdt1Len, data, &dataLen);
                    printf(">>>CAPK>>>\n");
                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getIDGStatusCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- retrieve CAPK  failed!! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                            strErr);
                        fflush(stdout);
                        break;
                    }
                    char str1[1024] = { 0 };
                    COMMON.convertBytesIntoHexStr(data, dataLen, 1, str1);
                    printf(">>Retrieve CAPK: %s.\n", str1);
                    fflush(stdout);
                }
                break;
                case 12: {
                    printf(">>12. Remove CAPK A0 00 00 99 99 E1\n");
                    fflush(stdout);
                    char * str2 = "A0 00 00 99 99 E1";
                    BYTE pdt1[200];
                    int pdt1Len = 200;
                    COMMON.convertHStrIntoHex(str2, pdt1, &pdt1Len);
                    r = ctls_removeCAPK(pdt1, pdt1Len);
                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getIDGStatusCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Remove CAPK  failed!! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                            strErr);
                        fflush(stdout);
                        break;
                    }
                    printf(">>Remove CAPK: OK.\n");
                    fflush(stdout);
                }
                break;
                case 13: {
                    printf(">>13. List CAPK\n");
                    fflush(stdout);
                    BYTE data[200];
                    int dataLen = 200;
                    int x       = 0;
                    r = ctls_retrieveCAPKList(data, &dataLen);
                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getIDGStatusCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- retrieve CAPK List failed!! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                            strErr);
                        fflush(stdout);
                        break;
                    }
                    char str1[_DATA_BUF_LEN] = { 0 };
                    //			convertBytesIntoHexStr(data, dataLen, 1, str1);
                    printf(">>Retrieve CAPK list:\n");
                    BYTE CAPK[6] = { 0 };
                    if (dataLen > 0) {
                        memset(CAPK, 0, 6);
                        for (x = 0; x < dataLen; x = x + 6) {
                            memcpy(CAPK, data + x, 6);

                            str1[0] = '\0';
                            COMMON.convertBytesIntoHexStr(CAPK, 6, 1, str1);
                            printf("\t%s.\n", str1);
                        }
                    }
                    fflush(stdout);
                }
                break;
                case 14: {
                    printf(">>14. Save CAPK a000009999e1 \n");
                    fflush(stdout);
                    char * str2 =
                      "a000009999e10101f8707b9bedf031e58a9f843631b90c90d80ed69500000003007099c5b70aa61b4f4c51b6f90b0e3bfb7a3ee0e7db41bc466888b3ec8e9977c762407ef1d79e0afb2823100a020c3e8020593db50e90dbeac18b78d13f96bb2f57eeddc30f256592417cdf739ca6804a10a29d2806e774bfa751f22cf3b65b38f37f91b4daf8aec9b803f7610e06ac9e6b";
                    //				char *str2 = "A0000000039901014ABFFD6B1C51212D05552E431C5B17007D2F5E6D000000038000AB79FCC9520896967E776E64444E5DCDD6E13611874F3985722520425295EEA4BD0C2781DE7F31CD3D041F565F747306EED62954B17EDABA3A6C5B85A1DE1BEB9A34141AF38FCF8279C9DEA0D5A6710D08DB4124F041945587E20359BAB47B7575AD94262D4B25F264AF33DEDCF28E09615E937DE32EDC03C54445FE7E382777";
                    BYTE pdt1[400];
                    int pdt1Len = 400;
                    COMMON.convertHStrIntoHex(str2, pdt1, &pdt1Len);
                    r = ctls_setCAPK(pdt1, pdt1Len);
                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getIDGStatusCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- save CAPK  failed!! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                            strErr);
                        fflush(stdout);
                        break;
                    }
                    printf(">>set CAPK: OK.\n");
                    fflush(stdout);
                }
                break;
                case 15: {
                    printf(">>15. Remove All CAPK\n");
                    fflush(stdout);
                    r = ctls_removeAllCAPK();
                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getIDGStatusCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- remove all CAPK  failed!! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                            strErr);
                        fflush(stdout);
                        break;
                    }
                    printf(">>Remove all CAPK: OK.\n");
                    fflush(stdout);
                }
                break;
                case 16:
                    printf(">>16. Load Default CAPK\n");
                    fflush(stdout);
                    {
                        r = ctls_removeAllCAPK();
                        printf("Please Wait. Loading Default CAPK...\r\n");
                        fflush(stdout);
                        char * str22 =
                          "a000009999e10101f8707b9bedf031e58a9f843631b90c90d80ed69500000003007099c5b70aa61b4f4c51b6f90b0e3bfb7a3ee0e7db41bc466888b3ec8e9977c762407ef1d79e0afb2823100a020c3e8020593db50e90dbeac18b78d13f96bb2f57eeddc30f256592417cdf739ca6804a10a29d2806e774bfa751f22cf3b65b38f37f91b4daf8aec9b803f7610e06ac9e6b";
                        BYTE pdt22[800];
                        int pdt22Len = 800;
                        COMMON.convertHStrIntoHex(str22, pdt22, &pdt22Len);
                        r = ctls_setCAPK(pdt22, pdt22Len);
                        if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                            printf(" >>>>>>load ..... save CAPK  failed! .......... ----- \n");
                            break;
                        } else {
                            printf(">>set CAPK: OK. load ........\n");
                        }
                        fflush(stdout);
                        pdt22Len = 800;
                        str22    =
                          "a000009999e20101c1056adce9e6f76ea77c89cb832f5a4817907a1a000000030070bd232e348b118eb3f6446ef4da6c3bac9b2ae510c5ad107d38343255d21c4bdf4952a42e92c633b1ce4bfec39afb6dfe147ecbb91d681dac15fb0e198e9a7e4636bdca107bcda3384fcb28b06afef90f099e7084511f3cc010d4343503e1e5a67264b4367daa9a3949499272e9b5022f";
                        COMMON.convertHStrIntoHex(str22, pdt22, &pdt22Len);
                        r = ctls_setCAPK(pdt22, pdt22Len);
                        if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                            printf(" >>>>>>load ..... save CAPK  failed! .......... ----- \n");
                            break;
                        } else {
                            printf(">>set CAPK: OK. load ........\n");
                        }
                        fflush(stdout);
                        pdt22Len = 800;
                        str22    =
                          "a000009999e301011b795cbb0830e2c5231704fa57424d1c4e50f3e4000100010070bc01e12223e1a41e88bffa801093c5f8cec5cd05dbbdbb787ce87249e8808327c2d218991f97a1131e8a25b0122ed11e709c533e8886a1259addfdcbb396604d24e505a2d0b5dd0384fb0002a7a1eb39bc8a11339c7a9433a948337761be73bc497b8e58736da4636538ad282d3cd3db";
                        COMMON.convertHStrIntoHex(str22, pdt22, &pdt22Len);
                        r = ctls_setCAPK(pdt22, pdt22Len);
                        if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                            printf(" >>>>>>load ..... save CAPK  failed! .......... ----- \n");
                            break;
                        } else {
                            printf(">>set CAPK: OK. load ........\n");
                        }
                        fflush(stdout);
                        pdt22Len = 800;
                        str22    =
                          "a000009999e40101ac8da3e12324d719c1d5c9e6e8580157196efeb9000000030080cbf2e40f0836c9a5e390a37be3b809bdf5d740cb1da38cfc05d5f8d6b7745b5e9a3fa6961e55ff20412108525e66b970f902f7ff4305dd832cd0763e3aa8b8173f84777100b1047bd1d744509312a0932ed25fed52a959430768ccd902fd8c8ad9123e6addb3f34b92e7924d729cb6473533ae2b2b55bf0e44964fdea8440117";
                        COMMON.convertHStrIntoHex(str22, pdt22, &pdt22Len);
                        r = ctls_setCAPK(pdt22, pdt22Len);
                        if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                            printf(" >>>>>>load ..... save CAPK  failed! .......... ----- \n");
                            break;
                        } else {
                            printf(">>set CAPK: OK. load ........\n");
                        }
                        fflush(stdout);
                        pdt22Len = 800;
                        str22    =
                          "a000009999e50101ada2349afd118d55af782d37b64651af1ca61ee5000000030080d4fdae94dedbecc6d20d38b01e91826dc6954338379917b2bb8a6b36b5d3b0c5eda60b337448baffebcc3abdba869e8dadec6c870110c42f5aab90a18f4f867f72e3386ffc7e67e7ff94eba079e531b3cf329517e81c5dd9b3dc65db5f9043190be0be897e5fe48adf5d3bfa0585e076e554f26ec69814797f15669f4a255c13";
                        COMMON.convertHStrIntoHex(str22, pdt22, &pdt22Len);
                        r = ctls_setCAPK(pdt22, pdt22Len);
                        if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                            printf(" >>>>>>load ..... save CAPK  failed! .......... ----- \n");
                            break;
                        } else {
                            printf(">>set CAPK: OK. load ........\n");
                        }
                        fflush(stdout);
                        pdt22Len = 800;
                        str22    =
                          "a000009999e601018aa4f4648f0dc62ab6aed92554ad1a831bafc9e4000100010080ebf9faecc3e5c315709694664775d3fbda5a504d89344dd920c55696e891d9ab622598a9d6ab8fbf35e4599cab7eb22f956992f8ab2e6535decb6b576fa0675f97c23dd4c374a66e6af419c9d204d0b9f93c08d789d63805660fbb629df1b488cfa1d7a13e9b729437eeafe718efa859348ba0d76812a99f31cd364f2a4fd42f";
                        COMMON.convertHStrIntoHex(str22, pdt22, &pdt22Len);
                        r = ctls_setCAPK(pdt22, pdt22Len);
                        if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                            printf(" >>>>>>load ..... save CAPK  failed! .......... ----- \n");
                            break;
                        } else {
                            printf(">>set CAPK: OK. load ........\n");
                        }
                        fflush(stdout);
                        pdt22Len = 800;
                        str22    =
                          "a000000004fa01017f5acbb96b589f74cb959ed1c35bdb965c3f41060001000100f8a4203e0c7beb27097b63c103c19fdcda671aea7f813065756f3b9b81810cbd4bc4dec548fbf1f3cdae51f847235cbf2c8badd8aca7c93bea3d44e80ed6a7b70e29622619db420accce07e1dd4e6c354f359fbdc9c5b70813926f77d827e52b19daf09bfae5274438bb8f61d17753c9ec0a8efa3b7e46f02692160d2653cdbcc71b7d48bd37968316eb444f6504b9421b7dd3035a2c117d8b1f76a8975440da9563618102397b881cef8ada7689edface32482a2dffed656e7f951db841da78368c6293bfc1053a86a845bfa6578e4b69f100b42b558fde1aecec6d250741bc783aa8a68a4261e7bb9246b10587a498d68dd955ce8b2b2433";
                        COMMON.convertHStrIntoHex(str22, pdt22, &pdt22Len);
                        r = ctls_setCAPK(pdt22, pdt22Len);
                        if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                            printf(" >>>>>>load ..... save CAPK  failed! .......... ----- \n");
                            break;
                        } else {
                            printf(">>set CAPK: OK. load ........\n");
                        }
                        fflush(stdout);
                        pdt22Len = 800;
                        str22    =
                          "a000000004fb0101fc787db138f994a0c554cc6734eb3e48a55066cc0001000100909b170603a489c7546c45da57b8ffd1db2061240f0e8c6d1f9abdc6b265aa8911915c1a4eabd8d0ed4755d1b902ba06fe5a645b786cd241295517d44ef1a7c25d75afe0eb28066e4d69fee7abafdd5eeb230f14e402c9840825fa77ead12b5f1c5494701de1897f65fe6bf106d47545ebf70ce7c158068c61f0773534db742ab83c28038c1494f15905d0ad17cf1bd38d";
                        COMMON.convertHStrIntoHex(str22, pdt22, &pdt22Len);
                        r = ctls_setCAPK(pdt22, pdt22Len);
                        if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                            printf(" >>>>>>load ..... save CAPK  failed! .......... ----- \n");
                            break;
                        } else {
                            printf(">>set CAPK: OK. load ........\n");
                        }
                        fflush(stdout);
                        pdt22Len = 800;
                        str22    =
                          "a000000004fc0101db50b5b0d966300760b1e42125277ba833b652340001000100f8b3296c91f4795bd97112606903407b6eff3ab39246e91095e51d17867da4ade59a48be2fe9b52710283d3d32260e2c7d247214c57d46aa6465e47e0a4b3ffaad8a7f6a190755bccfe3f3fb3989a9f6b1c9e1845bcccad6f20b1dac6033600234e81dac4153212b0f760c23099192aa6c4c9083beffd9a79d2a27b08fecc8e5d437d6c68550a839b1294151daba9d9cb2f160f60f749289f500c8c7f334bd20ebac4ab109cf3c182f1b781c7c097a7903530746c449b99e39e4db6493dd2a02e37c62ae8bc9a7470ecccf8dc06a18c33cd24b30d56f25d2755ce82aa4de4d2eaec07750a03db75ebd0d8ebc9f2a1d85a0d252eff40329be05";
                        COMMON.convertHStrIntoHex(str22, pdt22, &pdt22Len);
                        r = ctls_setCAPK(pdt22, pdt22Len);
                        if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                            printf(" >>>>>>load ..... save CAPK  failed! .......... ----- \n");
                            break;
                        } else {
                            printf(">>set CAPK: OK. load ........\n");
                        }
                        fflush(stdout);
                        pdt22Len = 800;
                        str22    =
                          "a000000004fd0101fc505e4a83ff29a3b1bd28dabf52599b2ae9cb14000100010090c9485dbeb5e40415d1b397524f47685f306cfdc499d4e2e7d0cbaf222cfa8184bd111daeedc9cc6ec8540c3f7271ea9990119cc5c43180501d9f45252d6835053fae35696ae8cd67a325647449cf5e594da8f627209f7f03ae8d6dfc0db3e79e28e415df29a5b57d6814856cc30a96da5b8890363e507fcb2e283da1ebb5f18e8e24102b7d0192bb8e35a4f7cd05a435";
                        COMMON.convertHStrIntoHex(str22, pdt22, &pdt22Len);
                        r = ctls_setCAPK(pdt22, pdt22Len);
                        if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                            printf(" >>>>>>load ..... save CAPK  failed! .......... ----- \n");
                            break;
                        } else {
                            printf(">>set CAPK: OK. load ........\n");
                        }
                        fflush(stdout);
                        pdt22Len = 800;
                        str22    =
                          "a000000004fe01018535f14cbd6b4ae5028618fab5ac1106549fd03c000100010090e76317965175a08bee510f58830e87b262c70d529803245fa8b88e0c753562de7aeb5a9e3e6c1a98e94d8db7c31407dac5d071e06b80b09e146f22db85f1d72d1ea18d22600032c6dd40e3714d5ada7de9d7d01e88391f893156d6f4bf13e9063559da0786de9bde6b1c9b0bb968edde07145abf877b931682ccb1fb800728724d04af241e2827e0fa1f62591914ff25";
                        COMMON.convertHStrIntoHex(str22, pdt22, &pdt22Len);
                        r = ctls_setCAPK(pdt22, pdt22Len);
                        if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                            printf(" >>>>>>load ..... save CAPK  failed! .......... ----- \n");
                            break;
                        } else {
                            printf(">>set CAPK: OK. load ........\n");
                        }
                        fflush(stdout);
                        pdt22Len = 800;
                        str22    =
                          "a000000004ff0101439eb23d8a71b99f879c1a1f1765252d840b9a74000100010090f69dbb5e15983eae3ccf31cf4e47098c2fc16f97a0c710f84777efa99622d86502b138728ab12e3481a84d20e014ad2d634d2836f27f294924b895a87f91f81b8169d4dfdad8d7cbd741804cd61b467c7a9acfeceb71188caa73a907547699d45c9c7d2098ac2966266417f665a46bdd012c097dbd33d1d11aff6ec8a9c0ad814a65b48262ca011636079a328c1aaeb7";
                        COMMON.convertHStrIntoHex(str22, pdt22, &pdt22Len);
                        r = ctls_setCAPK(pdt22, pdt22Len);
                        if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                            printf(" >>>>>>load ..... save CAPK  failed! .......... ----- \n");
                            break;
                        } else {
                            printf(">>set CAPK: OK. load ........\n");
                        }
                        fflush(stdout);
                        pdt22Len = 800;
                        str22    =
                          "a000000065020101b973e9f377b419c36ac9696ed95ffb25c8020687000100010080bb7f51983fd8707fd6227c23def5d5377a5a737cef3c5252e578efe136df87b50473f9341f1640c8d258034e14c16993fce6c6b8c3ceeb65fc8fbcd8eb77b3b05ac7c4d09e0fa1ba2efe87d3184db6718ae41a7cad89b8dce0fe80ceb523d5d647f9db58a31d2e71ac677e67fa6e75820736c9893761ee4acd11f31dbdc349ef";
                        COMMON.convertHStrIntoHex(str22, pdt22, &pdt22Len);
                        r = ctls_setCAPK(pdt22, pdt22Len);
                        if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                            printf(" >>>>>>load ..... save CAPK  failed! .......... ----- \n");
                            break;
                        } else {
                            printf(">>set CAPK: OK. load ........\n");
                        }
                        fflush(stdout);
                        pdt22Len = 800;
                        str22    =
                          "a0000000650301017dc435dbde093d1f0ad0bae0fea4dc12056413dc0000000300f8c9e6c1f3c6949a8a42a91f8d0224132b2865e6d953a5b5a54cffb0412439d54aeba79e9b399a6c104684df3fb727c7f55984db7a450e6aa917e110a7f2343a0024d2785d9ebe09f601d592362fdb237700b567ba14bbe2a6d3d23cf1270b3dd822b5496549bf884948f55a0d308348c4b723bafb6a7f3975ac397cad3c5d0fc2d178716f5e8e79e75beb1c84fa202f80e68069a984e008706b30c212305456201540787925e86a8b28b129a11af204b387cb6ee43db53d15a46e13901bebd5cecf4854251d9e9875b16e82ad1c5938a972842c8f1a42ebb5ae5336b04ff3da8b8dfbe606fca8b9084ee05bf67950ba89897cd089f924dbcd";
                        COMMON.convertHStrIntoHex(str22, pdt22, &pdt22Len);
                        r = ctls_setCAPK(pdt22, pdt22Len);
                        if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                            printf(" >>>>>>load ..... save CAPK  failed! .......... ----- \n");
                            break;
                        } else {
                            printf(">>set CAPK: OK. load ........\n");
                        }
                        fflush(stdout);
                        pdt22Len = 800;
                        str22    =
                          "a000000003500101b769775668cacb5d22a647d1d993141edab7237b000100010080d11197590057b84196c2f4d11a8f3c05408f422a35d702f90106ea5b019bb28ae607aa9cdebcd0d81a38d48c7ebb0062d287369ec0c42124246ac30d80cd602ab7238d51084ded4698162c59d25eac1e66255b4db2352526ef0982c3b8ad3d1cce85b01db5788e75e09f44be7361366def9d1e1317b05e5d0ff5290f88a0db47";
                        COMMON.convertHStrIntoHex(str22, pdt22, &pdt22Len);
                        r = ctls_setCAPK(pdt22, pdt22Len);
                        if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                            printf(" >>>>>>load ..... save CAPK  failed! .......... ----- \n");
                            break;
                        } else {
                            printf(">>set CAPK: OK. load ........\n");
                        }
                        fflush(stdout);
                        pdt22Len = 800;
                        str22    =
                          "a000000003510101b9d248075a3f23b522fe45573e04374dc4995d71000000030090db5fa29d1fda8c1634b04dccff148abee63c772035c79851d3512107586e02a917f7c7e885e7c4a7d529710a145334ce67dc412cb1597b77aa2543b98d19cf2cb80c522bdbea0f1b113fa2c86216c8c610a2d58f29cf3355ceb1bd3ef410d1edd1f7ae0f16897979de28c6ef293e0a19282bd1d793f1331523fc71a228800468c01a3653d14c6b4851a5c029478e757f";
                        COMMON.convertHStrIntoHex(str22, pdt22, &pdt22Len);
                        r = ctls_setCAPK(pdt22, pdt22Len);
                        if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                            printf(" >>>>>>load ..... save CAPK  failed! .......... ----- \n");
                            break;
                        } else {
                            printf(">>set CAPK: OK. load ........\n");
                        }
                        fflush(stdout);
                        pdt22Len = 800;
                        str22    =
                          "a000000003530101ac213a2e0d2c0ca35ad0201323536d58097e4e570000000300f8bcd83721be52cccc4b6457321f22a7dc769f54eb8025913be804d9eabbfa19b3d7c5d3ca658d768caf57067eec83c7e6e9f81d0586703ed9dddadd20675d63424980b10eb364e81eb37db40ed100344c928886ff4ccc37203ee6106d5b59d1ac102e2cd2d7ac17f4d96c398e5fd993ecb4ffdf79b17547ff9fa2aa8eefd6cbda124cbb17a0f8528146387135e226b005a474b9062ff264d2ff8efa36814aa2950065b1b04c0a1ae9b2f69d4a4aa979d6ce95fee9485ed0a03aee9bd953e81cfd1ef6e814dfd3c2ce37aefa38c1f9877371e91d6a5eb59fdedf75d3325fa3ca66cdfba0e57146cc789818ff06be5fcc50abd362ae4b80996d";
                        COMMON.convertHStrIntoHex(str22, pdt22, &pdt22Len);
                        r = ctls_setCAPK(pdt22, pdt22Len);
                        if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                            printf(" >>>>>>load ..... save CAPK  failed! .......... ----- \n");
                            break;
                        } else {
                            printf(">>set CAPK: OK. load ........\n");
                        }
                        fflush(stdout);
                        pdt22Len = 800;
                        str22    =
                          "a0000000039601017616e9ac8be014af88ca11a8fb17967b7394030e000000030080b74586d19a207be6627c5b0aafbc44a2ecf5a2942d3a26ce19c4ffaeee920521868922e893e7838225a3947a2614796fb2c0628ce8c11e3825a56d3b1bbaef783a5c6a81f36f8625395126fa983c5216d3166d48acde8a431212ff763a7f79d9edb7fed76b485de45beb829a3d4730848a366d3324c3027032ff8d16a1e44d8d";
                        COMMON.convertHStrIntoHex(str22, pdt22, &pdt22Len);
                        r = ctls_setCAPK(pdt22, pdt22Len);
                        if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                            printf(" >>>>>>load ..... save CAPK  failed! .......... ----- \n");
                            break;
                        } else {
                            printf(">>set CAPK: OK. load ........\n");
                        }
                        fflush(stdout);
                        pdt22Len = 800;
                        str22    =
                          "a000000003570101251a5f5de61cf28b5c6e2b5807c0644a01d46ff5000100010060942b7f2ba5ea307312b63df77c5243618acc2002bd7ecb74d821fe7bdc78bf28f49f74190ad9b23b9713b140ffec1fb429d93f56bdc7ade4ac075d75532c1e590b21874c7952f29b8c0f0c1ce3aeedc8da25343123e71dcf86c6998e15f756e3";
                        COMMON.convertHStrIntoHex(str22, pdt22, &pdt22Len);
                        r = ctls_setCAPK(pdt22, pdt22Len);
                        if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                            printf(" >>>>>>load ..... save CAPK  failed! .......... ----- \n");
                            break;
                        } else {
                            printf(">>set CAPK: OK. load ........\n");
                        }
                        fflush(stdout);
                        pdt22Len = 800;
                        str22    =
                          "a000000003580101753ed0aa23e4cd5abd69eae7904b684a34a57c220001000100c899552c4a1ecd68a0260157fc4151b5992837445d3fc57365ca5692c87be358cdcdf2c92fb6837522842a48eb11cdffe2fd91770c7221e4af6207c2de4004c7dee1b6276dc62d52a87d2cd01fbf2dc4065db52824d2a2167a06d19e6a0f781071cdb2dd314cb94441d8dc0e936317b77bf06f5177f6c5aba3a3bc6aa30209c97260b7a1ad3a192c9b8cd1d153570afcc87c3cd681d13e997fe33b3963a0a1c79772acf991033e1b8397ad0341500e48a24770bc4cbe19d2ccf419504fdbf0389bc2f2fdcd4d44e61f";
                        COMMON.convertHStrIntoHex(str22, pdt22, &pdt22Len);
                        r = ctls_setCAPK(pdt22, pdt22Len);
                        if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                            printf(" >>>>>>load ..... save CAPK  failed! .......... ----- \n");
                            break;
                        } else {
                            printf(">>set CAPK: OK. load ........\n");
                        }
                        fflush(stdout);
                        pdt22Len = 800;
                        str22    =
                          "a00000000354010106960618791a86d387301edd4a3baf2d34fef1b40001000100f8c6ddc0b7645f7f16286ab7e4116655f56dd0c944766040dc68664dd973bd3bfd4c525bcbb95272b6b3ad9ba8860303ad08d9e8cc344a4070f4cfb9eeaf29c8a3460850c264cda39bbe3a7e7d08a69c31b5c8dd9f94ddbc9265758c0e7399adcf4362caee458d414c52b498274881b196dacca7273f687f2a65faeb809d4b2ac1d3d1efb4f6490322318bd296d153b307a3283ab4e5be6ebd910359a8565eb9c4360d24baaca3dbfe393f3d6c830d603c6fc1e83409dfcd80d3a33ba243813bbb4ceaf9cbab6b74b00116f72ab278a88a011d70071e06cab140646438d986d48281624b85b3b2ebb9a6ab3bf2178fcc3011e7caf24897ae7d";
                        COMMON.convertHStrIntoHex(str22, pdt22, &pdt22Len);
                        r = ctls_setCAPK(pdt22, pdt22Len);
                        if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                            printf(" >>>>>>load ..... save CAPK  failed! .......... ----- \n");
                            break;
                        } else {
                            printf(">>set CAPK: OK. load ........\n");
                        }
                        fflush(stdout);
                        pdt22Len = 800;
                        str22    =
                          "a000000025600101894b8df19bdc691103c3b93979f5ee28c05888a7000100010090a8ee74edef3c0dca5102ff9b5707975ff67b60d64b5e7322d48de9d3bb6153f63512a091b606dd8fd5f6a14588324ef8827844c7ffc0bab2334ae5207770078b69cdc3f2c666cf69e28e16e1816714c4df313bef539cc01da9dd2d6f47de4f247c500b561c099166ad4fc16df12dfb684ac48d35cdd2c47a13a86a5a162306f64e33b092ab74eda71a4091d96e3daa47";
                        COMMON.convertHStrIntoHex(str22, pdt22, &pdt22Len);
                        r = ctls_setCAPK(pdt22, pdt22Len);
                        if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                            printf(" >>>>>>load ..... save CAPK  failed! .......... ----- \n");
                            break;
                        } else {
                            printf(">>set CAPK: OK. load ........\n");
                        }
                        fflush(stdout);
                        pdt22Len = 800;
                        str22    =
                          "a000000025610101cccf27c49c15b2a9410ec6089223a3a01ea8433e0001000100f886c7254665e17ce6934df7d082569f208d1cc1ad8e9fb2fe23e3d7467be50b4f874f906adf2280ec9d204f6d10c037a23ce5fd8283c9ed47d1c669abdd7c1cb356c70bcdc44e5c8ae231555f7b786ac9c3155bcd51f28efbc1b33cc87277049219b2c890952736c4713487111678911d9f42e08074cf524e65d721d727f054e6b5e85ec92b3eb59ffee926dd6c314df555c94ad487a99b67cb7c7ba5e46a5b813ddb918b8e3e0423f4302a58686d1263c0baca9e82068c493289e3e6936eca5f9f77e06b0d6fbda718818b835020098c671c5dd7e9b8e8e841d2df32ee94a7f4748484ca44108ab241a5263ba1ff00d51360dddc749d30a1";
                        COMMON.convertHStrIntoHex(str22, pdt22, &pdt22Len);
                        r = ctls_setCAPK(pdt22, pdt22Len);
                        if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                            printf(" >>>>>>load ..... save CAPK  failed! .......... ----- \n");
                            break;
                        } else {
                            printf(">>set CAPK: OK. load ........\n");
                        }
                        fflush(stdout);
                        pdt22Len = 800;
                        str22    =
                          "a000000152d00101de1bb8a37cddbceaab043aaef81634120349726d000100010090d05c2a09d09c9031366ec092bcac67d4b1b4f88b10005e1fc45c1b483ae7eb86ff0e884a19c0595a6c34f06386d776a21d620fc9f9c498adca00e66d129bcdd4789837b96dcc7f09da94ccac5ac7cfc07f4600df78e493dc1957deba3f4838a4b8bd4cefe4e4c6119085e5bb21077341c568a21d65d049d666807c39c401cdfee7f7f99b8f9cb34a8841ea62e83e8d63";
                        COMMON.convertHStrIntoHex(str22, pdt22, &pdt22Len);
                        r = ctls_setCAPK(pdt22, pdt22Len);
                        if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                            printf(" >>>>>>load ..... save CAPK  failed! .......... ----- \n");
                            break;
                        } else {
                            printf(">>set CAPK: OK. load ........\n");
                        }
                        fflush(stdout);
                        pdt22Len = 800;
                        str22    =
                          "a000000152d10101ffda858cb2af08b79d750cc97fa6efe2ef228dda0001000100f8a71af977c1079304d6dff3f665ab6db3fbdfa1b170287ac6d7bc0afcb7a202a4c815e1fc2e34f75a052564ee2148a39cd6b0f39cfaef95f0294a86c3198e349ff82eece633d50e5860a15082b4b342a90928024057dd51a2401d781b67ae7598d5d1ff26a441970a19a3a58011ca19284279a85567d3119264806caf761122a71fc0492ac8d8d42b036c394fc494e03b43600d7e02cb5267755ace64437cfa7b475ad40ddc93b8c9bcad63801fc492fd251640e41fd13f6e231f56f97283447ab44cbe11910db3c75243784aa9bdf57539c31b51c9f35bf8bc2495762881255478264b792bbdca6498777ae9120ed935bb3e8bea3eab13d9";
                        COMMON.convertHStrIntoHex(str22, pdt22, &pdt22Len);
                        r = ctls_setCAPK(pdt22, pdt22Len);
                        if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                            printf(" >>>>>>load ..... save CAPK  failed! .......... ----- \n");
                            break;
                        } else {
                            printf(">>set CAPK: OK. load ........\n");
                        }
                        fflush(stdout);
                        pdt22Len = 800;
                        str22    =
                          "a000000333c001018b094d260bdf8bfc8b9a88b0c177a43fe2fae765000100010090c7cdb6f2a3fe80a8834cdddd326e1082aa2288f47c464d57b34718193431711a44119148055044cfe3313708bed0c98e1c589b0f53cf6d7e829fcd906d21a90fd4cb6baf13110c4685107c27e00981db29dc0ac186e6d701577f23865626244e1f9b2cd1ddfcb9e899b41f5084d8ccc178a7c3f4546cf93187106fab055a7ac67df62e778cb88823ba58cf7546c2b09f";
                        COMMON.convertHStrIntoHex(str22, pdt22, &pdt22Len);
                        r = ctls_setCAPK(pdt22, pdt22Len);
                        if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                            printf(" >>>>>>load ..... save CAPK  failed! .......... ----- \n");
                            break;
                        } else {
                            printf(">>set CAPK: OK. load ........\n");
                        }
                        fflush(stdout);
                        pdt22Len = 800;
                        str22    =
                          "a000000333c10101b6372db9919f8c6c9c88e83d3c600a4ad8adc7a90001000100f892f083cbe46f8dcc0c04e498ba9952ba9d4c09c80dd277e579f07e45772846fa43dd3ab31cc6b08dd18695715949fb108e53a071d393a7fddbf9c5fb0b0507138797317480fc48d633ed38b401a451443ad7f15facda45a62abe24ff6343add0909ea8389348e54e26f842880d1a69f9214368ba30c18de5c5e0cb9253b5abc55fb6ef0a738d927494a30bbf82e340285363b6faa15673829dbb210e710da58ee9e578e7ce55dc812ab7d6dcce0e3b1ae179d664f3356eb951e3c91a1cbbf6a7ca8d0c7ec9c6af7a4941c5051099b9784e56c9162067b8c3b15c5fa4480a645cd2526a69c80ba8ef361be2aa9417defce35b62b0c9cf097d";
                        COMMON.convertHStrIntoHex(str22, pdt22, &pdt22Len);
                        r = ctls_setCAPK(pdt22, pdt22Len);
                        if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                            printf(" >>>>>>load ..... save CAPK  failed! .......... ----- \n");
                        } else {
                            printf(">>set CAPK: OK. load ........\n");
                        }

                        /*
                         * str22 ="";
                         * COMMON.convertHStrIntoHex(str22,pdt22,&pdt22Len);
                         * r = emv_setCAPK(pdt22,pdt22Len);
                         * if ( r != RETURN_CODE_DO_SUCCESS ) {
                         *
                         * printf(" >>>>>>load ..... save CAPK  failed! .......... ----- \n" );
                         *
                         * }else
                         * printf(">>set CAPK: OK. load ........\n");
                         *
                         */
                        printf(">>set CAPK: OK. loaded end \n");
                        fflush(stdout);
                    }
                    break;

                case 17: {
                    printf(">>17. Show ApplePay VAS Tags \n");
                    printf("\tSend the following tags with startTranasction to utilize ApplePay VAS\r\n\r\n");

                    printf("\tApplePay VAS OR ApplePay\r\n");
                    printf("\tFFEE06189F220201009F2604000000009F2B050100000000DF010101\r\n\r\n");
                    printf("\tApplePay VAS AND ApplePay\r\n");
                    printf("\tFFEE06189F220201009F2604000000019F2B050100000000DF010101\r\n\r\n");
                    printf("\tApplePay VAS ONLY\r\n");
                    printf("\tFFEE06189F220201009F2604000000029F2B050100000000DF010101\r\n\r\n");
                    printf("\tApplePay ONLY\r\n");
                    printf("\tFFEE06189F220201009F2604000000039F2B050100000000DF010101\r\n\r\n");
                    fflush(stdout);
                }
                break;
                case 18: {
                    printf(">>18. Online Approve Message\n");
                    fflush(stdout);
                    r = ctls_displayOnlineAuthResult(1, 0, 0);
                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getIDGStatusCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Online Approved Message  failed!! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                            strErr);
                        fflush(stdout);
                        break;
                    }
                    printf(">>Online Approve Message: OK.\n");
                    fflush(stdout);
                }
                break;
                case 19: {
                    printf(">>19. Online Decline Message\n");
                    fflush(stdout);
                    r = ctls_displayOnlineAuthResult(0, 0, 0);
                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getIDGStatusCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Online Decline Message  failed!! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                            strErr);
                        fflush(stdout);
                        break;
                    }
                    printf(">>Online Decline Message: OK.\n");
                    fflush(stdout);
                }
                break;
                case 0:
                    if (isMSRBusy) {
                        printf("CTLS Busy\n");
                        choice = -1;
                    } else {
                        printf(">>0. Back To Main Menu\n");
                    }
                    fflush(stdout);
                    break;
            }
        }
    } while (choice != 0);
    // #ifdef WIN32
    if (choice == 0) {
//        idtech_process.pProcess_function_list();
        return;
    }
    // #endif
} /* _NEO2_process_ctls */

void
_NEO2_display_ctls_menu() {
    idtech_display_menu_from_lib.pDisplay_Menu_current = _NEO2_display_ctls_menu;

    if (device_getL100PassThroughMode() == 1) {
        printf("\t\t************* Config Options [L100]*************\n");
        printf("\t\t0.  Back To Main Menu\n");
        printf("\t\t1.  Get Model Number\n");
        printf("\t\t2.  Get Serial Number\n");
        printf("\t\t************************************************\n");
    } else {
        printf("\t\t************ CTLS Options [NEO]*****************\n");
        printf("\t\t0.  Back To Main Menu\n");
        printf("\t\t1.  Start CTLS Trans\n");
        printf("\t\t2.  Cancel CTLS Trans\n");
        printf("\t\t3.  Retrieve AID\n");
        printf("\t\t4.  Remove AID\n");
        printf("\t\t5.  List AID\n");
        printf("\t\t6.  Save AID\n");
        printf("\t\t7.  Get Terminal Data\n");
        printf("\t\t8.  Set Terminal Data\n");
        printf("\t\t9.  Get Config Group\n");
        printf("\t\t10. Set Config Group\n");
        printf("\t\t11. Retrieve CAPK\n");
        printf("\t\t12. Remove CAPK\n");
        printf("\t\t13. List CAPK\n");
        printf("\t\t14. Save CAPK\n");
        printf("\t\t15. Remove All CAPK\n");
        printf("\t\t16. Load Default CAPK\n");
        printf("\t\t17. Show ApplePay VAS Tags\n");
        printf("\t\t18. Online Approve Message\n");
        printf("\t\t19. Online Decline Message\n");
        printf("\t\t************************************************\n");
    }
    fflush(stdout);
} /* _NEO2_display_ctls_menu */
