#include <stdio.h>
#include <string.h>
#include "demo_common.h"

IDT_COMMON_PROCESS COMMON;
EXPORT_SYMBOLS IDT_PROCESS idtech_process;
EXPORT_SYMBOLS IDT_DEMO_LIB_DISPLAY_MENU idtech_display_menu_from_lib;

void
_L100_display_pin_menu();
void
_L100_process_pin() {
    int choice;
    int r = 0;
    char str1[256] = { 0 };

    memset(str1, 0, 256);
    pin_registerCallBk(COMMON.PIN_callBack);
    do {
        _L100_display_pin_menu();
        choice = COMMON.inputSelection();
        switch (choice) {
            case 1:
                printf(">>1. Get Encrypted PIN\n");
                fflush(stdout);
                r = pin_getEncryptedPIN(1, "4111111111111111", 16, "ENTER PIN", 9, 30);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getResponseCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Get Encrypted PIN Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Get Encrypted PIN Succeeded\n");
                    printf("Please Enter PIN on PIN Pad...\n");
                }
                fflush(stdout);
                break;
            case 2:
                printf(">>2. Prompt Key Entry\n");
                fflush(stdout);
                r = pin_promptForKeyInput(1, 0, 0, 1, 12, 20);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getResponseCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Prompt Key Entry Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Prompt Key Entry Succeeded\n");
                    printf("Please Enter Key on Key Pad...\n");
                }
                fflush(stdout);
                break;
            case 3:
                printf(">>3. Prompt Amount Entry\n");
                fflush(stdout);
                r = pin_promptForAmountInput(1, 0, 1, 12, 20);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getResponseCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Prompt Amount Entry Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Prompt Amount Entry Succeeded\n");
                    printf("Please Enter Amount on Key Pad...\n");
                }
                fflush(stdout);
                break;
            case 4:
                printf(">>4. Get Function Key\n");
                fflush(stdout);
                r = pin_getFunctionKey(20);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getResponseCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Get Function Key Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Get Function Key Succeeded\n");
                    printf("Please Press the Function Key on Key Pad...\n");
                }
                fflush(stdout);
                break;
            case 5:
                printf(">>5. Cancel PIN Entry\n");
                fflush(stdout);
                pin_cancelPINEntry();
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getResponseCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Cancel PIN Entry Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("PIN Cancel PIN Succeeded\n");
                }
                fflush(stdout);
                break;
            case 6:
                printf(">>6. Send Beep\n");
                fflush(stdout);
                r = pin_sendBeep(2000, 200);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getResponseCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Send Beep Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Send Beep Succeeded\n");
                }
                fflush(stdout);
                break;
            case 0:
                if (isPINBusy) {
                    printf("PIN Busy\n");
                    choice = -1;
                } else {
                    printf(">>0. Back To Main Menu\n");
                }
                fflush(stdout);
                break;
        }
    } while (choice != 0);
    if (choice == 0) {
        idtech_process.pProcess_function_list();
    }
} /* _L100_process_pin */

void
_L100_display_pin_menu() {
    idtech_display_menu_from_lib.pDisplay_Menu_current = _L100_display_pin_menu;
    if (device_getCurrentDeviceType() == IDT_DEVICE_L80) {
        printf("\t\t*************** PIN Options [L80] ***************\n");
    } else {
        printf("\t\t*************** PIN Options [L100] **************\n");
    }
    printf("\t\t0. Back To Main Menu\n");
    printf("\t\t1. Get Encrypted PIN\n");
    printf("\t\t2. Prompt Key Entry\n");
    printf("\t\t3. Prompt Amount Entry\n");
    printf("\t\t4. Get Function Key\n");
    printf("\t\t5. Cancel PIN Entry\n");
    printf("\t\t6. Send Beep\n");
    printf("\t\t*************************************************\n");
    fflush(stdout);
}
