#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "demo_common.h"

IDT_COMMON_PROCESS COMMON;
extern IDT_PROCESS idtech_process;
extern IDT_DEMO_LIB_DISPLAY_MENU idtech_display_menu_from_lib;

void
_L100_display_lcd_menu();

void
_L100_process_lcd() {
    int choice;
    int status;
    int r = 0;

    do {
        _L100_display_lcd_menu();
        choice = COMMON.inputSelection();
        switch (choice) {
            case 1:
                printf(">>1. Clear Display\n");
                fflush(stdout);
                r = lcd_clearDisplay(0xFF);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getResponseCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Clear Display Failed! ErrorCode: 0x%02x, Info: %s ----- \n",
                        r, strErr);
                } else {
                    printf("Clear Display Succeeded\n");
                    //				char str2[200] = {0};
                    //				sprintf(str2, "Model Number: %s\n", str1);
                    //				printf (str2);
                }
                fflush(stdout);
                break;
            case 2:
                printf(">>2. Clear Line #1\n");
                fflush(stdout);
                r = lcd_clearDisplay(0);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getResponseCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Clear Line #1 Failed! ErrorCode: 0x%02x, Info: %s ----- \n",
                        r, strErr);
                } else {
                    printf("Clear Line #1 Succeeded\n");
                }
                fflush(stdout);
                break;
            case 3:
                printf(">>3. Save Prompt\n");
                fflush(stdout);
                r = lcd_savePrompt(2, "********", 8);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getResponseCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Save Prompt Failed! ErrorCode: 0x%02x, Info: %s ----- \n",
                        r, strErr);
                } else {
                    printf("Save Prompt Succeeded\n");
                }
                fflush(stdout);
                break;
            case 4:
                printf(">>4. Display Prompt\n");
                fflush(stdout);
                r = lcd_displayPrompt(1, 1);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getResponseCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Display Prompt Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Display Prompt Succeeded\n");
                }
                fflush(stdout);
                break;
            case 5:
                printf(">>5. Display Message\n");
                fflush(stdout);
                r = lcd_displayMessage(1, "SmartPIN L100 Ready", 19);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getResponseCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Display Message Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Display Message Succeeded\n");
                }
                fflush(stdout);
                break;
            case 6:
                printf(">>6. Enable Backlight\n");
                fflush(stdout);
                r = lcd_enableBacklight(1);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getResponseCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Enable Backlight Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Enable Backlight Succeeded\n");
                }
                fflush(stdout);
                break;
            case 7:
                printf(">>7. Disable Backlight\n");
                fflush(stdout);
                r = lcd_enableBacklight(0);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getResponseCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Disable Backlight Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Disable Backlight Succeeded\n");
                }
                fflush(stdout);
                break;
            case 8:
                printf(">>8. Get Backlight Status\n");
                fflush(stdout);
                r = lcd_getBacklightStatus(&status);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getResponseCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Get Backlight Status Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Get Backlight Status Succeeded\n");
                    if (status == 1) {
                        printf("Backlight is On\n");
                    } else {
                        printf("Backlight is Off\n");
                    }
                }
                fflush(stdout);
                break;
            case 0:
                printf(">>0.Back To Main Menu\n");
                fflush(stdout);
                break;
        }
    } while (choice != 0);
    if (choice == 0) {
        idtech_process.pProcess_function_list();
    }
} /* _L100_process_lcd */

void
_L100_display_lcd_menu() {
    idtech_display_menu_from_lib.pDisplay_Menu_current = _L100_display_lcd_menu;
    if (device_getCurrentDeviceType() == IDT_DEVICE_L80) {
        printf("\t\t************* LCD Options [L80] *****************\n");
    } else {
        printf("\t\t************* LCD Options [L100] ****************\n");
    }
    printf("\t\t0.  Back To Main Menu\n");
    printf("\t\t1.  Clear Display\n");
    printf("\t\t2.  Clear Line #1\n");
    printf("\t\t3.  Save Prompt\n");
    printf("\t\t4.  Display Prompt\n");
    printf("\t\t5.  Display Message\n");
    printf("\t\t6.  Enable Backlight\n");
    printf("\t\t7.  Disable Backlight\n");
    printf("\t\t8.  Get Backlight Status\n");
    printf("\t\t*************************************************\n");
    fflush(stdout);
}
