/*
 * Copyright (C) ID TECH.
 *
 * Author: Eric
 *
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "demo_common.h"

IDT_COMMON_PROCESS COMMON;
extern IDT_PROCESS idtech_process;
extern IDT_DEMO_LIB_DISPLAY_MENU idtech_display_menu_from_lib;

static int enableICC = 0;

void
display_L100_function_menu();

void
_L100_process_function_list() {
    int choice;

    //	msr_registerCallBk(COMMON.MSR_callBack);
    msr_registerCallBkp(COMMON.MSR_callBackp);

    emv_registerCallBk(COMMON.EMV_callBack);
    emv_allowFallback(0);

    registerLogCallBk(COMMON.SendDataLog,
      COMMON.ReadDataLog);

    // Get The Device Type
    // int deviceType = 1;
    if (!enableICC) {
        icc_enable(0); // To prevent cygwin issue (exception and quit).
        //		config_setBeeperController(1);
        enableICC = 1;
    }

    do {
        display_L100_function_menu();
        choice = COMMON.inputSelection();
        if (choice >= 0 && choice <= 4) {
            break;
        }
    } while (choice != 0);
    switch (choice) {
        case 1:
            if (idtech_process.pProcess_device) {
                idtech_process.pProcess_device();
            }
            break;

        case 2:
            if (idtech_process.pProcess_config) {
                idtech_process.pProcess_config();
            }
            break;

        case 3:
            if (idtech_process.pProcess_pin) {
                idtech_process.pProcess_pin();
            }
            break;

        case 4:
            if (idtech_process.pProcess_lcd) {
                idtech_process.pProcess_lcd();
            }
            break;

        case 0:
            printf(">>0. Back To Device Selection Menu\n");
            fflush(stdout);
            idtech_display_menu_from_lib.pDisplay_Menu_current = COMMON.main_display_device_list;
            COMMON.main_process_device_select();
            break;
    }
} /* _L100_process_function_list */

void
display_L100_function_menu() {
    idtech_display_menu_from_lib.pDisplay_Menu_current = display_L100_function_menu;
    if (device_getCurrentDeviceType() == IDT_DEVICE_L80) {
        printf("\t\t************* Universal SDK: [L80] *************\n");
    } else {
        printf("\t\t************* Universal SDK: [L100] ************\n");
    }
    printf("\t\t0. Back To Device Selection Menu\n");
    printf("\t\t1. Device\n");
    printf("\t\t2. Config\n");
    printf("\t\t3. PIN\n");
    printf("\t\t4. LCD\n");
    printf("\t\t************************************************\n");
    fflush(stdout);
}
