#include <stdio.h>
#include <string.h>
#include "demo_common.h"

IDT_COMMON_PROCESS COMMON;
extern IDT_PROCESS idtech_process;
extern IDT_DEMO_LIB_DISPLAY_MENU idtech_display_menu_from_lib;

void
_L100_display_device_menu();

void
_L100_process_device() {
    int choice;
    int r = 0;
    char str1[256] = { 0 };
    int len        = 512;

    memset(str1, 0, 256);
    do {
        _L100_display_device_menu();
        choice = COMMON.inputSelection();
        switch (choice) {
            case 1: {
                printf(">>1. Get Firmware Version\n");
                fflush(stdout);
                r = device_getFirmwareVersion(str1);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getResponseCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Get Firmware Version Failed! ErrorCode: 0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    char str2[200] = { 0 };
                    sprintf(str2, "Firmware version: %s\n", str1);
                    printf(str2);
                }
                fflush(stdout);
            }
            break;
            case 2: {
                printf(">>2. Reboot Device\n");
                fflush(stdout);
                r = device_rebootDevice();
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getResponseCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Do device_rebootDevice(), failed! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                        strErr);
                } else {
                    //					char str2[200] = {0};
                    printf("Reboot Device Success!");
                }
                fflush(stdout);
            }
            break;
            case 3: {
                printf(">>3. Send Command\n");
                fflush(stdout);
                BYTE bbyte[5] = { 0x00 };
                int cmdlen;
                BYTE cmdData[_DATA_BUF_LEN] = { 0x00 };
                int cmdDataLen;
                bbyte[0] = 0x78;
                bbyte[1] = 0x31;
                cmdlen   = 2;
                BYTE rbbyte[512] = { 0 };
                memset(rbbyte, 0, 512);
                len = 512;

                r = device_SendDataCommand(bbyte, cmdlen, NULL, 0, rbbyte, &len);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getResponseCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Do device_SendDataCommand(), failed! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                        strErr);
                } else {
                    char str3[1024] = { 0 };
                    memset(str3, 0, 1024);
                    COMMON.convertBytesIntoHexStr(rbbyte, len, 0, str3);
                    printf("response code : %s\n", str3);
                }
                fflush(stdout);
            }
            break;
            case 4:
                printf(">>4. Get Key Status\n");
                fflush(stdout);
                {
                    int newFormat    = 0;
                    BYTE status[100] = { 0 };
                    int statusLen    = 100;
                    int rt = device_getKeyStatus(&newFormat, status, &statusLen);
                    if (0 == newFormat && rt == RETURN_CODE_DO_SUCCESS && statusLen > 0) {
                        printf("Get Key Status succeeded:\r\n");
                        if (status[0] == 0x01) {
                            printf("\tPIN DUKPT Key Loaded\r\n");
                        } else if (status[0] == 0xFF) {
                            printf("\tPIN DUKPT Key STOP\r\n");
                        } else {
                            printf("\tPIN DUKPT Key NOT Loaded\r\n");
                        }
                        if (status[1] == 0x01) {
                            printf("\tPIN Master Key Loaded\r\n");
                        } else {
                            printf("\tPIN Master Key NOT Loaded\r\n");
                        }
                        if (status[2] == 0x01) {
                            printf("\tStandard PIN Session Key Loaded\r\n");
                        } else {
                            printf("\tStandardPIN Session Key NOT Loaded\r\n");
                        }
                        if (status[3] == 0x01) {
                            printf("\tDesjardins PIN Session Key Loaded\r\n");
                        } else {
                            printf("\tDesjardins PIN Session Key NOT Loaded\r\n");
                        }
                        if (status[4] == 0x01) {
                            printf("\tMSR DUKPT Key Loaded\r\n");
                        } else if (status[4] == 0xFF) {
                            printf("\tMSR DUKPT Key STOP\r\n");
                        } else {
                            printf("\tMSR DUKPT Key NOT Loaded\r\n");
                        }
                        if (status[5] == 0x01) {
                            printf("ICC DUKPT Key Loaded\r\n");
                        } else if (status[5] == 0xFF) {
                            printf("\tICC DUKPT Key STOP\r\n");
                        } else {
                            printf("\tICC DUKPT Key NOT Loaded\r\n");
                        }
                        if (status[6] == 0x01) {
                            printf("\tAdmin Key Loaded\r\n");
                        } else if (status[6] == 0xFF) {
                            printf("\tAdmin Key STOP\r\n");
                        } else {
                            printf("\tAdmin Key NOT Loaded\r\n");
                        }
                        if (status[7] == 0x01) {
                            printf("\tData DUKPT Key Loaded\r\n");
                        } else if (status[7] == 0xFF) {
                            printf("\tData DUKPT Key STOP\r\n");
                        } else {
                            printf("\tData DUKPT Key NOT Loaded\r\n");
                        }
                        if (status[8] == 0x01) {
                            printf("\tMAC DUKPT Key Loaded\r\n");
                        } else if (status[8] == 0xFF) {
                            printf("\tMAC DUKPT Key STOP\r\n");
                        } else {
                            printf("\tMAC DUKPT Key NOT Loaded\r\n");
                        }
                    } else {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getResponseCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n	----- Do device_getKeyStatus(), failed! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                            strErr);
                    }
                    fflush(stdout);
                }
                break;
            case 5: {
                printf(">>5. Set Date/Time\n");
                int r = device_setDateTime();
                if (r == RETURN_CODE_DO_SUCCESS) {
                    printf("Set Date Time Successful.\r\n");
                } else {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getResponseCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Do device_setDateTime(), failed! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                        strErr);
                }
            }
            break;
            case 6: {
                printf(">>6. Get Date/Time\n");
                fflush(stdout);
                BYTE dateTime[6] = { 0 };

                r = device_getDateTime(dateTime);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getResponseCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Do device_SendDataCommand(), failed! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                        strErr);
                } else {
                    char str3[50] = { 0 };
                    memset(str3, 0, 50);
                    COMMON.convertBytesIntoHexStr(dateTime, 6, 0, str3);
                    printf("response code : %s\n", str3);
                }
                fflush(stdout);
            }
            break;
                #if 0
            case 4: {
                printf(">>4. Update Firmware\n");
                char firmware_file_name[30];
                printf("Please enter the firmware file name (Ex. MiniSmartII_S_TTK_V1.00.XXX.fm):\n");
                fflush(stdout);
                fgets(firmware_file_name, 30, stdin);
                int i;
                for (i = 0; i < 30; i++) {
                    if (firmware_file_name[i] == '\n' || firmware_file_name[i] == '\r') {
                        firmware_file_name[i] = '\0';
                        break;
                    }
                }

                FILE * fp;
                if (NULL == (fp = fopen(firmware_file_name, "rb"))) {
                    printf("Could not open file %s\n", firmware_file_name);
                    fflush(stdout);
                    break;
                }

                BYTE firmwareData[_FIRMWARE_BUF_LEN / 4];
                int fw_size = 0;

                fseek(fp, 0, SEEK_END);
                fw_size = ftell(fp);
                if (fw_size > _FIRMWARE_BUF_LEN / 4) {
                    printf("Not enough buffer\n");
                    fflush(stdout);
                    break;
                }

                fseek(fp, 0, SEEK_SET);
                fread(firmwareData, fw_size, 1, fp);
                fclose(fp);

                printf("Firmware file size: %d\n", fw_size);
                printf("\033[1;31mUpdating firmware, please do not unplug the reader or close this program...\033[0m\n");
                fflush(stdout);
                r = device_updateFirmware(firmwareData, fw_size, firmware_file_name, 0, NULL, 0);
                if (r != RETURN_CODE_DO_SUCCESS) {
                    if (r == RETURN_CODE_FW_INIT_SUCCESS) {
                        //						printf("Initialize Firmware Update succeeded, please re-select the device after reboot, and do Update Firmware again.\n");
                        printf(
                            "\033[1;31mInitialize Firmware Update succeeded, please re-select the same device through Device Select Options menu, and do Update Firmware again.\033[0m\n");
                        printf(
                            "\033[1;31mWarning: Please do NOT close this program before firmware update is done.\033[0m\n");
                    } else {
                        //						printf("Firmware Update failed!\n");
                        printf("\033[1;31mFirmware Update failed!\033[0m\n");
                        printf("Error code: 0x%04X\n", r);
                    }
                } else {
                    //					printf("Firmware Update succeeded.\n");
                    printf(
                        "\033[1;31mFirmware Update succeeded.  Please re-select a device through Device Select Options menu.\033[0m\n");
                }
                fflush(stdout);
            }
            break;
                #endif /* if 0 */
            //		case 13:
            //		{
            //			printf(">>13. USB KB Mode\n");
            //			int r = msr_switchUSBInterfaceMode(1);
            //			if (r == RETURN_CODE_DO_SUCCESS)
            //			{
            //				printf("Set USB KB Mode Succeeded.\r\n");
            //			}
            //			else
            //			{
            //			   char strErr[200] = {0};
            //			   memset(strErr,0,200);
            //			   device_getResponseCodeString(r, strErr);
            //			   printf(">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Do msr_switchUSBInterfaceMode(), failed! ErrorCode:0x%02x ,Info: %s ----- \n",r,strErr);
            //		   }
            //		}
            //		break;
            //		case 14:
            //		{
            //			printf(">>14. USB HID Mode\n");
            //			int r = msr_switchUSBInterfaceMode(0);
            //			if (r == RETURN_CODE_DO_SUCCESS)
            //			{
            //				printf("Set USB KB Mode Succeeded.\r\n");
            //			}
            //			else
            //			{
            //			   char strErr[200] = {0};
            //			   memset(strErr,0,200);
            //			   device_getResponseCodeString(r, strErr);
            //			   printf(">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Do msr_switchUSBInterfaceMode(), failed! ErrorCode:0x%02x ,Info: %s ----- \n",r,strErr);
            //		   }
            //		}
            //		break;
            case 0:
                printf(">>0.Back To Main Menu\n");
                fflush(stdout);
                break;
        }
    } while (choice != 0);
    if (choice == 0) idtech_process.pProcess_function_list();
} /* _L100_process_device */

void
_L100_display_device_menu()
{
    idtech_display_menu_from_lib.pDisplay_Menu_current = _L100_display_device_menu;
    if (device_getCurrentDeviceType() == IDT_DEVICE_L80)
        printf("\t\t************* Device Options [L80] **************\n");
    else
        printf("\t\t************* Device Options [L100] *************\n");
    printf("\t\t0.  Back To Main Menu\n");
    printf("\t\t1.  Get Firmware Version\n");
    printf("\t\t2.  Reboot Device\n");
    printf("\t\t3.  Send Command\n");
    printf("\t\t4.  Get Key Status\n");
    printf("\t\t5.  Set Date/Time\n");
    printf("\t\t6.  Get Date/Time\n");
    #if 0
    printf("\t\t4.  Update Firmware (Need to run twice)\n");
    #endif
    printf("\t\t*************************************************\n");
    fflush(stdout);
}
