/**
 *  \mainpage libpos API Reference
 *
 *  \section objects POS objects
 *
 */


#ifndef __LIBDEMO_KIOSKIII_C___
#define __LIBDEMO_KIOSKIII_C___

#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <memory.h>
#include "libDemo_KioskIII.h"
#ifndef WIN32
# include <dlfcn.h>
#endif

// KioskIII process
extern void
_KioskIII_process_function_list();
extern void
_KioskIII_process_device();
extern void
_KioskIII_process_ctls();

extern void
_KioskIII_display_ctls_menu();
extern void
_KioskIII_display_device_menu();


IDT_COMMON_PROCESS COMMON;
IDT_PROCESS idtech_process;
IDT_DEMO_LIB_DISPLAY_MENU idtech_display_menu_from_lib;


void
IDT_PROCESS_clean() {
    idtech_process.pProcess_function_list = NULL;
    idtech_process.pProcess_device        = NULL;
    idtech_process.pProcess_config        = NULL;
    idtech_process.pProcess_msr = NULL;
    idtech_process.pProcess_icc = NULL;
    idtech_process.pProcess_emv = NULL;
    idtech_process.pProcess_pin = NULL;
}

void
libDemo_getMenuFn(IDT_DEMO_LIB_DISPLAY_MENU * _idtech_display_menu_from_lib) {
    *_idtech_display_menu_from_lib = idtech_display_menu_from_lib;
}

void
libDemo_init(IDT_COMMON_PROCESS _demo_Common_Process, IDT_DEMO_LIB_DISPLAY_MENU * _idtech_display_menu_from_lib) {
    COMMON = _demo_Common_Process;
    // intialize the process function
    IDT_PROCESS_clean();
    idtech_process.pProcess_function_list = _KioskIII_process_function_list;
    idtech_process.pProcess_device        = _KioskIII_process_device;
    idtech_process.pProcess_ctls = _KioskIII_process_ctls;

    // intialize the display menu callback
    //	idtech_display_menu_from_lib.pDisplay_Menu_ctls = _KioskIII_display_device_menu;//_KioskIII_display_ctls_menu;
    idtech_display_menu_from_lib = *_idtech_display_menu_from_lib;

    idtech_display_menu_from_lib.pDisplay_Menu_ctls   = _KioskIII_display_ctls_menu;
    idtech_display_menu_from_lib.pDisplay_Menu_device = _KioskIII_display_device_menu;
    *_idtech_display_menu_from_lib = idtech_display_menu_from_lib;
    // into the function menu selection
    idtech_process.pProcess_function_list();
}

#endif /* ifndef __LIBDEMO_KIOSKIII_C___ */
