#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include "demo_common.h"

extern IDT_COMMON_PROCESS COMMON;
extern IDT_PROCESS idtech_process;
extern IDT_DEMO_LIB_DISPLAY_MENU idtech_display_menu_from_lib;

void
_KioskIII_display_device_menu();

int dt = 0;

void
_KioskIII_process_device() {
    int choice;
    int r = 0;
    char str1[256] = { 0 };
    int len        = 512;

    memset(str1, 0, 256);
    IDTMSRData cardData;

    dt = device_getCurrentDeviceType();

    do {
        _KioskIII_display_device_menu();
        //		printf("Please Input your Selection:\n");
        //		scanf("%d",&choice);
        choice = COMMON.inputSelection();
        switch (choice) {
            case 1: {
                printf(">>1. Get Firmware Version\n");
                fflush(stdout);
                r = device_getFirmwareVersion(str1);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Get Firmware Version Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    char str2[200] = { 0 };
                    sprintf(str2, "Firmware version: %s\n", str1);
                    printf(str2);
                }
                fflush(stdout);
            }
            break;
            case 2: {
                printf(">>2. Send Command: 0x29, 0x00\n");
                fflush(stdout);
                BYTE rbbyte[512] = { 0 };
                memset(rbbyte, 0, 512);
                len = 512;

                //				r = device_SendDataCommand(bbyte,cmdlen,cmdData,cmdDataLen,rbbyte,&len);
                r = device_SendDataCommandNEO(0x29, 0x00, NULL, 0, rbbyte, &len);

                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Do device_SendDataCommand(), failed! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                        strErr);
                } else {
                    char str3[1024] = { 0 };
                    memset(str3, 0, 1024);
                    COMMON.convertBytesIntoHexStr(rbbyte, len, 0, str3);
                    printf("response code : %s\n", str3);
                    int i;
                    for (i = 0; i < len; i++) {
                        printf("%c", rbbyte[i]);
                    }
                    printf("\n");
                }
                fflush(stdout);
            }
            break;
            case 3: {
                printf(">>3. Get Serial Number\n");
                fflush(stdout);
                r = config_getSerialNumber(str1);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Get Serial Number Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    char str2[200] = { 0 };
                    sprintf(str2, "Serial Number: %s\n", str1);
                    printf(str2);
                }
                fflush(stdout);
            }
            break;
            case 4: {
                printf(">>4. Ping Device\n");
                fflush(stdout);
                r = device_pingDevice();
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Ping Device Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Ping Device Succeeded\n");
                }
                fflush(stdout);
            }
            break;
            case 5: {
                printf(">>5. Interface Control\n");
                fflush(stdout);
                BYTE values[4] = { 0xFF, 0x04, 0xFF, 0x01 };
                r = device_controlUserInterface(values);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Interface Control Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Interface Control Succeeded\n");
                }
                fflush(stdout);
            }
            break;
            case 6:
                printf(">>6. Pass Through On\n");
                fflush(stdout);
                r = device_enablePassThrough(1);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Pass Through On Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Pass Through On Succeeded\n");
                }
                fflush(stdout);
                break;
            case 7:
                printf(">>7. Pass Through Off\n");
                fflush(stdout);
                r = device_enablePassThrough(0);
                if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                    char strErr[200] = { 0 };
                    memset(strErr, 0, 200);
                    device_getIDGStatusCodeString(r, strErr);
                    printf(
                        ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Pass Through Off Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                        strErr);
                } else {
                    printf("Pass Through Off Succeeded\n");
                }
                fflush(stdout);
                break;
            case 8:
                if (dt == IDT_DEVICE_KIOSK_III) {
                    printf(">>8. Set Burst On\n");
                    fflush(stdout);
                    r = device_setBurstMode(1);
                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getIDGStatusCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Set Burst On Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                            strErr);
                    } else {
                        printf("Set Burst On Succeeded\n");
                    }
                    fflush(stdout);
                } else {
                    printf(">>8. Set Auto Poll On\n");
                    fflush(stdout);
                    r = device_setPollMode(0);
                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getIDGStatusCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Set Auto Poll On Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                            strErr);
                    } else {
                        printf("Set Auto Poll On Succeeded\n");
                    }
                    fflush(stdout);
                }
                break;
            case 9:
                if (dt == IDT_DEVICE_KIOSK_III) {
                    printf(">>9. Set Burst Off\n");
                    fflush(stdout);
                    r = device_setBurstMode(0);
                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getIDGStatusCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Set Burst Off Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                            strErr);
                    } else {
                        printf("Set Burst Off Succeeded\n");
                    }
                    fflush(stdout);
                } else {
                    printf(">>9. Poll On Demand\n");
                    fflush(stdout);
                    r = device_setPollMode(1);
                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getIDGStatusCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Poll On Demand Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                            strErr);
                    } else {
                        printf("Set Poll On Demand Succeeded\n");
                    }
                    fflush(stdout);
                }
                break;

            case 10:
                if (dt == IDT_DEVICE_KIOSK_III || dt == IDT_DEVICE_KIOSK_III_COM) {
                    printf(">>10. Set Auto Poll On\n");
                    fflush(stdout);
                    r = device_setPollMode(0);
                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getIDGStatusCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Set Auto Poll On Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                            strErr);
                    } else {
                        printf("Set Auto Poll On Succeeded\n");
                    }
                    fflush(stdout);
                } else {
                    printf(">>10. Set Merchant Record\n");
                    fflush(stdout);
                    r = device_setMerchantRecord(1, 1, "pass.com.firstdata.money2020", null);
                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getIDGStatusCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Set Merchant Record Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                            strErr);
                    } else {
                        printf("Set Merchant Record Succeeded\n");
                    }
                    fflush(stdout);
                }
                break;
            case 11:
                if (dt == IDT_DEVICE_KIOSK_III || dt == IDT_DEVICE_KIOSK_III_COM) {
                    printf(">>11. Poll On Demand\n");
                    fflush(stdout);
                    r = device_setPollMode(1);
                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getIDGStatusCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Poll On Demand Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                            strErr);
                    } else {
                        printf("Set Poll On Demand Succeeded\n");
                    }
                    fflush(stdout);
                } else {
                    printf(">>11. Get Merchant Record\n");
                    fflush(stdout);
                    BYTE record[0x63];
                    memset(record, 0, 0x63);
                    r = device_getMerchantRecord(1, record);
                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getIDGStatusCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Get Merchant Record Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                            strErr);
                    } else {
                        printf("Get Merchant Record Succeeded\n");
                        int i;
                        printf("Record:\n");
                        for (i = 0; i < 0x63; i++) {
                            printf("%02X", record[i]);
                        }
                        printf("\n");
                    }
                    fflush(stdout);
                }
                break;
            case 12:
                if (dt == IDT_DEVICE_KIOSK_III || dt == IDT_DEVICE_KIOSK_III_COM) {
                    printf(">>12. Set Merchant Record\n");
                    fflush(stdout);
                    r = device_setMerchantRecord(1, 1, "pass.com.firstdata.money2020", null);
                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getIDGStatusCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Set Merchant Record Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                            strErr);
                    } else {
                        printf("Set Merchant Record Succeeded\n");
                    }
                    fflush(stdout);
                } else {
                    printf(">>12. Get Transaction Results\n");
                    fflush(stdout);
                    r = device_getTransactionResults(&cardData);
                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getIDGStatusCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Do device_SendDataCommand(), failed! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                            strErr);
                    } else {
                        COMMON.printMSRData(&cardData);
                    }
                    fflush(stdout);
                }
                break;
            case 13:
                if (dt == IDT_DEVICE_KIOSK_III || dt == IDT_DEVICE_KIOSK_III_COM) {
                    printf(">>13. Get Merchant Record\n");
                    fflush(stdout);
                    BYTE record[0x63];
                    memset(record, 0, 0x63);
                    r = device_getMerchantRecord(1, record);
                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getIDGStatusCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Get Merchant Record Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                            strErr);
                    } else {
                        printf("Get Merchant Record Succeeded\n");
                        int i;
                        printf("Record:\n");
                        for (i = 0; i < 0x63; i++) {
                            printf("%02X", record[i]);
                        }
                        printf("\n");
                    }
                    fflush(stdout);
                } else {
                    printf(">>13. Start Remote Key Injection\n");
                    char option[10] = { 0 };
                    while (option[0] != '0' && option[0] != '1') {
                        printf("Please enter 0 for Demo unit or 1 for Production unit:\n");
                        fflush(stdout);
                        fgets(option, 10, stdin);
                    }
                    int opt = 0;
                    if (option[0] == '1') {
                        opt = 1;
                    }
                    //			fflush(stdout);
                    r = device_startRKI(NULL, opt);
                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getIDGStatusCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Remote Key Injection Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                            strErr);
                    } else {
                        printf("Start Remote Key Injection, please wait...\n");
                    }
                    fflush(stdout);
                }
                break;
            case 14:
                if (dt == IDT_DEVICE_KIOSK_III || dt == IDT_DEVICE_KIOSK_III_COM) {
                    printf(">>14. Get Transaction Results\n");
                    fflush(stdout);
                    r = device_getTransactionResults(&cardData);
                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getIDGStatusCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Do device_SendDataCommand(), failed! ErrorCode:0x%02x ,Info: %s ----- \n", r,
                            strErr);
                    } else {
                        COMMON.printMSRData(&cardData);
                    }
                    fflush(stdout);
                } else {
                    printf(">>14. Update Firmware\n");
                    fflush(stdout);
                    char firmware_file_name[50];
                    memset(firmware_file_name, 0, 50);
                    printf("Please enter the firmware file name (Ex. Kiosk III NEO v1.10.064.S_ENC_USBHID.txt):\n");
                    fflush(stdout);
                    fgets(firmware_file_name, 50, stdin);
                    int i;
                    for (i = 49; i >= 0; i--) {
                        if (firmware_file_name[i] == '\n' || firmware_file_name[i] == '\r') {
                            firmware_file_name[i] = '\0';
                            break;
                        }
                    }
                    printf("Firmware File Name: %s\n", firmware_file_name);
                    FILE * fp;
                    if (NULL == (fp = fopen(firmware_file_name, "r"))) {
                        printf("Could not open file %s\n", firmware_file_name);
                        break;
                    }
                    fflush(stdout);
                    char firmwareData[_FIRMWARE_BUF_LEN];
                    memset(firmwareData, 0, _FIRMWARE_BUF_LEN);
                    int fw_lines = 0;
                    int idx      = 0;
                    char * line  = firmware_file_name;
                    char temp[_FIRMWARE_CMD_LEN];
                    while (!feof(fp) && strcmp(line, "END>")) {
                        if (idx >= _FIRMWARE_BUF_LEN) {
                            break;
                        }
                        memset(temp, 0, _FIRMWARE_CMD_LEN);
                        fgets(temp, _FIRMWARE_CMD_LEN, fp);
                        for (i = (_FIRMWARE_CMD_LEN) -1; i >= 0; i--) {
                            if (temp[i] == '\n' || temp[i] == '\r') {
                                temp[i] = '\0';
                                break;
                            }
                        }
                        line = temp;
                        strcpy(&(firmwareData[idx]), temp);
                        fw_lines++;
                        idx += strlen(temp) + 1;
                    }
                    fclose(fp);
                    if (idx >= _FIRMWARE_BUF_LEN) {
                        printf("Not enough buffer\n");
                        fflush(stdout);
                        break;
                    }
                    printf("\033[1;31mUpdating firmware, please do not unplug the reader or exit this demo...\033[0m\n");
                    fflush(stdout);
                    //				printf("Firmware Update, please do not unplug the reader or close this program...\n");
                    r = device_updateFirmware(firmwareData, idx, NULL, 0, NULL, 0);
                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        if (r == IDG_P2_STATUS_CODE_FW_INIT_SUCCESS) {
                            //						printf("Initialize Firmware Update succeeded, please re-select the device after reboot, and do Update Firmware again.\n");
                            //						if (device_getCurrentDeviceType() == IDT_DEVICE_KIOSK_III_S)
                            if (dt == IDT_DEVICE_KIOSK_III_S) {
                                //							printf("\033[1;31mInitialize Firmware Update succeeded, please re-select the same device through Device Select Options menu, and do Update Firmware again.\033[0m\n");
                                printf(
                                    "\033[1;31mInitialize Firmware Update succeeded, please do the Firmware Update again after the reader is reconnected (do NOT exit this menu).\033[0m\n");
                            } else {
                                printf(
                                    "\033[1;31mInitialize Firmware Update succeeded, please do Update Firmware again.\033[0m\n");
                            }
                            printf(
                                "\033[1;31mWarning: Please do NOT close this program before firmware update is done.\033[0m\n");
                        } else {
                            //						printf("Firmware Update failed!\n");
                            printf("\033[1;31mFirmware Update failed!\033[0m\n");
                            printf("Error code: 0x%04X\n", r);
                        }
                    } else {
                        //					printf("Firmware Update succeeded.\n");
                        printf(
                            "\033[1;31mFirmware Update succeeded.  Please re-select a device through Device Select Options menu.\033[0m\n");
                    }
                    fflush(stdout);
                }
                break;
            case 15:
                //			if (device_getCurrentDeviceType() == IDT_DEVICE_KIOSK_III || device_getCurrentDeviceType() == IDT_DEVICE_KIOSK_III_COM)
                if (dt == IDT_DEVICE_KIOSK_III || dt == IDT_DEVICE_KIOSK_III_COM) {
                    printf(">>15. Start Remote Key Injection\n");
                    char option[10] = { 0 };
                    while (option[0] != '0' && option[0] != '1') {
                        printf("Please enter 0 for Demo unit or 1 for Production unit:\n");
                        fflush(stdout);
                        fgets(option, 10, stdin);
                    }
                    int opt = 0;
                    if (option[0] == '1') {
                        opt = 1;
                    }
                    //			fflush(stdout);
                    r = device_startRKI(NULL, opt);
                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        char strErr[200] = { 0 };
                        memset(strErr, 0, 200);
                        device_getIDGStatusCodeString(r, strErr);
                        printf(
                            ">>>>>>>>>>>>FAIL<<<<<<<<<<<<< \n   ----- Remote Key Injection Failed! ErrorCode:0x%02x, Info: %s ----- \n", r,
                            strErr);
                    } else {
                        printf("Start Remote Key Injection, please wait...\n");
                    }
                    fflush(stdout);
                }
                break;
            case 16:
                if (dt == IDT_DEVICE_KIOSK_III || dt == IDT_DEVICE_KIOSK_III_COM) {
                    printf(">>16. Update Firmware\n");
                    fflush(stdout);
                    char firmware_file_name[50];
                    memset(firmware_file_name, 0, 50);
                    printf("Please enter the firmware file name (Ex. Kiosk III NEO v1.10.064.S_ENC_USBHID.txt):\n");
                    fflush(stdout);
                    fgets(firmware_file_name, 50, stdin);
                    int i;
                    for (i = 49; i >= 0; i--) {
                        if (firmware_file_name[i] == '\n' || firmware_file_name[i] == '\r') {
                            firmware_file_name[i] = '\0';
                            break;
                        }
                    }
                    printf("Firmware File Name: %s\n", firmware_file_name);
                    FILE * fp;
                    if (NULL == (fp = fopen(firmware_file_name, "r"))) {
                        printf("Could not open file %s\n", firmware_file_name);
                        fflush(stdout);
                        break;
                    }
                    fflush(stdout);

                    char firmwareData[_FIRMWARE_BUF_LEN];
                    memset(firmwareData, 0, _FIRMWARE_BUF_LEN);
                    int fw_lines = 0;
                    int idx      = 0;
                    char * line  = firmware_file_name;
                    char temp[_FIRMWARE_CMD_LEN];
                    while (!feof(fp) && strcmp(line, "END>")) {
                        if (idx >= _FIRMWARE_BUF_LEN) {
                            break;
                        }
                        memset(temp, 0, _FIRMWARE_CMD_LEN);
                        fgets(temp, _FIRMWARE_CMD_LEN, fp);
                        for (i = (_FIRMWARE_CMD_LEN) -1; i >= 0; i--) {
                            if (temp[i] == '\n' || temp[i] == '\r') {
                                temp[i] = '\0';
                                break;
                            }
                        }
                        line = temp;
                        strcpy(&(firmwareData[idx]), temp);
                        fw_lines++;
                        idx += strlen(temp) + 1;
                    }
                    fclose(fp);
                    if (idx >= _FIRMWARE_BUF_LEN) {
                        printf("Not enough buffer\n");
                        fflush(stdout);
                        break;
                    }
                    printf("\033[1;31mUpdating firmware, please do not unplug the reader or exit this demo...\033[0m\n");
                    fflush(stdout);
                    r = device_updateFirmware(firmwareData, idx, NULL, 0, NULL, 0);

                    if (r != IDG_P2_STATUS_CODE_DO_SUCCESS) {
                        if (r == IDG_P2_STATUS_CODE_FW_INIT_SUCCESS) {
                            //						if (device_getCurrentDeviceType() == IDT_DEVICE_KIOSK_III)
                            //							printf("\033[1;31mInitialize Firmware Update succeeded, please go back to Interface Select Options menu after the reader is reconnected, reselect USB and then reselect the same device through Device Select Options menu, and do Update Firmware again.\033[0m\n");
                            printf(
                                "\033[1;31mInitialize Firmware Update succeeded, please do the Firmware Update again after the reader is reconnected (do NOT exit this menu).\033[0m\n");
                            //						else
                            //							printf("\033[1;31mInitialize Firmware Update succeeded, please do Update Firmware again.\033[0m\n");
                            //						printf("\033[1;31mWarning: Please do NOT exit the demo before firmware update is done.\033[0m\n");
                        } else {
                            printf("\033[1;31mFirmware Update failed!\033[0m\n");
                            printf("Error code: 0x%04X\n", r);
                        }
                    } else {
                        mssleep(3000);
                        //					printf("\033[1;31mFirmware Update succeeded.  Please re-select a device through Device Select Options menu.\033[0m\n");
                        printf(
                            "\033[1;31mFirmware Update succeeded.  Please exit the demo and reboot the reader.\033[0m\n");
                        //					printf("\033[1;31mFirmware Update succeeded.  Please exit the demo.\033[0m\n");
                    }
                    fflush(stdout);
                }
                break;
            case 0:
                printf(">>0.Back To Main Menu\n");
                fflush(stdout);
                break;
        }
    } while (choice != 0);
    // #ifdef WIN32
    if (choice == 0) {
//        idtech_process.pProcess_function_list();
        return;
    }
    // #endif
} /* _KioskIII_process_device */

void
_KioskIII_display_device_menu() {
    idtech_display_menu_from_lib.pDisplay_Menu_current = _KioskIII_display_device_menu;
    //	if (device_getCurrentDeviceType() == IDT_DEVICE_KIOSK_III || device_getCurrentDeviceType() == IDT_DEVICE_KIOSK_III_COM)
    if (dt == IDT_DEVICE_KIOSK_III || dt == IDT_DEVICE_KIOSK_III_COM) {
        // #ifdef WIN32
        //		printf("\t\t********** Device Options [Kiosk II/III/IV]***********\n");
        // #else
        printf("\t\t********** Device Options [Kiosk III/IV]***********\n");
    }
    // #endif
    else {
        printf("\t\t********** Device Options [Kiosk III S]***********\n");
    }
    printf("\t\t0.  Back To Main Menu\n");
    printf("\t\t1.  Get Firmware Version\n");
    printf("\t\t2.  Send Data Command\n");
    printf("\t\t3.  Get Serial Number\n");
    printf("\t\t4.  Ping Device\n");
    printf("\t\t5.  Interface Control\n");
    printf("\t\t6.  Enable Passthrough\n");
    printf("\t\t7.  Disable Passthrough\n");
    //	if (device_getCurrentDeviceType() == IDT_DEVICE_KIOSK_III || device_getCurrentDeviceType() == IDT_DEVICE_KIOSK_III_COM)
    if (dt == IDT_DEVICE_KIOSK_III || dt == IDT_DEVICE_KIOSK_III_COM) {
        printf("\t\t8.  Burst Mode ON\n");
        printf("\t\t9.  Burst Mode OFF\n");
        printf("\t\t10. Auto Poll\n");
        printf("\t\t11. Poll On Demand\n");
        printf("\t\t12. Set Merchant Record\n");
        printf("\t\t13. Get Merchant Record\n");
        printf("\t\t14. Get Transaction Results\n");
        printf("\t\t15. Start Remote Key Injection\n");
        printf("\t\t16. Update Firmware (Need to run twice)\n");
    } else {
        printf("\t\t8.  Auto Poll\n");
        printf("\t\t9.  Poll On Demand\n");
        printf("\t\t10. Set Merchant Record\n");
        printf("\t\t11. Get Merchant Record\n");
        printf("\t\t12. Get Transaction Results\n");
        printf("\t\t13. Start Remote Key Injection\n");
        printf("\t\t14. Update Firmware (Need to run twice)\n");
    }
    printf("\t\t************************************************\n");
    fflush(stdout);
} /* _KioskIII_display_device_menu */
