#
# UPDDGesturesmacosx
# 
# installUPDDInkingPrefPane.py
# Copyright 2011 Touch-Base Ltd. All Rights Reserved
# 

import shutil, os, os.path, stat, codecs

prefPanePath = os.path.expanduser('~/Library/PreferencePanes/UPDDInk.prefpane')

# Do nothing is pref pane is already present:
if not os.path.exists(prefPanePath):

    # Copy OS X's built in Ink pref pane
    shutil.copytree('/System/Library/PreferencePanes/Ink.prefpane', prefPanePath)
    
    # Change its bundle identifier to something different, so it doesn't appear to be the same pref pane anymore
    os.system('defaults write ' + prefPanePath + '/Contents/Info CFBundleIdentifier com.touch-base.preference.ink')
    
    # Delete the TabletFinder executible
    os.remove(prefPanePath + '/Contents/Resources/TabletFinder')
    
    # Insert a new one that returns the opposite of the original TabletFinder:
    f = open(prefPanePath + '/Contents/Resources/TabletFinder', 'w')
    tabletFinderScript = """#!/bin/sh
/System/Library/PreferencePanes/Ink.prefPane/Contents/Resources/TabletFinder
if [ "$?" -eq 0 ]
    then
        exit 1
    else
        exit 0
    fi"""
    f.write(tabletFinderScript)
    f.close()
    
    # Make it executible by everyone:
    os.chmod('' + prefPanePath + '/Contents/Resources/TabletFinder',
             stat.S_IRWXU | stat.S_IRGRP | stat.S_IXGRP | stat.S_IROTH | stat.S_IXOTH)
    
    # Find all InfoPlist.strings files and replace the NSPrefPaneIconLabel string with the name we want, so
    # that the pref pane appears as "UPDD Ink"
    # (Currently disabled, as doing so is confusing!)
    # resources = os.walk(prefPanePath + '/Contents/Resources')
    # for dirname, dirs, files in resources:
    #     if 'InfoPlist.strings' in files:
    #         # Read in a strings file (it is UTF-16):
    #         fullPath = dirname + '/InfoPlist.strings'
    #         f = codecs.open(fullPath, encoding='utf-16', mode='r')
    #         allLines = f.readlines()
    #         f.close()
    #         
    #         # Write it out as it is, replacing the line for NSPrefPaneIconLabel:
    #         f = codecs.open(fullPath, encoding='utf-16', mode='w')
    #         for line in allLines:
    #             if line.startswith(u'NSPrefPaneIconLabel'):
    #                 f.write(u'NSPrefPaneIconLabel = "UPDD Ink";\n')
    #             else:
    #                 f.write(line)
    #         f.close()
    
    
    # Make the pref pane readable by everyone, just to be safe:
    os.system('chmod -R a+r ' + prefPanePath)