//
//  CEPrintTextViewController.m
//  DemoCustomiOSApi
//
//  Created by CUSTOM S.p.A. on 19/07/13.
//  Copyright (c) 2013 CUSTOM S.p.A.. All rights reserved.
//
//************************************************************************************
//*                                                                                  *
//* This document contains programming examples.                                     *
//*                                                                                  *
//* CUSTOM S.p.A. grants you a nonexclusive copyright license to use                 *
//* all programming code examples from which you can generate similar                *
//* function tailored to your own specific needs.                                    *
//*                                                                                  *
//* All sample code is provided by CUSTOM S.p.A. for illustrative purposes           *
//* only. These examples have not been thoroughly tested under all conditions.       *
//* CUSTOM S.p.A., therefore, cannot guarantee or imply reliability,                 *
//* serviceability, or function of these programs.                                   *
//*                                                                                  *
//* In no event shall CUSTOM S.p.A. be liable for any direct, indirect,              *
//* incidental, special, exemplary, or consequential damages (including, but not     *
//* limited to, procurement of substitute goods or services; loss of use, data,      *
//* or profits; or business interruption) however caused and on any theory of        *
//* liability, whether in contract, strict liability, or tort (including negligence  *
//* or otherwise) arising in any way out of the use of this software, even if        *
//* advised of the possibility of such damage.                                       *
//*                                                                                  *
//* All programs contained herein are provided to you "as is" without any            *
//* warranties of any kind.                                                          *
//* The implied warranties of non-infringement, merchantability and fitness for a    *
//* particular purpose are expressly disclaimed.                                     *
//*                                                                                  *
//************************************************************************************


#import "CEPrintTextViewController.h"
#import "CEFirstViewController.h"
#import <QuartzCore/QuartzCore.h>

@interface CEPrintTextViewController () <UINavigationControllerDelegate, UIImagePickerControllerDelegate>

@end

@implementation CEPrintTextViewController

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        self.title = NSLocalizedString(@"Text", @"Text");
    }
    return self;
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    // Do any additional setup after loading the view from its nib.
    
    //Set textToPrint Color
    [textToPrint.layer setBackgroundColor: [[UIColor whiteColor] CGColor]];
    [textToPrint.layer setBorderColor: [[UIColor grayColor] CGColor]];
    [textToPrint.layer setBorderWidth: 1.0];
    [textToPrint.layer setCornerRadius:8.0f];
    [textToPrint.layer setMasksToBounds:YES];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)dealloc {
}
- (void)viewDidUnload {
    btnPrintText = nil;
    [super viewDidUnload];
}


- (IBAction)ButtonPrintTextTouchDown:(id)sender
{
    NSError *error;
    
    CEFirstViewController* mainView = [CEFirstViewController getInstance];
    
    if (mainView.currentCustomPrn == nil)
        return;
    
    //Create Windows and Show it
    msg = [CEFirstViewController CreateOverMessage:@"Printing..."];
    [msg show];
    
    [mainView.currentCustomPrn PrintTextLF:[textToPrint text] :&error];
    
    [msg dismissWithClickedButtonIndex:0 animated:YES];
    msg=nil;
    
}

//Called every time is activated
- (void) viewWillAppear:(BOOL)animated
{
    Boolean printerConnected = false;
    float alpha = 0.5;
    
    CEFirstViewController* mainView = [CEFirstViewController getInstance];
    
    if (mainView.currentCustomPrn != nil)
    {
        //Enabled
        printerConnected = true;
        //100% colors
        alpha = 1.0;
    }
    
    //Enable / disable Objects
    btnPrintText.enabled = printerConnected;
    btnPrintText.alpha = alpha;
    
}

- (BOOL)isVisible {
    return [self isViewLoaded] && self.view.window;
}

- (BOOL)textView:(UITextView *)textView shouldChangeTextInRange:(NSRange)range
 replacementText:(NSString *)text
{
    if([text isEqualToString:@"\n"])
    {
        //Close Keyboard
        [textView resignFirstResponder];
        
        return NO;
    }
    return YES;
    
}



@end
