//
//  CEPrintPictureViewController.m
//  DemoCustomiOSApi
//
//  Created by CUSTOM S.p.A. on 19/07/13.
//  Copyright (c) 2013 CUSTOM S.p.A.. All rights reserved.
//
//************************************************************************************
//*                                                                                  *
//* This document contains programming examples.                                     *
//*                                                                                  *
//* CUSTOM S.p.A. grants you a nonexclusive copyright license to use                 *
//* all programming code examples from which you can generate similar                *
//* function tailored to your own specific needs.                                    *
//*                                                                                  *
//* All sample code is provided by CUSTOM S.p.A. for illustrative purposes           *
//* only. These examples have not been thoroughly tested under all conditions.       *
//* CUSTOM S.p.A., therefore, cannot guarantee or imply reliability,                 *
//* serviceability, or function of these programs.                                   *
//*                                                                                  *
//* In no event shall CUSTOM S.p.A. be liable for any direct, indirect,              *
//* incidental, special, exemplary, or consequential damages (including, but not     *
//* limited to, procurement of substitute goods or services; loss of use, data,      *
//* or profits; or business interruption) however caused and on any theory of        *
//* liability, whether in contract, strict liability, or tort (including negligence  *
//* or otherwise) arising in any way out of the use of this software, even if        *
//* advised of the possibility of such damage.                                       *
//*                                                                                  *
//* All programs contained herein are provided to you "as is" without any            *
//* warranties of any kind.                                                          *
//* The implied warranties of non-infringement, merchantability and fitness for a    *
//* particular purpose are expressly disclaimed.                                     *
//*                                                                                  *
//************************************************************************************

#import "CEPrintPictureViewController.h"
#import "CEFirstViewController.h"
#import <QuartzCore/QuartzCore.h>

@interface CEPrintPictureViewController () <UINavigationControllerDelegate, UIImagePickerControllerDelegate>

@end

@implementation CEPrintPictureViewController


- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        self.title = NSLocalizedString(@"Pictures", @"Pictures");
    }
    return self;
}

- (IBAction)grabImage
{
	[self presentModalViewController:self.imgPicker animated:YES];
}

- (void)imagePickerController:(UIImagePickerController *)picker didFinishPickingImage:(UIImage *)img editingInfo:(NSDictionary *)editInfo
{
    //Close window
    [picker dismissModalViewControllerAnimated:YES];
    picker = nil;
    
    //Show Picture
	imagePreview.image = img;
    //Save Picture
    imageToPrint = img;    
    
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    // Do any additional setup after loading the view from its nib.
    self.imgPicker = [[UIImagePickerController alloc] init];
	self.imgPicker.delegate = self;
    imageToPrint = nil;
    
    //Set imagePreview Color
    [imagePreview.layer setBackgroundColor: [[UIColor whiteColor] CGColor]];
    [imagePreview.layer setBorderColor: [[UIColor grayColor] CGColor]];
    [imagePreview.layer setBorderWidth: 1.0];
    [imagePreview.layer setCornerRadius:8.0f];
    [imagePreview.layer setMasksToBounds:YES];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)dealloc {

}
- (void)viewDidUnload {

    imagePreview = nil;
    btnPrintPicture = nil;
    [super viewDidUnload];
}

- (IBAction)ButtonTakeCameraTouchDown:(id)sender
{
    //From Camera
    self.imgPicker.sourceType = UIImagePickerControllerSourceTypeCamera;
    
    [self grabImage];
}

- (IBAction)ButtonTakeGalleryTouchDown:(id)sender
{
    //From Gallery
    self.imgPicker.sourceType = UIImagePickerControllerSourceTypePhotoLibrary;
    
    
    [self grabImage];
}

- (IBAction)ButtonPrintPictureTouchDown:(id)sender
{
    NSError *error;
    CEFirstViewController* mainView = [CEFirstViewController getInstance];
    
    if (mainView.currentCustomPrn == nil)
        return;
    
    //Create Windows and Show it
    msg = [CEFirstViewController CreateOverMessage:@"Printing..."];
    [msg show];
    
    [mainView.currentCustomPrn PrintImage:imageToPrint :&error];
    [mainView.currentCustomPrn Cut:CUT_TOTAL :&error];
    
    [msg dismissWithClickedButtonIndex:0 animated:YES];
    msg=nil;
    
}

//Called every time is activated
- (void) viewWillAppear:(BOOL)animated
{
    Boolean printerConnected = false;
    float alpha = 0.5;
    
    CEFirstViewController* mainView = [CEFirstViewController getInstance];
    
    if (mainView.currentCustomPrn != nil)
    {
        //Enabled
        printerConnected = true;
        //100% colors
        alpha = 1.0;
    }
    
    //Enable / disable Objects
    btnPrintPicture.enabled = printerConnected;
    btnPrintPicture.alpha = alpha;
    
}

- (BOOL)isVisible {
    return [self isViewLoaded] && self.view.window;
}

@end
