//
//  CEFirstViewController.m
//  DemoCustomiOSApi
//
//  Created by CUSTOM S.p.A. on 19/07/13.
//  Copyright (c) 2013 CUSTOM S.p.A.. All rights reserved.
//
//************************************************************************************
//*                                                                                  *
//* This document contains programming examples.                                     *
//*                                                                                  *
//* CUSTOM S.p.A. grants you a nonexclusive copyright license to use                 *
//* all programming code examples from which you can generate similar                *
//* function tailored to your own specific needs.                                    *
//*                                                                                  *
//* All sample code is provided by CUSTOM S.p.A. for illustrative purposes           *
//* only. These examples have not been thoroughly tested under all conditions.       *
//* CUSTOM S.p.A., therefore, cannot guarantee or imply reliability,                 *
//* serviceability, or function of these programs.                                   *
//*                                                                                  *
//* In no event shall CUSTOM S.p.A. be liable for any direct, indirect,              *
//* incidental, special, exemplary, or consequential damages (including, but not     *
//* limited to, procurement of substitute goods or services; loss of use, data,      *
//* or profits; or business interruption) however caused and on any theory of        *
//* liability, whether in contract, strict liability, or tort (including negligence  *
//* or otherwise) arising in any way out of the use of this software, even if        *
//* advised of the possibility of such damage.                                       *
//*                                                                                  *
//* All programs contained herein are provided to you "as is" without any            *
//* warranties of any kind.                                                          *
//* The implied warranties of non-infringement, merchantability and fitness for a    *
//* particular purpose are expressly disclaimed.                                     *
//*                                                                                  *
//************************************************************************************

#import "CEFirstViewController.h"

@interface CEFirstViewController ()

@end

@implementation CEFirstViewController

@synthesize currentCustomPrn;
@synthesize customiOsApi;

static CEFirstViewController *instance =nil;
+(CEFirstViewController *)getInstance
{
    return instance;
}

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        self.title = @"";
        //self.tabBarItem.image = [UIImage imageNamed:@"first"];
        customiOsApi = nil;
        currentCustomPrn = nil;
        instance = self;
    }

    return self;
}
							
- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view, typically from a nib.
    customiOsApi = [[CustomiOSApi alloc] init];
    
    //App Version
    NSString* appversion = [[[NSBundle mainBundle] infoDictionary] objectForKey:(NSString*)kCFBundleVersionKey];
    
    //Write Version
    NSString* strVersions = [NSString stringWithFormat:@"SW release %@\niOS SDK release %@",
                            appversion, [customiOsApi GetAPIVersion]];
    
    [labelSWVersion setText:strVersions];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)viewDidUnload {
    labelSWVersion = nil;
    [super viewDidUnload];
}
- (void)dealloc {
}

+ (UIAlertView*) CreateOverMessage:(NSString*)strTitle
{
    UIAlertView* av=[[UIAlertView alloc] initWithTitle:strTitle message:@"" delegate:self cancelButtonTitle:nil otherButtonTitles:nil];
    UIActivityIndicatorView * ActInd=[[UIActivityIndicatorView alloc] initWithActivityIndicatorStyle:UIActivityIndicatorViewStyleWhiteLarge];
    [ActInd startAnimating];
    [ActInd setFrame:CGRectMake(110, 60, 37, 37)];
    [av addSubview:ActInd];
    
    return av;
}

- (BOOL)isVisible {
    return [self isViewLoaded] && self.view.window;
}

@end
