/*
 * Decompiled with CFR 0.152.
 */
package it.custom.printer.api.android.p006;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import it.custom.printer.api.android.CustomException;
import it.custom.printer.api.android.CustomPrinter;
import it.custom.printer.api.android.PrinterFont;
import it.custom.printer.api.android.PrinterStatus;
import it.custom.printer.api.android.ScannerCardData;
import it.custom.printer.api.android.ScannerImage;
import it.custom.printer.api.android.ScannerStatus;
import it.custom.printer.api.android.p001.c002;
import it.custom.printer.api.android.p002.c014;
import it.custom.printer.api.android.p003.c002;
import it.custom.printer.api.android.p005.c003;
import it.custom.printer.api.android.p005.c004;

abstract class c001
extends CustomPrinter {
    public static final String m001 = "2.41";
    protected it.custom.printer.api.android.p002.c001 m002 = null;
    protected PrinterFont m003 = new PrinterFont();
    protected long m004 = 0L;
    protected byte[] m005 = new byte[4];
    protected long m006 = 0L;
    protected byte[] m007 = new byte[4];
    protected c004 m008 = null;
    protected int[] m009 = null;
    public String m010;
    public int m011;
    public int m012;
    public boolean m013;
    public c002.c001 m014;
    public int[][] m015;
    public boolean m016 = false;
    public boolean m017 = true;
    public boolean m018 = false;
    public int m019;

    public c001(it.custom.printer.api.android.p002.c001 c0012) {
        this.m002 = c0012;
    }

    public void close() throws CustomException {
        this.m002.m005();
    }

    public int getCommPortType() throws CustomException {
        if (this.m002 == null) {
            throw new CustomException(3L);
        }
        return this.m002.m006();
    }

    public boolean isPrintAvailable() {
        return this.m017;
    }

    public boolean isScannerAvailable() {
        return this.m018;
    }

    public void m001() {
        if (!this.m016) {
            it.custom.printer.api.android.p004.c001.m001("This printer doesn't supports GET PRINTER FEATURES...");
            this.m008 = new c004();
            return;
        }
        int n = 0;
        while (n < 5) {
            try {
                this.m008 = this.m004();
                it.custom.printer.api.android.p004.c001.m001("GET PRINTER FEATURES... OK");
                return;
            }
            catch (Exception exception) {
                ++n;
            }
        }
        it.custom.printer.api.android.p004.c001.m001("GET PRINTER FEATURES... FAILS");
        this.m008 = new c004();
    }

    public boolean isVeriprintAvailable() {
        try {
            if (!this.m008.m031) {
                it.custom.printer.api.android.p004.c001.m002("No veriprint Found...");
                return false;
            }
        }
        catch (Exception exception) {
            it.custom.printer.api.android.p004.c001.m002("Error during Get Printer Features...");
            return false;
        }
        return true;
    }

    public boolean isPrinterOnline() throws CustomException {
        int n = 0;
        do {
            try {
                PrinterStatus printerStatus = this.getPrinterFullStatus();
                if (printerStatus != null) {
                    return true;
                }
            }
            catch (CustomException customException) {}
            ++n;
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        } while (n < 50);
        return false;
    }

    public String getAPIVersion() throws CustomException {
        return m001;
    }

    public String getFirmwareVersion() throws CustomException {
        this.clearReadBuffer();
        byte[] byArray = this.m002(c003.m001(c014.m006), 4);
        return new String(byArray);
    }

    public int getPrinterId() throws CustomException {
        this.clearReadBuffer();
        return this.m002.m007();
    }

    public byte[] getPrinterFullStatusBuffer() throws CustomException {
        String string = "";
        if (System.currentTimeMillis() - this.m004 < 500L) {
            int n = 0;
            while (n < 4) {
                string = String.valueOf(string) + " " + c003.m002(this.m005[n]);
                ++n;
            }
            it.custom.printer.api.android.p004.c001.m001("Status(F) :" + string);
            return this.m005;
        }
        this.clearReadBuffer();
        byte[] byArray = this.m002(c003.m001(c014.m007), 6);
        if (byArray == null) {
            throw new CustomException(4L);
        }
        byte[] byArray2 = new byte[4];
        System.arraycopy(byArray, 2, byArray2, 0, 4);
        int n = 0;
        while (n < 4) {
            string = String.valueOf(string) + " " + c003.m002(byArray2[n]);
            ++n;
        }
        it.custom.printer.api.android.p004.c001.m001("Status :" + string);
        this.m004 = System.currentTimeMillis();
        System.arraycopy(byArray2, 0, this.m005, 0, 4);
        return byArray2;
    }

    public PrinterStatus getPrinterFullStatus() throws CustomException {
        byte[] byArray = this.getPrinterFullStatusBuffer();
        this.clearReadBuffer();
        long l = c003.m002(byArray);
        it.custom.printer.api.android.p004.c001.m001("Status :" + c003.m001(l));
        return PrinterStatus.FillPrinterStatusFromPrinterFullStatus(l);
    }

    private byte[] m002() throws CustomException {
        String string = "";
        this.clearReadBuffer();
        byte[] byArray = this.m002(c003.m001(c014.m007), 6);
        if (byArray == null) {
            throw new CustomException(4L);
        }
        byte[] byArray2 = new byte[4];
        System.arraycopy(byArray, 2, byArray2, 0, 4);
        int n = 0;
        while (n < 4) {
            string = String.valueOf(string) + " " + c003.m002(byArray2[n]);
            ++n;
        }
        it.custom.printer.api.android.p004.c001.m001("Status : " + string);
        return byArray2;
    }

    private PrinterStatus m003() throws CustomException {
        byte[] byArray = this.m002();
        this.clearReadBuffer();
        long l = c003.m002(byArray);
        it.custom.printer.api.android.p004.c001.m001("Status :" + c003.m001(l));
        return PrinterStatus.FillPrinterStatusFromPrinterFullStatus(l);
    }

    public long getReadTimeout() throws CustomException {
        return this.m002.m001;
    }

    public long getWriteTimeout() throws CustomException {
        return this.m002.m002;
    }

    /*
     * WARNING - void declaration
     */
    public void setReadTimeout(int msecs) throws CustomException {
        void var1_1;
        if (msecs < 50 || msecs > 30000) {
            throw new CustomException(2L);
        }
        this.m002.m001 = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setWriteTimeout(int msecs) throws CustomException {
        void var1_1;
        if (msecs < 50 || msecs > 30000) {
            throw new CustomException(2L);
        }
        this.m002.m002 = var1_1;
    }

    public int[] readData() throws CustomException {
        byte[] byArray = this.m002.m004();
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        int[] nArray = new int[byArray.length];
        int n = 0;
        while (n < byArray.length) {
            nArray[n] = c003.m001(byArray[n]);
            ++n;
        }
        return nArray;
    }

    public void clearReadBuffer() throws CustomException {
        this.m002.m003();
    }

    /*
     * WARNING - void declaration
     */
    public void writeData(byte[] data) throws CustomException {
        void var1_1;
        this.writeData(data, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    public void writeData(int[] data) throws CustomException {
        void var1_1;
        this.writeData(data, 0, ((void)var1_1).length);
    }

    public void m001(byte[] byArray, int n) throws CustomException {
        this.writeData(byArray, 0, n);
    }

    public void m001(int[] nArray, int n) throws CustomException {
        this.writeData(nArray, 0, n);
    }

    /*
     * WARNING - void declaration
     */
    public void writeData(int[] data, int offset, int nBytes) throws CustomException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.writeData(c003.m001((int[])var1_1), (int)var2_2, (int)var3_3);
    }

    public void writeData(byte[] data, int offset, int nBytes) throws CustomException {
        if (nBytes + offset > data.length) {
            throw new CustomException(2L, "Number of bytes > buffer size");
        }
        byte[] byArray = new byte[nBytes];
        int n = 0;
        while (n < nBytes) {
            byArray[n] = data[n + offset];
            ++n;
        }
        this.m002.m002(byArray);
    }

    public void feed(int nFeeds) throws CustomException {
        if (!this.m017) {
            it.custom.printer.api.android.p004.c001.m002("This device doesn't support printer functions");
            throw new CustomException(9L);
        }
        if (nFeeds <= 0) {
            throw new CustomException(2L, "Number of Feeds must be > 0");
        }
        byte[] byArray = new byte[nFeeds];
        int n = 0;
        while (n < nFeeds) {
            byArray[n] = c003.m001(c014.m002[0]);
            ++n;
        }
        this.m002.m002(byArray);
    }

    public void cut(int cutType) throws CustomException {
        if (!this.m017) {
            it.custom.printer.api.android.p004.c001.m002("This device doesn't support printer functions");
            throw new CustomException(9L);
        }
        throw new CustomException(9L);
    }

    public void eject(int ejectType) throws CustomException {
        if (!this.m017) {
            it.custom.printer.api.android.p004.c001.m002("This device doesn't support printer functions");
            throw new CustomException(9L);
        }
        throw new CustomException(9L);
    }

    public void present(int presentMM) throws CustomException {
        if (!this.m017) {
            it.custom.printer.api.android.p004.c001.m002("This device doesn't support printer functions");
            throw new CustomException(9L);
        }
        throw new CustomException(9L);
    }

    public String getPrinterName() {
        return this.m010;
    }

    public String getPrinterInfo() {
        return this.m002.m001();
    }

    public int getPageWidth() {
        return this.m011;
    }

    public int getResolution() {
        return this.m012;
    }

    /*
     * WARNING - void declaration
     */
    public void printImage(Bitmap image, int leftAlign, int widthOption, int imgWidth) throws CustomException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (!this.m017) {
            it.custom.printer.api.android.p004.c001.m002("This device doesn't support printer functions");
            throw new CustomException(9L);
        }
        this.m001((Bitmap)var1_1, this.m012, (int)var2_2, (int)var3_3, imgWidth, this.m014, this.m011, this.m013, true);
    }

    /*
     * WARNING - void declaration
     */
    public void printImage(Bitmap image) throws CustomException {
        void var1_1;
        if (!this.m017) {
            it.custom.printer.api.android.p004.c001.m002("This device doesn't support printer functions");
            throw new CustomException(9L);
        }
        this.m001((Bitmap)var1_1, this.m012, 0, 1, 0, this.m014, this.m011, this.m013, true);
    }

    /*
     * WARNING - void declaration
     */
    public void printBarcode(String brcText, int brcType, int brcHriType, int brcJustification, int brcWidth, int brcHeight) throws CustomException {
        void var3_3;
        void var2_2;
        byte[] byArray;
        if (!this.m017) {
            it.custom.printer.api.android.p004.c001.m002("This device doesn't support printer functions");
            throw new CustomException(9L);
        }
        int n = brcText.length();
        byArray = byArray.getBytes();
        this.m001(byArray, n, (int)var2_2, (int)var3_3, brcJustification, brcWidth, brcHeight);
    }

    /*
     * WARNING - void declaration
     */
    public void printBarcode(byte[] brcData, int nBytes, int brcType, int brcHriType, int brcJustification, int brcWidth, int brcHeight) throws CustomException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (!this.m017) {
            it.custom.printer.api.android.p004.c001.m002("This device doesn't support printer functions");
            throw new CustomException(9L);
        }
        this.m001((byte[])var1_1, (int)var2_2, (int)var3_3, brcHriType, brcJustification, brcWidth, brcHeight);
    }

    /*
     * WARNING - void declaration
     */
    public void printBarcode2D(String brcText, int brcType, int brcJustification, int brcWidth) throws CustomException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (!this.m017) {
            it.custom.printer.api.android.p004.c001.m002("This device doesn't support printer functions");
            throw new CustomException(9L);
        }
        this.m001((String)var1_1, (int)var2_2, (int)var3_3, brcWidth);
    }

    /*
     * WARNING - void declaration
     */
    public void printBarcode2D(byte[] brcData, int nBytes, int brcType, int brcJustification, int brcWidth) throws CustomException {
        void var3_3;
        String string;
        if (!this.m017) {
            it.custom.printer.api.android.p004.c001.m002("This device doesn't support printer functions");
            throw new CustomException(9L);
        }
        string = new String((byte[])string);
        this.m001(string, (int)var3_3, brcJustification, brcWidth);
    }

    /*
     * WARNING - void declaration
     */
    public void printText(String text, int leftAlign, int printWidth, PrinterFont font) throws CustomException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (!this.m017) {
            it.custom.printer.api.android.p004.c001.m002("This device doesn't support printer functions");
            throw new CustomException(9L);
        }
        this.m001((String)var1_1, (int)var2_2, (int)var3_3, font, this.m011, this.m015);
        this.m003 = font;
    }

    /*
     * WARNING - void declaration
     */
    public void printText(String text, PrinterFont font) throws CustomException {
        void var2_2;
        void var1_1;
        if (!this.m017) {
            it.custom.printer.api.android.p004.c001.m002("This device doesn't support printer functions");
            throw new CustomException(9L);
        }
        this.m001((String)var1_1, 0, -1, font, this.m011, this.m015);
        this.m003 = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void printText(String text) throws CustomException {
        void var1_1;
        if (!this.m017) {
            it.custom.printer.api.android.p004.c001.m002("This device doesn't support printer functions");
            throw new CustomException(9L);
        }
        this.m001((String)var1_1, 0, -1, this.m003, this.m011, this.m015);
    }

    /*
     * WARNING - void declaration
     */
    public void printTextLF(String text, int leftAlign, int printWidth, PrinterFont font) throws CustomException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (!this.m017) {
            it.custom.printer.api.android.p004.c001.m002("This device doesn't support printer functions");
            throw new CustomException(9L);
        }
        this.m001((String)var1_1, (int)var2_2, (int)var3_3, font, this.m011, this.m015);
        this.m003 = font;
        this.feed(1);
    }

    /*
     * WARNING - void declaration
     */
    public void printTextLF(String text, PrinterFont font) throws CustomException {
        void var2_2;
        void var1_1;
        if (!this.m017) {
            it.custom.printer.api.android.p004.c001.m002("This device doesn't support printer functions");
            throw new CustomException(9L);
        }
        this.m001((String)var1_1, 0, -1, font, this.m011, this.m015);
        this.m003 = var2_2;
        this.feed(1);
    }

    /*
     * WARNING - void declaration
     */
    public void printTextLF(String text) throws CustomException {
        void var1_1;
        if (!this.m017) {
            it.custom.printer.api.android.p004.c001.m002("This device doesn't support printer functions");
            throw new CustomException(9L);
        }
        this.m001((String)var1_1, 0, -1, this.m003, this.m011, this.m015);
        this.feed(1);
    }

    public byte[] scannerGetFullStatusBuffer() throws CustomException {
        if (!this.m018) {
            it.custom.printer.api.android.p004.c001.m002("This device doesn't support scanner functions");
            throw new CustomException(9L);
        }
        String string = "";
        if (System.currentTimeMillis() - this.m006 < 500L) {
            int n = 0;
            while (n < 4) {
                string = String.valueOf(string) + " " + c003.m002(this.m007[n]);
                ++n;
            }
            it.custom.printer.api.android.p004.c001.m001("Scanner Status(F) :" + string);
            return this.m007;
        }
        this.clearReadBuffer();
        byte[] byArray = this.m002(c003.m001(c014.m023), 6);
        if (byArray == null) {
            throw new CustomException(4L);
        }
        byte[] byArray2 = new byte[4];
        System.arraycopy(byArray, 2, byArray2, 0, 4);
        int n = 0;
        while (n <= 0) {
            string = String.valueOf(string) + " " + c003.m002(byArray2[0]);
            ++n;
        }
        it.custom.printer.api.android.p004.c001.m001("Scanner Status :" + string);
        this.m006 = System.currentTimeMillis();
        System.arraycopy(byArray2, 0, this.m007, 0, 4);
        return byArray2;
    }

    public ScannerStatus scannerGetFullStatus() throws CustomException {
        if (!this.m018) {
            it.custom.printer.api.android.p004.c001.m002("This device doesn't support scanner functions");
            throw new CustomException(9L);
        }
        byte[] byArray = this.scannerGetFullStatusBuffer();
        this.clearReadBuffer();
        long l = c003.m003(byArray);
        it.custom.printer.api.android.p004.c001.m001("Scanner Status :" + c003.m001(l));
        return ScannerStatus.FillScannerStatusFromScannerFullStatus(l);
    }

    /*
     * WARNING - void declaration
     */
    public void scannerFeeder(int iFeeder) throws CustomException {
        void var1_1;
        if (!this.m018) {
            it.custom.printer.api.android.p004.c001.m002("This device doesn't support scanner functions");
            throw new CustomException(9L);
        }
        if (iFeeder != 1 && iFeeder != 0) {
            throw new CustomException(2L, "Param value not supported");
        }
        this.m001((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ScannerImage scannerGetImage(int iImageType, boolean bCropImage) throws CustomException {
        void var2_3;
        void var1_1;
        if (!this.m018) {
            it.custom.printer.api.android.p004.c001.m002("This device doesn't support scanner functions");
            throw new CustomException(9L);
        }
        int n = this.scannerGetImageScannedID();
        if (n == 0) {
            it.custom.printer.api.android.p004.c001.m002("No Image Available...(1)");
            throw new CustomException(1L, "Image not available (Image ID == 0)");
        }
        Object object = this.scannerGetFullStatus();
        if (!((ScannerStatus)object).stsSCANNERGRAYCREATED && !((ScannerStatus)object).stsSCANNERBWCREATED) {
            it.custom.printer.api.android.p004.c001.m002("No Image Available...(2)");
            throw new CustomException(1L, "Gray or BW Image not available");
        }
        if (((ScannerStatus)object).stsSCANNERSEARCHING) {
            it.custom.printer.api.android.p004.c001.m002("Scanner still in searching...");
            throw new CustomException(1L);
        }
        if (iImageType != 1 && iImageType != 2) {
            it.custom.printer.api.android.p004.c001.m002("Image type " + iImageType + " not recognized");
            throw new CustomException(2L, "Param value not supported");
        }
        object = new byte[50];
        Object object2 = this.m001((int)var1_1, (boolean)var2_3, (byte[])object);
        try {
            object2 = new ScannerImage((Bitmap)object2, (byte[])object);
        }
        catch (Exception exception) {
            throw new CustomException(2L, "Param value not supported");
        }
        return object2;
    }

    public Bitmap scannerGetImageVeriprint() throws CustomException {
        if (!this.m008.m031) {
            it.custom.printer.api.android.p004.c001.m002("No veriprint Found...");
            throw new CustomException(9L);
        }
        Bitmap bitmap = this.m005();
        return bitmap;
    }

    /*
     * WARNING - void declaration
     */
    public boolean scannerPrintBarcodeAndVerify(String brcText, int brcType, int brcHriType, int brcJustification, int brcWidth, int brcHeight) throws CustomException {
        void var3_3;
        void var2_2;
        byte[] byArray;
        if (!this.m017) {
            it.custom.printer.api.android.p004.c001.m002("This device doesn't support printer functions");
            throw new CustomException(9L);
        }
        this.m002.m003();
        if (!this.m008.m031) {
            it.custom.printer.api.android.p004.c001.m002("No veriprint Found...");
            throw new CustomException(9L);
        }
        int n = brcText.length();
        byArray = byArray.getBytes();
        return this.m002(byArray, n, (int)var2_2, (int)var3_3, brcJustification, brcWidth, brcHeight);
    }

    /*
     * WARNING - void declaration
     */
    public boolean scannerPrintBarcodeAndVerify(byte[] brcData, int nBytes, int brcType, int brcHriType, int brcJustification, int brcWidth, int brcHeight) throws CustomException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (!this.m017) {
            it.custom.printer.api.android.p004.c001.m002("This device doesn't support printer functions");
            throw new CustomException(9L);
        }
        this.m002.m003();
        if (!this.m008.m031) {
            it.custom.printer.api.android.p004.c001.m002("No veriprint Found...");
            throw new CustomException(9L);
        }
        return this.m002((byte[])var1_1, (int)var2_2, (int)var3_3, brcHriType, brcJustification, brcWidth, brcHeight);
    }

    public int scannerGetImageScannedID() throws CustomException {
        if (!this.m018) {
            it.custom.printer.api.android.p004.c001.m002("This device doesn't support scanner functions");
            throw new CustomException(9L);
        }
        this.clearReadBuffer();
        byte[] byArray = this.m002(c003.m001(c014.m033), 2);
        if (byArray == null) {
            throw new CustomException(4L);
        }
        int n = c003.m001(byArray[0]) + (c003.m001(byArray[1]) << 8);
        it.custom.printer.api.android.p004.c001.m001("Image ID :" + n);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public void scannerSetSearchType(int iSearchTypes, boolean bSaveToRam) throws CustomException {
        void var1_1;
        void var2_2;
        if (!this.m018) {
            it.custom.printer.api.android.p004.c001.m002("This device doesn't support scanner functions");
            throw new CustomException(9L);
        }
        it.custom.printer.api.android.p004.c001.m001("Search Type :" + (iSearchTypes &= 3));
        int[] nArray = new int[c014.m034.length + 2];
        System.arraycopy(c014.m034, 0, nArray, 0, c014.m034.length);
        nArray[c014.m034.length] = var2_2 != false ? 87 : 119;
        nArray[c014.m034.length + 1] = var1_1;
        this.m002.m002(c003.m001(nArray));
    }

    /*
     * WARNING - void declaration
     */
    public void scannerSetEndScanMovement(int iAutoMType) throws CustomException {
        void var1_1;
        if (!this.m018) {
            it.custom.printer.api.android.p004.c001.m002("This device doesn't support scanner functions");
            throw new CustomException(9L);
        }
        if (iAutoMType != 48 && iAutoMType != 49 && iAutoMType != 50) {
            throw new CustomException(2L, "Param value not supported");
        }
        int[] nArray = new int[c014.m035.length + 1];
        System.arraycopy(c014.m035, 0, nArray, 0, c014.m035.length);
        nArray[c014.m035.length] = var1_1;
        this.m002.m002(c003.m001(nArray));
    }

    /*
     * WARNING - void declaration
     */
    public void scannerEject(int iEjectType) throws CustomException {
        void var1_1;
        if (!this.m018) {
            it.custom.printer.api.android.p004.c001.m002("This device doesn't support scanner functions");
            throw new CustomException(9L);
        }
        if (iEjectType != 49 && iEjectType != 50) {
            throw new CustomException(2L, "Param value not supported");
        }
        int[] nArray = new int[c014.m036.length + 1];
        System.arraycopy(c014.m036, 0, nArray, 0, c014.m036.length);
        nArray[c014.m036.length] = var1_1;
        this.m002.m002(c003.m001(nArray));
    }

    public void scannerCleanBuffers() throws CustomException {
        if (!this.m018) {
            it.custom.printer.api.android.p004.c001.m002("This device doesn't support scanner functions");
            throw new CustomException(9L);
        }
        this.m002.m002(c003.m001(c014.m024));
    }

    public ScannerCardData scannerGetCardData() throws CustomException {
        if (!this.m018) {
            it.custom.printer.api.android.p004.c001.m002("This device doesn't support scanner functions");
            throw new CustomException(9L);
        }
        Object object = this.scannerGetFullStatus();
        if (((ScannerStatus)object).stsSCANNERSEARCHING) {
            it.custom.printer.api.android.p004.c001.m002("Scanner still in searching...");
            throw new CustomException(1L);
        }
        if (!((ScannerStatus)object).stsSCANNERCARDFOUND) {
            it.custom.printer.api.android.p004.c001.m002("No Card Found...");
            throw new CustomException(11L);
        }
        this.m002.m002(c003.m001(c014.m038));
        object = null;
        byte[] byArray = new byte[1024];
        int n = 0;
        long l = System.currentTimeMillis();
        int n2 = this.m002.m001;
        this.m002.m001 = 100;
        while (true) {
            try {
                object = this.m002.m004();
            }
            catch (Exception exception) {}
            if (object == null || ((Object)object).length == 0) {
                if (System.currentTimeMillis() - l <= 500L) continue;
                break;
            }
            l = System.currentTimeMillis();
            System.arraycopy(object, 0, byArray, n, ((Object)object).length);
            n += ((Object)object).length;
            object = null;
        }
        this.m002.m001 = n2;
        it.custom.printer.api.android.p004.c001.m001("Buffer Read Size:" + n);
        if (n == 0) {
            it.custom.printer.api.android.p004.c001.m002("Card Read Error...(1)");
            throw new CustomException(4L);
        }
        if (byArray[0] == 0) {
            it.custom.printer.api.android.p004.c001.m002("No Card Data Read...");
            throw new CustomException(11L);
        }
        if (n < 3) {
            it.custom.printer.api.android.p004.c001.m002("Card Read Error...(2)");
            throw new CustomException(4L);
        }
        int n3 = c003.m001(byArray[1]) | c003.m001(byArray[2]) << 8;
        it.custom.printer.api.android.p004.c001.m001("Data Buffer Read Size:" + n3);
        if (n < n3 + 3) {
            it.custom.printer.api.android.p004.c001.m002("Card Read Error...(3)");
            throw new CustomException(4L);
        }
        byte[] byArray2 = new byte[n3 + 3];
        System.arraycopy(byArray, 0, byArray2, 0, n3 + 3);
        ScannerCardData scannerCardData = new ScannerCardData(byArray2);
        return scannerCardData;
    }

    public byte[] scannerGetBarcode() throws CustomException {
        if (!this.m018) {
            it.custom.printer.api.android.p004.c001.m002("This device doesn't support scanner functions");
            throw new CustomException(9L);
        }
        Object object = this.scannerGetFullStatus();
        if (((ScannerStatus)object).stsSCANNERSEARCHING) {
            it.custom.printer.api.android.p004.c001.m002("Scanner still in searching...");
            throw new CustomException(1L);
        }
        if (!((ScannerStatus)object).stsSCANNERBARCODEFOUND) {
            it.custom.printer.api.android.p004.c001.m002("No Barcode Found...");
            throw new CustomException(11L);
        }
        this.m002.m002(c003.m001(c014.m037));
        object = null;
        byte[] byArray = new byte[1024];
        int n = 0;
        long l = System.currentTimeMillis();
        int n2 = this.m002.m001;
        this.m002.m001 = 100;
        while (true) {
            try {
                object = this.m002.m004();
            }
            catch (Exception exception) {}
            if (object == null || ((Object)object).length == 0) {
                if (System.currentTimeMillis() - l <= 500L) continue;
                break;
            }
            l = System.currentTimeMillis();
            System.arraycopy(object, 0, byArray, n, ((Object)object).length);
            n += ((Object)object).length;
            object = null;
        }
        this.m002.m001 = n2;
        it.custom.printer.api.android.p004.c001.m001("Buffer Read Size:" + n);
        if (n == 0) {
            it.custom.printer.api.android.p004.c001.m002("Barcode Read Error...(1)");
            throw new CustomException(4L);
        }
        if (byArray[0] != 6) {
            it.custom.printer.api.android.p004.c001.m002("No Barcode Data Read...");
            throw new CustomException(11L);
        }
        if (n < 2) {
            it.custom.printer.api.android.p004.c001.m002("Barcode Read Error...(2)");
            throw new CustomException(4L);
        }
        int n3 = c003.m001(byArray[1]);
        it.custom.printer.api.android.p004.c001.m001("Data Buffer Read Size:" + n3);
        if (n < n3 + 2) {
            it.custom.printer.api.android.p004.c001.m002("Barcode Read Error...(3)");
            throw new CustomException(4L);
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 2, byArray2, 0, n3);
        return byArray2;
    }

    /*
     * WARNING - void declaration
     */
    public void scannerVoidTicket(Bitmap image, int iOffset) throws CustomException {
        void var1_1;
        if (!this.m018) {
            it.custom.printer.api.android.p004.c001.m002("This device doesn't support scanner functions");
            throw new CustomException(9L);
        }
        if (!this.m008.m039) {
            it.custom.printer.api.android.p004.c001.m002("No Void printer Found...");
            throw new CustomException(9L);
        }
        if (iOffset != 0) {
            void var2_2;
            if ((var2_2 <<= 3) < 0) {
                // empty if block
            }
            int[] nArray = new int[c014.m039.length + 2];
            System.arraycopy(c014.m039, 0, nArray, 0, c014.m039.length);
            nArray[c014.m039.length] = var2_2 & 0xFF;
            nArray[c014.m039.length + 1] = var2_2 >> 8 & 0xFF;
            this.m002.m002(c003.m001(nArray));
        }
        this.m002.m002(c003.m001(c014.m040));
        it.custom.printer.api.android.p003.c002.m001(this.m002, this.m014, (Bitmap)var1_1, this.m012, 0, 1, 0, this.m019, this.m013, -1);
        it.custom.printer.api.android.p004.c001.m001("Image data sent");
        this.m002.m003();
        this.m002.m002(c003.m001(c014.m041));
    }

    /*
     * WARNING - void declaration
     */
    public void scannerVoidBarcode(Bitmap image) throws CustomException {
        void var1_1;
        if (!this.m018) {
            it.custom.printer.api.android.p004.c001.m002("This device doesn't support scanner functions");
            throw new CustomException(9L);
        }
        ScannerStatus scannerStatus = this.scannerGetFullStatus();
        if (scannerStatus.stsSCANNERSEARCHING) {
            it.custom.printer.api.android.p004.c001.m002("Scanner still in searching...");
            throw new CustomException(1L);
        }
        if (!scannerStatus.stsSCANNERBARCODEFOUND) {
            it.custom.printer.api.android.p004.c001.m002("No Barcode Found...");
            throw new CustomException(11L);
        }
        if (!this.m008.m039) {
            it.custom.printer.api.android.p004.c001.m002("No Void printer Found...");
            throw new CustomException(9L);
        }
        this.m002.m002(c003.m001(c014.m042));
        this.m002.m002(c003.m001(c014.m040));
        it.custom.printer.api.android.p003.c002.m001(this.m002, this.m014, (Bitmap)var1_1, this.m012, 0, 1, 0, this.m019, this.m013, -1);
        it.custom.printer.api.android.p004.c001.m001("Image data sent");
        this.m002.m003();
        this.m002.m002(c003.m001(c014.m041));
    }

    public int[] scannerGetThresholds() throws CustomException {
        if (!this.m018) {
            it.custom.printer.api.android.p004.c001.m002("This device doesn't support scanner functions");
            throw new CustomException(9L);
        }
        this.clearReadBuffer();
        byte[] byArray = this.m002(c003.m001(c014.m043), 1);
        if (byArray == null || byArray.length != 1) {
            throw new CustomException(4L);
        }
        int n = c003.m001(byArray[0]);
        it.custom.printer.api.android.p004.c001.m001("HW Threshold:" + n);
        byArray = this.m002(c003.m001(c014.m045), 1);
        if (byArray == null || byArray.length != 1) {
            throw new CustomException(4L);
        }
        int n2 = c003.m001(byArray[0]);
        it.custom.printer.api.android.p004.c001.m001("SW Threshold:" + n2);
        int[] nArray = new int[2];
        int[] nArray2 = nArray;
        nArray[0] = n;
        nArray2[1] = n2;
        return nArray2;
    }

    /*
     * WARNING - void declaration
     */
    public void scannerSetThresholds(int ithHW, int ithSW) throws CustomException {
        int[] nArray;
        if (!this.m018) {
            it.custom.printer.api.android.p004.c001.m002("This device doesn't support scanner functions");
            throw new CustomException(9L);
        }
        if (ithHW < 0 || ithHW > 255) {
            it.custom.printer.api.android.p004.c001.m002("Param value HW out of range:" + ithHW);
            throw new CustomException(2L, "Param value HW out of range");
        }
        if (ithSW < 0 || ithSW > 255) {
            it.custom.printer.api.android.p004.c001.m002("Param value SW out of range:" + ithSW);
            throw new CustomException(2L, "Param value SW out of range");
        }
        int[] nArray2 = this.scannerGetThresholds();
        if (nArray2[0] != ithHW) {
            void var1_1;
            nArray = new int[c014.m044.length + 1];
            System.arraycopy(c014.m044, 0, nArray, 0, c014.m044.length);
            nArray[c014.m044.length] = var1_1;
            this.m002.m002(c003.m001(nArray));
        }
        if (nArray2[1] != ithSW) {
            void var2_2;
            nArray = new int[c014.m046.length + 1];
            System.arraycopy(c014.m046, 0, nArray, 0, c014.m046.length);
            nArray[c014.m046.length] = var2_2;
            this.m002.m002(c003.m001(nArray));
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean scannerProgramTickets(byte[] bBufferRicketsFile, boolean bSaveOnlyToRam) throws CustomException {
        void var2_3;
        void var1_1;
        if (!this.m018) {
            it.custom.printer.api.android.p004.c001.m002("This device doesn't support scanner functions");
            throw new CustomException(9L);
        }
        if (bBufferRicketsFile == null || bBufferRicketsFile.length == 0) {
            it.custom.printer.api.android.p004.c001.m002("File buffer error");
            throw new CustomException(2L, "Param value file empty");
        }
        int n = bBufferRicketsFile.length;
        this.clearReadBuffer();
        int[] nArray = new int[c014.m047.length + 3];
        System.arraycopy(c014.m047, 0, nArray, 0, c014.m047.length);
        nArray[c014.m047.length] = n & 0xFF;
        nArray[c014.m047.length + 1] = n >> 8 & 0xFF;
        nArray[c014.m047.length + 2] = n >> 16 & 0xFF;
        this.m002.m002(c003.m001(nArray));
        this.m002.m002((byte[])var1_1);
        long l = System.currentTimeMillis();
        int n2 = this.m002.m001;
        this.m002.m001 = 100;
        byte[] byArray = null;
        do {
            try {
                byArray = this.m002.m004();
            }
            catch (Exception exception) {}
        } while ((byArray == null || byArray.length == 0) && System.currentTimeMillis() - l <= 2000L);
        this.m002.m001 = n2;
        if (byArray == null) {
            it.custom.printer.api.android.p004.c001.m002("No answer from the device");
            throw new CustomException(4L);
        }
        if (byArray.length != 1) {
            it.custom.printer.api.android.p004.c001.m002("Wrong answer from the device");
            throw new CustomException(4L);
        }
        if (byArray[0] != 6) {
            it.custom.printer.api.android.p004.c001.m002("Program Ticket answer Error:" + byArray[0]);
            return false;
        }
        if (var2_3 != false) {
            return true;
        }
        this.m002.m002(c003.m001(c014.m048));
        l = System.currentTimeMillis();
        n2 = this.m002.m001;
        this.m002.m001 = 100;
        byArray = null;
        do {
            try {
                byArray = this.m002.m004();
            }
            catch (Exception exception) {}
        } while ((byArray == null || byArray.length == 0) && System.currentTimeMillis() - l <= 2000L);
        this.m002.m001 = n2;
        if (byArray == null) {
            it.custom.printer.api.android.p004.c001.m002("No answer from the device Programming Ticket into FLASH");
            throw new CustomException(4L);
        }
        if (byArray.length != 1) {
            it.custom.printer.api.android.p004.c001.m002("Wrong answer from the device Programming Ticket into FLASH");
            throw new CustomException(4L);
        }
        if (byArray[0] != 6) {
            it.custom.printer.api.android.p004.c001.m002("Program Ticket into FLASH answer Error:" + byArray[0]);
            return false;
        }
        return true;
    }

    private c004 m004() throws CustomException {
        c004 c0042 = new c004();
        byte[] byArray = new byte[1024];
        this.m002.m003();
        this.m002.m002(c003.m001(c014.m009));
        int n = 0;
        long l = System.currentTimeMillis();
        while (true) {
            byte[] byArray2 = null;
            try {
                byArray2 = this.m002.m004();
            }
            catch (Exception exception) {}
            if (byArray2 == null || byArray2.length == 0) {
                if (System.currentTimeMillis() - l <= 500L) continue;
                break;
            }
            l = System.currentTimeMillis();
            System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            n += byArray2.length;
        }
        if (n == 0) {
            it.custom.printer.api.android.p004.c001.m002("No Get Features Answer");
            throw new CustomException(4L);
        }
        c0042.m001(byArray, n);
        return c0042;
    }

    private void m001(int n) throws CustomException {
        if (this.m008.m031) {
            if (n == 1) {
                this.m002.m002(c003.m001(c014.m027));
                return;
            }
            if (n == 0) {
                this.m002.m002(c003.m001(c014.m028));
                return;
            }
            throw new CustomException(2L);
        }
        if (n == 1) {
            this.m002.m002(c003.m001(c014.m025));
            return;
        }
        if (n == 0) {
            this.m002.m002(c003.m001(c014.m026));
            return;
        }
        throw new CustomException(2L);
    }

    private Bitmap m001(int n, boolean bl, byte[] byArray) throws CustomException {
        int n2 = n;
        if (bl) {
            n2 = n | 0x30;
        }
        this.m002.m003();
        Object object = new int[c014.m029.length + 1];
        System.arraycopy(c014.m029, 0, object, 0, c014.m029.length);
        object[c014.m029.length] = c003.m001(n2);
        this.m002.m002(c003.m001(object));
        byte[] byArray2 = this.m002.m001(4);
        int n3 = c003.m001(byArray2);
        it.custom.printer.api.android.p004.c001.m001("File Size :" + n3);
        int n4 = this.m002.m001;
        this.m002.m001 = 2000;
        byte[] byArray3 = new byte[n3];
        long l = System.currentTimeMillis();
        System.arraycopy(c014.m030, 0, object, 0, c014.m030.length);
        object[c014.m030.length] = c003.m001(n2);
        this.m002.m002(c003.m001(object));
        n2 = 0;
        do {
            object = null;
            try {
                object = this.m002.m004();
            }
            catch (Exception exception) {}
            if (object == null || ((int[])object).length == 0) {
                if (System.currentTimeMillis() - l <= 2500L) continue;
                break;
            }
            l = System.currentTimeMillis();
            System.arraycopy(object, 0, byArray3, n2, ((int[])object).length);
            n2 += ((int[])object).length;
        } while (n2 != n3);
        this.m002.m001 = n4;
        System.arraycopy(byArray3, 0, byArray, 0, 50);
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray3, (int)0, (int)n3);
        object = bitmap;
        return bitmap;
    }

    private Bitmap m005() throws CustomException {
        this.m002.m003();
        this.m002.m002(c003.m001(c014.m031));
        byte[] byArray = this.m002.m001(4);
        int n = c003.m001(byArray);
        it.custom.printer.api.android.p004.c001.m001("File Size :" + n);
        if (n == 0) {
            it.custom.printer.api.android.p004.c001.m002("Veriprint Image not available");
            throw new CustomException(1L);
        }
        int n2 = this.m002.m001;
        this.m002.m001 = 2000;
        byte[] byArray2 = new byte[n];
        long l = System.currentTimeMillis();
        this.m002.m002(c003.m001(c014.m032));
        int n3 = 0;
        do {
            byte[] byArray3 = null;
            try {
                byArray3 = this.m002.m004();
            }
            catch (Exception exception) {}
            if (byArray3 == null || byArray3.length == 0) {
                if (System.currentTimeMillis() - l <= 2500L) continue;
                break;
            }
            l = System.currentTimeMillis();
            System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
            n3 += byArray3.length;
        } while (n3 != n);
        this.m002.m001 = n2;
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray2, (int)0, (int)n);
        return bitmap;
    }

    private void m001(Bitmap bitmap, int n, int n2, int n3, int n4, c002.c001 c0012, int n5, boolean bl, boolean bl2) throws CustomException {
        if (bitmap == null) {
            throw new CustomException(1L);
        }
        if (this.m002 == null || this.m002.m002()) {
            throw new CustomException(3L);
        }
        if (!this.isPrinterOnline()) {
            throw new CustomException(4L);
        }
        it.custom.printer.api.android.p003.c002.m001(this.m002, c0012, bitmap, n, n2, n3, n4, n5, bl, -1);
        it.custom.printer.api.android.p004.c001.m001("Image data sent");
        this.m002.m003();
        if (bl2) {
            long l;
            long l2 = System.currentTimeMillis();
            boolean bl3 = false;
            while (l2 + 10000L >= (l = System.currentTimeMillis())) {
                try {
                    PrinterStatus printerStatus = this.m003();
                    if (bl3) {
                        if (!printerStatus.stsSPOOLING && !printerStatus.stsPAPERROLLING) {
                            break;
                        }
                    } else if (printerStatus.stsSPOOLING || printerStatus.stsPAPERROLLING) {
                        bl3 = true;
                        l2 = System.currentTimeMillis();
                        it.custom.printer.api.android.p004.c001.m001("Print Start...");
                    }
                }
                catch (Exception exception) {}
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {}
            }
        }
        it.custom.printer.api.android.p004.c001.m001("Print End");
    }

    private void m001(String object, int n, int n2, PrinterFont printerFont, int n3, int[][] nArray) throws CustomException {
        if (printerFont == null) {
            throw new CustomException(5L);
        }
        if (this.m002 == null || this.m002.m002()) {
            throw new CustomException(3L);
        }
        if (n2 != -1 && (n2 <= 0 || n2 > n3)) {
            throw new CustomException(2L);
        }
        if (n < 0 || n > n3) {
            throw new CustomException(2L);
        }
        if (n + (n2 != -1 ? n2 : 0) > n3) {
            throw new CustomException(2L);
        }
        n3 = 0;
        if (this.m010.contains("S'Print")) {
            n3 = 1;
        }
        object = ((String)object).replaceAll("\\r\\n", "\\n");
        object = ((String)object).replaceAll("\\n\\r", "\\n");
        object = ((String)object).replaceAll("\\r", "\\n");
        if (n3 == 0) {
            this.m002.m002(it.custom.printer.api.android.p008.c001.m001(printerFont, n, n2));
        } else {
            this.m002.m002(it.custom.printer.api.android.p008.c001.m002(printerFont, n, n2));
        }
        this.m002.m002(it.custom.printer.api.android.p008.c002.m001((String)object, nArray, printerFont.getInternationalCharSet(), printerFont.getInternationalCharSetString()));
        object = new PrinterFont();
        if (n3 == 0) {
            this.m002.m002(it.custom.printer.api.android.p008.c001.m001((PrinterFont)object, 0, n2));
        }
    }

    private void m001(byte[] object, int n, int n2, int n3, int n4, int n5, int n6) throws CustomException {
        long l;
        if (object == null) {
            it.custom.printer.api.android.p004.c001.m002("Wrong data / text");
            throw new CustomException(2L);
        }
        if (this.m002 == null || this.m002.m002()) {
            throw new CustomException(3L);
        }
        if (!this.isPrinterOnline()) {
            throw new CustomException(4L);
        }
        Bitmap bitmap = null;
        it.custom.printer.api.android.p001.c001 c0012 = new it.custom.printer.api.android.p001.c001();
        String[] stringArray = new String[1];
        object = c0012.m001(this.m002, (byte[])object, n, stringArray, n2, n5);
        it.custom.printer.api.android.p004.c001.m001("Barcode data sent");
        this.m002.m003();
        if (((it.custom.printer.api.android.p005.c001)object).m005() << 3 > this.m011) {
            it.custom.printer.api.android.p004.c001.m002("Wrong Barcode Width");
            throw new CustomException(2L);
        }
        if (object == null || ((it.custom.printer.api.android.p005.c001)object).m005() == 0) {
            it.custom.printer.api.android.p004.c001.m002("Wrong Barcode Data Output");
            throw new CustomException(2L);
        }
        if (n3 != 0 && ((bitmap = c0012.m001(stringArray[0], ((it.custom.printer.api.android.p005.c001)object).m005() << 3, n6)).getWidth() == 0 || bitmap.getWidth() > this.m011)) {
            it.custom.printer.api.android.p004.c001.m002("Wrong HRI Image Width");
            throw new CustomException(2L);
        }
        if (n3 == 1 || n3 == 3) {
            it.custom.printer.api.android.p003.c002.m001(this.m002, this.m014, bitmap, this.m012, n4, 0, 0, this.m011, this.m013, 4);
        }
        it.custom.printer.api.android.p003.c002.m001(this.m002, this.m014, (it.custom.printer.api.android.p005.c001)object, this.m012, n6, n4, this.m011, this.m013, 4);
        if (n3 == 2 || n3 == 3) {
            it.custom.printer.api.android.p003.c002.m001(this.m002, this.m014, bitmap, this.m012, n4, 0, 0, this.m011, this.m013, 4);
        }
        if (bitmap != null) {
            bitmap.recycle();
        }
        long l2 = System.currentTimeMillis();
        boolean bl = false;
        while (l2 + 10000L >= (l = System.currentTimeMillis())) {
            try {
                PrinterStatus printerStatus = this.m003();
                if (bl) {
                    if (!printerStatus.stsSPOOLING && !printerStatus.stsPAPERROLLING) {
                        break;
                    }
                } else if (printerStatus.stsSPOOLING || printerStatus.stsPAPERROLLING) {
                    bl = true;
                    l2 = System.currentTimeMillis();
                    it.custom.printer.api.android.p004.c001.m001("Print Start...");
                }
            }
            catch (Exception exception) {}
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {}
        }
        it.custom.printer.api.android.p004.c001.m001("Print End");
    }

    private void m001(String string, int n, int n2, int n3) throws CustomException {
        long l;
        if (string == null) {
            it.custom.printer.api.android.p004.c001.m002("Wrong Data / Text");
            throw new CustomException(2L);
        }
        if (this.m002 == null || this.m002.m002()) {
            throw new CustomException(3L);
        }
        if (!this.isPrinterOnline()) {
            throw new CustomException(4L);
        }
        c002 c0022 = new c002();
        string = c0022.m001(string, n, n3);
        it.custom.printer.api.android.p004.c001.m001("Barcode image created");
        this.m002.m003();
        if (string == null) {
            it.custom.printer.api.android.p004.c001.m002("Wrong Barcode Image");
            throw new CustomException(2L, "Barcode 2D Creation Error");
        }
        if (string.getWidth() == 0 || string.getWidth() > this.m011) {
            it.custom.printer.api.android.p004.c001.m002("Wrong Barcode Image Width");
            throw new CustomException(2L);
        }
        it.custom.printer.api.android.p003.c002.m001(this.m002, this.m014, (Bitmap)string, this.m012, n2, 0, 0, this.m011, this.m013, 0);
        string.recycle();
        long l2 = System.currentTimeMillis();
        boolean bl = false;
        while (l2 + 10000L >= (l = System.currentTimeMillis())) {
            try {
                PrinterStatus printerStatus = this.m003();
                if (bl) {
                    if (!printerStatus.stsSPOOLING && !printerStatus.stsPAPERROLLING) {
                        break;
                    }
                } else if (printerStatus.stsSPOOLING || printerStatus.stsPAPERROLLING) {
                    bl = true;
                    l2 = System.currentTimeMillis();
                    it.custom.printer.api.android.p004.c001.m001("Print Start...");
                }
            }
            catch (Exception exception) {}
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {}
        }
        it.custom.printer.api.android.p004.c001.m001("Print End");
    }

    private boolean m002(byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6) throws CustomException {
        if (byArray == null) {
            it.custom.printer.api.android.p004.c001.m002("Wrong data / text");
            throw new CustomException(2L);
        }
        if (this.m002 == null || this.m002.m002()) {
            throw new CustomException(3L);
        }
        if (!this.isPrinterOnline()) {
            throw new CustomException(4L);
        }
        if (this.m009 == null) {
            it.custom.printer.api.android.p004.c001.m002("This device doesn't support printer functions");
            throw new CustomException(9L);
        }
        boolean bl = false;
        int n7 = 0;
        while (n7 < this.m009.length) {
            if (this.m009[n7] == n2) {
                bl = true;
                break;
            }
            ++n7;
        }
        if (!bl) {
            it.custom.printer.api.android.p004.c001.m002("This printer doesn't support this barcode");
            throw new CustomException(2L);
        }
        this.m002.m002(c003.m001(c014.m018));
        byte[] byArray2 = new byte[1];
        byte[] byArray3 = byArray2;
        byArray2[0] = c003.m001(n6 & 0xFF);
        this.m002.m002(byArray3);
        this.m002.m002(c003.m001(c014.m019));
        byte[] byArray4 = new byte[1];
        byArray3 = byArray4;
        byArray4[0] = c003.m001(n5 & 0xFF);
        this.m002.m002(byArray3);
        this.m002.m002(c003.m001(c014.m017));
        byArray3 = new byte[1];
        if (n4 == 0) {
            byArray3[0] = 0;
        } else if (n4 == -1) {
            byArray3[0] = 1;
        } else if (n4 == -2) {
            byArray3[0] = 2;
        } else {
            it.custom.printer.api.android.p004.c001.m002("Barcode Justification error");
            throw new CustomException(2L);
        }
        this.m002.m002(byArray3);
        this.m002.m002(c003.m001(c014.m020));
        byArray3 = new byte[1];
        if (n3 == 0) {
            byArray3[0] = 0;
        } else if (n3 == 1) {
            byArray3[0] = 1;
        } else if (n3 == 2) {
            byArray3[0] = 2;
        } else if (n3 == 3) {
            byArray3[0] = 2;
        } else {
            it.custom.printer.api.android.p004.c001.m002("Barcode HRI error");
            throw new CustomException(2L);
        }
        this.m002.m002(byArray3);
        this.m002.m003();
        if (n2 == -6) {
            this.m002.m002(c003.m001(c014.m021));
        } else if (n2 == -9) {
            this.m002.m002(c003.m001(c014.m022));
        } else {
            it.custom.printer.api.android.p004.c001.m002("Barcode not supported error");
            throw new CustomException(2L);
        }
        byte[] byArray5 = new byte[n + 1];
        byArray3 = byArray5;
        byArray5[0] = c003.m001(n & 0xFF);
        int n8 = 0;
        while (n8 < n) {
            byArray3[n8 + 1] = byArray[n8];
            ++n8;
        }
        this.m002.m002(byArray3);
        it.custom.printer.api.android.p004.c001.m001("Print End");
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {}
        long l = System.currentTimeMillis();
        boolean bl2 = false;
        n = 0;
        do {
            block38: {
                long l2;
                if (l + 10000L < (l2 = System.currentTimeMillis())) {
                    it.custom.printer.api.android.p004.c001.m001("Self read exit for timeout");
                    break;
                }
                try {
                    byte[] byArray6 = this.m002.m004();
                    if (byArray6 == null) break block38;
                    n3 = 0;
                    while (n3 < byArray6.length) {
                        if (byArray6[n3] == 6) {
                            bl2 = true;
                            n = 1;
                            it.custom.printer.api.android.p004.c001.m001("Self read OK");
                            break;
                        }
                        if (byArray6[n3] == 21) {
                            bl2 = false;
                            n = 1;
                            it.custom.printer.api.android.p004.c001.m001("Self read NOT OK");
                            break;
                        }
                        ++n3;
                    }
                }
                catch (Exception exception) {}
            }
            if (n != 0) continue;
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {}
        } while (n == 0);
        it.custom.printer.api.android.p004.c001.m001("Wait Answer End");
        if (!bl2) {
            it.custom.printer.api.android.p004.c001.m001("Self read fails");
            return false;
        }
        return true;
    }

    protected byte[] m002(byte[] byArray, int n) throws CustomException {
        return this.m002.m001(byArray, n);
    }
}

